#include "../BasicCompiler_Common/common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif

BOOL IsVariableTopChar(char c){
	if((c>='A'&&c<='Z')||(c>='a'&&c<='z')||c=='_') return 1;
	return 0;
}
BOOL IsVariableChar(char c){
	if((c>='A'&&c<='Z')||(c>='a'&&c<='z')||(c>='0'&&c<='9')||
		c=='%'||c=='!'||c=='#'||c=='$'||
		c=='_'||c=='.') return 1;
	return 0;
}
BOOL IsPtrType(int type){
	if(type==-1) return 0;

	if(PTR_LEVEL(type)||type==DEF_PTR_VOID||type==DEF_PTR_PROC||
		(type&FLAG_PTR) ) return 1;

	return 0;
}
BOOL IsSignedType(int type){
	switch(type){
		case DEF_CHAR:
		case DEF_INTEGER:
		case DEF_LONG:
		case DEF_INT64:
		case DEF_SINGLE:
		case DEF_DOUBLE:
			return 1;
		default:
			break;
	}
	return 0;
}
BOOL IsNaturalWholeNumberType(int type){
	switch(type){
		case DEF_CHAR:
		case DEF_BYTE:
		case DEF_INTEGER:
		case DEF_WORD:
		case DEF_LONG:
		case DEF_DWORD:
		case DEF_INT64:
		case DEF_QWORD:
			return 1;
		default:
			break;
	}
	return 0;
}
BOOL IsWholeNumberType(int type){
	return (IsNaturalWholeNumberType(type)||IsPtrType(type));
}
BOOL IsRealNumberType(int type){
	switch(type){
		case DEF_DOUBLE:
		case DEF_SINGLE:
			return 1;
		default:
			break;
	}
	return 0;
}
BOOL Is64Type(int type){
	switch(type){
		case DEF_INT64:
		case DEF_QWORD:
			return 1;
		default:
			break;
	}
#ifdef _AMD64_
	return IsPtrType(type);
#else
	return 0;
#endif
}
int GetSignedType(int type){
	switch(type){
		case DEF_BYTE:
			return DEF_CHAR;
		case DEF_WORD:
			return DEF_INTEGER;
		case DEF_DWORD:
			return DEF_LONG;
		case DEF_QWORD:
			return DEF_INT64;
		default:
			break;
	}
#ifdef _AMD64_
	if(IsPtrType(type)) return DEF_INT64;
#else
	if(IsPtrType(type)) return DEF_LONG;
#endif
	return type;
}
int GetUnsignedType(int type){
	switch(type){
		case DEF_CHAR:
			return DEF_BYTE;
		case DEF_INTEGER:
			return DEF_WORD;
		case DEF_LONG:
			return DEF_DWORD;
		case DEF_INT64:
			return DEF_QWORD;
	}
	return type;
}
int GetTypeSize(int type,LONG_PTR lpIndex){
	if(type==DEF_LONG){
		if(lpIndex==LITERAL_NULL||lpIndex==LITERAL_M128_0||lpIndex==LITERAL_0_255)
			return sizeof(BYTE);
		else if(lpIndex==LITERAL_M32768_0||lpIndex==LITERAL_0_65535)
			return sizeof(WORD);

		return sizeof(DWORD);
	}

	//^
	if(type==DEF_INT64||type==DEF_QWORD)
		return sizeof(_int64);
	else if(type==DEF_LONG||type==DEF_DWORD)
		return sizeof(DWORD);
	else if(type==DEF_INTEGER||type==DEF_WORD)
		return sizeof(WORD);
	else if(type==DEF_CHAR||type==DEF_BYTE)
		return sizeof(BYTE);

	//^
	else if(type==DEF_DOUBLE)		return sizeof(double);
	else if(type==DEF_SINGLE)		return sizeof(float);

	//|C^^
	else if(IsPtrType(type))		return PTR_SIZE;

	else if(type==DEF_OBJECT){
		CClass *pobj_c;
		pobj_c=(CClass *)lpIndex;
		if(!pobj_c) return 0;
		return GetSizeOfClass(pobj_c);
	}
	else{
		SetError(300,NULL,cp);
	}
	return 0;
}
int GetPtrType(int type,LONG_PTR lpIndex){
	return MAKE_PTR_TYPE(NATURAL_TYPE(type),PTR_LEVEL(type)+1);
}
int GetTypeFixed(char *TypeName,LONG_PTR *lpNum){
	int type;

	if(lpNum) *lpNum=-1;

	if(TypeName[0]=='*'){
		if(TypeName[1]==1&&(TypeName[2]==ESC_FUNCTION||TypeName[2]==ESC_SUB)){
			//֐|C^i*Functionj
			return DEF_PTR_PROC;
		}

		type=GetTypeFixed(TypeName+1,lpNum);
		if(type==-1) return -1;

		return GetPtrType(type,*lpNum);
	}

	//^
	if(lstrcmpi(TypeName,"Char")==0)			return DEF_CHAR;
	else if(lstrcmpi(TypeName,"Byte")==0)		return DEF_BYTE;
	else if(lstrcmpi(TypeName,"Integer")==0)	return DEF_INTEGER;
	else if(lstrcmpi(TypeName,"WORD")==0)		return DEF_WORD;
	else if(lstrcmpi(TypeName,"Long")==0)		return DEF_LONG;
	else if(lstrcmpi(TypeName,"DWORD")==0)		return DEF_DWORD;
	else if(lstrcmpi(TypeName,"Int64")==0)		return DEF_INT64;
	else if(lstrcmpi(TypeName,"QWORD")==0)		return DEF_QWORD;

	//^
	else if(lstrcmpi(TypeName,"Single")==0)		return DEF_SINGLE;
	else if(lstrcmpi(TypeName,"Double")==0)		return DEF_DOUBLE;

	//|C^^
	//VoidPtr^ȊÕ|C^^TypeDef錾ɂ`
	else if(lstrcmpi(TypeName,"VoidPtr")==0)	return DEF_PTR_VOID;

	//̑
	else if(lstrcmpi(TypeName,"Any")==0)		return DEF_ANY;


	////////////////////
	// TypeDefꂽ^
	////////////////////
	int i;
	i=pobj_DBTypeDef->check(TypeName);
	if(i!=-1){
		return GetTypeFixed(pobj_DBTypeDef->ppobj_TypeDef[i]->lpszBaseName,lpNum);
	}

	if(!lpNum) return -1;

	//NX
	CClass *pobj_c;
	pobj_c=pobj_DBClass->check(TypeName);
	if(pobj_c){
		*lpNum=(LONG_PTR)pobj_c;
		return DEF_OBJECT;
	}

	return -1;
}
void GetOriginalTypeName(char *buffer){
	// TypeDefꂽ^ɑ΂āAIWǐ^̖OɕύX

	if(buffer[0]=='*'){
		if(buffer[1]==1&&(buffer[2]==ESC_FUNCTION||buffer[2]==ESC_SUB)) return;

		GetOriginalTypeName(buffer+1);
		return;
	}

	int i;
	i=pobj_DBTypeDef->check(buffer);
	if(i!=-1){
		lstrcpy(buffer,pobj_DBTypeDef->ppobj_TypeDef[i]->lpszBaseName);
		GetOriginalTypeName(buffer);
	}
}
BOOL GetTypeName(int type,LONG_PTR lpIndex,char *name){
	if(PTR_LEVEL(type)){
		//|C^^
		name[0]='*';
		return GetTypeName(MAKE_PTR_TYPE(NATURAL_TYPE(type),PTR_LEVEL(type)-1),lpIndex,name+1);
	}

	//^
	if(type==DEF_CHAR)				lstrcpy(name,"Char");
	else if(type==DEF_BYTE)			lstrcpy(name,"Byte");
	else if(type==DEF_INTEGER)		lstrcpy(name,"Integer");
	else if(type==DEF_WORD)			lstrcpy(name,"Word");
	else if(type==DEF_LONG)			lstrcpy(name,"Long");
	else if(type==DEF_DWORD)		lstrcpy(name,"DWord");
	else if(type==DEF_INT64)		lstrcpy(name,"Int64");
	else if(type==DEF_QWORD)		lstrcpy(name,"QWord");

	//^
	else if(type==DEF_SINGLE)		lstrcpy(name,"Single");
	else if(type==DEF_DOUBLE)		lstrcpy(name,"Double");

	//IuWFNg
	else if(type==DEF_OBJECT){
		if(lpIndex==0) lstrcpy(name,"non");
		else{
			lstrcpy(name,((CClass *)lpIndex)->name);
		}
	}

	//|C^^
	else if(type==DEF_PTR_VOID)		lstrcpy(name,"VoidPtr");

	else if(type==DEF_PTR_PROC){
		if(lpIndex==-1) lstrcpy(name,"VoidPtr");
		else{
			extern PROCPTRINFO *pProcPtrInfo;
			if(pProcPtrInfo[lpIndex].ReturnType==-1)
				lstrcpy(name,"*Sub");
			else lstrcpy(name,"*Function");
		}
	}

	else{
		extern int cp;
		SetError(1,NULL,cp);
		return 0;
	}
	return 1;
}

BOOL GetVarFormatString(char *buffer,char *array,char *array2,char *NestMember,int *pRefType){
	extern int cp;
	int i,i2,i3;
	char cPare_Open,cPare_Close;

	array[0]=0;
	array2[0]=0;
	NestMember[0]=0;
	*pRefType=0;
	for(i=0;;i++){
		if(buffer[i]=='\"'){
			for(i++;;i++){
				if(IsDBCSLeadByte(buffer[i])){
					i++;
					continue;
				}
				if(buffer[i]=='\"') break;
			}
		}
		if(buffer[i]=='['||buffer[i]=='('){
			if(buffer[i]=='['){
				cPare_Open='[';
				cPare_Close=']';
			}
			else{
				cPare_Open='(';
				cPare_Close=')';
			}
			buffer[i]=0;
			for(i++,i2=0;;i++,i2++){
				if(buffer[i]==cPare_Open){
					if(cPare_Open=='[') i3=GetStringInBracket(array+i2,buffer+i);
					else i3=GetStringInPare(array+i2,buffer+i);
					i+=i3-1;
					i2+=i3-1;
					continue;
				}
				if(buffer[i]==cPare_Close){
					array[i2]=0;
					break;
				}
				array[i2]=buffer[i];
			}
			if(buffer[i+1]==cPare_Open){
				for(i+=2,i2=0;;i++,i2++){
					if(buffer[i]==cPare_Open){
						if(cPare_Open=='[') i3=GetStringInBracket(array2+i2,buffer+i);
						else i3=GetStringInPare(array2+i2,buffer+i);
						i+=i3-1;
						i2+=i3-1;
						continue;
					}
					if(buffer[i]==cPare_Close){
						array2[i2]=0;
						break;
					}
					array2[i2]=buffer[i];
				}
				if(buffer[i+1]==cPare_Open){
					SetError(14,buffer,cp);
					return 0;
				}
			}
			continue;
		}
		if(buffer[i]=='.'){
			lstrcpy(NestMember,buffer+i+1);
			*pRefType=DEF_OBJECT;
			buffer[i]=0;
			break;
		}
		if(buffer[i]==1&&buffer[i+1]==ESC_PSMEM){
			lstrcpy(NestMember,buffer+i+2);
			*pRefType=DEF_PTR_OBJECT;
			buffer[i]=0;
			break;
		}
		if(buffer[i]=='\0') break;
	}
	return 1;
}

void GetArrayElement(char *buffer,char *variable,char *array_element){
	array_element[0]=0;

	if(buffer[lstrlen(buffer)-1]!=']'){
		lstrcpy(variable,buffer);
		return;
	}

	int i,i2;
	for(i=0;;i++){
		if(buffer[i]=='\0') break;
		if(buffer[i]=='['){
			i2=GetStringInBracket(array_element,buffer+i);
			i+=i2-1;
			continue;
		}
	}

	lstrcpy(variable,buffer);
	variable[lstrlen(variable)-lstrlen(array_element)]=0;

	RemoveStringBracket(array_element);
}

BOOL CheckVarNameError(char *name,int NowLine){
	int i2;

	if(!IsVariableTopChar(name[0])){
		SetError(1,NULL,NowLine);
		return 0;
	}
	for(i2=1;;i2++){
		if(name[i2]=='\0') break;
		if(!IsVariableChar(name[i2])){
			SetError(1,NULL,NowLine);
			return 0;
		}
	}
	return 1;
}

int JumpSubScripts(int *ss){
	//DIMŒ`ꂽ񂾔z̐AhXi߂
	int i,i2;
	for(i=0,i2=1;i<255;i++){
		if(ss[i]==-1) break;
		i2*=ss[i]+1;
	}
	return i2;
}
void GetArrange(char *variable,char *variAnswer,int *SubScripts){
	extern int cp;
	int i,i2,i3,i4;
	double dbl;
	_int64 i64data;
	BOOL bBracket;
	char temporary[VN_SIZE];

	for(i=0;;i++){
		if(variable[i]=='('||variable[i]=='['){
			if(variable[i]=='[') bBracket=1;
			else bBracket=0;

			variAnswer[i]=0;
			for(i++,i2=0,i3=0;;i++,i2++){
				if(variable[i]==','){
					temporary[i2]=0;

					i2=StaticCalculation(true, temporary,0,&i64data,0);
					if(IsRealNumberType(i2)){
						memcpy(&dbl,&i64data,sizeof(double));
						i64data=(_int64)dbl;
					}

					if(i64data<0){
						//error
						SubScripts[i3]=0;
					}
					else SubScripts[i3]=(int)i64data;
					i3++;
					i2=-1;
					continue;
				}
				if(variable[i]=='('){
					i4=GetStringInPare(temporary+i2,variable+i);
					i2+=i4-1;
					i+=i4-1;
					continue;
				}
				if(variable[i]=='['){
					i4=GetStringInBracket(temporary+i2,variable+i);
					i2+=i4-1;
					i+=i4-1;
					continue;
				}
				if(variable[i]==')'&&bBracket==0||
					variable[i]==']'&&bBracket){
					temporary[i2]=0;
					if(i2==0){
						SubScripts[i3]=-2;
						break;
					}

					i2=StaticCalculation(true, temporary,0,&i64data,0);
					if(IsRealNumberType(i2)){
						memcpy(&dbl,&i64data,sizeof(double));
						i64data=(_int64)dbl;
					}

					if(i64data<0){
						//error
						SubScripts[i3]=0;
					}
					else SubScripts[i3]=(int)i64data;
					SubScripts[i3+1]=-1;
					break;
				}
				if(variable[i]=='\"'){
					SetError(1,NULL,cp);
					return;
				}
				temporary[i2]=variable[i];
			}
			break;
		}
		variAnswer[i]=variable[i];
		if(variable[i]=='\0'){
			SubScripts[0]=-1;
			break;
		}
	}
}

int GetTypeFromSimpleName(char *variable){
	extern char DefIntVari[26],DefSngVari[26],DefStrVari[26],divNum,dsvNum,dStrvNum;
	int i;
	char name[VN_SIZE];

	//\̃ȍꍇl
	for(i=lstrlen(variable);i>0;i--){
		if(variable[i]=='.'){
			i++;
			break;
		}
	}

	for(;;i++){
		if(variable[i]=='('||variable[i]=='\0'){
			name[i]=0;
			break;
		}
		name[i]=variable[i];
	}
	//ϐI
	i--;
	if(name[i]=='#') return DEF_DOUBLE;
	if(name[i]=='!') return DEF_SINGLE;
	if(name[i]=='%') return DEF_INTEGER;
	return DEF_DOUBLE;
}


int GetMemberType(CClass *pobj_c,char *member,LONG_PTR *plpNestIndex,BOOL bPrivateAccess,BOOL bError){
	extern int cp;
	int i;

	//NXAz̍\vf͂
	char VarName[VN_SIZE];		//ϐ
	char array[VN_SIZE];		//1z
	char lpPtrOffset[VN_SIZE];		//2z
	char NestMember[VN_SIZE];	//qo
	int object_type;			//"."QƂ̂Ƃ0A"->"QƂ̂Ƃ1
	lstrcpy(VarName,member);
	if(!GetVarFormatString(VarName,array,lpPtrOffset,NestMember,&object_type)) return 0;

	for(i=0;i<pobj_c->iMemberNum;i++){
		if(lstrcmp(pobj_c->ppobj_Member[i]->name,VarName)==0) break;
	}
	if(i==pobj_c->iMemberNum){
		if(bError) SetError(103,VarName,cp);
		return -1;
	}

	//ANZVreB`FbN
	if(pobj_c==pobj_CompilingClass){
		//NXIuWFNg̏ꍇ̓vCx[gANZXeF
		if(pobj_c->ppobj_Member[i]->dwAccess==ACCESS_NON){
			if(bError) SetError(107,VarName,cp);
			return -1;
		}
	}
	else{
		if((bPrivateAccess==0&&pobj_c->ppobj_Member[i]->dwAccess==ACCESS_PRIVATE)||
			pobj_c->ppobj_Member[i]->dwAccess==ACCESS_NON){
			if(bError) SetError(107,VarName,cp);
			return -1;
		}
		else if(bPrivateAccess==0&&pobj_c->ppobj_Member[i]->dwAccess==ACCESS_PROTECTED){
			if(bError) SetError(108,VarName,cp);
			return -1;
		}
	}

	int type;
	type=pobj_c->ppobj_Member[i]->TypeInfo.type;
	*plpNestIndex=pobj_c->ppobj_Member[i]->TypeInfo.u.lpIndex;

	//|C^ϐ̏ꍇ
	if(IsPtrType(type)){
		if(pobj_c->ppobj_Member[i]->SubScripts[0]==-1){
			lstrcpy(lpPtrOffset,array);
			array[0]=0;
		}
	}
	else{
		if(lpPtrOffset[0]){
			if(bError) SetError(16,member,cp);
			return 0;
		}
	}

	if(object_type){
		//q\̏ꍇ

		return GetMemberType(pobj_c->ppobj_Member[i]->TypeInfo.u.pobj_Class,
			NestMember,
			plpNestIndex,
			0,
			bError);
	}

	if(array[0]==0&&pobj_c->ppobj_Member[i]->SubScripts[0]!=-1){
		return type|FLAG_PTR;
	}

	if(lpPtrOffset[0]){
		if(PTR_LEVEL(type)){
			type=MAKE_PTR_TYPE(NATURAL_TYPE(type),PTR_LEVEL(type)-1);
		}
		else{
			//G[
			if(bError) SetError(1,NULL,cp);
			return -1;
		}
	}

	return type;
}
int GetVarType(char *NameBuffer,LONG_PTR *plpIndex,BOOL bError){
	extern BOOL bCompilingGlobal;
	int i;
	char variable[VN_SIZE],member[VN_SIZE],VarName[VN_SIZE],array[VN_SIZE],lpPtrOffset[VN_SIZE];

	if(NameBuffer[0]=='.'){
		GetWithName(variable);
		lstrcat(variable,NameBuffer);
	}
	else lstrcpy(variable,NameBuffer);

	lstrcpy(VarName,variable);
	GetVarFormatString(VarName,array,lpPtrOffset,member,&i);

	int *pSubScripts;
	int type;
	LONG_PTR lpIndex;

	extern int MaxGlobalVarNum;
	extern VARIABLE *GlobalVar;
	extern int MaxLocalVarNum;
	extern VARIABLE *LocalVar;

	if(bCompilingGlobal==0){
		/////////////////
		// [Jϐ
		/////////////////

		for(i=MaxLocalVarNum-1;i>=0;i--){	//LVJXR[vlăobNT[`
			if(LocalVar[i].bLiving){
				if(lstrcmp(VarName,LocalVar[i].name)==0) break;
			}
		}
		if(i>=0){
			//|C^ϐ̏ꍇ
			if(IsPtrType(LocalVar[i].type)){
				if(LocalVar[i].SubScripts[0]==-1){
					lstrcpy(lpPtrOffset,array);
					array[0]=0;
				}
			}
			else{
				if(lpPtrOffset[0]){
					if(bError) SetError(16,variable,cp);
					return -1;
				}
			}

			type=LocalVar[i].type;
			lpIndex=LocalVar[i].u.index;
			pSubScripts=LocalVar[i].SubScripts;

			goto ok;
		}
	}

	if(pobj_CompilingClass){
		///////////////////////
		// NXo̎Q
		///////////////////////

		if(lstrcmpi(variable,"This")==0){
			//ThisIuWFNg
			*plpIndex=(LONG_PTR)pobj_CompilingClass;
			return DEF_OBJECT;
		}

		if(_memicmp(variable,"This.",5)==0){
			//ThisIuWFNg̃oQƂƂ
			SlideString(variable+5,-5);
			lstrcpy(VarName,variable);
		}
		else{
			//NXoQƂƂiʏj

			for(i=0;i<pobj_CompilingClass->iMemberNum;i++){
				if(lstrcmp(VarName,pobj_CompilingClass->ppobj_Member[i]->name)==0) break;
			}
			if(i==pobj_CompilingClass->iMemberNum) goto NonClassMember;
		}

		return GetMemberType(pobj_CompilingClass,variable,plpIndex,1,bError);
	}

NonClassMember:

	//////////////////////////
	// ÓI[Jϐ
	// "Static.Object.Method.Variable"
	//////////////////////////

	char temporary[VN_SIZE];
	extern SUBINFO *pCompilingSubInfo;
	if(pCompilingSubInfo){
		GetNowStaticVarFullName(VarName,temporary);

		for(i=0;i<MaxGlobalVarNum;i++){
			if(lstrcmp(temporary,GlobalVar[i].name)==0) break;
		}
		if(i!=MaxGlobalVarNum){
			goto GlobalOk;
		}
	}


	////////////////////
	// O[oϐ
	////////////////////

	for(i=MaxGlobalVarNum-1;i>=0;i--){	//LVJXR[vlăobNT[`
		if(GlobalVar[i].bLiving){
			if(lstrcmp(VarName,GlobalVar[i].name)==0) break;
		}
	}

	if(i>=0){
		goto GlobalOk;
	}


	//////////////////////////
	// NX̐ÓIo
	//////////////////////////

	if(member[0]){
		lstrcpy(temporary,member);
		GetVarFormatString(temporary,array,lpPtrOffset,member,&i);

		char temp2[VN_SIZE];
		sprintf(temp2,"%s.%s",VarName,temporary);
		for(i=0;i<MaxGlobalVarNum;i++){
			if(lstrcmp(temp2,GlobalVar[i].name)==0) break;
		}

		if(i!=MaxGlobalVarNum){
			goto GlobalOk;
		}
	}

	if(pobj_CompilingClass){
		//g̃NXÓIoQƂꍇ
		char temp2[VN_SIZE];
		sprintf(temp2,"%s.%s",pobj_CompilingClass->name,VarName);
		for(i=0;i<MaxGlobalVarNum;i++){
			if(lstrcmp(temp2,GlobalVar[i].name)==0) break;
		}

		if(i!=MaxGlobalVarNum){
			goto GlobalOk;
		}
	}

	if(bError) SetError(3,variable,cp);
	return -1;

GlobalOk:

	//|C^ϐ̏ꍇ
	if(IsPtrType(GlobalVar[i].type)){
		if(GlobalVar[i].SubScripts[0]==-1){
			lstrcpy(lpPtrOffset,array);
			array[0]=0;
		}
	}
	else{
		if(lpPtrOffset[0]){
			if(bError) SetError(16,variable,cp);
			return -1;
		}
	}

	type=GlobalVar[i].type;
	lpIndex=GlobalVar[i].u.index;
	pSubScripts=GlobalVar[i].SubScripts;

ok:

	if(member[0]){
		if(NATURAL_TYPE(type)==DEF_OBJECT)
			return GetMemberType((CClass *)lpIndex,member,plpIndex,0,bError);
	}

	if(array[0]==0&&pSubScripts[0]!=-1){
		//z̐擪|C^ꍇ
		type|=FLAG_PTR;
	}

	if(lpPtrOffset[0]){
		if(PTR_LEVEL(type)){
			type=MAKE_PTR_TYPE(NATURAL_TYPE(type),PTR_LEVEL(type)-1);
		}
		else{
			//G[
			if(bError) SetError(1,NULL,cp);
			return -1;
		}
	}

	*plpIndex=lpIndex;
	return type;
}



BOOL GetDimentionFormat(char *buffer,char *VarName,int *SubScripts,TYPEINFO *pTypeInfo,char *InitBuf,char *ConstractParameter){
	int i,i2,i3,IsStr;
	char variable[VN_SIZE],temporary[8192];

	for(i=0;;i++){
		if((buffer[i]==1&&buffer[i+1]==ESC_AS)||
			buffer[i]=='='||
			buffer[i]=='\0'){
			variable[i]=0;
			break;
		}
		variable[i]=buffer[i];
	}

	if(buffer[i]=='='){
		////////////////////////////////////
		// f[^w肳ꂢƂ
		////////////////////////////////////

		for(i++,i2=0,IsStr=0;;i++,i2++){
			if(buffer[i]=='\"') IsStr^=1;
			if(buffer[i]=='('&&IsStr==0){
				i3=GetStringInPare(InitBuf+i2,buffer+i);
				i+=i3-1;
				i2+=i3-1;
				continue;
			}
			if(buffer[i]=='['&&IsStr==0){
				i3=GetStringInBracket(InitBuf+i2,buffer+i);
				i+=i3-1;
				i2+=i3-1;
				continue;
			}
			if((buffer[i]==1&&buffer[i+1]==ESC_AS)||
				(buffer[i]==','&&IsStr==0)||
				buffer[i]=='\0'){
				InitBuf[i2]=0;
				break;
			}
			InitBuf[i2]=buffer[i];
		}
	}
	else{
		//f[^Ȃ
		InitBuf[0]=0;
	}

	ConstractParameter[0]=0;
	if(buffer[i]==1&&buffer[i+1]==ESC_AS){
		/////////////////////////////
		// "As `" ɂ^w肠
		/////////////////////////////

		for(i+=2,i2=0;;i++,i2++){
			if(buffer[i]==','||buffer[i]=='('||buffer[i]=='\0'){
				temporary[i2]=0;
				break;
			}
			temporary[i2]=buffer[i];
		}
		pTypeInfo->type=GetTypeFixed(temporary,&pTypeInfo->u.lpIndex);
		if(pTypeInfo->type==-1){
			SetError(3,temporary,cp);
			return 0;
		}

		if(pTypeInfo->type==DEF_PTR_PROC){
			if(temporary[0]=='*'&&
				temporary[1]==1&&
				(temporary[2]==ESC_FUNCTION||temporary[2]==ESC_SUB)){
				if(buffer[i]!='('){
					SetError(10,temporary,cp);
					return 0;
				}
				i3=GetStringInPare(temporary+3,buffer+i);
				i+=i3;
				i2+=i3;

				if(temporary[2]==ESC_FUNCTION&&buffer[i]==1&&buffer[i+1]==ESC_AS){
					temporary[i2++]=buffer[i++];
					temporary[i2++]=buffer[i++];
					for(;;i++,i2++){
						if(!IsVariableChar(buffer[i])){
							temporary[i2]=0;
							break;
						}
						temporary[i2]=buffer[i];
					}
				}
			}
			else{
				//TypeDefÕx[X^擾
				GetOriginalTypeName(temporary);
			}

			if(temporary[3]!='('){
				SetError(10,temporary,cp);
				return 0;
			}

			//֐|C^
			pTypeInfo->u.lpIndex=AddProcPtrInfo(temporary+3,temporary[2]);
		}

		if(buffer[i]=='('){
			//RXgN^ɓnp[^擾
			i2=GetStringInPare(ConstractParameter,buffer+i);
			i+=i2;
			RemoveStringPare(ConstractParameter);

			if(pTypeInfo->type!=DEF_OBJECT){
				SetError(112,variable,cp);
				return 0;
			}
		}
	}
	else{
		//AswȂ
		pTypeInfo->type=GetTypeFromSimpleName(variable);

		i2=lstrlen(variable)-1;
		if(i2>=0){
			if(!(variable[i2]=='#'||variable[i2]=='!'||variable[i2]=='%'||variable[i2]=='$'))
				SetError(-103,variable,cp);
		}
	}

	GetArrange(variable,VarName,SubScripts);
	return 1;
}

BOOL GetNowStaticVarFullName(char *VarName,char *FullName){
	extern SUBINFO *pCompilingSubInfo;
	if(!pCompilingSubInfo) return 0;

	//Static
	lstrcpy(FullName,"Static%");

	//NX
	if(pobj_CompilingClass){
		lstrcat(FullName,pobj_CompilingClass->name);
		lstrcat(FullName,"%");
	}

	//֐
	lstrcat(FullName,pCompilingSubInfo->name);
	lstrcat(FullName,"%");

	//ID
	char temp[255];
	sprintf(temp,"%x",pCompilingSubInfo->id);
	lstrcat(FullName,temp);
	lstrcat(FullName,"%");

	lstrcat(FullName,VarName);

	return 1;
}


void AddGlobalVariable(char *name,int *SubScripts,TYPEINFO *pTypeInfo,int TypeSize,char *InitBuf,char *ConstractParameter,DWORD dwFlag){
	/////////////////////////
	// O[oϐǉ
	/////////////////////////
	extern VARIABLE *GlobalVar;
	extern int MaxGlobalVarNum;
	extern int AllInitGlobalVarSize;
	extern int AllGlobalVarSize;

	int i2,i3,VarSize;

	for(i2=0;i2<MaxGlobalVarNum;i2++){
		if(GlobalVar[i2].bLiving&&obj_LexScopes.GetNowLevel()==GlobalVar[i2].ScopeLevel){
			if(lstrcmp(GlobalVar[i2].name,name)==0){
				//Qd`̃G[
				SetError(15,name,cp);
				return;
			}
		}
	}

	GlobalVar=(VARIABLE *)HeapReAlloc(hHeap,0,GlobalVar,(MaxGlobalVarNum+1)*sizeof(VARIABLE));

	for(i2=1,i3=0;i3<255;i3++){
		//zvf
		GlobalVar[MaxGlobalVarNum].SubScripts[i3]=SubScripts[i3];

		if(SubScripts[i3]==-1) break;
		i2*=SubScripts[i3]+1;
	}
	VarSize=TypeSize*i2;
	if(VarSize%PTR_SIZE) VarSize+=PTR_SIZE-(VarSize%PTR_SIZE);

	lstrcpy(GlobalVar[MaxGlobalVarNum].name,name);
	if(SubScripts[0]==-1) GlobalVar[MaxGlobalVarNum].bArray=0;
	else GlobalVar[MaxGlobalVarNum].bArray=1;
	GlobalVar[MaxGlobalVarNum].type=pTypeInfo->type;
	GlobalVar[MaxGlobalVarNum].u.index=pTypeInfo->u.lpIndex;

	//RXgN^pp[^
	GlobalVar[MaxGlobalVarNum].ConstractParameter=(char *)HeapAlloc(hHeap,0,lstrlen(ConstractParameter)+1);
	lstrcpy(GlobalVar[MaxGlobalVarNum].ConstractParameter,ConstractParameter);

	if(InitBuf[0]||dwFlag==DIMFLAG_INITDEBUGVAR){
		//obt@Ƃ
		GlobalVar[MaxGlobalVarNum].offset=AllInitGlobalVarSize;
		AllInitGlobalVarSize+=VarSize;
	}
	else{
		//obt@ȂƂ
		GlobalVar[MaxGlobalVarNum].offset=AllGlobalVarSize | 0x80000000;
		AllGlobalVarSize+=VarSize;
	}

	//LVJXR[v
	GlobalVar[MaxGlobalVarNum].ScopeLevel=obj_LexScopes.GetNowLevel();
	GlobalVar[MaxGlobalVarNum].ScopeStartAddress=obj_LexScopes.GetStartAddress();
	GlobalVar[MaxGlobalVarNum].bLiving=TRUE;

	//obt@Ƀf[^Zbg
	extern BYTE *initGlobalBuf;
	initGlobalBuf=(BYTE *)HeapReAlloc(hHeap,
		HEAP_ZERO_MEMORY,
		initGlobalBuf,
		AllInitGlobalVarSize);
	if(InitBuf[0])
		SetInitGlobalData(GlobalVar[MaxGlobalVarNum].offset,
			GlobalVar[MaxGlobalVarNum].type,
			GlobalVar[MaxGlobalVarNum].u.index,
			GlobalVar[MaxGlobalVarNum].SubScripts,
			InitBuf);


	//G[p
	GlobalVar[MaxGlobalVarNum].source_code_address=cp;


	MaxGlobalVarNum++;



	if(pTypeInfo->type==DEF_OBJECT){
		//pΏۂ̃NXRXgN^AfXgN^Ɏgp`FbN
		for(i2=0;i2<pTypeInfo->u.pobj_Class->iMethodNum;i2++){
			if(lstrcmp(pTypeInfo->u.pobj_Class->ppobj_Method[i2]->psi->name,pTypeInfo->u.pobj_Class->name)==0){
				//RXgN^
				pTypeInfo->u.pobj_Class->ppobj_Method[i2]->psi->bUse=1;
			}
			if(pTypeInfo->u.pobj_Class->ppobj_Method[i2]->psi->name[0]=='~'){
				//fXgN^
				pTypeInfo->u.pobj_Class->ppobj_Method[i2]->psi->bUse=1;
			}
		}
	}
}
