#include "stdafx.h"

using namespace ActiveBasic::IDE;
using namespace ActiveBasic::IDE::WindowComponents;

LRESULT CALLBACK WindowFunc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam);
void SetupWindow(HWND hwnd);
void ResetTextEditFont(HWND hwnd);

::LRESULT MainFrame::OnCreate( ::UINT msg, ::WPARAM wParam, ::LPARAM lParam, ::BOOL& handled )
{
	// EBhEGA}l[WɐeEBhEo^
	wam.SetParentWnd( m_hWnd );

	RECT rect;
	GetClientRect( &rect );

	// MDIx[X쐬
	mdiWindow = new MdiWindow();
	mdiWindow->Create(
		m_hWnd,
		rect,
		NULL,
		WS_CHILD
	);
	wam.AddMdiWindow( mdiWindow );





	extern HWND hOwner;
	hOwner = m_hWnd;
	extern WNDPROC oldMainFrameWndProc;
	oldMainFrameWndProc = (WNDPROC)::GetWindowLong( hOwner, GWL_WNDPROC );
	::SetWindowLong( hOwner, GWL_WNDPROC, (LONG)WindowFunc );

	SetupWindow(hOwner);

	//eLXgGfB^tHgݒ
	ResetTextEditFont(hOwner);



	return 0;
}

void MainFrame::OnSize(UINT nType, CSize size)
{
	//mdiWindow->MoveWindow( 0, 0, size.cx, size.cy );
}

::LRESULT MainFrame::OnClose( ::UINT msg, ::WPARAM wParam, ::LPARAM lParam, ::BOOL& handled )
{
	DestroyWindow();
	return 0;
}
::LRESULT MainFrame::OnDestroy( ::UINT msg, ::WPARAM wParam, ::LPARAM lParam, ::BOOL& handled )
{
	mdiWindow->DestroyWindow();
	delete mdiWindow;

	::PostQuitMessage( 0 );

	return 0;
}

void backup(void *dummy);
void MainFrame::OnTimer( UINT_PTR id )
{
	switch( id )
	{
	case ID_TIMER_BACKUP:
		_beginthread( backup, 0, 0 );
		break;

#ifndef THETEXT
	case ID_DEBUGSAFTY:
		{
			//BasicCompiler.exeIĂ邩ǂ
			extern CDebugger *pobj_Debugger;
			pobj_Debugger->SaftyCheck();
			break;
		}
#endif
	}
}

void ResetState_EditMenu(void);
void MainFrame::OnDrawClipboard()
{
	ResetState_EditMenu();
}

void MenuAdvice(WPARAM msg);
void MainFrame::OnMenuSelect( UINT nItemID, UINT nFlags, HMENU menu )
{
	MenuAdvice( nItemID );
}

void MainFrame::OnInitMenu( CMenu menu )
{
	extern CNonVolatile *pobj_nv;
	extern CSubMenuEx *pobj_FileHistoryMenu;
	pobj_nv->pobj_History->ResetFileMenu(pobj_FileHistoryMenu,1);
#ifndef THETEXT
	extern CSubMenuEx *pobj_ProjectHistoryMenu;
	pobj_nv->pobj_ProjectHistory->ResetFileMenu(pobj_ProjectHistoryMenu,0);
#endif
}

void MainFrame::OnMeasureItem( int nIDCtl, LPMEASUREITEMSTRUCT lpMI )
{
	if(lpMI->CtlType==ODT_MENU){
		SIZE size;
		CMenuItemData *pobj_MenuItemData;
		pobj_MenuItemData=(CMenuItemData *)lpMI->itemData;
		if(pobj_MenuItemData->pobj_ThisMenu->hMenu==pobj_MainMenu->hMenu){
			//Cj[̐eACe
			pobj_MainMenu->GetItemSize(pobj_MenuItemData->item_index,&size);
			lpMI->itemWidth = size.cx;
			lpMI->itemHeight = size.cy;
		}
		else{
			//Cj[ɂԂ炳Tuj[
			pobj_MenuItemData->pobj_ThisMenu->GetItemSize(pobj_MenuItemData->item_index,&size);
			lpMI->itemWidth = size.cx;
			lpMI->itemHeight = size.cy;
		}
	}
}

void MainFrame::OnDrawItem( int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct )
{
	if(lpDrawItemStruct->CtlType==ODT_MENU){
		if(!pobj_MainMenu) return;

		CMenuItemData *pobj_MenuItemData;
		pobj_MenuItemData=(CMenuItemData *)lpDrawItemStruct->itemData;
		if(pobj_MainMenu->hMenu==pobj_MenuItemData->pobj_ThisMenu->hMenu){
			//Cj[̐eACe
			pobj_MainMenu->OwnerDrawMenu(lpDrawItemStruct->hDC,
				&lpDrawItemStruct->rcItem,
				(lpDrawItemStruct->itemState&ODS_SELECTED)!=0,
				pobj_MenuItemData->item_index);
		}
		else{
			//Cj[ɂԂ炳Tuj[
			pobj_MainMenu->OwnerDrawSubMenu(pobj_MenuItemData->pobj_ThisMenu->hMenu,
				lpDrawItemStruct->hDC,
				&lpDrawItemStruct->rcItem,
				(lpDrawItemStruct->itemState&ODS_SELECTED)!=0,
				pobj_MenuItemData->item_index);
		}
	}
}

LRESULT MainFrame::OnNotify( int idCtrl, LPNMHDR pnmh )
{
	NMPGCALCSIZE *lpCalcSize;
	NMPGSCROLL *lpScroll;

	if(!pnmh) return 0;
	LPTOOLTIPTEXT TipText=(LPTOOLTIPTEXT)pnmh;
	if(TipText->hdr.code==TTN_NEEDTEXT) ShowToolTipText(TipText);

	extern HWND hStandardToolbarPager;
	extern HWND hDebuggerToolbarPager;
	if(pobj_Rebar){
		//o[IuWFNg݂Ƃ
		if(pnmh->hwndFrom==pobj_Rebar->hRebar&&pnmh->code==RBN_HEIGHTCHANGE){
			ResizeOwnerWnd();
			return 0;
		}
	}
	if(pnmh->hwndFrom==hStandardToolbarPager){
		if(pnmh->code==PGN_CALCSIZE){
			lpCalcSize=(LPNMPGCALCSIZE)pnmh;
			if(lpCalcSize->dwFlag==PGF_CALCWIDTH)
				lpCalcSize->iWidth=BMPNUM_STANDARDTOOLBAR*23+SEPNUM_STANDARDTOOLBAR*8;
		}
		else if(pnmh->code==PGN_SCROLL){
			lpScroll=(LPNMPGSCROLL)pnmh;
			lpScroll->iScroll=20;
		}
	}
	else if(pnmh->hwndFrom==hDebuggerToolbarPager){
		if(pnmh->code==PGN_CALCSIZE){
			lpCalcSize=(LPNMPGCALCSIZE)pnmh;
			if(lpCalcSize->dwFlag==PGF_CALCWIDTH)
				lpCalcSize->iWidth=BMPNUM_DEBUGGERTOOLBAR*23+SEPNUM_DEBUGGERTOOLBAR*8;
		}
		else if(pnmh->code==PGN_SCROLL){
			lpScroll=(LPNMPGSCROLL)pnmh;
			lpScroll->iScroll=20;
		}
	}

	if(pobj_MainTab){
		if(pnmh->hwndFrom==pobj_MainTab->hTab){
			if(pnmh->code==TCN_SELCHANGE)
				pobj_MainTab->SelChangeEvent();

			if(pnmh->code==NM_RCLICK){

				TCHITTESTINFO tcHitTest;
				GetCursorPos(&tcHitTest.pt);
				::ScreenToClient(pobj_MainTab->hTab,&tcHitTest.pt);
				int index = TabCtrl_HitTest(pobj_MainTab->hTab,&tcHitTest);
				if( index == -1 ) return 0;

				TabCtrl_SetCurSel(pobj_MainTab->hTab,index);

				pobj_MainTab->SelChangeEvent();


				/////////////////////
				// j[\
				/////////////////////

				HWND hChild=::GetWindow(hClient,GW_CHILD);
				int WndNum=GetWndNum(hChild);

				//ۑR}h̕Zbg
				char temporary[1024], temp2[1024];
				MENUITEMINFO mii;
				mii.cbSize=sizeof(MENUITEMINFO);
				mii.fMask=MIIM_TYPE;
				mii.dwTypeData=temporary;
				mii.fType=MFT_STRING;
				if(MdiInfo[WndNum].path[0]){
					_splitpath(MdiInfo[WndNum].path,NULL,NULL,temporary,temp2);
					lstrcat(temporary,temp2);
					lstrcat(temporary," ۑ(&S)");
				}
				else{
					lstrcpy(temporary,"ۑ(&S)");
				}
				extern HMENU hTabMenu;
				SetMenuItemInfo(hTabMenu,IDM_SAVE,FALSE,&mii);

				/*u΃pXRs[vutH_Jvut@C폜v
												R}hꍇɂĖɂ */
				if(MdiInfo[WndNum].path[0]){
					EnableMenuItem(hTabMenu,IDM_PATH_COPY,MF_BYCOMMAND|MF_ENABLED);
					EnableMenuItem(hTabMenu,IDM_FOLDER_OPEN,MF_BYCOMMAND|MF_ENABLED);
					EnableMenuItem(hTabMenu,IDM_DELETE_FILE,MF_BYCOMMAND|MF_ENABLED);
				}
				else{
					EnableMenuItem(hTabMenu,IDM_PATH_COPY,MF_BYCOMMAND|MF_GRAYED);
					EnableMenuItem(hTabMenu,IDM_FOLDER_OPEN,MF_BYCOMMAND|MF_GRAYED);
					EnableMenuItem(hTabMenu,IDM_DELETE_FILE,MF_BYCOMMAND|MF_GRAYED);
				}

				POINT MousePos;
				GetCursorPos(&MousePos);
				TrackPopupMenu(hTabMenu,TPM_LEFTALIGN|TPM_RIGHTBUTTON,MousePos.x,MousePos.y,0,hOwner,NULL);
			}
		}
	}
	if(pobj_SideWeb){
		if(pnmh->hwndFrom==pobj_SideWeb->hTab&&pnmh->code==TCN_SELCHANGE){
			pobj_SideWeb->SelChangeEvent();
		}
	}

	return 0;
}

void MainFrame::OnCmdNew( UINT uNotifyCode, int nID, CWindow wndCtl )
{

#ifdef THETEXT
	NewTextEditWindow(NULL,WNDTYPE_TEXT);
	return;
#else
	int FileType;
	BOOL bAddToProject;
	char temporary[MAX_PATH];

	FileType=DialogBox(hResInst,MAKEINTRESOURCE(IDD_NEWFILE),hOwner,(DLGPROC)DlgNewFile);
	if(FileType==-1) return;

	if(FileType&0x00008000){
		bAddToProject=1;
		FileType&=0x0FFF;
		extern char NewFileName[MAX_PATH];
		lstrcpy(temporary,NewFileName);
		if(!strstr(temporary,".")) lstrcat(temporary,".ab");
		GetFullPath(temporary,ProjectInfo.dir);
	}
	else bAddToProject=0;

	switch(FileType){
		case FT_BASICPROGRAM:		//BasicvO
		case FT_SUBPROGRAM:
			if(bAddToProject){
				WriteBuffer(temporary,0,0);
				NewTextEditWindow(temporary,WNDTYPE_BASIC);
				Project_File_Insert(temporary);
			}
			else NewTextEditWindow(NULL,WNDTYPE_BASIC);
			break;

		case FT_PROJECT:
			DlgNewProjectWizard(hOwner);
			break;

		case FT_TEXT:
			NewTextEditWindow(NULL,WNDTYPE_TEXT);
			break;

		case FT_HTML:
			NewTextEditWindow(NULL,WNDTYPE_HTML);
			break;

		case FT_ICON:
			NewIconEditWindow(NULL);
			break;
	}
#endif
}

void MainFrame::OnCmdOpen( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	//"t@Cw肵Ă"
	extern LPSTR DefFileFilter;
	char temporary[1024];
	if(!GetFilePathDialog(m_hWnd,temporary,DefFileFilter,STRING_FILEOPENTITLE_DEFAULT,TRUE)) return;

	OpenFileWithExtension( temporary );
}

void MainFrame::OnCmdClose( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	if(::IsWindow(hChild)) SendMessage(hChild,WM_CLOSE,0,0);
}
