#pragma once

namespace ActiveBasic{ namespace IDE{ namespace WindowComponents{


class MdiWindow
	: public CMDIFrameWindowImpl<MdiWindow>
	, public CUpdateUI<MdiWindow>
	, public CMessageFilter
	, public CIdleHandler
{
public:
    virtual BOOL PreTranslateMessage(MSG* pMsg){
        if(CMDIFrameWindowImpl<MdiWindow>::PreTranslateMessage(pMsg))
            return TRUE;

        // ANeBuȎqEBhEɃbZ[WtB^̋@^
        HWND hWnd = MDIGetActive();
        if(hWnd != NULL)
            return (BOOL)::SendMessage(hWnd, WM_FORWARDMSG, 0, (LPARAM)pMsg);

        return FALSE;
    }

    virtual BOOL OnIdle(){
        UIUpdateToolBar();
        UIUpdateStatusBar();
        return FALSE;
    }

    BEGIN_UPDATE_UI_MAP(MdiWindow)
        // GgȂ
    END_UPDATE_UI_MAP()

    BEGIN_MSG_MAP_EX(MdiWindow)
        MSG_WM_CREATE(OnCreate)
        COMMAND_ID_HANDLER_EX(ID_APP_EXIT, OnFileExit)
        COMMAND_ID_HANDLER_EX(ID_FILE_NEW, OnFileNew)
        COMMAND_ID_HANDLER_EX(ID_WINDOW_CASCADE, OnWindowCascade)
        COMMAND_ID_HANDLER_EX(ID_WINDOW_TILE_HORZ, OnWindowTile)
        COMMAND_ID_HANDLER_EX(ID_WINDOW_ARRANGE, OnWindowArrangeIcons)
        CHAIN_MSG_MAP(CUpdateUI<MdiWindow>)
        CHAIN_MSG_MAP(CMDIFrameWindowImpl<MdiWindow>)
    END_MSG_MAP()

    LRESULT OnCreate(LPCREATESTRUCT lpcs);

    void OnFileExit(UINT uNotifyCode, int nID, HWND hWndCtl){
        PostMessage(WM_CLOSE);
    }

    void OnFileNew(UINT uNotifyCode, int nID, HWND hWndCtl){
        // qEBhE쐬
        MdiChild *child = new MdiChild();
        child->CreateEx( m_hWndClient );
    }

    void OnWindowCascade(UINT uNotifyCode, int nID, HWND hWndCtl){
        // qEBhEd˂ĕ\
        MDICascade();
    }

    void OnWindowTile(UINT uNotifyCode, int nID, HWND hWndCtl){
        // qEBhE㉺ɕׂĕ\
        MDITile();
    }

    void OnWindowArrangeIcons(UINT uNotifyCode, int nID, HWND hWndCtl){
        // ŏꂽqEBhẼACR𐮗
        MDIIconArrange();
    }
};


}}}
