#include "stdafx.h"

void Messenger::Output( const std::string &message )
{
	////////////////////////////////////////////////////////////////////
	// GfBbgRg[ɏo
	////////////////////////////////////////////////////////////////////
	extern HWND hMainDlg;

	// o͐̃GfBbgRg[ĂƂ̓NAėL
	if( !IsWindowEnabled( GetDlgItem(hMainDlg,IDC_ERRORLIST) ) )
	{
		SetDlgItemText( hMainDlg, IDC_ERRORLIST, "" );
		EnableWindow( GetDlgItem( hMainDlg, IDC_ERRORLIST ), TRUE );
	}

	// GfBbgRg[ɏo
	int i2 = GetWindowTextLength(GetDlgItem(hMainDlg,IDC_ERRORLIST));
	SendDlgItemMessage(hMainDlg,IDC_ERRORLIST,EM_SETSEL,i2,i2);
	SendDlgItemMessage(hMainDlg,IDC_ERRORLIST,EM_REPLACESEL,0,(LPARAM)(message + "\r\n").c_str());


	// Oɏo
	trace( message );

	// Wo
	std::cout << message << endl;
}
int Messenger::GetNextErrorLine()
{
	extern HWND hMainDlg;
	int index = GetWindowTextLength(GetDlgItem(hMainDlg,IDC_ERRORLIST));
	return static_cast<int>(SendMessage(GetDlgItem(hMainDlg,IDC_ERRORLIST),EM_LINEFROMCHAR,index,0));
}

ErrorInfo::ErrorInfo( int errorCode, const std::string &keyword, int sourceIndex )
	: errorCode( errorCode )
	, keyword( keyword )
	, sourceFilePath( "" )
	, sourceLineNum( -1 )
{
	if( sourceIndex != -1 )
	{
		compiler.GetObjectModule().GetCurrentSource().GetLineInfo( sourceIndex, sourceLineNum, sourceFilePath );
	}

	errorLineNum = compiler.messenger.GetNextErrorLine();
}

std::string ErrorInfo::GetMessageString() const
{
	extern HANDLE hHeap;
	int i2;
	char temporary[64];

	char tempKeyWord[1024];
	lstrcpy(tempKeyWord,keyword.c_str());
	for(i2=0;;i2++){
		if(tempKeyWord[i2]=='\0') break;
		if(tempKeyWord[i2]==1){
			GetDefaultNameFromES(tempKeyWord[i2+1],temporary);
			SlideString(tempKeyWord+i2+2,lstrlen(temporary)-2);
			memcpy(tempKeyWord+i2,temporary,lstrlen(temporary));
		}
	}

	if( errorCode == -1 || errorCode == -2 )
	{
		// G[
		return keyword;
	}

	char msg[1024];
	if(errorCode==3)
	{
		for( int i3=0; ; i3++ )
		{
			if( !IsVariableChar( tempKeyWord[i3] ) || tempKeyWord[i3] == '.' )
			{
				temporary[i3] = 0;
				break;
			}
			temporary[i3] = tempKeyWord[i3];
		}

#if defined(JPN)
		//{
		sprintf(msg,"\"%s\" Ȏʎqł",temporary);
#else
		//p
		sprintf(msg,"\"%s\" Invalid identifier.",temporary);
#endif

	}
	if(errorCode==30){
#if defined(JPN)
		//{
		if(temporary[0]) sprintf(msg,"\"%s\" ̎gsł",tempKeyWord);
		else lstrcpy(msg,"@ԈĂ܂");
#else
		//p
		if(temporary[0]) sprintf(msg,"How to use the \"%s\" is wrong.",tempKeyWord);
		else lstrcpy(msg,"Syntax Error.");
#endif
	}


	/////////////////////
	// [jOG[
	/////////////////////
#if defined(JPN)
	////////////////////
	//{
	////////////////////
	if(errorCode==-101) sprintf(msg,"[x] %sɋϊĂ܂Bf[^\܂B",tempKeyWord);
	if(errorCode==-102) sprintf(msg,"[x] %sɋϊĂ܂B",tempKeyWord);
	if(errorCode==-103) sprintf(msg,"[x] \"%s\" ^w肳Ă܂BDouble^ƂĈ܂B",tempKeyWord);
	if(errorCode==-104) sprintf(msg,"[x] \"%s\" ߂ľ^w肳Ă܂BDouble^ƂĈ܂B",tempKeyWord);
	if(errorCode==-105) sprintf(msg,"[x] ꎞIuWFNg̉s܂BLXgpIuWFNgpӂĂB",tempKeyWord);
	if(errorCode==-106) sprintf(msg,"[x] DLLt@C \"%s\" ܂B",tempKeyWord);
	if(errorCode==-107) sprintf(msg,"[x] DLL֐ \"%s\" QƂł܂B",tempKeyWord);
	if(errorCode==-108) lstrcpy(msg,"[x] Catch߁AFinally߂ȂӖ̂ȂTryXR[vłB");
	if(errorCode==-120) sprintf(msg,"[x] VarPtr֐̈ɃIuWFNg CX^Xw肳܂BIuWFNg̐擪AhX擾ƂObjPtr֐ɐ؂ւ肢܂Bm(__)mǐxVarPtrObjPtrւ̐؂ւ܂i؂ւ \"KމӏɌ\" ł̂ŁAӂIjj",tempKeyWord);
#else
#endif


	///////////////
	// ʃG[
	///////////////

#if defined(JPN)
	////////////////////
	//{
	////////////////////
	if(errorCode==1) lstrcpy(msg,"@ԈĂ܂B");
	if(errorCode==2) sprintf(msg,"̃IyhAӒlɂȂĂ܂B");
	//errorCode==3͗\񂳂Ă܂
	if(errorCode==4) sprintf(msg,"%s̑݊֌Wv܂B",tempKeyWord);
	if(errorCode==5) sprintf(msg,"_uNH[g̐v܂B");
	if(errorCode==6) sprintf(msg,"\"%s\" Wv悪słB",tempKeyWord);
	if(errorCode==7) lstrcpy(msg,"DLL܂igq܂߁A16ȉɂĉjB");
	if(errorCode==8) lstrcpy(msg,"RpCFłȂR[h܂܂Ă܂B");
	if(errorCode==9) sprintf(msg,"^Ⴂ܂B");
	if(errorCode==10) sprintf(msg,"\"%s\" ̃p[^w肪ԈĂ܂B",tempKeyWord);
	if(errorCode==11) sprintf(msg,"\"%s\" ^Ⴂ܂B",tempKeyWord);
	if(errorCode==12) sprintf(msg,"%s ̎gsłB",tempKeyWord);
	if(errorCode==13) sprintf(msg,"\"%s\" QƂł܂B",tempKeyWord);
	if(errorCode==14) sprintf(msg,"\"%s\" zw肪słB",tempKeyWord);
	if(errorCode==15) sprintf(msg,"\"%s\" ͂łɒ`Ă܂B",tempKeyWord);
	if(errorCode==16) sprintf(msg,"\"%s\" zA܂̓|C^ȊO̕ϐɓYw肳Ă܂B",tempKeyWord);
	if(errorCode==17) sprintf(msg,"\[X f[^słB");
	if(errorCode==18) sprintf(msg,"\"%s\"̓|C^ϐ^łB񉉎Zw肷邱Ƃ͂ł܂B",tempKeyWord);
	if(errorCode==19) sprintf(msg,"\"%s\"͒lQƌ^łBByValw肷邱Ƃ͂ł܂B",tempKeyWord);
	if(errorCode==20) lstrcpy(msg,"SpXy[X܂܂Ă܂iSpXy[X̓RpCFłȂ̂ŁApXy[X܂̓^uɂĂjB");
	if(errorCode==21) sprintf(msg,"If̃ubNw肪słB");
	if(errorCode==22) sprintf(msg,"%s ɑ΂ End %s ܂B",tempKeyWord,tempKeyWord);
	if(errorCode==23) sprintf(msg,"\[X t@C \"%s\" ̓ǂݍ݂ɎsB",tempKeyWord);
	if(errorCode==24) lstrcpy(msg,"Exportẘ֐̃p[^ɂ͎̃IuWFNg𗘗p邱Ƃ͂ł܂iBytePtr^Ȃǂ𗘗pĉjB");
	if(errorCode==25) sprintf(msg,"DLL֐ɃIuWFNgnƂ͂ł܂(%s)B",tempKeyWord);
	if(errorCode==26) sprintf(msg,"\"%s\" ߂ľ^w肳Ă܂B",tempKeyWord);
	if(errorCode==27) sprintf(msg,"\"%s\" ͒`Ă܂B",tempKeyWord);
	if(errorCode==28) sprintf(msg,"\̃p[^͎QƓnɂĂ(%s)B",tempKeyWord);
	if(errorCode==29) sprintf(msg,"z|C^vfƓɈnƂ́A|C^QƁiByRefjɂĂB");
	//errorCode==30͗\񂳂Ă܂
	if(errorCode==31) sprintf(msg,"\"%s\" ͍\̂łio̎QƂ̓sIh \".\" ŋ؂ĂjB",tempKeyWord);
	if(errorCode==32) sprintf(msg,"\"%s\" ͍\̃|C^łio̎QƂ \"->\" ŋ؂ĂjB",tempKeyWord);
	if(errorCode==33) sprintf(msg,"萔ɃelA܂͒萔ȊÔ̂܂܂Ă܂B");
	if(errorCode==34) sprintf(msg,"萔̓W[xŐ錾ĉB");
	if(errorCode==38) sprintf(msg,"\"%s\" ߂l݂ȂvV[WłB",tempKeyWord);
	if(errorCode==39) sprintf(msg,"\"%s\" ̓IuWFNg|C^ł͂܂i\"->\" QƂ͂ł܂jB",tempKeyWord);
	if(errorCode==40) lstrcpy(msg,"DLL֐̖߂lƂăIuWFNg󂯎邱Ƃ͂ł܂B");
	if(errorCode==41) lstrcpy(msg,"f[^słB");
	if(errorCode==42) lstrcpy(msg,"JbR \")\" ̌ɕsȕ܂܂Ă܂B");
	if(errorCode==43) lstrcpy(msg,"_uNH[ǧɕsȕ܂܂Ă܂B");
	if(errorCode==45) sprintf(msg,"ɑ΂ \"%s\" Zq͗pł܂B",tempKeyWord);
	if(errorCode==46) lstrcpy(msg,"z̓YɐȊO̒l^Ă܂B");
	if(errorCode==47) lstrcpy(msg,"AsZq̉EӒlɌ^ȊO̎ʎqw肳Ă܂B");
	if(errorCode==48) sprintf(msg,"%sZqɑ΂Č^w肳Ă܂B",tempKeyWord);
	if(errorCode==49) lstrcpy(msg,"YɐȊǑ^w肳Ă܂B");
	if(errorCode==50) sprintf(msg,"%sɕϊł܂B",tempKeyWord);
	if(errorCode==51) lstrcpy(msg,"IuWFNgA\̂̃ACgl 1, 2, 4, 8, 16 ̂ꂩłȂ΂Ȃ܂B");
	if(errorCode==52) sprintf(msg,"\"%s\" I[o[[hł܂B",tempKeyWord);
	if(errorCode==53) sprintf(msg,"\"%s\" o̓t@C݂̏Ɏs܂BsĂ\܂B",tempKeyWord);
	if(errorCode==54) sprintf(msg,"Ή%s݂܂B",tempKeyWord);
	if(errorCode==55) sprintf(msg,"\"%s\" ͑ΉForXe[ggŗpJE^ϐł͂܂B",tempKeyWord);
	if(errorCode==56) lstrcpy(msg,"[肪s܂B");
	if(errorCode==57) lstrcpy(msg,"8ĩe\LsłB");
	if(errorCode==58) lstrcpy(msg,"16ĩe\LsłB");
	if(errorCode==59) sprintf(msg,"}jtFXg t@C \"%s\" ̓ǂݍ݂ɎsB",tempKeyWord);
	if(errorCode==60) lstrcpy(msg,"StaticXe[gg̓O[öł͎gpł܂B");
	if(errorCode==61) sprintf(msg,"\"%s\" ͒萔łB݃ANZX͂ł܂B",tempKeyWord);
	if(errorCode==62) sprintf(msg,"O[öłReturn͋֎~Ă܂B",tempKeyWord);
	if(errorCode==63) lstrcpy(msg,"OԂĂ܂B");
	if(errorCode==64) sprintf(msg,"\"%s\" ȖOԂłB",tempKeyWord);
	if(errorCode==65) sprintf(msg,"[J̈%s͎gpł܂B",tempKeyWord);
	if(errorCode==66) sprintf(msg,"%s vĂ֐|C^̃p[^܂͖߂lv܂B", tempKeyWord );
	if(errorCode==67) sprintf(msg,"%s vĂfQ[g̃p[^܂͖߂lv܂B", tempKeyWord );
	if(errorCode==68) sprintf(msg,"\"%s\" sȊ֐łB", tempKeyWord);
	if(errorCode==69) sprintf(msg,"\"%s\" sȃ\bhłB", tempKeyWord);
	if(errorCode==70) lstrcpy(msg,"Tryɑ΂ĕFinallyLqł܂B");
	if(errorCode==71) lstrcpy(msg,"Finally̌CatchLq邱Ƃ͂ł܂B");
	if(errorCode==72) lstrcpy(msg,"Catch̃p[^̌^w肳Ă܂B");
	if(errorCode==73) lstrcpy(msg,"\"%s\" Catch̃p[^̌^̓NX^łȂ΂Ȃ܂B");
	if(errorCode==74) sprintf(msg,"\"%s\" ^ƂĔFł܂B",tempKeyWord);


	//IuWFNg֘A
	if(errorCode==102) sprintf(msg,"\"%s\" IuWFNg͒`Ă܂B",tempKeyWord);
	if(errorCode==103) sprintf(msg,"\"%s\" o͒`Ă܂B",tempKeyWord);
	if(errorCode==104) sprintf(msg,"\"%s\" Qƕ@Ⴂ܂B",tempKeyWord);
	if(errorCode==105) sprintf(msg,"\"%s\" g̃NXp邱Ƃ͂ł܂B",tempKeyWord);
	if(errorCode==106) sprintf(msg,"\"%s\" ݂ȂNXłB",tempKeyWord);
	if(errorCode==107) sprintf(msg,"Privateo \"%s\" ɃANZX邱Ƃ͂ł܂B",tempKeyWord);
	if(errorCode==108) sprintf(msg,"Protectedo \"%s\" ɃANZX邱Ƃ͂ł܂B",tempKeyWord);
	if(errorCode==109) sprintf(msg,"Privateo֐ \"%s\" ĂяoƂ͂ł܂B",tempKeyWord);
	if(errorCode==110) sprintf(msg,"Protectedo֐ \"%s\" ĂяoƂ͂ł܂B",tempKeyWord);
	if(errorCode==111) lstrcpy(msg,"InheritsClass`̐擪ɋLqKv܂B");
	if(errorCode==112) sprintf(msg,"\"%s\" ̓NX^ł͂Ȃ߁Ap[^w肷邱Ƃ͂ł܂B",tempKeyWord);
	if(errorCode==113) sprintf(msg,"\"%s\" RXgN^֓np[^słB",tempKeyWord);
	if(errorCode==114) lstrcpy(msg,"fXgN^̓p[^Ă܂B");
	if(errorCode==115) lstrcpy(msg,"RXgN^yуfXgN^͖߂lĂ܂B");
	//if(errorCode==116) lstrcpy(msg,"RXgN^yуfXgN^̓pubNANZXɂȂ΂Ȃ܂B");
	if(errorCode==117) lstrcpy(msg,"fXgN^̖O \"~NX\" ɂȂĂ܂B");
	if(errorCode==118) lstrcpy(msg,"QƂNX݂܂B");
	if(errorCode==119) sprintf(msg,"\"%s\" o͊NXŒ`Ă܂B",tempKeyWord);
	if(errorCode==120) lstrcpy(msg,"fXgNgIuWFNǧ^słB");
	if(errorCode==121) lstrcpy(msg,"NewZqɂ̓NXȊǑ^wł܂B");
	if(errorCode==122) lstrcpy(msg,"DeleteZqɃ|C^ȊǑ^w肳Ă܂B");
	if(errorCode==123) lstrcpy(msg,"[vps܂B");
	if(errorCode==124) lstrcpy(msg,"zQƂs܂B");
	if(errorCode==125) sprintf(msg,"\"%s\" ͒ۃNXłBCX^X邱Ƃ͂ł܂B",tempKeyWord);
	if(errorCode==126) lstrcpy(msg,"Iy[^̃I[o[[hNX̊OōsƂ͂ł܂B");
	if(errorCode==127) lstrcpy(msg,"OverrideCq̎w肪󋵂ŃI[o[ChsƂ͂ł܂B");
	if(errorCode==128) lstrcpy(msg,"I[o[ChsƂ̓ANZVreB𓯈ɂȂ΂Ȃ܂B");
	if(errorCode==129) sprintf(msg,"ÓIo \"%s\" ͒`Ă܂B",tempKeyWord);
	if(errorCode==130) sprintf(msg,"\"%s\" ̓IuWFNg萔łB݃ANZX͂ł܂B",tempKeyWord);
	if(errorCode==131) lstrcpy(msg,"Const`ꂽ\bhŃNXoւ̏݃ANZX͂ł܂B");
	if(errorCode==132) lstrcpy(msg,"IȃRXgN^ĂяoƏl̎w𓯎ɍsƂ͂ł܂B");
	if(errorCode==133) lstrcpy(msg,"Thisɑ͂ł܂B");
	if(errorCode==134) lstrcpy( msg,"ObjPtr֐ɂ̓IuWFNg CX^XȊOwł܂B" );
	if(errorCode==135) lstrcpy( msg, "NXȊǑ^pƂĎw肷邱Ƃ͂ł܂B" );
	if(errorCode==136) sprintf( msg, "\"%s\" 񉼑z֐ɑ΂ăI[o[Ch悤Ƃ܂B", tempKeyWord );
	if(errorCode==137) lstrcpy(msg,"ImplementsClass`̐擪ɋLqKv܂B");
	if(errorCode==138) sprintf(msg,"%s ̓C^[tFCXł͂܂BImplementsł̂̓C^[tFCXɌ܂B",tempKeyWord);
	if(errorCode==139) sprintf(msg,"%s ̓C^[tFCXł͂܂B",tempKeyWord);
	if(errorCode==140) lstrcpy(msg,"AlignCq\̈ȊǑ^Ɏw肷邱Ƃ͂ł܂B");
	if(errorCode==141) lstrcpy(msg,"BlittableCqNXȊǑ^Ɏw肷邱Ƃ͂ł܂B");
	if(errorCode==142) lstrcpy(msg,"sThisQƂłB");

	//Enum֘A
	if(errorCode==150) sprintf(msg,"\"%s\" l`Ă܂B",tempKeyWord);
	if(errorCode==151) sprintf(msg,"\"%s\" 񋓃Xgɓo^Ă܂B",tempKeyWord);

	//J
	if(errorCode==200) sprintf(msg,"\"%s\" ł (N G[)B",tempKeyWord);
	if(errorCode==201) sprintf(msg,"\"%s\" ̓ǂݍ݂ɎsB",tempKeyWord);
	if(errorCode==202) sprintf(msg,"\"%s\" ݂͑܂B",tempKeyWord);
	if(errorCode==203) sprintf(msg,"\"%s\" ݂͑܂Aǂݍ߂܂iÂo[W̃RpCŃrhꂽ\܂jB",tempKeyWord);

	//s
	if(errorCode==300) lstrcpy(msg,"G[");

	// x[XCus
	if( errorCode == 400 )	sprintf( msg, "\"%s\" ݂܂BWCu̓eÂ\܂B", tempKeyWord );

#else
	////////////////////
	//p
	////////////////////
	if(errorCode==1) lstrcpy(msg,"Syntax Error.");
	if(errorCode==2) sprintf(msg,"Left operand must be l-value.");
	//errorCode==3͗\񂳂Ă܂
	if(errorCode==4) sprintf(msg,"Correlation of %s is wrong.",tempKeyWord);
	if(errorCode==5) sprintf(msg,"Correlation of double quotes is wrong.");
	if(errorCode==6) sprintf(msg,"\"%s\" Label not found.",tempKeyWord);
	if(errorCode==7) lstrcpy(msg,"The DLL name is too long. Must be 16 characters or less.");
	if(errorCode==8) lstrcpy(msg,"The inaccurate characters are contained.");
	if(errorCode==9) sprintf(msg,"Type is wrong.");
	if(errorCode==10) sprintf(msg,"\"%s\" Rule of parameter is wrong.",tempKeyWord);
	if(errorCode==11) sprintf(msg,"\"%s\" Type is wrong.",tempKeyWord);
	if(errorCode==12) sprintf(msg,"\"%s\" Not a valid use.",tempKeyWord);
	if(errorCode==13) sprintf(msg,"Cannot refer to \"%s\".",tempKeyWord);
	if(errorCode==14) sprintf(msg,"\"%s\" Array argument(s) out of bound.",tempKeyWord);
	if(errorCode==15) sprintf(msg,"\"%s\" is already defined.",tempKeyWord);
	if(errorCode==16) sprintf(msg,"\"%s\" Argument(s) following variable which is not pointer or array.",tempKeyWord);
	if(errorCode==17) sprintf(msg,"Invalid resource data.");
	if(errorCode==18) sprintf(msg,"\"%s\" Invalid operation on a pointer variable.",tempKeyWord);
	if(errorCode==19) sprintf(msg,"\"%s\" is already to be passed by value. You cannot use \"ByVal\".",tempKeyWord);
	if(errorCode==21) sprintf(msg,"Wrong structure of \"If\" block.");
	if(errorCode==22) sprintf(msg,"No matching \"End %s\" found for \"%s\".",tempKeyWord,tempKeyWord);
	if(errorCode==23) sprintf(msg,"Cannot read the resource file \"%s\".",tempKeyWord);
	if(errorCode==24) lstrcpy(msg,"Must not use String type as an argument for exported function. (Use BytePtr type instead.)");
	if(errorCode==27) sprintf(msg,"\"%s\" Undefined procedure.",tempKeyWord);
	if(errorCode==28) sprintf(msg,"\"%s\" Structure must not be passed by value. (Use \"ByRef\".)",tempKeyWord);
	if(errorCode==29) sprintf(msg,"Array must not be passed by value. (Use \"ByRef\".)");
	//errorCode==30͗\񂳂Ă܂
	if(errorCode==31) sprintf(msg,"\"%s\" is a struct. (Use period \".\" to refer to the members.)",tempKeyWord);
	if(errorCode==32) sprintf(msg,"\"%s\" is a pointer of struct. (Use arrow \"->\" to refer to the members.)",tempKeyWord);
	if(errorCode==33) sprintf(msg,"Constant formula has a thing that is not literal value or constant value.");
	if(errorCode==34) sprintf(msg,"Constant formula must be defined in the module level.");
	if(errorCode==38) sprintf(msg,"\"%s\" is a procedure without a return value.",tempKeyWord);
	if(errorCode==39) sprintf(msg,"\"%s\" is not object pointer. \"->\" is invalid.",tempKeyWord);
	if(errorCode==40) lstrcpy(msg,"Cannot set a object to return value.");
	if(errorCode==41) lstrcpy(msg,"Init data is wrong.");
	if(errorCode==42) lstrcpy(msg,"The inaccurate characters are contained after the closing parenthesis \")\".");
	if(errorCode==43) lstrcpy(msg,"The inaccurate characters are contained after the double quote.");

	//IuWFNg֘A
	if(errorCode==102) sprintf(msg,"\"%s\" The object is not defined.",tempKeyWord);
	if(errorCode==103) sprintf(msg,"\"%s\" The member is not defined.",tempKeyWord);
	if(errorCode==104) sprintf(msg,"\"%s\" The reference character is different.",tempKeyWord);
	if(errorCode==105) sprintf(msg,"\"%s\" An own class is not inheritable.",tempKeyWord);
	if(errorCode==106) sprintf(msg,"\"%s\" It class is not defined.",tempKeyWord);
	if(errorCode==107) sprintf(msg,"\"%s\" Cannot access the private member.",tempKeyWord);
	if(errorCode==108) sprintf(msg,"\"%s\" Cannot access the protected member.",tempKeyWord);
	if(errorCode==109) sprintf(msg,"\"%s\" Cannot call the private member.",tempKeyWord);
	if(errorCode==110) sprintf(msg,"\"%s\" Cannot call the protected member.",tempKeyWord);
	if(errorCode==111) lstrcpy(msg,"The Inherits phrase must be described to the 1st line of class module");
	if(errorCode==112) sprintf(msg,"\"%s\" is not class object. Therefor you cannot set the parameter for constructor.",tempKeyWord);
	if(errorCode==113) sprintf(msg,"\"%s\" The parameter for constructor is wrong.",tempKeyWord);
	if(errorCode==114) lstrcpy(msg,"Destructor cannot have a parameter.");
	if(errorCode==115) lstrcpy(msg,"Constructor and Destructor cannot have a return value.");
	if(errorCode==116) lstrcpy(msg,"Constructor and Destructor must be public access.");
	if(errorCode==117) lstrcpy(msg,"Destructors name must be \"~ClassName\".");
	if(errorCode==118) lstrcpy(msg,"Super class is not found.");
	if(errorCode==119) sprintf(msg,"\"%s\" The member is not defined in the super class.",tempKeyWord);

	//Enum֘A
	if(errorCode==150) sprintf(msg,"\"%s\" The value is not set",tempKeyWord);
	if(errorCode==151) sprintf(msg,"\"%s\" is not found from enum lists.",tempKeyWord);

	//J
	if(errorCode==200) sprintf(msg,"\"%s\" Unknown error.",tempKeyWord);
#endif

	return msg;
}

std::string ErrorInfo::GetFullMessageString() const
{
	if( sourceLineNum != -1 )
	{
		char temporary[1024];
		sprintf( temporary, "%s(%d) : %s",
			sourceFilePath.c_str(),
			sourceLineNum,
			GetMessageString().c_str()
			);

		return temporary;
	}

	return GetMessageString();
}

void ErrorMessenger::Output( const ErrorInfo &errorInfo )
{
	if( errorInfo.GetErrorCode() == 3 )
	{
		if( errorInfo.GetKeyword().size() <= 0 )
		{
			// 肦Ȃ
			throw;
		}

		if( Jenga::Common::IsExistString( synonymKeyWords, errorInfo.GetKeyword() ) )
		{
			// ɃG[o͂Ăꍇ͖
			return;
		}

		synonymKeyWords.push_back( errorInfo.GetKeyword() );
	}

	errorInfos.push_back( errorInfo );

	// o
	Messenger::Output( errorInfo.GetFullMessageString() );
}
void ErrorMessenger::Output( int errorCode, const std::string &keyword, int sourceIndex )
{
	Output( ErrorInfo( errorCode, keyword, sourceIndex ) );
}
void ErrorMessenger::Output( int errorCode, const char *keyword, int sourceIndex )
{
	if( !keyword )
	{
		keyword = "";
	}
	Output( errorCode, std::string( keyword ), sourceIndex );
}
void ErrorMessenger::OutputFatalError()
{
	Output( 300, "", cp );
}

int ErrorMessenger::GetErrorCount() const
{
	int count = 0;
	BOOST_FOREACH( const ErrorInfo &errorInfo, errorInfos )
	{
		if( !errorInfo.IsWarning() )
		{
			count ++;
		}
	}
	return count;
}
bool ErrorMessenger::HasError() const
{
	return ( GetErrorCount() > 0 );
}
int ErrorMessenger::GetWarningCount() const
{
	int count = 0;
	BOOST_FOREACH( const ErrorInfo &errorInfo, errorInfos )
	{
		if( errorInfo.IsWarning() )
		{
			count ++;
		}
	}
	return count;
}

void ErrorMessenger::ShowErrorLine( int errorLineNum )
{
	const ErrorInfo *pErrorInfo = NULL;
	BOOST_FOREACH( const ErrorInfo &errorInfo, errorInfos )
	{
		if( errorInfo.GetErrorLineNum() == errorLineNum )
		{
			pErrorInfo = &errorInfo;
			break;
		}
	}

	if( !pErrorInfo )
	{
		// YȂ
		return;
	}
	if( pErrorInfo->GetSourceLineNum() == -1 )
	{
		return;
	}

	HANDLE hFile;
	DWORD dw;
	char FileName[MAX_PATH];
	char temporary[MAX_PATH];

	lstrcpy( FileName, pErrorInfo->GetSourceFilePath().c_str() );

	if(IsWindow(hOwnerEditor)){
		if(FileName){

			while( !IsFileExist( FileName ) ){
				char temp2[MAX_PATH],temp3[MAX_PATH];
				_splitpath(FileName,NULL,NULL,temp2,temp3);
				lstrcat(temp2,temp3);

				sprintf(temporary,"\"%s\" ܂Bi[ĂfBNgw肵ĂB",temp2);
				if(!GetFolder(hOwnerEditor,temp3,temporary)) return;

				if(temp3[lstrlen(temp3)-1]!='\\') lstrcat(temp3,"\\");

				sprintf(FileName,"%s%s",temp3,temp2);
			}

			hFile=CreateFile(
				( ActiveBasic::Common::Environment::GetAbdevRootPath() + "\\pgm.tmp" ).c_str(),
				GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_ARCHIVE|FILE_ATTRIBUTE_HIDDEN|FILE_ATTRIBUTE_TEMPORARY,NULL);
			WriteFile(hFile,FileName,lstrlen(FileName),&dw,NULL);
			CloseHandle(hFile);

			SendMessage(hOwnerEditor,WM_SHOWERROR,pErrorInfo->GetSourceLineNum(),0);
		}
	}
}
