#include "stdafx.h"

#include <Compiler.h>

#ifdef _AMD64_
#include "../compiler_x64/opcode.h"
#else
#include "../compiler_x86/opcode.h"
#endif

void InitGCVariables(void){
	char temporary[255];
	Type type;
	RELATIVE_VAR RelativeVar;


	///////////////////////////////
	// X^bNt[̊Jnʒu
	///////////////////////////////

	if( compiler.GetObjectModule().meta.GetGlobalVars().Find( Symbol( "_System_gc_StackRoot_StartPtr" ) ) == NULL )
	{
		// `̏ꍇ͒`
		sprintf(temporary,"_System_gc_StackRoot_StartPtr%c%c*LONG_PTR",1,ESC_AS);
		OpcodeDim(temporary,0);
	}

	GetVarOffsetReadWrite("_System_gc_StackRoot_StartPtr",&RelativeVar,type);

	//mov rax,rsp
	compiler.codeGenerator.op_mov_RR(REG_RAX,REG_RSP);

	//mov ptr[offset],rax/eax
	compiler.codeGenerator.op_mov_MR(PTR_SIZE,REG_RAX,0,(int)RelativeVar.offset,MOD_DISP32, Schedule::GlobalVar );
}
