#include "stdafx.h"

#include "common.h"

#ifdef _AMD64_
#include "../compiler_x64/opcode.h"
#else
#include "../compiler_x86/opcode.h"
#endif

void Opcode_Input(const char *Parameter){
	extern int cp;
	int i2,i3,i4,i5;
	BOOL bFile;
	char temporary[VN_SIZE],temp2[VN_SIZE],buffer[VN_SIZE];

	if(Parameter[0]=='#'){
		bFile=1;
		for(i2=0,i3=1;;i2++,i3++){
			buffer[i2]=Parameter[i3];
			if(Parameter[i3]==','||Parameter[i3]=='\0') break;
		}
		buffer[i2+1]=0;
		i2=i3+1;
	}
	else{
		bFile=0;
		i2=0;
		buffer[0]=0;

		//\pp[^Zbg
		if(Parameter[0]=='\"'){
			buffer[0]='\"';
			for(i2=1;;i2++){
				if(Parameter[i2]=='\"'){
					buffer[i2]=0;
					break;
				}
				buffer[i2]=Parameter[i2];
			}
			if(Parameter[i2+1]==';') lstrcpy(buffer+i2,"? \"");
			else if(Parameter[i2+1]==',') lstrcpy(buffer+i2,"\"");
			else compiler.errorMessenger.Output(10,"Input",cp);
			i2+=2;
		}
		else if((Parameter[0]=='e'||Parameter[0]=='E')&&
			(Parameter[1]=='x'||Parameter[1]=='X')&&
			Parameter[2]=='\"'){
			memcpy(buffer,Parameter,3);
			for(i2=3;;i2++){
				if(Parameter[i2]=='\"'){
					buffer[i2]=0;
					break;
				}
				buffer[i2]=Parameter[i2];
			}
			if(Parameter[i2+1]==';') lstrcpy(buffer+i2,"? \"");
			else if(Parameter[i2+1]==',') lstrcpy(buffer+i2,"\"");
			else compiler.errorMessenger.Output(10,"Input",cp);
			i2+=2;
		}
		else{
			lstrcpy(buffer,"\"? \"");
			i2=0;
		}
	}

	//ϐ|C^Aϐ̃^CvZbg
	i4=0;
	while(1){
		for(i3=0;;i2++,i3++){
			if(Parameter[i2]=='('){
				i5=GetStringInPare(temporary+i3,Parameter+i2);
				i2+=i5-1;
				i3+=i5-1;
			}
			if(Parameter[i2]=='['){
				i5=GetStringInBracket(temporary+i3,Parameter+i2);
				i2+=i5-1;
				i3+=i5-1;
			}
			if(Parameter[i2]==','){
				temporary[i3]=0;
				i2++;
				break;
			}
			temporary[i3]=Parameter[i2];
			if(Parameter[i2]=='\0') break;
		}
		if(temporary[0]=='\0'){
			compiler.errorMessenger.Output(10,"Input",cp);
			return;
		}

		Type varType;
		if( !GetVarType(temporary, varType, 1) ){
			return;
		}

		sprintf(temp2,"_System_InputDataPtr[%d]=VarPtr(%s)",i4,temporary);
		OpcodeCalc(temp2);

		if(varType.IsLong()) varType.SetBasicType( DEF_DWORD );
		else if(varType.IsInteger()) varType.SetBasicType( DEF_WORD );
		else if(varType.IsObject()){
			varType.SetBasicType( DEF_OBJECT );
			if( varType.IsStringClass() ){
				varType.SetBasicType( DEF_STRING );
			}
		}
		sprintf(temp2,"_System_InputDataType[%d]=%d",i4,varType.GetBasicType());
		OpcodeCalc(temp2);

		i4++;
		if(Parameter[i2]=='\0') break;
	}
	sprintf(temp2,"_System_InputDataPtr[%d]=0",i4);
	OpcodeCalc(temp2);

	const UserProc *pUserProc;
	if(bFile) pUserProc=GetSubHash("INPUT_FromFile");
	else pUserProc=GetSubHash("INPUT_FromPrompt");
	if(!pUserProc){
		compiler.errorMessenger.Output(3,"Input",cp);
		return;
	}
	Opcode_CallProc(buffer,pUserProc,0,"");
}
void Opcode_PrintUsing(const char *Parameter,char *buffer,BOOL bFile){
	extern int cp;
	int i2,i3,i4,i5;
	char temporary[VN_SIZE],temp2[8192];
	BOOL bReturnLine;

	char parms[8192];
	lstrcpy( parms, Parameter );

	i2=lstrlen(parms);
	if(parms[i2-1]==';'){
		bReturnLine=0;
		parms[i2-1]=0;
	}
	else bReturnLine=1;

	i3=lstrlen(buffer);
	for(i2=0;;i2++,i3++){
		if(parms[i2]==';'){
			buffer[i3]=0;
			break;
		}
		buffer[i3]=parms[i2];
		if(parms[i2]=='\0') break;
	}
	if(parms[i2]==';') i2++;

	if(bReturnLine) lstrcat(buffer,"+Ex\"\\r\\n\"");

	//f[^|C^Af[^̃^CvZbg
	i4=0;
	while(1){
		for(i3=0;;i2++,i3++){
			if(parms[i2]=='\"'){
				temporary[i3]=parms[i2];
				for(i2++,i3++;;i2++,i3++){
					temporary[i3]=parms[i2];
					if(parms[i2]=='\"') break;
				}
				continue;
			}
			if(parms[i2]=='('){
				i5=GetStringInPare(temporary+i3,parms+i2);
				i2+=i5-1;
				i3+=i5-1;
				continue;
			}
			if(parms[i2]=='['){
				i5=GetStringInBracket(temporary+i3,parms+i2);
				i2+=i5-1;
				i3+=i5-1;
				continue;
			}
			if(parms[i2]==','){
				temporary[i3]=0;
				i2++;
				break;
			}
			temporary[i3]=parms[i2];
			if(parms[i2]=='\0') break;
		}
		if(temporary[0]=='\0'){
			compiler.errorMessenger.Output(10,"Print",cp);
			return;
		}

		int iResult;
		iResult=IsStrCalculation(temporary);

		if(iResult==1){
			//
			sprintf(temp2,"_System_UsingStrData[%d]=%s",i4,temporary);
			OpcodeCalc(temp2);

			sprintf(temp2,"_System_UsingDataType[%d]=%d",i4,DEF_STRING);
			OpcodeCalc(temp2);
		}
		else if(iResult==0){
			//l
			sprintf(temp2,"_System_UsingDblData[%d]=%s",i4,temporary);
			OpcodeCalc(temp2);

			sprintf(temp2,"_System_UsingDataType[%d]=%d",i4,DEF_DOUBLE);
			OpcodeCalc(temp2);
		}
		//else if(iResult==-1) G[

		i4++;
		if(parms[i2]=='\0') break;
	}
	sprintf(temp2,"_System_UsingDataType[%d]=-1",i4);
	OpcodeCalc(temp2);

	const UserProc *pUserProc;
	if(bFile) pUserProc=GetSubHash("PRINTUSING_ToFile");
	else pUserProc=GetSubHash("PRINTUSING_ToPrompt");
	if(!pUserProc){
		compiler.errorMessenger.Output(3,"Print",cp);
		return;
	}
	Opcode_CallProc(buffer,pUserProc,0,"");
}
void Opcode_Print(const char *Parameter,BOOL bWrite){
	int i2,i3,i4,sw;
	char temporary[VN_SIZE],buffer[VN_SIZE];
	BOOL bFile;

	if(Parameter[0]=='#'){
		bFile=1;
		for(i2=0,i3=1;;i2++,i3++){
			buffer[i2]=Parameter[i3];
			if(Parameter[i3]==','||Parameter[i3]=='\0') break;
		}
		buffer[i2+1]=0;
		if(Parameter[i3]==',') i3++;
		i2=i3;
	}
	else{
		bFile=0;
		i2=0;
		buffer[0]=0;
	}
	if(Parameter[i2]==1&&Parameter[i2+1]==ESC_USING){
		Opcode_PrintUsing(Parameter+i2+2,buffer,bFile);
		return;
	}

	lstrcat(buffer,"_System_DummyStr+");

	sw=1;
	while(1){
		for(i3=0;;i2++,i3++){
			if(Parameter[i2]=='\"'){
				temporary[i3]=Parameter[i2];
				for(i2++,i3++;;i2++,i3++){
					temporary[i3]=Parameter[i2];
					if(Parameter[i2]=='\"') break;
				}
				continue;
			}
			if(Parameter[i2]=='('){
				i4=GetStringInPare(temporary+i3,Parameter+i2);
				i2+=i4-1;
				i3+=i4-1;
				continue;
			}
			if(Parameter[i2]=='['){
				i4=GetStringInBracket(temporary+i3,Parameter+i2);
				i2+=i4-1;
				i3+=i4-1;
				continue;
			}
			if(Parameter[i2]==','||Parameter[i2]==';'){
				temporary[i3]=0;
				break;
			}
			temporary[i3]=Parameter[i2];
			if(Parameter[i2]=='\0') break;
		}

		if(temporary[0]=='\0') lstrcat(buffer,"\"\"");
		else{
			int iResult;
			iResult=IsStrCalculation(temporary);
			if(iResult==-1){
				//G[
				lstrcat(buffer,"\"\"");
			}
			else if(iResult){
				//
				lstrcat(buffer,temporary);
			}
			else{
				//l
				sprintf(buffer+lstrlen(buffer),"Str$(%s)",temporary);
			}
		}

		if(Parameter[i2]==','){
			if(bWrite) lstrcat(buffer,"+\",\"+");
			else lstrcat(buffer,"+\"\t\"+");
		}
		else if(Parameter[i2]==';'){
			if(Parameter[i2+1]=='\0'){
				sw=0;
				break;
			}
			if(bWrite) lstrcat(buffer,"+\",\"+");
			else lstrcat(buffer,"+\" \"+");
		}
		else if(Parameter[i2]=='\0') break;

		i2++;
	}

	if(sw) lstrcat(buffer,"+Ex\"\\r\\n\"");

	const UserProc *pUserProc;
	if(bFile) pUserProc=GetSubHash("PRINT_ToFile");
	else pUserProc=GetSubHash("PRINT_ToPrompt");
	if(!pUserProc){
		compiler.errorMessenger.Output(3,"Print",cp);
		return;
	}
	Opcode_CallProc(buffer,pUserProc,0,"");
}
