#include "stdafx.h"

#include "Common.h"


//IME֘ÃCxg
void TextEditEvent_IME_StartComposition(HWND hwnd);
BOOL TextEditEvent_IME_Composition(HWND hwnd,LPARAM lParam);

//}EX֘ÃCxg
void TextEditEvent_LButtonDown(HWND hwnd,POINT *pMousePos);
void TextEditEvent_LButtonUp(HWND hwnd,POINT *pMousePos);
void TextEditEvent_MouseMove(HWND hwnd,POINT *pMousePos);
void TextEditEvent_LButtonDblClk(HWND hwnd,POINT *pMousePos);

//L[{[h֘ÃCxg
void TextEditEvent_KeyUp(HWND hwnd,int nVirtualKey);
void TextEditEvent_Char(HWND hwnd,int nVirtualKey);
void TextEditEvent_KeyDown(HWND hwnd,int nVirtualKey,int lKeyData);



HFONT hFont_TextEdit,hFont_HyperLink_TextEdit;
int font_width,font_height;

//s̃Lbgh~p
int hide_caret_switch;

LRESULT CALLBACK TextEditProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern HANDLE hHeap;
	extern HWND hDocCombo;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	static DWORD dwAutoScroll;
	extern COMPLEMENT_WINDOW_INFO ComplementWndInfo;
	int i,WndNum;
	SCROLLINFO si;
	RECT rect;
	POINT pos;

	switch(message){
		case WM_MDIACTIVATE:
			if(!lParam) return 0;
			i=GetWndNum((HWND)lParam);
			if(i==-1) return 0;	//EBhEԂ̏ꍇ

			i=SendMessage(hDocCombo,CB_FINDSTRINGEXACT,0,(long)MdiInfo[i].title);
			SendMessage(hDocCombo,CB_SETCURSEL,i,0);
			SetStatusText(NULL);
			ResetState_EditMenu();
			return 0;



		///////////////////////
		// IME֘ÃCxg
		///////////////////////

		case WM_IME_STARTCOMPOSITION:
			TextEditEvent_IME_StartComposition(hwnd);
			//ftHgs
			break;
		case WM_IME_CHAR:
			//ftHgsȂiWM_CHARĂяoȂ߁j
			return 0;
		case WM_IME_COMPOSITION:
			if(!TextEditEvent_IME_Composition(hwnd,lParam)) return 0;

			//ftHgs
			break;



		//////////////////////////
		// }EX֘ÃCxg
		//////////////////////////

		case WM_LBUTTONDOWN:
			pos.x=LOWORD(lParam);
			pos.y=HIWORD(lParam);
			TextEditEvent_LButtonDown(hwnd,&pos);
			return 0;
		case WM_LBUTTONUP:
			pos.x=LOWORD(lParam);
			pos.y=HIWORD(lParam);
			TextEditEvent_LButtonUp(hwnd,&pos);
			return 0;
		case WM_MOUSEMOVE:
			pos.x=LOWORD(lParam);
			pos.y=HIWORD(lParam);
			TextEditEvent_MouseMove(hwnd,&pos);
			return 0;
		case WM_LBUTTONDBLCLK:
			pos.x=LOWORD(lParam);
			pos.y=HIWORD(lParam);
			TextEditEvent_LButtonDblClk(hwnd,&pos);
			return 0;
		case WM_RBUTTONUP:
			pos.x=LOWORD(lParam);
			pos.y=HIWORD(lParam);
			ClientToScreen(hwnd,&pos);

			//|bvAbvj[\
			extern HMENU hEditMenu;
			TrackPopupMenu(hEditMenu,TPM_LEFTALIGN|TPM_RIGHTBUTTON,pos.x,pos.y,0,hOwner,NULL);
			return 0;



		//////////////////////////////
		// L[{[h֌W̃Cxg
		//////////////////////////////

		case WM_KEYUP:
			TextEditEvent_KeyUp(hwnd,wParam);
			return 0;
		case WM_CHAR:
			TextEditEvent_Char(hwnd,wParam);
			return 0;
		case WM_KEYDOWN:
			TextEditEvent_KeyDown(hwnd,wParam,lParam);
			return 0;



		case WM_PAINT:
			PAINTSTRUCT ps;
			HDC hdc;

			WndNum=GetWndNum(GetParent(hwnd));
			if(WndNum==-1) return 0;

			hdc=BeginPaint(hwnd,&ps);
			TextEdit_DrawBuffer(hdc,WndNum);
			EndPaint(hwnd,&ps);
			return 0;
		case WM_SETFOCUS:
			WndNum=GetWndNum(GetParent(hwnd));
			if(WndNum==-1) return 0;

			//^Lbg쐬
			CreateCaret(hwnd,NULL,1,font_height);

			//Lbg|WVݒ
			ResetCaretPos(WndNum);

			//Lbg\is̏̃Lbgh~̍lɒӁj
			if(hide_caret_switch==0) ShowCaret(hwnd);
			return 0;
		case WM_RESETCARETPOS:
			WndNum=GetWndNum(GetParent(hwnd));
			ResetCaretPos(WndNum);
			return 0;
		case WM_KILLFOCUS:
			HideCaret(hwnd);
			DestroyCaret();
			return 0;
		case WM_MOUSEWHEEL:
			int zDelta;
			zDelta= (short) HIWORD(wParam);

			WndNum=GetWndNum(GetParent(hwnd));
			si.cbSize=sizeof(SCROLLINFO);
			si.fMask=SIF_POS|SIF_PAGE|SIF_RANGE;
			GetScrollInfo(hwnd,SB_VERT,&si);

			i=0;
			if(zDelta>=120){
				//փXN[
				i=-3;
			}
			else if(zDelta<=-120){
				//փXN[
				i=3;
			}

			if(i){
				GetClientRect(hwnd,&rect);
				i=max(-si.nPos,min(i,si.nMax-(rect.bottom/font_height-2)-si.nPos));
				if(i!=0){
					si.nPos+=i;
					SetScrollInfo(hwnd,SB_VERT,&si,1);

					InvalidateRect(hwnd,NULL,0);
				}
				ResetCaretPos(WndNum);
			}
			return 0;
		case WM_SIZE:
			WndNum=GetWndNum(GetParent(hwnd));
			if(WndNum==-1) return 0;
			InvalidateRect(hwnd,NULL,0);
			return 0;
		case WM_VSCROLL:
			WndNum=GetWndNum(GetParent(hwnd));
			si.cbSize=sizeof(SCROLLINFO);
			si.fMask=SIF_POS|SIF_PAGE|SIF_RANGE;
			GetScrollInfo(hwnd,SB_VERT,&si);
			if(LOWORD(wParam)==SB_LINEUP) i=-1;
			else if(LOWORD(wParam)==SB_LINEDOWN) i=1;
			else if(LOWORD(wParam)==SB_PAGEUP) i=-(signed int)si.nPage;
			else if(LOWORD(wParam)==SB_PAGEDOWN) i=si.nPage;
			else if(LOWORD(wParam)==SB_THUMBTRACK) i=HIWORD(wParam)-si.nPos;
			else i=0;
			GetClientRect(hwnd,&rect);
			i=max(-si.nPos,min(i,si.nMax-(rect.bottom/font_height-2)-si.nPos));
			if(i!=0){
				si.nPos+=i;
				SetScrollInfo(hwnd,SB_VERT,&si,1);

				InvalidateRect(hwnd,NULL,0);
			}
			ResetCaretPos(WndNum);
			return 0;
		case WM_HSCROLL:
			WndNum=GetWndNum(GetParent(hwnd));
			si.cbSize=sizeof(SCROLLINFO);
			si.fMask=SIF_POS|SIF_PAGE|SIF_RANGE;
			GetScrollInfo(hwnd,SB_HORZ,&si);
			if(LOWORD(wParam)==SB_LINEUP) i=-1;
			else if(LOWORD(wParam)==SB_LINEDOWN) i=1;
			else if(LOWORD(wParam)==SB_PAGEUP) i=-(signed int)si.nPage;
			else if(LOWORD(wParam)==SB_PAGEDOWN) i=si.nPage;
			else if(LOWORD(wParam)==SB_THUMBTRACK) i=HIWORD(wParam)-si.nPos;
			else i=0;

			GetClientRect(hwnd,&rect);

			int iControlTabSpace;
			iControlTabSpace=MdiInfo[WndNum].pMdiTextEdit->iWidth_ControlTabSpace;

			i=max(-si.nPos,min(i,si.nMax-((rect.right-iControlTabSpace)/font_width)-si.nPos));
			if(i!=0){
				si.nPos+=i;
				SetScrollInfo(hwnd,SB_HORZ,&si,1);

				InvalidateRect(hwnd,NULL,0);
			}
			ResetCaretPos(WndNum);

			//[[ĕ`
			InvalidateRect(MdiInfo[WndNum].pMdiTextEdit->pobj_Ruler->hRulerWnd,NULL,0);
			UpdateWindow(MdiInfo[WndNum].pMdiTextEdit->pobj_Ruler->hRulerWnd);

			return 0;
		case WM_CLOSE:
			CloseDocWindow(GetWndNum(hwnd));
			pobj_nv->bMDIZoomed=IsZoomed(hwnd);
			i=DefMDIChildProc(hwnd,message,wParam,lParam);

			//j[Ԃݒ
			ResetState_DocMenu();

			return i;



		case WM_SEARCH_TAB_CREATE:
			HWND hOneTabWnd;
			hOneTabWnd=CreateWindowEx(0,"OneTab","OneTab",
				WS_CHILD|WS_VISIBLE,
				0,0,0,0,
				MdiInfo[wParam].pMdiTextEdit->pobj_WebResult->hwnd,0,hInst,0);

			SetWindowLongPtr(hOneTabWnd,GWLP_USERDATA,(long)lParam);

			return (LRESULT)hOneTabWnd;
		case WM_SEARCH_TAB_CLOSE:
			DestroyWindow((HWND)lParam);
			return 0;
	}
	return DefMDIChildProc(hwnd,message,wParam,lParam);
}
