#include "stdafx.h"

#include <boost/foreach.hpp>

#include <jenga/include/common/Directory.h>
#include <jenga/include/common/Path.h>

#include <Source.h>
#include <Compiler.h>


const string BasicSource::generateDirectiveName = "#generate";


class CDefine{
	vector<string> names;
public:
	CDefine( int majorVer );
	~CDefine();
	void Free();
	void Init( int majorVer );

	BOOL add(char *name);
	BOOL undef(char *name);
	BOOL check(char *name);
	void preprocessor_ifdef(char *buffer,bool isNot);
	void DirectiveIfdef(char *buffer);
};
// TODO: o[Wԍ̎ʎqdefine
CDefine objDefine(0);


//////////////////////////////////////
// #require̊Ǘ
//////////////////////////////////////
class CRequireFiles{
	char **ppFilePath;
	int count;
public:
	CRequireFiles(){
		ppFilePath = (char **)malloc( 1 );
		count = 0;
	}
	~CRequireFiles(){
		for( int i = 0; i < count; i++ ){
			free( ppFilePath[i] );
		}
		free( ppFilePath );
	}
	void clear(){
		for( int i = 0; i < count; i++ ){
			free( ppFilePath[i] );
		}
		free( ppFilePath );

		ppFilePath = (char **)malloc( 1 );
		count = 0;
	}
	bool IsIncluded( const char *includeFilePath ){
		// '/'  '\\'
		char tempPath[MAX_PATH];
		lstrcpy( tempPath, includeFilePath );
		for( int i=0; tempPath[i]; i++ ){
			if( tempPath[i] == '/' ){
				tempPath[i] = '\\';
			}
		}

		for( int i=0; i<count; i++ ){
			if( lstrcmpi( ppFilePath[i], tempPath ) == 0 ){
				return true;
			}
		}
		return false;
	}
	void Add( const char *includeFilePath ){
		// '/'  '\\'
		char tempPath[MAX_PATH];
		lstrcpy( tempPath, includeFilePath );
		for( int i=0; tempPath[i]; i++ ){
			if( tempPath[i] == '/' ){
				tempPath[i] = '\\';
			}
		}

		//ɓǂݍ܂ĂƂ
		if( IsIncluded( tempPath ) ) return;

		//ǉ
		ppFilePath = (char **)realloc(ppFilePath, ( count + 1 ) * sizeof(char *) );
		ppFilePath[count] = (char *)malloc( lstrlen(tempPath) + 1 );
		lstrcpy( ppFilePath[count], tempPath );
		count++;
	}
};
CRequireFiles requireFiles;


//////////////////////////////////////
// #defineԂNX
//////////////////////////////////////

CDefine::CDefine( int majorVer )
{
	Init( majorVer );
}
CDefine::~CDefine()
{
}
void CDefine::Init( int majorVer )
{
	names.clear();

	if( compiler.IsDebug() )
	{
		add("_DEBUG");
	}

#ifdef _AMD64_
	add("_WIN64");
#endif

	if( compiler.IsDll() )
	{
		add("_DLL");
	}

	if( compiler.IsUnicode() )
	{
		add( "UNICODE" );
	}

	char temporary[255];
	sprintf(temporary,"_AB_VER%d",majorVer);
	add(temporary);
}
BOOL CDefine::add(char *name){
	extern HANDLE hHeap;

	//d`FbN
	if(check(name)) return 0;

	//ǉ
	names.push_back( name );

	return 1;
}
BOOL CDefine::undef(char *name){
	vector<string>::iterator i = names.begin();
	BOOST_FOREACH( const string &temp, names ){
		if( temp == name ){
			names.erase( i );
			return 1;
		}
		i++;
	}

	return 0;
}
BOOL CDefine::check(char *name){

	//d`FbN
	BOOST_FOREACH( const string &temp, names ){
		if( temp == name ){
			return 1;
		}
	}
	return 0;
}

int Search_endif(char *buffer,int i, int *pLine = 0){
	for(;;i++){
		if(buffer[i]=='\0') break;

		if( buffer[i] == '\n' ){
			if( pLine ){
				(*pLine)++;
			}
		}

		if(buffer[i-1]=='\n'){
			if(memicmp(buffer+i,"#ifdef",6)==0||memicmp(buffer+i,"#ifndef",7)==0){
				i=Search_endif(buffer,i+6, pLine);
				if(buffer[i]=='\0') break;
				continue;
			}
			else if(memicmp(buffer+i,"#endif",6)==0){
				break;
			}
		}
	}
	return i;
}

void CDefine::preprocessor_ifdef(char *buffer,bool isNot){
	int i,i2,i3;
	char temporary[VN_SIZE];

	if(isNot) i=lstrlen("#ifndef");
	else i=lstrlen("#ifdef");
	while(buffer[i]==' '||buffer[i]=='\t') i++;

	for(i2=0;;i++,i2++){
		if(buffer[i]=='\n'||buffer[i]=='\0'){
			temporary[i2]=0;
			break;
		}
		temporary[i2]=buffer[i];
	}

	int sw=0;
	if(check(temporary)) sw=1;

	if(isNot){
		//#ifndef̂Ƃi΂ɂj
		if(sw) sw=0;
		else sw=1;
	}

	//#ifdef̍s
	Text::SlideString(buffer+i,-i);
	i=0;

	BOOL bElse=0;
	if(sw){
		//TRUÊƂ

		//#elseA#endifT
		for(;;i++){
			if(buffer[i]=='\0') break;

			if(i==0||buffer[i-1]=='\n'){
				if(memicmp(buffer+i,"#ifdef",6)==0||memicmp(buffer+i,"#ifndef",7)==0){
					i=Search_endif(buffer,i+6);
					if(buffer[i]=='\0') break;
					continue;
				}
				else if(memicmp(buffer+i,"#else",5)==0){
					i2=5;
					bElse=1;
					break;
				}
				else if(memicmp(buffer+i,"#endif",6)==0){
					i2=6;
					bElse=0;
					break;
				}
			}
		}

		//s
		Text::SlideString(buffer+i+i2,-i2);

		if(bElse){
			//#elseꍇ͂̋Ԃ

			for(i2=i,i3=0;;i2++){
				if(buffer[i2]=='\0') break;

				if(buffer[i2]=='\n') i3++;

				if(i2==0||buffer[i2-1]=='\n'){
					if(memicmp(buffer+i2,"#ifdef",6)==0||memicmp(buffer+i2,"#ifndef",7)==0){
						i2=Search_endif(buffer,i2+6, &i3 );
						if(buffer[i2]=='\0') break;
						continue;
					}
					if(memicmp(buffer+i2,"#endif",6)==0){
						i2+=6;
						break;
					}
				}
			}

			//\[XR[hԂAsR[h}
			Text::SlideString(buffer+i2,i-i2+i3);
			memset(buffer+i,'\n',i3);
		}
	}
	else{
		//FALSÊƂ

		//#elseA#endifT
		for(i2=i,i3=0;;i2++){
			if(buffer[i2]=='\0') break;

			if(buffer[i2]=='\n') i3++;

			if(i2==0||buffer[i2-1]=='\n'){
				if(memicmp(buffer+i2,"#ifdef",6)==0||memicmp(buffer+i2,"#ifndef",7)==0){
					i2=Search_endif(buffer,i2+6, &i3 );
					if(buffer[i2]=='\0') break;
					continue;
				}
				else if(memicmp(buffer+i2,"#else",5)==0){
					i2+=5;
					bElse=1;
					break;
				}
				else if(memicmp(buffer+i2,"#endif",6)==0){
					i2+=6;
					bElse=0;
					break;
				}
			}
		}

		//\[XR[hԂAsR[h}
		Text::SlideString(buffer+i2,i-i2+i3);
		memset(buffer+i,'\n',i3);

		if(bElse){
			//#endifT
			for(;;i++){
				if(buffer[i]=='\0') break;

				if(i==0||buffer[i-1]=='\n'){
					if(memicmp(buffer+i,"#ifdef",6)==0||memicmp(buffer+i,"#ifndef",7)==0){
						i=Search_endif(buffer,i+6);
						if(buffer[i]=='\0') break;
						continue;
					}
					else if(memicmp(buffer+i,"#endif",6)==0){
						i2=6;
						bElse=0;
						break;
					}
				}
			}

			//s
			Text::SlideString(buffer+i+i2,-i2);
		}
	}
}


void CDefine::DirectiveIfdef(char *buffer){
	int i,i2,i3,sw;
	char temporary[VN_SIZE];

	for(i=0;;i++){
		if(buffer[i]=='\0') break;

		if(i==0||(i>=1&&buffer[i-1]=='\n')){
			sw=0;
			if(memicmp(buffer+i,"#define",7)==0){
				i2=i+7;
				while(buffer[i2]==' '||buffer[i2]=='\t') i2++;

				for(i3=0;;i2++,i3++){
					if(buffer[i2]=='\n'||buffer[i2]=='\0'){
						temporary[i3]=0;
						break;
					}
					temporary[i3]=buffer[i2];
				}

				add(temporary);

				i2-=i;

				//fBNeBu
				Text::SlideString(buffer+i+i2,-i2);
			}
			if(memicmp(buffer+i,"#undef",6)==0){
				i2=i+7;
				while(buffer[i2]==' '||buffer[i2]=='\t') i2++;

				for(i3=0;;i2++,i3++){
					if(buffer[i2]=='\n'||buffer[i2]=='\0'){
						temporary[i3]=0;
						break;
					}
					temporary[i3]=buffer[i2];
				}

				undef(temporary);

				i2-=i;

				//fBNeBu
				Text::SlideString(buffer+i+i2,-i2);
			}
			else if(memicmp(buffer+i,"#ifdef",6)==0){
				preprocessor_ifdef(buffer+i,false);
				continue;
			}
			else if(memicmp(buffer+i,"#ifndef",7)==0){
				preprocessor_ifdef(buffer+i,true);
				continue;
			}
			else continue;
		}
	}
}




bool Text::ReadFile( const string &filePath ){
	//t@CI[v
	HANDLE hFile=CreateFile(filePath.c_str(),GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile==INVALID_HANDLE_VALUE){
		return false;
	}

	length = GetFileSize( hFile, NULL );

	buffer = (char *)realloc( buffer, length + 1 );

	//ǂݍ
	DWORD dwAccBytes;
	::ReadFile(hFile,buffer,length,&dwAccBytes,0);
	buffer[dwAccBytes]=0;

	//t@CN[Y
	CloseHandle(hFile);

	return true;
}

void BasicSource::ChangeReturnLineChar(){
	int i,i2;

	bool isMustChange = false;
	for( i=0; ; i++ ){
		if( buffer[i] == '\0' ){
			break;
		}
		if( buffer[i]=='\n' )
		{
			if( i>0 )
			{
				if( buffer[i-1] == '\r' )
				{
					isMustChange = true;
				}
			}
		}
	}

	if( !isMustChange )
	{
		// sR[h̕ϊ͕KvȂ
		return;
	}

#ifdef _DEBUG
	//sR[h̐`FbN
	for( i=0; ; i++ ){
		if( buffer[i] == '\0' ){
			break;
		}
		if( buffer[i]!='\r' && buffer[i+1]=='\n'
			||  buffer[i]=='\r' && buffer[i+1]!='\n' ){
				char temporary[255];
				strncpy( temporary, buffer + i-100, 130 );
				temporary[130] = 0;
				for(int i2=0; ;i2++){
					if(temporary[i2]=='\r') temporary[i2]='A';
					if(temporary[i2]=='\n') temporary[i2]='B';
					if(temporary[i2]=='\0') break;
				}

				extern HWND hOwnerEditor;
				MessageBox( hOwnerEditor, temporary, "sR[h̐`FbN", MB_OK | MB_ICONEXCLAMATION );
		}
	}
#endif

	//sR[hCRLFLFɕϊ
	for(i=0,i2=0;;i++,i2++){
		if(buffer[i]=='\r'&&buffer[i+1]=='\n') i++;
		buffer[i2]=buffer[i];
		if(buffer[i]=='\0') break;
	}

	length = i;
}

void BasicSource::RemoveComments(){
	int i,i2,i3,IsStr;
	char *temporary;
	temporary=(char *)GlobalAlloc(GMEM_FIXED,lstrlen(buffer)+1);
	for(i=0,i2=0,i3=0,IsStr=0;;i++,i2++){
		if(buffer[i]=='\"') IsStr^=1;
		if(buffer[i]=='\n'||buffer[i]=='\0'){
			i2--;
			while(temporary[i2]==' '||temporary[i2]=='\t') i2--;
			i2++;

			if(i3){
				//sɓn钍ߕ̒ɉs݂Ƃ
				memset(temporary+i2,'\n',i3);
				i2+=i3;
				i3=0;
			}
		}
		if(buffer[i]=='\''&&IsStr==0){
			//ߕ
			i2--;
			while(temporary[i2]==' '||temporary[i2]=='\t') i2--;
			i2++;
			while(buffer[i]!='\n'&&buffer[i]!='\0') i++;
		}
		if(buffer[i]=='/'&&buffer[i+1]=='*'&&IsStr==0){
			//ߕisj
			i+=2;
			i3=0;
			while(!(buffer[i]=='*'&&buffer[i+1]=='/')){
				if(buffer[i]=='\n') i3++;
				if(buffer[i]=='\0') break;
				i++;
			}
			if(buffer[i]){
				i+=2;
			}
			i--;
			i2--;
			continue;
		}
		temporary[i2]=buffer[i];
		if(buffer[i]=='\0') break;
	}
	lstrcpy(buffer,temporary);
	GlobalFree(temporary);
}

bool BasicSource::ReadFile_InIncludeDirective( const string &filePath ){
	if( !Text::ReadFile( filePath ) ){
		return false;
	}

	// sR[hCRLFLFɕϊ
	ChangeReturnLineChar();

	// Rg폜
	RemoveComments();

	// #ifdeffBNeBu
	objDefine.DirectiveIfdef( buffer );

	// A_[o[ɂs𐳋K\ɖ߂
	RemoveReturnLineUnderbar();

	// _~[sZbg
	Realloc( length + 2 );
	Text::SlideString( buffer, 2 );
	buffer[0] = '\n';
	buffer[1] = '\n';

	return true;
}

void BasicSource::DirectiveIncludeOrRequire(){
	extern HANDLE hHeap;
	extern char BasicCurDir[MAX_PATH];
	int i,i2,i3,sw1,LineNum,FileLayer[255],layer,LastFileByte[255];
	char temporary[MAX_PATH],temp2[MAX_PATH+255],*LayerDir[255];

	layer=0;
	FileLayer[layer]=0;
	LastFileByte[layer]=GetLength();
	LineNum=0;

	if( includedFilesRelation.GetLineCounts() != 0 )
	{
		Jenga::Throw( "CN[ht@C\̏ls" );
	}

	// C\[XR[h
	FileLayer[layer] = includedFilesRelation.AddFile( program.GetSourceFilePath() );

	//QƃfBNg
	LayerDir[0]=(char *)malloc(lstrlen(BasicCurDir)+1);
	lstrcpy(LayerDir[0],BasicCurDir);

	for(i=0;;i++){
		if(buffer[i]=='\0'){
			break;
		}
		if(buffer[i]=='\n'){
			includedFilesRelation.AddLine( FileLayer[layer] );
		}
		if(i>LastFileByte[layer]){
			free(LayerDir[layer]);
			LayerDir[layer]=0;
			layer--;
		}
		if((buffer[i-1]=='\n'||i==0)&&buffer[i]=='#'){
			bool isRequire = false;
			if(memcmp( buffer + i + 1, "include", 7 ) == 0
				|| memcmp( buffer + i + 1, "require", 7 ) == 0){

					//#requirȅꍇ
					if( buffer[i + 1] == 'r' ) isRequire = true;

					i2=i+8;
					while(buffer[i2]==' '||buffer[i2]=='\t') i2++;

					if(buffer[i2]=='\"') sw1=0;
					else if(buffer[i2]=='<') sw1=1;
					i2++;

					for(i3=0;;i2++,i3++){
						if((buffer[i2]=='\"'&&sw1==0)||(buffer[i2]=='>'&&sw1==1)||buffer[i2]=='\n'||buffer[i2]=='\0'){
							temporary[i3]=0;
							break;
						}
						temporary[i3]=buffer[i2];
					}
					while(buffer[i2]!='\n'&&buffer[i2]!='\0') i2++;

					if(sw1){
						sprintf(temp2,"%s\\%s", program.GetIncludeDir().c_str(), temporary );
						lstrcpy(temporary,temp2);
					}
					else{
						Jenga::Common::Directory dir( LayerDir[layer] );
						lstrcpy( temporary, dir.GetFullPath( temporary ).c_str() );
					}
			}
			else if(memcmp(buffer+i+1,"prompt",6)==0){
				i2=i+7;
				sprintf(temporary,"%s\\basic\\prompt.sbp", program.GetIncludeDir().c_str() );
			}
			else if(memcmp(buffer+i+1,"N88BASIC",8)==0){
				i2=i+9;
				sprintf(temporary,"%s\\basic\\prompt.sbp", program.GetIncludeDir().c_str() );
			}
			else if(memcmp(buffer+i+1,"console",7)==0){
				//TuVXe ^CvCUIɕύX
				extern unsigned short TypeOfSubSystem;
				TypeOfSubSystem=IMAGE_SUBSYSTEM_WINDOWS_CUI;

				i2=i+8;
				sprintf(temporary,"%s\\basic\\dos_console.sbp", program.GetIncludeDir().c_str() );
			}
			else continue;

			if( i == 0 && Jenga::Common::Path(temporary).GetFileName() == "basic" )
			{
			}
			else
			{
				//fBNeBu邽߁AsĂ܂̂hibasic.sbpj
				Text::SlideString(buffer+i2,1);
				buffer[i2]='\n';
				for(i3=0;i3<=layer;i3++) LastFileByte[i3]++;
			}

			layer++;
			FileLayer[layer] = includedFilesRelation.AddFile( temporary );

			//#requirȅꍇł́Aɓǂݍ܂Ăt@C͓ǂݍ܂Ȃ悤ɂ
			bool isFake = false;
			if( isRequire ){
				if( requireFiles.IsIncluded( temporary ) ){
					//ɓǂݍ܂ĂƂ
					isFake = true;
				}
			}

			BasicSource source;

			if( isFake ){
				//ɓǂݍ܂ĂƂ͋f[^
				source.SetBuffer( "" );
			}
			else{
				//荞܂ꂽt@CW
				requireFiles.Add( temporary );

				//CN[ht@Cǂݍ
				if( !source.ReadFile_InIncludeDirective( temporary ) ){
					sprintf(temp2,"CN[ht@C \"%s\" I[vł܂",temporary);
					compiler.errorMessenger.Output(-1,temp2,i);
					break;
				}
			}

			i3=lstrlen(buffer)+source.GetLength();
			Realloc( i3 );
			Text::SlideString(buffer+i2,source.GetLength()+(i-i2));
			memcpy(buffer+i,source.GetBuffer(),source.GetLength());

			//VQƃfBNgZbg
			char temp4[MAX_PATH];
			_splitpath(temporary,temp2,temp4,0,0);
			lstrcat(temp2,temp4);
			LayerDir[layer]=(char *)malloc(lstrlen(temp2)+1);
			lstrcpy(LayerDir[layer],temp2);

			//t@C͈͂XCh
			LastFileByte[layer]=i+source.GetLength()-1;
			for(i3=0;i3<layer;i3++) LastFileByte[i3]+=source.GetLength()+(i-i2);

			i--;
		}
	}

	free(LayerDir[0]);

	length = lstrlen(buffer);
}

int KillReturnCode_InParameter(char *buffer,int *pRnum,char cBeginPare,char cEndPare){
	int i,i2,i3,IsStr;

	//JbR'('̉s
	while(buffer[0]=='\n'){
		Text::SlideString(buffer+1,-1);
		(*pRnum)++;
	}

	for(i=0,IsStr=0;;i++){
		if(IsDBCSLeadByte(buffer[i])&&buffer[i+1]){
			i++;
			continue;
		}

		if(buffer[i]=='\"') IsStr^=1;

		if(buffer[i]=='\0') break;	//G[
		if(buffer[i]=='\n'){
			i2=0;
			i3=0;
			while(buffer[i+i2]=='\n'){
				i2++;
				i3++;
				while(buffer[i+i2]==' '||buffer[i+i2]=='\t') i2++;
			}
			while(buffer[i+i2]==' '||buffer[i+i2]=='\t') i2++;

			if(buffer[i+i2]==cEndPare){
				Text::SlideString(buffer+i+i2,-i2);
				(*pRnum)+=i3;
				break;
			}

			//G[
			break;
		}

		if(buffer[i]=='('&&IsStr==0){
			i++;
			i2=KillReturnCode_InParameter(buffer+i,pRnum,'(',')');
			i+=i2;
			if(buffer[i]!=')') break;
			continue;
		}
		if(buffer[i]=='['&&IsStr==0){
			i++;
			i2=KillReturnCode_InParameter(buffer+i,pRnum,'[',']');
			i+=i2;
			if(buffer[i]!=']') break;
			continue;
		}
		if(buffer[i]==cEndPare&&IsStr==0) break;

		if(buffer[i]==','&&buffer[i+1]=='\n'&&IsStr==0){
			i++;
			while(buffer[i]=='\n'){
				Text::SlideString(buffer+i+1,-1);
				(*pRnum)++;
			}
			i--;
		}
	}
	return i;
}
void BasicSource::RemoveReturnLineUnderbar(){
	int i,i2;

	//A_[o[ɂs
	for(i=0;;i++){
		i2=0;
		while(buffer[i]=='_'&&buffer[i+1]=='\n'){
			i2++;
			Text::SlideString(buffer+i+2,-2);
			while(buffer[i]=='\n'){
				Text::SlideString(buffer+i+1,-1);
				i2++;
			}
			for(;;i++){
				if(buffer[i]=='_'&&buffer[i+1]=='\n') break;
				if(buffer[i]=='\n'||buffer[i]=='\0'){
					Text::SlideString(buffer+i,i2);
					memset(buffer+i,'\n',i2);
					break;
				}
			}
		}
		if(buffer[i]=='\0') break;
	}

	//JbRp[^̉s
	int IsStr,rnum;
	for(i=0,IsStr=0,rnum=0;;i++){
		if(IsDBCSLeadByte(buffer[i])&&buffer[i+1]){
			i++;
			continue;
		}
		if(buffer[i]=='\0') break;
		if(buffer[i]=='\n'){
			if(rnum){
				Text::SlideString(buffer+i+1,rnum);
				memset(buffer+i+1,'\n',rnum);
				rnum=0;
			}
		}
		if(buffer[i]=='\"') IsStr^=1;
		if(buffer[i]=='('&&IsStr==0){
			i++;
			i2=KillReturnCode_InParameter(buffer+i,&rnum,'(',')');
			i+=i2;
			if(buffer[i]!=')') break;
		}
		if(buffer[i]=='['&&IsStr==0){
			i++;
			i2=KillReturnCode_InParameter(buffer+i,&rnum,'[',']');
			i+=i2;
			if(buffer[i]!=']') break;
		}
	}

	length = lstrlen(buffer);
}

void BasicSource::Initialize( const std::string &source )
{
	Clear();
	Add( source );

	// sR[hCRLFLFɕϊ
	ChangeReturnLineChar();

	// Rg폜
	RemoveComments();

	//ŏIsɂ͕܂܂Ȃ悤ɂ
	if( lstrlen(buffer)>0 && buffer[lstrlen(buffer)-1] != '\n' )
	{
		Realloc( length + 1 );
		lstrcat( buffer, "\n" );
	}

	// A_[o[ɂs𐳋K\ɖ߂
	RemoveReturnLineUnderbar();
}

void BasicSource::SetBuffer( const char *buffer ){
	this->buffer = (char *)calloc( lstrlen(buffer) + 1, 1 );
	lstrcpy( this->buffer, buffer );
	length = lstrlen(buffer);

	// _~[sZbg
	Realloc( length + 2 );
	Text::SlideString( this->buffer, 2 );
	this->buffer[0] = '\n';
	this->buffer[1] = '\n';
}

bool BasicSource::ReadFile( const string &filePath ){
	if( !Text::ReadFile( filePath ) ){
		return false;
	}

	// sR[hCRLFLFɕϊ
	ChangeReturnLineChar();

	// basic.sbpCN[h
	//const char *headCode = "#include <basic.sbp>\n";
	const char *headCode = "";
	Realloc( length + lstrlen(headCode) );
	Text::SlideString( buffer, lstrlen(headCode) );
	memcpy( buffer, headCode, lstrlen(headCode) );

	// #define#require
	// TODO: o[Wԍ̎ʎqdefine
	objDefine.Init(0);
	requireFiles.clear();

	// Rg폜
	RemoveComments();

	// #ifdeffBNeBu
	objDefine.DirectiveIfdef( buffer );

	//ŏIsɂ͕܂܂Ȃ悤ɂ
	Realloc( length + 1 );
	lstrcat( buffer, "\n" );

	// #include / #require fBNeBu
	DirectiveIncludeOrRequire();

	// A_[o[ɂs𐳋K\ɖ߂
	RemoveReturnLineUnderbar();

	// _~[sZbg
	Realloc( length + 2 );
	Text::SlideString( buffer, 2 );
	buffer[0] = '\n';
	buffer[1] = '\n';

	extern char *basbuf;
	basbuf = GetBuffer();

	return true;
}

bool BasicSource::Generate( const string &genName, const char *genBuffer ){
	const int genBufferLength = lstrlen( genBuffer );

#ifdef _DEBUG
	// }\[XɉsR[h܂܂ĂȂ
	for( int i=0; genBuffer[i] ; i++ ){
		if( genBuffer[i] == '\n' ){
			compiler.errorMessenger.OutputFatalError();
			break;
		}
	}
#endif

	bool isFound = false;

	for( int i=0; ; i++ ){
		if( i == 0 || buffer[i] == '\n' ){
			if( buffer[i] == '\n' ){
				i++;
			}
			while( IsBlank( buffer[i] ) ){
				i++;
			}

			int startIndex = i;

			if( memicmp( buffer + i, generateDirectiveName.c_str(), generateDirectiveName.size() ) == 0 ){
				i += (int)generateDirectiveName.size();
				while( IsBlank( buffer[i] ) ){
					i++;
				}

				char temporary[VN_SIZE];
				for( int i2=0; ; i++, i2++ ){
					if( buffer[i] == '\n' ){
						temporary[i2] = 0;
						break;
					}
					temporary[i2] = buffer[i];
				}
				if( genName == temporary ){
					// v

					int endIndex = i;

					int lengthOffset = genBufferLength - ( endIndex - startIndex );

					Realloc( length + lengthOffset );
					Text::SlideString( buffer + endIndex, lengthOffset );
					memcpy( buffer + startIndex, genBuffer, genBufferLength );

					isFound = true;

					break;
				}
			}
		}
	}

	return isFound;
}

void BasicSource::Addition( const char *buffer ){
	Realloc( length + lstrlen(buffer) );
	lstrcat( this->buffer, buffer );
}

bool BasicSource::GetLineInfo( int sourceCodePos, int &line, std::string &filePath ) const
{
	int i2,i3,i4,i5;

	const char *buffer = GetBuffer();
	int i = sourceCodePos;

	if(buffer[i]=='\n') i--;
	for(i3=0,i2=0;i3<i;i3++){
		if(buffer[i3]=='\n') i2++;
		if(buffer[i3]=='\0') return 0;
	}

	if( includedFilesRelation.GetLineCounts() < i2 )
	{
		//Jenga::Throw( "BasicSource::GetLineInfo\bhŕsȍs̏擾悤Ƃ" );

		//t@CEsԍłȂꍇ
		line = -1;
		filePath = "";
		return false;
	}

	i4=0;
	while( includedFilesRelation.GetFileNumber( i2 ) != includedFilesRelation.GetFileNumber( i4 ) )
	{
		i4++;
	}
	for(i3=0,i5=0;i5<i4;i3++){
		if(buffer[i3]=='\n') i5++;
		if(buffer[i3]=='\0') return 0;
	}
	for(i5=0;i4<i2;i3++){
		if(buffer[i3]=='\n'){
			i4++;
			i5++;
			if( includedFilesRelation.GetFileNumber( i2 ) < includedFilesRelation.GetFileNumber( i4 ) )
			{
				for( ;includedFilesRelation.GetFileNumber( i2 ) != includedFilesRelation.GetFileNumber( i4 ); i3++ ){
					if(buffer[i3]=='\n') i4++;
				}
			}
		}
		if(buffer[i3]=='\0') return 0;
	}

	//sԍZbg
	line = i5;

	//t@CZbg
	filePath = includedFilesRelation.GetFilePath( i2 );

	return 1;
}


SourceTemplate::SourceTemplate( const std::string &filePath )
{
	Jenga::Common::File file = Jenga::Common::File( GetApplicationBaseFullPath( filePath ) );
	source = file.Read();
}
std::string SourceTemplate::GetResult( const std::map<std::string,std::string> &values )
{
	std::string result = source;

	std::map<std::string,std::string>::const_iterator it = values.begin();
	while( it != values.end() )
	{
		while( true )
		{
			std::string::size_type index = result.find( it->first );
			if( index == std::string::npos )
			{
				break;
			}

			result = result.substr( 0, index ) + it->second + result.substr( index + it->first.length() );
		}
		it++;
	}

	return result;
}
