#include "stdafx.h"

#include <jenga/include/common/Path.h>

#include <Program.h>
#include <Compiler.h>
#include <ver.h>

#include "BasicCompiler.h"

#if defined HeapAlloc
#define MEM_MAX 65536
LPVOID pCheckMem[MEM_MAX];
int now;
#undef HeapAlloc
#undef HeapReAlloc
LPVOID CheckHeapAlloc(HANDLE hf,DWORD dwFlags,DWORD dwBytes){
	LPVOID ret;
	ret=HeapAlloc(hf,dwFlags,dwBytes);
	pCheckMem[now]=ret;

	//̕now̃`FbN}

	now++;
	if(now>=MEM_MAX){
		MessageBox(0,"pCheckMem̍ől𒴂܂","Check - BasicCompiler.exe",0);
	}
	return ret;
}
LPVOID CheckHeapReAlloc(HANDLE hf,DWORD dwFlags,LPVOID lpMem,DWORD dwBytes){
	int i;
	LPVOID ret;
	for(i=0;;i++){
		if(lpMem==pCheckMem[i]) break;
		if(i>=MEM_MAX){
			MessageBox(0,"G[","Check - BasicCompiler.exe",0);
			break;
		}
	}
	ret=HeapReAlloc(hf,dwFlags,lpMem,dwBytes);
	pCheckMem[i]=ret;
	return ret;
}
void HeapDefaultFree(LPVOID lpMem){
	int i;
	for(i=0;;i++){
		if(lpMem==pCheckMem[i]) break;
		if(i>=MEM_MAX||lpMem==0){
			MessageBox(0,"G[","Check - BasicCompiler.exe",0);
			break;
		}
	}
	pCheckMem[i]=0;
	HeapFree(hHeap,0,lpMem);
}
void CheckHeapCheck(){
	int i,i2;
	char temp[100];
	temp[0]=0;
	for(i=0,i2=0;i<MEM_MAX;i++){
		if(pCheckMem[i]){
			sprintf(temp+lstrlen(temp),"%d\r\n",i);
			i2++;
			if(i2==10){
				lstrcat(temp,"ȏ̖mFĂ܂");
				break;
			}
		}
	}
	if(temp[0]) MessageBox(0,temp,"Check - BasicCompiler.exe",0);
}
#define HeapAlloc CheckHeapAlloc
#define HeapReAlloc CheckHeapReAlloc
#else
void HeapDefaultFree(LPVOID lpMem){
	HeapFree(hHeap,0,lpMem);
}
#endif

void ts(int i){
	char temporary[255];
	sprintf(temporary,"0x%08x",i);
	MessageBox(0,temporary,"TestMessage",0);
}
void ts(int i,int i2){
	char temporary[255];
	sprintf(temporary,"0x%08x\r\n0x%08x",i,i2);
	MessageBox(0,temporary,"TestMessage",0);
}
void ts(const char *msg){
	MessageBox(0,FormatEscapeSequenceStringToDefaultString(msg).c_str(),"TestMessage",0);
}
void ts(const char *msg,const char *title){
	MessageBox(0,FormatEscapeSequenceStringToDefaultString(msg).c_str(),title,0);
}
void ts(const std::string msg)
{
	ts(msg.c_str());
}

void epi_check(){
	//̕obp̃`FbN}
	// c epi=0x41999    obp>=0x0999
/*
	extern int obp;
	if(obp>=0x988DE){
		int test=0;
	}*/
}

void GetRelationalPath(char *path,char *dir){
	//΃pX擾
	int i,i2,i3,i4,i5;
	char temporary[MAX_PATH],temp2[MAX_PATH],temp3[MAX_PATH],temp4[MAX_PATH];

	//hCu`FbN
	_splitpath(path,temporary,0,0,0);
	_splitpath(dir,temp2,0,0,0);
	if(lstrcmpi(temporary,temp2)!=0) return;

	_splitpath(path,0,temporary,0,0);
	_splitpath(dir,0,temp2,0,0);
	i=1;i2=1;
	while(1){
		i4=i;
		if(temporary[i-1]=='\\'&&temporary[i]){	//path
			for(i3=0;;i++,i3++){
				if(temporary[i]=='\\'){
					temp3[i3]=0;
					i++;
					break;
				}
				temp3[i3]=temporary[i];
			}
		}
		else temp3[0]=0;

		i5=i2;
		if(temp2[i2-1]=='\\'&&temp2[i2]){		//dir
			for(i3=0;;i2++,i3++){
				if(temp2[i2]=='\\'){
					temp4[i3]=0;
					i2++;
					break;
				}
				temp4[i3]=temp2[i2];
			}
		}
		else temp4[0]=0;

		if(temp3[0]=='\0'&&temp4[0]=='\0'){
			lstrcpy(temp3,".\\");
			break;
		}

		if(lstrcmpi(temp3,temp4)!=0){
			for(i3=0;;i5++){
				if(temp2[i5]=='\0') break;
				if(temp2[i5]=='\\') i3++;
			}
			if(i3==0) lstrcpy(temp3,".\\");
			else{
				temp3[0]=0;
				for(i2=0;i2<i3;i2++) lstrcat(temp3,"..\\");
			}
			lstrcat(temp3,temporary+i4);
			break;
		}
	}
	_splitpath(path,0,0,temporary,temp2);
	lstrcat(temp3,temporary);
	lstrcat(temp3,temp2);
	lstrcpy(path,temp3);
}
void GetFullPath( char *path, const string &baseDirPath ){
	int i,i2,i3,i4;
	char temporary[MAX_PATH];

	// '/''\'
	for( i=0;path[i];i++ ){
		if( path[i] == '/' ){
			path[i]='\\';
		}
	}

	if(strstr(path,":")||strstr(path,"\\\\")) return;

	i=0;i2=0;
	while(1){
		if(path[i]=='.'&&path[i+1]=='\\') i+=2;
		if(path[i]=='.'&&path[i+1]=='.'&&path[i+2]=='\\'){
			i2++;
			i+=3;
		}
		else break;
	}

	std::string tempBaseDirPath = baseDirPath;
	if( tempBaseDirPath[tempBaseDirPath.size()-1] != '\\' )
	{
		tempBaseDirPath += "\\";
	}

	i3=(int)tempBaseDirPath.size();i4=0;
	while(i4<i2){
		for(i3--;;i3--){
			if(tempBaseDirPath[i3-1]=='\\'){
				i4++;
				break;
			}
		}
	}
	memcpy(temporary,tempBaseDirPath.c_str(),i3);
	temporary[i3]=0;
	lstrcat(temporary,path+i);
	lstrcpy(path,temporary);
}
std::string GetApplicationBaseFullPath( const std::string &relationalPath )
{
	char fullPath[1024];
	lstrcpy( fullPath, relationalPath.c_str() );
	GetFullPath( fullPath, Jenga::Common::Environment::GetAppDir() );
	return fullPath;
}

void ShowErrorLine(int LineNum,const char *constFileName){
	HANDLE hFile;
	DWORD dw;
	char FileName[MAX_PATH];
	char temporary[MAX_PATH];

	lstrcpy( FileName, constFileName );

	if(LineNum==-1) return;

	if(IsWindow(hOwnerEditor)){
		if(FileName){

			while( !IsFileExist( FileName ) ){
				char temp2[MAX_PATH],temp3[MAX_PATH];
				_splitpath(FileName,NULL,NULL,temp2,temp3);
				lstrcat(temp2,temp3);

				sprintf(temporary,"\"%s\" ܂Bi[ĂfBNgw肵ĂB",temp2);
				if(!GetFolder(hOwnerEditor,temp3,temporary)) return;

				if(temp3[lstrlen(temp3)-1]!='\\') lstrcat(temp3,"\\");

				sprintf(FileName,"%s%s",temp3,temp2);
			}

			hFile=CreateFile(
				( Jenga::Common::Environment::GetAppDir() + "\\pgm.tmp" ).c_str(),
				GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_ARCHIVE|FILE_ATTRIBUTE_HIDDEN|FILE_ATTRIBUTE_TEMPORARY,NULL);
			WriteFile(hFile,FileName,lstrlen(FileName),&dw,NULL);
			CloseHandle(hFile);

			SendMessage(hOwnerEditor,WM_SHOWERROR,LineNum,0);
		}
	}
}

BOOL GetFilePathDialog(HWND hwnd,char *filename,LPSTR Filter,LPSTR Title,BOOL bOpen){
	OPENFILENAME ofstr;
	filename[0]=0;
	ofstr.lStructSize=sizeof(OPENFILENAME);
	ofstr.hwndOwner=hwnd;
	ofstr.hInstance=0;
	ofstr.lpstrFilter=Filter;
	ofstr.lpstrCustomFilter=NULL;
	ofstr.nMaxCustFilter=0;
	ofstr.nFilterIndex=1;
	ofstr.lpstrFile=filename;
	ofstr.nMaxFile=MAX_PATH;
	ofstr.lpstrFileTitle=NULL;
	ofstr.nMaxFileTitle=0;
	ofstr.lpstrInitialDir=0;
	ofstr.lpstrTitle=Title;
	ofstr.Flags=OFN_FILEMUSTEXIST|OFN_HIDEREADONLY|OFN_PATHMUSTEXIST;
	ofstr.nFileOffset=0;
	ofstr.nFileExtension=0;
	ofstr.lpstrDefExt="*";
	ofstr.lCustData=NULL;
	ofstr.lpfnHook=NULL;
	ofstr.lpTemplateName=NULL;
	if(bOpen){
		if(!GetOpenFileName(&ofstr)) return FALSE;
	}
	else{
		if(!GetSaveFileName(&ofstr)) return FALSE;
	}
	return TRUE;
}

LRESULT CALLBACK ErrorListProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	int i,pos;
	int StartPos,EndPos;

	switch(message){
		case WM_CHAR:
			if(GetKeyState(VK_CONTROL)&0x8000){
				//ANZ[^L[̏ꍇl
				break;
			}
			return 0;
		case WM_LBUTTONDBLCLK:
			SendMessage(hwnd,EM_GETSEL,(WPARAM)&pos,0);
			i=(int)SendMessage(hwnd,EM_LINEFROMCHAR,pos,0);
			compiler.errorMessenger.ShowErrorLine( i );

			StartPos=(int)SendMessage(hwnd,EM_LINEINDEX,i,0);
			EndPos=StartPos+(int)SendMessage(hwnd,EM_LINELENGTH,pos,0);
			SendMessage(hwnd,EM_SETSEL,StartPos,EndPos);
			return 0;
	}
	return CallWindowProc(OldErrorListProc,hwnd,message,wParam,lParam);
}
LRESULT CALLBACK DebugListProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	switch(message){
		case WM_CHAR:
			if(GetKeyState(VK_CONTROL)&0x8000){
				//ANZ[^L[̏ꍇl
				break;
			}
			return 0;
	}
	return CallWindowProc(OldDebugListProc,hwnd,message,wParam,lParam);
}
void MakeMessageText(char *buffer,char *msg,int flag){
	if( program.IsClipCompileView() ){
		//ProjectViewߍ݂C^[tFCX̂Ƃ

		//t@C̑΃pX擾
		char relationalPath[MAX_PATH];
		lstrcpy( relationalPath, program.GetOutputFilePath().c_str() );
		GetRelationalPath( relationalPath, BasicCurDir );

		//////////
		// 

#if defined(JPN)
		//{
		if(flag==0){
			if(compiler.IsDll())
			{
				sprintf(buffer,"DLLt@C \"%s\"     [ %s ]",relationalPath,msg);
			}
			else sprintf(buffer,"st@C \"%s\"     [ %s ]",relationalPath,msg);
		}
		if(flag==1) sprintf(buffer,"\"%s\" 𐶐Ă܂     [ %s ]",relationalPath,msg);
		if(flag==2) lstrcpy(buffer,msg);
#else
		//p
		if(flag==0){
			if(compiler.IsDll()) sprintf(buffer,"DLL file \"%s\"     [ %s ]",relationalPath,msg);
			else sprintf(buffer,"Execution file \"%s\"     [ %s ]",relationalPath,msg);
		}
		if(flag==1) sprintf(buffer,"Creating \"%s\"     [ %s ]",relationalPath,msg);
		if(flag==2) lstrcpy(buffer,msg);
#endif
	}
	else{
		//ʏ_CAÔƂ
		lstrcpy(buffer,msg);
	}
}

void SetPosCenter(HWND hwnd){
	RECT OwnerRect,rect;
	int x,y;

	if(IsWindow(hOwnerEditor)) GetWindowRect(hOwnerEditor,&OwnerRect);
	else{
		OwnerRect.left=0;
		OwnerRect.top=0;
		OwnerRect.right=ScreenX;
		OwnerRect.bottom=ScreenY;
	}
	GetWindowRect(hwnd,&rect);

	x=((OwnerRect.right-OwnerRect.left)-(rect.right-rect.left))/2+OwnerRect.left;
	y=((OwnerRect.bottom-OwnerRect.top)-(rect.bottom-rect.top))/2+OwnerRect.top;
	SetWindowPos(hwnd,0,x,y,0,0,SWP_NOSIZE);
}
BOOL CALLBACK DlgCompile(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern HANDLE hDebugProcess;
	char temporary[MAX_PATH];
	RECT rect;
	POINT pos;
	SIZE size;
	static POINT pos_List,pos_Progress;
	static int height_Progress;

	switch(message){
		case WM_INITDIALOG:
			pos=pobj_nv->MainDlgPos;
			GetWindowRect(hwnd,&rect);
			size.cx=rect.right-rect.left;
			size.cy=rect.bottom-rect.top;
			MoveWindow(hwnd,pos.x,pos.y,size.cx,size.cy,1);

			char relationalPath[MAX_PATH];
			lstrcpy(relationalPath,program.GetOutputFilePath().c_str());
			GetRelationalPath(relationalPath,BasicCurDir);
			SetDlgItemText(hwnd,IDC_EXEPATH,relationalPath);

			//"G["
			SetDlgItemText(hwnd,IDC_ERRORLIST,STRING_NOERROR);

			//"fobO񖳂"
			SetDlgItemText(hwnd,IDC_DEBUGLIST,STRING_NODEBUGMSG);

			//Xg{bNX̏ʒu
			GetWindowRect(GetDlgItem(hwnd,IDC_ERRORLIST),&rect);
			pos_List.x=rect.left;
			pos_List.y=rect.top;
			ScreenToClient(hwnd,&pos_List);

			//vOXo[̏ʒuƍ
			GetWindowRect(GetDlgItem(hwnd,IDC_PROGRESS),&rect);
			pos_Progress.x=rect.left;
			pos_Progress.y=rect.top;
			ScreenToClient(hwnd,&pos_Progress);
			height_Progress=rect.bottom-rect.top;

			//o[W\L
			sprintf(temporary,"Version %d.%02d.%02d %s",MAJOR_VER,MINOR_VER,REVISION_VER,VER_INFO);
			SetDlgItemText(hwnd,IDC_STATIC_VERSION,temporary);

			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					GetDlgItemText(hwnd,IDOK,temporary,MAX_PATH);

					//STRING_COMPILE = "RpC"
					if(lstrcmp(temporary,STRING_COMPILE)==0){
						char tempOutputFileName[MAX_PATH];
						GetDlgItemText(hwnd,IDC_EXEPATH,tempOutputFileName,MAX_PATH);
						program.SetOutputFilePath(
							Jenga::Common::Path::MakeFullPath( tempOutputFileName, BasicCurDir )
						);
						_beginthread( &MainThread, NULL, NULL );
					}

					//STRING_STOP = "f"
					else if(lstrcmp(temporary,STRING_STOP)==0){
						if(hDebugProcess){
							//fobÔƂ

							//vZXI
							TerminateProcess(hDebugProcess,0);
							hDebugProcess=0;

							//fobO_CAOI
							if(hDebugWnd){
								DestroyWindow(hDebugWnd);
							}
						}
						else{
							//RpĈƂ
							bStopCompile=1;

							/* CXbhŁuv{^ɕύX邱ƂŁA
								RpC𒆒f̑^C~OłI邱Ƃ\ */
							//""
							SetDlgItemText(hwnd,IDOK,STRING_CLOSE);
						}
					}

					else{
						SetFocus(hOwnerEditor);
						DestroyWindow(hwnd);
					}
					return 1;
				case IDCANCEL:
					//~{^p

					if(hDebugProcess){
						//fobÔƂ

						//vZXI
						TerminateProcess(hDebugProcess,0);
						hDebugProcess=0;

						//fobO_CAOI
						if(hDebugWnd){
							DestroyWindow(hDebugWnd);
						}
					}

					SetFocus(hOwnerEditor);
					DestroyWindow(hwnd);
					return 1;
				case IDC_SHOWERROR:
					ShowWindow(GetDlgItem(hwnd,IDC_ERRORLIST),SW_SHOW);
					ShowWindow(GetDlgItem(hwnd,IDC_DEBUGLIST),SW_HIDE);
					return 1;
				case IDC_SHOWDEBUG:
					ShowWindow(GetDlgItem(hwnd,IDC_ERRORLIST),SW_HIDE);
					ShowWindow(GetDlgItem(hwnd,IDC_DEBUGLIST),SW_SHOW);
					return 1;
			}
			break;
		case WM_SHOWVARLIST:
			if( program.IsClipCompileView() ){
				//ߍݕ\
				CreateDialogParam(hInst,MAKEINTRESOURCE(IDD_DEBUGGER),hOwnerEditor,(DLGPROC)DlgDebugger,lParam);
				ShowWindow(hDebugWnd,SW_SHOW);

				SendMessage(hOwnerEditor,WM_SETDEBUGGERVIEW,0,(LPARAM)hDebugWnd);
			}
			else{
				//|bvAbv\
				CreateDialogParam(hInst,MAKEINTRESOURCE(IDD_VARLIST),hOwnerEditor,(DLGPROC)DlgVarList,lParam);
				SetForegroundWindow(hDebugWnd);
			}
			return 1;
		case WM_SIZE:
			if( program.IsClipCompileView() ){
				//G[Xg̈ʒu
				MoveWindow(GetDlgItem(hwnd,IDC_ERRORLIST),
					pos_List.x,
					pos_List.y,
					LOWORD(lParam)-pos_List.x,
					HIWORD(lParam)-pos_List.y,
					1);

				//fobOXg̈ʒu
				MoveWindow(GetDlgItem(hwnd,IDC_DEBUGLIST),
					pos_List.x,
					pos_List.y,
					LOWORD(lParam)-pos_List.x,
					HIWORD(lParam)-pos_List.y,
					1);

				//vOXo[̈ʒu
				MoveWindow(GetDlgItem(hwnd,IDC_PROGRESS),
					pos_Progress.x,
					pos_Progress.y,
					LOWORD(lParam)-pos_Progress.x,
					height_Progress,
					1);
			}
			return 1;
		case WM_DESTROY:
			GetWindowRect(hwnd,&rect);

			if( !program.IsClipCompileView() ){
				pobj_nv->MainDlgPos.x=rect.left;
				pobj_nv->MainDlgPos.y=rect.top;
			}

			PostQuitMessage(0);
			return 1;



		///////////////////////
		// fobOR}h
		///////////////////////

		case WM_DEBUG_STOP:
			Debugger_Stop();
			return 1;
		case WM_DEBUG_PAUSE:
			Debugger_Pause();
			return 1;


		case WM_CLOSE_DEBUGGER:
			if(hDebugWnd){
				DestroyWindow(hDebugWnd);
			}
			return 1;
	}
	return 0;
}

void _Test()
{
	Jenga::Common::LoggerSetting loggerSetting;
	bool result = loggerSetting.WriteXml( Jenga::Common::Environment::GetAppDir() + "\\logger.setting.xml" );
}

int main()
{
	int i;
	char temporary[1024],temp2[MAX_PATH];

	hInst = GetModuleHandle( NULL );

	// O[o[P{ɂ
	locale::global(locale("japanese"));
	_setmode(_fileno(stdout), _O_BINARY);

	//_Test();

	//MessageBox(0,"starting compiler/debugger","ActiveBasic",MB_OK);
	trace( "Start ActiveBasic Compiler!" );

	//RRg[
	InitCommonControls();

	hHeap=GetProcessHeap();
	ScreenX=GetSystemMetrics(SM_CXSCREEN);
	ScreenY=GetSystemMetrics(SM_CYSCREEN);

	//sf[^擾
	pobj_nv=new CNonVolatile;
	pobj_nv->load();

	program.Configurate();

	if( !program.AnalysisCommandLines() )
	{
		// R}hCs
		return 0;
	}

	bool isSpecifiedSourceFilePathByCommandLine = false;
	if( program.GetSourceFilePath().size() > 0 )
	{
		// \[Xt@C^ĂƂ
		isSpecifiedSourceFilePathByCommandLine = true;
	}
	else
	{
		// \[Xt@C^ȂƂ
		char temp[MAX_PATH];
		if(!GetFilePathDialog(0,temp,BasicFileFilter,"RpCt@Cw肵ĉ",1))
		{
			return 0;
		}
		program.SetSourceFilePath( temp );
	}

	//o̓t@C^ȂƂ
	if( program.GetOutputFilePath().size() == 0 )
	{
		char tempOutputFileName[MAX_PATH];
		_splitpath( program.GetSourceFilePath().c_str(), tempOutputFileName,temporary,temp2,0);
		lstrcat(tempOutputFileName,temporary);
		lstrcat(tempOutputFileName,temp2);
		if( compiler.IsStaticLibrary() )
		{
			if( program.IsDebugRun() || compiler.IsDebug() )
			{
				lstrcat(tempOutputFileName,"_debug.abobj");
			}
			else
			{
				lstrcat(tempOutputFileName,".abobj");
			}
		}
		else
		{
			if( program.IsDebugRun() || compiler.IsDebug() )
			{
				lstrcat(tempOutputFileName,"_debug.exe");
			}
			else
			{
				lstrcat(tempOutputFileName,".exe");
			}
		}

		program.SetOutputFilePath( tempOutputFileName );
	}

	{
		// JgfBNg擾
		std::string baseDirPath = Jenga::Common::Environment::GetAppDir()+"\\";

		// CN[hfBNgw肳ȂƂ
		if( program.GetIncludeDir().size() == 0 )
		{
			program.SetIncludeDir( Jenga::Common::Path::MakeFullPath( ".\\Include", ActiveBasic::Common::Environment::GetAbdevRootPath() ) );
		}
		else
		{
			// CN[hfBNg΃pXɕύX
			program.SetIncludeDir( Jenga::Common::Path::MakeFullPath( program.GetIncludeDir(), ActiveBasic::Common::Environment::GetAbdevRootPath() ) );
		}

		// \[Xt@C΃pXɕϊ
		program.SetSourceFilePath( Jenga::Common::Path::MakeFullPath( program.GetSourceFilePath(), baseDirPath ) );

		// o̓t@C΃pXɕϊ
		program.SetOutputFilePath( Jenga::Common::Path::MakeFullPath( program.GetOutputFilePath(), baseDirPath ) );

		// W[Zbg
		compiler.SetModuleName( Jenga::Common::Path( program.GetOutputFilePath() ).GetFileName() );
	}

	if( compiler.IsDll() )
	{
		//DLLt@C擾
		_splitpath( program.GetOutputFilePath().c_str(),NULL,NULL,szDllName,temporary);
		lstrcat(szDllName,temporary);
	}

	if( program.IsDebugRun() )
	{
		//R}hCADLL̎s\AvP[V擾
		HANDLE hFile;
		DWORD dwAccessBytes;
		hFile=CreateFile(
			( Jenga::Common::Environment::GetAppDir() + "\\pgm.tmp" ).c_str(),
			GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if(hFile!=INVALID_HANDLE_VALUE){
			ReadFile(hFile,temporary,MAX_PATH,&dwAccessBytes,NULL);
			CloseHandle(hFile);
			temporary[dwAccessBytes]=0;
		}
		else temporary[0]=0;

		for(i=0;;i++){
			if(temporary[i]=='\r'&&temporary[i+1]=='\n'||temporary[i]=='\0'){
				szDebugExeForDll[i]=0;
				break;
			}
			szDebugExeForDll[i]=temporary[i];
		}
		if(temporary[i]){
			lstrcpy(szDebugCmdLine,temporary+i+2);
		}
	}

	_splitpath( program.GetSourceFilePath().c_str(), BasicCurDir,temporary,NULL,NULL);
	lstrcat(BasicCurDir,temporary);

	if( program.IsClipCompileView() ){
		//ProjectEditorߍ݌^C^[tFCX
		hMainDlg=CreateDialog(hInst,MAKEINTRESOURCE(IDD_CLIPMAIN),hOwnerEditor,(DLGPROC)DlgCompile);
		ShowWindow(hMainDlg,SW_SHOW);
		SendMessage(hOwnerEditor,WM_SETCOMPILEVIEW,0,(LPARAM)hMainDlg);

		//vOXo[̐FZbg
		PostMessage(GetDlgItem(hMainDlg,IDC_PROGRESS),PBM_SETBARCOLOR,0,RGB(255,220,192));
		PostMessage(GetDlgItem(hMainDlg,IDC_PROGRESS),PBM_SETBKCOLOR,0,RGB(255,255,255));
	}
	else{
		//ʏ_CAOC^[tFCX
		hMainDlg=CreateDialog(hInst,MAKEINTRESOURCE(IDD_MAIN),hOwnerEditor,(DLGPROC)DlgCompile);

		if( program.IsKickedFromEditor() )
		{
			// GfB^NꂽƂ
			PostMessage( hMainDlg, WM_COMMAND, IDOK, 0 );
		}
		else if( program.IsShowDlg() )
		{
			// R}hCshow_dlgp[^w肳ꂽꍇA_CAO\
			// ɃrhJn
			ShowWindow(hMainDlg,SW_SHOW);
			PostMessage( hMainDlg, WM_COMMAND, IDOK, 0 );
		}
		else if( isSpecifiedSourceFilePathByCommandLine )
		{
			// R}hCŃ\[XR[hw肪ꍇ̓EBhE͕\Â܂܃rhJnB
			MainThread(0);

			trace("Complete ActiveBasic Compiler!");

			ExitProcess( program.GetExitCode() );
			return 0;
		}
		else
		{
			ShowWindow(hMainDlg,SW_SHOW);
		}
	}
	SendDlgItemMessage(hMainDlg,IDC_SHOWERROR,BM_SETCHECK,BST_CHECKED,0);

	//G[XgTuNX
	OldErrorListProc=(WNDPROC)GetWindowLongPtr(GetDlgItem(hMainDlg,IDC_ERRORLIST),GWLP_WNDPROC);
	SetWindowLongPtr(GetDlgItem(hMainDlg,IDC_ERRORLIST),GWLP_WNDPROC,(LONG_PTR)ErrorListProc);

	//fobOXgTuNX
	OldDebugListProc=(WNDPROC)GetWindowLongPtr(GetDlgItem(hMainDlg,IDC_DEBUGLIST),GWLP_WNDPROC);
	SetWindowLongPtr(GetDlgItem(hMainDlg,IDC_DEBUGLIST),GWLP_WNDPROC,(LONG_PTR)DebugListProc);

	if( program.IsKickedFromEditor() )
	{
		SendMessage(hMainDlg,WM_COMMAND,IDOK,0);
	}

	MSG msg;
	while(GetMessage(&msg,0,0,0)){
		if(IsDialogMessage(hMainDlg,&msg)) continue;
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	//sf[^ۑ
	pobj_nv->save();
	delete pobj_nv;
	pobj_nv=0;

#if defined HeapAlloc
	CheckHeapCheck();
#endif

	if( program.IsClipCompileView() ){
		SendMessage(hOwnerEditor,WM_DESTROYCOMPILEVIEW,0,0);
	}

	trace("Complete ActiveBasic Compiler!");

	ExitProcess( program.GetExitCode() );

	return 0;
}
