#include "stdafx.h"

#include "Common.h"

void DrawLineInClient(int WndNum,long StartX,long StartY,long EndX,long EndY){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	MoveToEx(MdiInfo[WndNum].MdiRadInfo->hMemDC,
		StartX+MdiInfo[WndNum].MdiRadInfo->ClientPos.x,
		StartY+MdiInfo[WndNum].MdiRadInfo->ClientPos.y,
		NULL);
	LineTo(MdiInfo[WndNum].MdiRadInfo->hMemDC,
		EndX+MdiInfo[WndNum].MdiRadInfo->ClientPos.x,
		EndY+MdiInfo[WndNum].MdiRadInfo->ClientPos.y);
}
void DrawRectangleInClient(int WndNum,long left,long top,long right,long bottom,COLORREF RGB_Pen,COLORREF RGB_Brush,BOOL bBrushing){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	HPEN hPen,hOldPen;
	HBRUSH hBrush,hOldBrush;

	hPen=CreatePen(PS_SOLID,0,RGB_Pen);
	if(bBrushing) hBrush=CreateSolidBrush(RGB_Brush);
	else hBrush=(HBRUSH)GetStockObject(NULL_BRUSH);
	hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
	hOldBrush=(HBRUSH)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hBrush);

	Rectangle(MdiInfo[WndNum].MdiRadInfo->hMemDC,
		left+MdiInfo[WndNum].MdiRadInfo->ClientPos.x,
		top+MdiInfo[WndNum].MdiRadInfo->ClientPos.y,
		right+MdiInfo[WndNum].MdiRadInfo->ClientPos.x,
		bottom+MdiInfo[WndNum].MdiRadInfo->ClientPos.y);

	SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
	SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldBrush);
	DeleteObject(hPen);
	if(bBrushing) DeleteObject(hBrush);
}
void DrawButtonEdge(int WndNum,POINT *pPos,SIZE *pSize){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	HPEN hPen,hOldPen;

	//̉
	hPen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_3DHIGHLIGHT));
	hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
	DrawLineInClient(WndNum,
		pPos->x, pPos->y,
		pPos->x+pSize->cx-1, pPos->y);
	DrawLineInClient(WndNum,
		pPos->x, pPos->y,
		pPos->x, pPos->y+pSize->cy-1);
	SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
	DeleteObject(hPen);

	//ẻ
	hPen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_3DDKSHADOW));
	hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
	DrawLineInClient(WndNum,
		pPos->x, pPos->y+pSize->cy-1,
		pPos->x+pSize->cx, pPos->y+pSize->cy-1);
	DrawLineInClient(WndNum,
		pPos->x+pSize->cx-1, pPos->y,
		pPos->x+pSize->cx-1, pPos->y+pSize->cy-1);
	SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
	DeleteObject(hPen);

	hPen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_3DSHADOW));
	hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
	DrawLineInClient(WndNum,
		pPos->x+1, pPos->y+pSize->cy-2,
		pPos->x+pSize->cx-1, pPos->y+pSize->cy-2);
	DrawLineInClient(WndNum,
		pPos->x+pSize->cx-2, pPos->y+1,
		pPos->x+pSize->cx-2, pPos->y+pSize->cy-2);
	SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
	DeleteObject(hPen);

	//
	DrawRectangleInClient(WndNum,
		pPos->x+1,pPos->y+1,
		pPos->x+pSize->cx-2,pPos->y+pSize->cy-2,
		GetSysColor(COLOR_3DFACE),GetSysColor(COLOR_3DFACE),1);

	pPos->x+=3;
	pPos->y+=2;
	pSize->cx-=5;
	pSize->cy-=4;
}
void DrawItemEdgeByExStyle(int WndNum,int ExStyle,POINT *pPos,SIZE *pSize){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	HPEN hPen,hOldPen;
	RECT rect;

	if(ExStyle&WS_EX_DLGMODALFRAME){
		///////////////////////////
		//[_ t[E

		rect.left=pPos->x+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
		rect.top=pPos->y+MdiInfo[WndNum].MdiRadInfo->ClientPos.y;
		rect.right=pPos->x+pSize->cx+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
		rect.bottom=pPos->y+pSize->cy+MdiInfo[WndNum].MdiRadInfo->ClientPos.y;
		DrawEdge(MdiInfo[WndNum].MdiRadInfo->hMemDC,&rect,EDGE_RAISED,BF_RECT);
		pPos->x+=2;
		pPos->y+=2;
		pSize->cx-=4;
		pSize->cy-=4;

		//טg
		DrawRectangleInClient(WndNum,
			pPos->x,pPos->y,
			pPos->x+pSize->cx,pPos->y+pSize->cy,
			GetSysColor(COLOR_ACTIVEBORDER),0,0);

		pPos->x+=1;
		pPos->y+=1;
		pSize->cx-=2;
		pSize->cy-=2;
	}
	else if(ExStyle&WS_EX_STATICEDGE){
		//////////////////////
		//X^eBbNE

		//e̐F
		hPen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_3DSHADOW));
		hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
		DrawLineInClient(WndNum,
			pPos->x,
			pPos->y,
			pPos->x,
			pPos->y+pSize->cy-1);
		DrawLineInClient(WndNum,
			pPos->x,
			pPos->y,
			pPos->x+pSize->cx-1,
			pPos->y);
		SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
		DeleteObject(hPen);

		//̉
		hPen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_3DHIGHLIGHT));
		hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
		DrawLineInClient(WndNum,
			pPos->x,
			pPos->y+pSize->cy-1,
			pPos->x+pSize->cx-1,
			pPos->y+pSize->cy-1);
		DrawLineInClient(WndNum,
			pPos->x+pSize->cx-1,
			pPos->y,
			pPos->x+pSize->cx-1,
			pPos->y+pSize->cy);
		SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
		DeleteObject(hPen);

		pPos->x+=1;
		pPos->y+=1;
		pSize->cx-=2;
		pSize->cy-=2;
	}
	if(ExStyle&WS_EX_CLIENTEDGE){
		//////////////////////
		//NCAgE

		rect.left=pPos->x+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
		rect.top=pPos->y+MdiInfo[WndNum].MdiRadInfo->ClientPos.y;
		rect.right=pPos->x+pSize->cx+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
		rect.bottom=pPos->y+pSize->cy+MdiInfo[WndNum].MdiRadInfo->ClientPos.y;
		DrawEdge(MdiInfo[WndNum].MdiRadInfo->hMemDC,&rect,EDGE_SUNKEN,BF_RECT);
		pPos->x+=2;
		pPos->y+=2;
		pSize->cx-=4;
		pSize->cy-=4;
	}
}
void DrawScrollBar(int WndNum,DWORD style,BOOL bSwitch,POINT *pPos,SIZE *pSize){
	extern PROJECTINFO ProjectInfo;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i,i2;
	HPEN hPen,hOldPen;
	COLORREF rgb;
	POINT pos;
	SIZE size;

	if(bSwitch==0){
		//XN[o[

		//{^
		if(pSize->cx>16*2){
			pos=*pPos;
			size.cx=16;
			size.cy=pSize->cy;
		}
		else{
			pos=*pPos;
			size.cx=pSize->cx/2;
			size.cy=pSize->cy;
		}
		DrawItemEdgeByExStyle(WndNum,WS_EX_DLGMODALFRAME,&pos,&size);

		//
		DrawRectangleInClient(WndNum,
			pos.x,pos.y,
			pos.x+size.cx,pos.y+size.cy,
			GetSysColor(COLOR_3DFACE),GetSysColor(COLOR_3DFACE),1);

		if(style&WS_DISABLED){
			hPen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_3DHIGHLIGHT));
			hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
			pos.x++;
			pos.y++;
			i2=pos.y+(size.cy/2);
			for(i=0;i<4;i++,i2--){
				DrawLineInClient(WndNum,i+pos.x+2,i2,i+pos.x+2,i2+(i*2)+1);
			}
			SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
			DeleteObject(hPen);
			rgb=GetSysColor(COLOR_GRAYTEXT);
			pos.x--;
			pos.y--;
		}
		else rgb=GetSysColor(COLOR_BTNTEXT);
		hPen=CreatePen(PS_SOLID,0,rgb);
		hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
		i2=pos.y+(size.cy/2);
		for(i=0;i<4;i++,i2--){
			DrawLineInClient(WndNum,i+pos.x+2,i2,i+pos.x+2,i2+(i*2)+1);
		}
		SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
		DeleteObject(hPen);

		//E{^
		if(pSize->cx>16*2){
			pos.x=pPos->x+pSize->cx-16;
			pos.y=pPos->y;
			size.cx=16;
			size.cy=pSize->cy;
		}
		else{
			pos.x=pPos->x+pSize->cx/2+pSize->cx%2;
			pos.y=pPos->y;
			size.cx=pSize->cx/2;
			size.cy=pSize->cy;
		}
		DrawItemEdgeByExStyle(WndNum,WS_EX_DLGMODALFRAME,&pos,&size);

		//
		DrawRectangleInClient(WndNum,
			pos.x,pos.y,
			pos.x+size.cx,pos.y+size.cy,
			GetSysColor(COLOR_3DFACE),GetSysColor(COLOR_3DFACE),1);

		if(style&WS_DISABLED){
			hPen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_3DHIGHLIGHT));
			hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
			pos.x++;
			pos.y++;
			i2=pos.y+(size.cy/2);
			for(i=3;i>=0;i--,i2--){
				DrawLineInClient(WndNum,i+pos.x+3,i2,i+pos.x+3,i2+((3-i)*2)+1);
			}
			SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
			DeleteObject(hPen);
			rgb=GetSysColor(COLOR_GRAYTEXT);
			pos.x--;
			pos.y--;
		}
		else rgb=GetSysColor(COLOR_BTNTEXT);
		hPen=CreatePen(PS_SOLID,0,rgb);
		hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
		i2=pos.y+(size.cy/2);
		for(i=3;i>=0;i--,i2--){
			DrawLineInClient(WndNum,i+pos.x+3,i2,i+pos.x+3,i2+((3-i)*2)+1);
		}
		SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
		DeleteObject(hPen);

		if(pSize->cx>16*3){
			if(!(style&WS_DISABLED)){
				pos.x=pPos->x+16;
				pos.y=pPos->y;
				size.cx=16;
				size.cy=pSize->cy;
				DrawItemEdgeByExStyle(WndNum,WS_EX_DLGMODALFRAME,&pos,&size);

				//
				DrawRectangleInClient(WndNum,
					pos.x,pos.y,
					pos.x+size.cx,pos.y+size.cy,
					GetSysColor(COLOR_3DFACE),GetSysColor(COLOR_3DFACE),1);

				pos.x=pPos->x+16*2;
				pos.y=pPos->y;
				size.cx=pSize->cx-16*3;
				size.cy=pSize->cy;
			}
			else{
				pos.x=pPos->x+16;
				pos.y=pPos->y;
				size.cx=pSize->cx-16*2;
				size.cy=pSize->cy;
			}
		}
		else if(pSize->cx>16*2){
			pos.x=pPos->x+16;
			pos.y=pPos->y;
			size.cx=pSize->cx-16*2;
			size.cy=pSize->cy;
		}
		else{
			pos.x=pPos->x+pSize->cx/2;
			pos.y=pPos->y;
			size.cx=pSize->cx%2;
			size.cy=pSize->cy;
		}
	}
	else{
		//XN[o[

		//{^
		if(pSize->cy>16*2){
			pos=*pPos;
			size.cy=16;
			size.cx=pSize->cx;
		}
		else{
			pos=*pPos;
			size.cy=pSize->cy/2;
			size.cx=pSize->cx;
		}
		DrawItemEdgeByExStyle(WndNum,WS_EX_DLGMODALFRAME,&pos,&size);

		//
		DrawRectangleInClient(WndNum,
			pos.x,pos.y,
			pos.x+size.cx,pos.y+size.cy,
			GetSysColor(COLOR_3DFACE),GetSysColor(COLOR_3DFACE),1);

		pos.y++;
		if(style&WS_DISABLED){
			hPen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_3DHIGHLIGHT));
			hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
			pos.x++;
			pos.y++;
			i2=pos.x+(size.cx/2)-1;
			for(i=0;i<4;i++,i2--){
				DrawLineInClient(WndNum,i2,i+pos.y+2,i2+(i*2)+1,i+pos.y+2);
			}
			SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
			DeleteObject(hPen);
			rgb=GetSysColor(COLOR_GRAYTEXT);
			pos.x--;
			pos.y--;
		}
		else rgb=GetSysColor(COLOR_BTNTEXT);
		hPen=CreatePen(PS_SOLID,0,rgb);
		hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
		i2=pos.x+(size.cx/2)-1;
		for(i=0;i<4;i++,i2--){
			DrawLineInClient(WndNum,i2,i+pos.y+2,i2+(i*2)+1,i+pos.y+2);
		}
		SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
		DeleteObject(hPen);

		//{^
		if(pSize->cy>16*2){
			pos.x=pPos->x;
			pos.y=pPos->y+pSize->cy-16;
			size.cx=pSize->cx;
			size.cy=16;
		}
		else{
			pos.x=pPos->x;
			pos.y=pPos->y+pSize->cy/2+pSize->cy%2;
			size.cx=pSize->cx;
			size.cy=pSize->cy/2;
		}
		DrawItemEdgeByExStyle(WndNum,WS_EX_DLGMODALFRAME,&pos,&size);

		//
		DrawRectangleInClient(WndNum,
			pos.x,pos.y,
			pos.x+size.cx,pos.y+size.cy,
			GetSysColor(COLOR_3DFACE),GetSysColor(COLOR_3DFACE),1);

		pos.x--;
		if(style&WS_DISABLED){
			hPen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_3DHIGHLIGHT));
			hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
			pos.x++;
			pos.y++;
			i2=pos.x+(size.cx/2);
			for(i=3;i>=0;i--,i2--){
				DrawLineInClient(WndNum,i2,i+pos.y+3,i2+((3-i)*2)+1,i+pos.y+3);
			}
			SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
			DeleteObject(hPen);
			rgb=GetSysColor(COLOR_GRAYTEXT);
			pos.x--;
			pos.y--;
		}
		else rgb=GetSysColor(COLOR_BTNTEXT);
		hPen=CreatePen(PS_SOLID,0,rgb);
		hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
		i2=pos.x+(size.cx/2);
		for(i=3;i>=0;i--,i2--){
			DrawLineInClient(WndNum,i2,i+pos.y+3,i2+((3-i)*2)+1,i+pos.y+3);
		}
		SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
		DeleteObject(hPen);

		if(pSize->cy>16*3){
			if(!(style&WS_DISABLED)){
				pos.x=pPos->x;
				pos.y=pPos->y+16;
				size.cx=pSize->cx;
				size.cy=16;
				DrawItemEdgeByExStyle(WndNum,WS_EX_DLGMODALFRAME,&pos,&size);

				//
				DrawRectangleInClient(WndNum,
					pos.x,pos.y,
					pos.x+size.cx,pos.y+size.cy,
					GetSysColor(COLOR_3DFACE),GetSysColor(COLOR_3DFACE),1);

				pos.x=pPos->x;
				pos.y=pPos->y+16*2;
				size.cx=pSize->cx;
				size.cy=pSize->cy-16*3;
			}
			else{
				pos.x=pPos->x;
				pos.y=pPos->y+16;
				size.cx=pSize->cx;
				size.cy=pSize->cy-16*2;
			}
		}
		else if(pSize->cy>16*2){
			pos.x=pPos->x;
			pos.y=pPos->y+16;
			size.cx=pSize->cx;
			size.cy=pSize->cy-16*2;
		}
		else{
			pos.x=pPos->x;
			pos.y=pPos->y+pSize->cy/2;
			size.cx=pSize->cx;
			size.cy=pSize->cy%2;
		}
	}

	if(size.cx){
		int x,y;
		HBITMAP hBitmap;
		BITMAPINFO BitmapInfo;
		BYTE *pByte;

		memset(&BitmapInfo.bmiHeader,0,sizeof(BITMAPINFOHEADER));
		BitmapInfo.bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
		BitmapInfo.bmiHeader.biWidth=size.cx;
		BitmapInfo.bmiHeader.biHeight=size.cy;
		BitmapInfo.bmiHeader.biPlanes=1;
		BitmapInfo.bmiHeader.biBitCount=24;

		hBitmap=CreateDIBSection(MdiInfo[WndNum].MdiRadInfo->hMemDC,&BitmapInfo,DIB_RGB_COLORS,(void **)&pByte,0,0);
		i=BitmapInfo.bmiHeader.biWidth*3;
		if(i%sizeof(LONG)!=0) i+=sizeof(LONG)-(i%sizeof(LONG));
		for(y=0;y<BitmapInfo.bmiHeader.biHeight;y++){
			if(y%2==0) rgb=GetSysColor(COLOR_3DFACE);
			else rgb=RGB(255,255,255);
			for(x=0;x<BitmapInfo.bmiHeader.biWidth;x++){
				i2=y*i+x*3;
				pByte[i2+2]=LOBYTE(LOWORD(rgb));
				pByte[i2+1]=HIBYTE(LOWORD(rgb));
				pByte[i2]=LOBYTE(HIWORD(rgb));
				if(rgb==RGB(255,255,255)) rgb=GetSysColor(COLOR_3DFACE);
				else rgb=RGB(255,255,255);
			}
		}
		SetDIBitsToDevice(MdiInfo[WndNum].MdiRadInfo->hMemDC,
			pos.x+MdiInfo[WndNum].MdiRadInfo->ClientPos.x,
			pos.y+MdiInfo[WndNum].MdiRadInfo->ClientPos.y,
			BitmapInfo.bmiHeader.biWidth, BitmapInfo.bmiHeader.biHeight,
			0,0,
			0,BitmapInfo.bmiHeader.biHeight,
			pByte,
			&BitmapInfo,
			DIB_RGB_COLORS);
		DeleteObject(hBitmap);
	}
}
void DrawUpDownControl(int WndNum,DWORD style,BOOL bSwitch,POINT *pPos,SIZE *pSize){
	extern PROJECTINFO ProjectInfo;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i,i2;
	HPEN hPen,hOldPen;
	COLORREF rgb;
	POINT pos;
	SIZE size;

	if(bSwitch==0){
		//

		//{^
		pos=*pPos;
		size.cx=pSize->cx/2;
		size.cy=pSize->cy;
		DrawItemEdgeByExStyle(WndNum,WS_EX_DLGMODALFRAME,&pos,&size);

		//
		DrawRectangleInClient(WndNum,
			pos.x,pos.y,
			pos.x+size.cx,pos.y+size.cy,
			GetSysColor(COLOR_3DFACE),GetSysColor(COLOR_3DFACE),1);

		if(style&WS_DISABLED){
			hPen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_3DHIGHLIGHT));
			hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
			pos.x++;
			pos.y++;
			i2=pos.y+(size.cy/2);
			for(i=0;i<4;i++,i2--){
				DrawLineInClient(WndNum,i+pos.x+2,i2,i+pos.x+2,i2+(i*2)+1);
			}
			SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
			DeleteObject(hPen);
			rgb=GetSysColor(COLOR_GRAYTEXT);
			pos.x--;
			pos.y--;
		}
		else rgb=GetSysColor(COLOR_BTNTEXT);
		hPen=CreatePen(PS_SOLID,0,rgb);
		hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
		i2=pos.y+(size.cy/2);
		for(i=0;i<4;i++,i2--){
			DrawLineInClient(WndNum,i+pos.x+2,i2,i+pos.x+2,i2+(i*2)+1);
		}
		SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
		DeleteObject(hPen);

		//E{^
		pos.x=pPos->x+pSize->cx/2+pSize->cx%2;
		pos.y=pPos->y;
		size.cx=pSize->cx/2;
		size.cy=pSize->cy;
		DrawItemEdgeByExStyle(WndNum,WS_EX_DLGMODALFRAME,&pos,&size);

		//
		DrawRectangleInClient(WndNum,
			pos.x,pos.y,
			pos.x+size.cx,pos.y+size.cy,
			GetSysColor(COLOR_3DFACE),GetSysColor(COLOR_3DFACE),1);

		if(style&WS_DISABLED){
			hPen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_3DHIGHLIGHT));
			hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
			pos.x++;
			pos.y++;
			i2=pos.y+(size.cy/2);
			for(i=3;i>=0;i--,i2--){
				DrawLineInClient(WndNum,i+pos.x+3,i2,i+pos.x+3,i2+((3-i)*2)+1);
			}
			SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
			DeleteObject(hPen);
			rgb=GetSysColor(COLOR_GRAYTEXT);
			pos.x--;
			pos.y--;
		}
		else rgb=GetSysColor(COLOR_BTNTEXT);
		hPen=CreatePen(PS_SOLID,0,rgb);
		hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
		i2=pos.y+(size.cy/2);
		for(i=3;i>=0;i--,i2--){
			DrawLineInClient(WndNum,i+pos.x+3,i2,i+pos.x+3,i2+((3-i)*2)+1);
		}
		SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
		DeleteObject(hPen);
	}
	else{
		//

		//{^
		pos=*pPos;
		size.cy=pSize->cy/2;
		size.cx=pSize->cx;
		DrawItemEdgeByExStyle(WndNum,WS_EX_DLGMODALFRAME,&pos,&size);

		//
		DrawRectangleInClient(WndNum,
			pos.x,pos.y,
			pos.x+size.cx,pos.y+size.cy,
			GetSysColor(COLOR_3DFACE),GetSysColor(COLOR_3DFACE),1);

		pos.y++;
		if(style&WS_DISABLED){
			hPen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_3DHIGHLIGHT));
			hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
			pos.x++;
			pos.y++;
			i2=pos.x+(size.cx/2)-1;
			for(i=0;i<4;i++,i2--){
				DrawLineInClient(WndNum,i2,i+pos.y+2,i2+(i*2)+1,i+pos.y+2);
			}
			SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
			DeleteObject(hPen);
			rgb=GetSysColor(COLOR_GRAYTEXT);
			pos.x--;
			pos.y--;
		}
		else rgb=GetSysColor(COLOR_BTNTEXT);
		hPen=CreatePen(PS_SOLID,0,rgb);
		hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
		i2=pos.x+(size.cx/2)-1;
		for(i=0;i<4;i++,i2--){
			DrawLineInClient(WndNum,i2,i+pos.y+2,i2+(i*2)+1,i+pos.y+2);
		}
		SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
		DeleteObject(hPen);

		//{^
		pos.x=pPos->x;
		pos.y=pPos->y+pSize->cy/2+pSize->cy%2;
		size.cx=pSize->cx;
		size.cy=pSize->cy/2;
		DrawItemEdgeByExStyle(WndNum,WS_EX_DLGMODALFRAME,&pos,&size);

		//
		DrawRectangleInClient(WndNum,
			pos.x,pos.y,
			pos.x+size.cx,pos.y+size.cy,
			GetSysColor(COLOR_3DFACE),GetSysColor(COLOR_3DFACE),1);

		pos.x--;
		if(style&WS_DISABLED){
			hPen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_3DHIGHLIGHT));
			hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
			pos.x++;
			pos.y++;
			i2=pos.x+(size.cx/2);
			for(i=3;i>=0;i--,i2--){
				DrawLineInClient(WndNum,i2,i+pos.y+3,i2+((3-i)*2)+1,i+pos.y+3);
			}
			SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
			DeleteObject(hPen);
			rgb=GetSysColor(COLOR_GRAYTEXT);
			pos.x--;
			pos.y--;
		}
		else rgb=GetSysColor(COLOR_BTNTEXT);
		hPen=CreatePen(PS_SOLID,0,rgb);
		hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hPen);
		i2=pos.x+(size.cx/2);
		for(i=3;i>=0;i--,i2--){
			DrawLineInClient(WndNum,i2,i+pos.y+3,i2+((3-i)*2)+1,i+pos.y+3);
		}
		SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldPen);
		DeleteObject(hPen);
	}
}
void DrawWindowScrollBar(int WndNum,DWORD style,POINT *pPos,SIZE *pSize){
	POINT pos;
	SIZE size;
	if(style&WS_HSCROLL){
		pos.x=pPos->x;
		pos.y=pPos->y+pSize->cy-GetSystemMetrics(SM_CYVSCROLL);
		if(style&WS_VSCROLL) size.cx=pSize->cx-GetSystemMetrics(SM_CXVSCROLL);
		else size.cx=pSize->cx;
		size.cy=GetSystemMetrics(SM_CYVSCROLL);
		DrawScrollBar(WndNum,style,0,&pos,&size);
	}
	if(style&WS_VSCROLL){
		pos.x=pPos->x+pSize->cx-GetSystemMetrics(SM_CXHSCROLL);
		pos.y=pPos->y;
		size.cx=GetSystemMetrics(SM_CXHSCROLL);
		if(style&WS_HSCROLL) size.cy=pSize->cy-GetSystemMetrics(SM_CYHSCROLL);
		else size.cy=pSize->cy;
		DrawScrollBar(WndNum,style,1,&pos,&size);
	}
}
void DrawOEMImage(HDC hdc,POINT *pPos,SIZE *pSize,DWORD dwImage){
	HBITMAP hBmp,hOldBmp;
	HDC memdc;

	//iXP݂̂ɑΉHj

	memdc=CreateCompatibleDC(hdc);
	hBmp=LoadBitmap(NULL,(LPSTR)dwImage);
	hOldBmp=(HBITMAP)SelectObject(memdc,hBmp);
	BitBlt(hdc,pPos->x,pPos->y,pSize->cx,pSize->cy,memdc,0,0,SRCCOPY);
	SelectObject(memdc,hOldBmp);
	DeleteDC(memdc);
	DeleteObject(hBmp);
}
void DesigningWindow(int WndNum,HDC hdc,POINT *pBasePos,WINDOW_INFO *pWindowInfo){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3,i4;
	double red,green,blue,d_red,d_green,d_blue;
	char temporary[MAX_PATH];
	COLORREF rgb;
	HPEN hPen,hOldPen;
	HBRUSH hBrush,hOldBrush;
	HFONT hFont,hOldFont;
	HANDLE hImage;
	RECT InsideRect,rect,rc2;
	POINT pos,pos2;
	SIZE size,size2;

	HGLOBAL hResource;
	BITMAPINFO *pBitmapInfo;
	BYTE *pByte,*pByte2;


	////////////////////////
	//EBhẺ`
	InsideRect.left=pBasePos->x;
	InsideRect.top=pBasePos->y;
	InsideRect.right=InsideRect.left+pWindowInfo->size.cx;
	InsideRect.bottom=InsideRect.top+pWindowInfo->size.cy;

	if(pWindowInfo->style&(WS_BORDER|WS_THICKFRAME)){
		DrawEdge(hdc,&InsideRect,EDGE_RAISED,BF_RECT);

		InsideRect.left+=2;
		InsideRect.top+=2;
		InsideRect.right-=2;
		InsideRect.bottom-=2;
	}


	////////////
	//g`
	if(pWindowInfo->style&(WS_BORDER|WS_THICKFRAME)){
		//טg
		hPen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_ACTIVEBORDER));
		hBrush=CreateSolidBrush(GetSysColor(COLOR_3DFACE));
		hOldPen=(HPEN)SelectObject(hdc,hPen);
		hOldBrush=(HBRUSH)SelectObject(hdc,hBrush);
		Rectangle(hdc,InsideRect.left,InsideRect.top,InsideRect.right,InsideRect.bottom);

		InsideRect.left+=1;
		InsideRect.top+=1;
		InsideRect.right-=1;
		InsideRect.bottom-=1;

		//TCYύXg
		if(pWindowInfo->style&WS_THICKFRAME){
			Rectangle(hdc,InsideRect.left,InsideRect.top,InsideRect.right,InsideRect.bottom);

			InsideRect.left+=1;
			InsideRect.top+=1;
			InsideRect.right-=1;
			InsideRect.bottom-=1;
		}
		SelectObject(hdc,hOldPen);
		SelectObject(hdc,hOldBrush);
		DeleteObject(hPen);
		DeleteObject(hBrush);
	}


	//Draw...InClient֐̂
	MdiInfo[WndNum].MdiRadInfo->ClientPos.x=0;
	MdiInfo[WndNum].MdiRadInfo->ClientPos.y=0;

	if(pWindowInfo->style&(WS_CAPTION&(~WS_BORDER))){
		//////////////////////
		//^Cgo[`

		//wi`iOf[Vj
		i=GetSysColor(COLOR_ACTIVECAPTION);
		OSVERSIONINFO OsVersionInfo;
		OsVersionInfo.dwOSVersionInfoSize=sizeof(OSVERSIONINFO);
		GetVersionEx(&OsVersionInfo);
		if((OsVersionInfo.dwPlatformId==VER_PLATFORM_WIN32_NT&&OsVersionInfo.dwMajorVersion>=5)||
			(OsVersionInfo.dwPlatformId==VER_PLATFORM_WIN32_WINDOWS&&LOWORD(OsVersionInfo.dwBuildNumber)>=1998)){
#define COLOR_GRADIENTACTIVECAPTION 27
			i2=GetSysColor(COLOR_GRADIENTACTIVECAPTION);
		}
		else i2=i;
		if(pWindowInfo->ExStyle&WS_EX_TOOLWINDOW)
			i3=GetSystemMetrics(SM_CYSMCAPTION);
		else i3=GetSystemMetrics(SM_CYCAPTION);
		d_red=((double)((i2&0xFF)-(i&0xFF)))/(double)(InsideRect.right-InsideRect.left);
		d_green=((double)(((i2>>8)&0xFF))-((i>>8)&0xFF))/(double)(InsideRect.right-InsideRect.left);
		d_blue=((double)(((i2>>16)&0xFF))-((i>>16)&0xFF))/(double)(InsideRect.right-InsideRect.left);

		red=(double)(i&0xFF);
		green=(double)((i>>8)&0xFF);
		blue=(double)((i>>16)&0xFF);
		for(i4=InsideRect.left;i4<InsideRect.right;i4++){
			hPen=CreatePen(PS_SOLID,0,RGB((_int8)red,(_int8)green,(_int8)blue));
			hOldPen=(HPEN)SelectObject(hdc,hPen);
			MoveToEx(hdc,i4,InsideRect.top,NULL);
			LineTo(hdc,i4,InsideRect.top+i3-1);
			SelectObject(hdc,hOldPen);
			DeleteObject(hPen);
			red+=d_red;
			green+=d_green;
			blue+=d_blue;
		}

		//^CgeLXg̕`
		LOGFONT LogFont;
		SystemParametersInfo(SPI_GETICONTITLELOGFONT,sizeof(LOGFONT),&LogFont,0);
		hFont=CreateFontIndirect(&LogFont);
		hOldFont=(HFONT)SelectObject(hdc,hFont);
		SetTextColor(hdc,GetSysColor(COLOR_CAPTIONTEXT));
		rect.left=InsideRect.left+20;
		rect.top=InsideRect.top;
		rect.right=InsideRect.right;
		rect.bottom=InsideRect.top+i3;
		DrawText(hdc,pWindowInfo->caption,lstrlen(pWindowInfo->caption),&rect,DT_SINGLELINE|DT_VCENTER|DT_NOPREFIX);
		SelectObject(hdc,hOldFont);
		DeleteObject(hFont);

		//{^
		if(pWindowInfo->style&WS_SYSMENU){
			//I{^
			size.cx=GetSystemMetrics(SM_CXSIZE)-2;
			size.cy=GetSystemMetrics(SM_CYSIZE)-4;
			pos.x=InsideRect.right-2-size.cx;
			pos.y=InsideRect.top+2;
			DrawButtonEdge(WndNum,&pos,&size);

			hResource=LoadResource(hResInst,FindResource(hResInst,MAKEINTRESOURCE(IDB_TITLE_BUTTON_CLOSE),RT_BITMAP));
			pBitmapInfo=(BITMAPINFO *)LockResource(hResource);
			pByte=(BYTE *)pBitmapInfo+pBitmapInfo->bmiHeader.biSize;

			i2=pBitmapInfo->bmiHeader.biWidth*3;
			if(i2%sizeof(LONG)!=0) i2+=sizeof(LONG)-(i2%sizeof(LONG));
			pByte2=(BYTE *)GlobalAlloc(GMEM_FIXED,pBitmapInfo->bmiHeader.biHeight*i2);
			int x,y;
			for(y=0;y<pBitmapInfo->bmiHeader.biHeight;y++){
				if(y%2==0) rgb=GetSysColor(COLOR_3DFACE);
				else rgb=RGB(255,255,255);
				for(x=0;x<pBitmapInfo->bmiHeader.biWidth;x++){
					i4=y*i2+x*3;
					rgb=RGB(pByte[i4+2],pByte[i4+1],pByte[i4]);
					if(rgb==RGB(0,0,0)){
						rgb=GetSysColor(COLOR_BTNTEXT);
						pByte2[i4+2]=LOBYTE(LOWORD(rgb));
						pByte2[i4+1]=HIBYTE(LOWORD(rgb));
						pByte2[i4]=LOBYTE(HIWORD(rgb));
					}
					else if(rgb==RGB(255,255,255)){
						rgb=GetSysColor(COLOR_3DFACE);
						pByte2[i4+2]=LOBYTE(LOWORD(rgb));
						pByte2[i4+1]=HIBYTE(LOWORD(rgb));
						pByte2[i4]=LOBYTE(HIWORD(rgb));
					}
				}
			}
			SetStretchBltMode(hdc,COLORONCOLOR);
			StretchDIBits(hdc,
				pos.x+(int)((double)size.cx*0.17), pos.y+(int)((double)size.cy*0.17),
				(int)((double)size.cx*0.65)+1, (int)((double)size.cy*0.65)+1,
				0,0,
				pBitmapInfo->bmiHeader.biWidth,pBitmapInfo->bmiHeader.biHeight,
				pByte2,
				pBitmapInfo,
				DIB_RGB_COLORS,SRCCOPY);
			GlobalFree(pByte2);

			if(pWindowInfo->style&WS_MAXIMIZEBOX||pWindowInfo->style&WS_MINIMIZEBOX){
				//ő剻{^
				size.cx=GetSystemMetrics(SM_CXSIZE)-2;
				size.cy=GetSystemMetrics(SM_CYSIZE)-4;
				pos.x=InsideRect.right-size.cx*2-4;
				pos.y=InsideRect.top+2;
				DrawButtonEdge(WndNum,&pos,&size);
				if(!(pWindowInfo->style&WS_MAXIMIZEBOX)){
					pos.x++;
					pos.y++;
					hPen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_3DHIGHLIGHT));
					hOldPen=(HPEN)SelectObject(hdc,hPen);
					hOldBrush=(HBRUSH)SelectObject(hdc,GetStockObject(NULL_BRUSH));
					Rectangle(hdc,pos.x,pos.y,pos.x+size.cx-2,pos.y+size.cy-1);
					MoveToEx(hdc,pos.x,pos.y+1,NULL);
					LineTo(hdc,pos.x+size.cx-2,pos.y+1);
					SelectObject(hdc,hOldPen);
					SelectObject(hdc,hOldBrush);
					DeleteObject(hPen);
					pos.x--;
					pos.y--;
					rgb=GetSysColor(COLOR_GRAYTEXT);
				}
				else rgb=GetSysColor(COLOR_BTNTEXT);
				hPen=CreatePen(PS_SOLID,0,rgb);
				hOldPen=(HPEN)SelectObject(hdc,hPen);
				hOldBrush=(HBRUSH)SelectObject(hdc,GetStockObject(NULL_BRUSH));
				Rectangle(hdc,pos.x,pos.y,pos.x+size.cx-2,pos.y+size.cy-1);
				MoveToEx(hdc,pos.x,pos.y+1,NULL);
				LineTo(hdc,pos.x+size.cx-2,pos.y+1);
				SelectObject(hdc,hOldPen);
				SelectObject(hdc,hOldBrush);
				DeleteObject(hPen);

				//ŏ{^
				size.cx=GetSystemMetrics(SM_CXSIZE)-2;
				size.cy=GetSystemMetrics(SM_CYSIZE)-4;
				pos.x=InsideRect.right-size.cx*3-4;
				pos.y=InsideRect.top+2;
				DrawButtonEdge(WndNum,&pos,&size);
				if(!(pWindowInfo->style&WS_MINIMIZEBOX)){
					pos.x++;
					pos.y++;
					hPen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_3DHIGHLIGHT));
					hOldPen=(HPEN)SelectObject(hdc,hPen);
					MoveToEx(hdc,pos.x+1,pos.y+size.cy-2,NULL);
					LineTo(hdc,pos.x+size.cy-3,pos.y+size.cy-2);
					MoveToEx(hdc,pos.x+1,pos.y+size.cy-3,NULL);
					LineTo(hdc,pos.x+size.cy-3,pos.y+size.cy-3);
					SelectObject(hdc,hOldPen);
					DeleteObject(hPen);
					pos.x--;
					pos.y--;
					rgb=GetSysColor(COLOR_GRAYTEXT);
				}
				else rgb=GetSysColor(COLOR_BTNTEXT);
				hPen=CreatePen(PS_SOLID,0,rgb);
				hOldPen=(HPEN)SelectObject(hdc,hPen);
				MoveToEx(hdc,pos.x+1,pos.y+size.cy-2,NULL);
				LineTo(hdc,pos.x+size.cy-3,pos.y+size.cy-2);
				MoveToEx(hdc,pos.x+1,pos.y+size.cy-3,NULL);
				LineTo(hdc,pos.x+size.cy-3,pos.y+size.cy-3);
				SelectObject(hdc,hOldPen);
				DeleteObject(hPen);
			}
		}

		InsideRect.top+=i3;
	}

	if(pWindowInfo->MenuID){
		//j[C3DFACEŕ`
		rgb=GetSysColor(COLOR_3DFACE);
		i=GetSystemMetrics(SM_CYMENU);
		hPen=CreatePen(PS_SOLID,0,rgb);
		hBrush=CreateSolidBrush(rgb);
		hOldPen=(HPEN)SelectObject(hdc,hPen);
		hOldBrush=(HBRUSH)SelectObject(hdc,hBrush);
		Rectangle(hdc,
			InsideRect.left,InsideRect.top-1,InsideRect.right,InsideRect.top+i);
		SelectObject(hdc,hOldPen);
		SelectObject(hdc,hOldBrush);
		DeleteObject(hPen);
		DeleteObject(hBrush);

		InsideRect.top+=i;
	}

	//NCAg|WVݒ
	MdiInfo[WndNum].MdiRadInfo->ClientPos.x=InsideRect.left;
	MdiInfo[WndNum].MdiRadInfo->ClientPos.y=InsideRect.top;

	//ExStyleɂ鉏`
	pos.x=0;
	pos.y=0;
	size.cx=InsideRect.right-InsideRect.left;
	size.cy=InsideRect.bottom-InsideRect.top;
	DrawItemEdgeByExStyle(WndNum,pWindowInfo->ExStyle,&pos,&size);

	//XN[o[`
	DrawWindowScrollBar(WndNum,pWindowInfo->style,&pos,&size);

	//NCAg̈̃TCYݒ
	MdiInfo[WndNum].MdiRadInfo->ClientSize=size;


	//////////////
	//wi`
	if(pWindowInfo->bgColor==COLOR_3DFACE){
		//3DFACE
		hPen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_3DFACE));
		hBrush=CreateSolidBrush(GetSysColor(COLOR_3DFACE));
		hOldPen=(HPEN)SelectObject(hdc,hPen);
		hOldBrush=(HBRUSH)SelectObject(hdc,hBrush);
		Rectangle(hdc,InsideRect.left,InsideRect.top,InsideRect.right,InsideRect.bottom);
		SelectObject(hdc,hOldPen);
		SelectObject(hdc,hOldBrush);
		DeleteObject(hPen);
		DeleteObject(hBrush);
	}
	else if(pWindowInfo->bgColor<=0){
		//Fw
		hPen=CreatePen(PS_SOLID,0,-pWindowInfo->bgColor);
		hBrush=CreateSolidBrush(-pWindowInfo->bgColor);
		hOldPen=(HPEN)SelectObject(hdc,hPen);
		hOldBrush=(HBRUSH)SelectObject(hdc,hBrush);
		Rectangle(hdc,InsideRect.left,InsideRect.top,InsideRect.right,InsideRect.bottom);
		SelectObject(hdc,hOldPen);
		SelectObject(hdc,hOldBrush);
		DeleteObject(hPen);
		DeleteObject(hBrush);
	}
	else if(pWindowInfo->bgColor>=0x1000){
		//rbg}bv
		for(i2=0;i2<ProjectInfo.res.NumberOfBitmapRes;i2++){
			if(lstrcmp(ProjectInfo.res.pBitmapResInfo[pWindowInfo->bgColor-0x1000].IdName,
				ProjectInfo.res.pBitmapResInfo[i2].IdName)==0) break;
		}
		if(i2!=ProjectInfo.res.NumberOfBitmapRes){
			lstrcpy(temporary,ProjectInfo.res.pBitmapResInfo[i2].path);
			GetFullPath(temporary,ProjectInfo.dir);
			hImage=LoadImage(NULL,temporary,IMAGE_BITMAP,0,0,LR_DEFAULTSIZE|LR_LOADFROMFILE);

			hBrush=CreatePatternBrush((HBITMAP)hImage);
			hOldBrush=(HBRUSH)SelectObject(hdc,hBrush);
			SetBrushOrgEx(hdc,InsideRect.left,InsideRect.top,&pos);
			PatBlt(hdc,
				InsideRect.left, InsideRect.top,
				InsideRect.right-InsideRect.left, InsideRect.bottom-InsideRect.top,PATCOPY);
			SetBrushOrgEx(hdc,pos.x,pos.y,0);
			SelectObject(hdc,hOldBrush);
			DeleteObject(hBrush);
			DeleteObject(hImage);
		}
	}


	////////////////////////////////////////////
	//qEBhEi_CAOACej`
	hFont=CreateFontIndirect(&pWindowInfo->LogFont);
	for(i=0;i<pWindowInfo->NumberOfChildWindows;i++){
		pos=pWindowInfo->pChildInfo[i].pos;
		size=pWindowInfo->pChildInfo[i].size;

		//ExStyleɂ鉏`
		DrawItemEdgeByExStyle(WndNum,pWindowInfo->pChildInfo[i].ExStyle,&pos,&size);

		if(pWindowInfo->pChildInfo[i].Control==CT_BUTTON){
			////////////////////////
			// Button Rg[

			if((pWindowInfo->pChildInfo[i].style&0x0000000F)==BS_DEFPUSHBUTTON){
				//W̃{^̏ꍇig`j
				DrawRectangleInClient(WndNum,
					pos.x, pos.y,
					pos.x+size.cx, pos.y+size.cy,
					RGB(0,0,0),0,0);
				pos.x++;
				pos.y++;
				size.cx-=2;
				size.cy-=2;
			}

			//{^̉`
			DrawButtonEdge(WndNum,&pos,&size);

			if(!(pWindowInfo->pChildInfo[i].style&(BS_ICON|BS_BITMAP))){
				//LvV eLXg

				rect.left=pos.x+1+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
				rect.top=pos.y+1+MdiInfo[WndNum].MdiRadInfo->ClientPos.y;
				rect.right=pos.x+size.cx-2+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
				rect.bottom=pos.y+size.cy-2+MdiInfo[WndNum].MdiRadInfo->ClientPos.y;

				if(pWindowInfo->pChildInfo[i].style&BS_MULTILINE) i4=0;
				else i4=DT_SINGLELINE;

				//rbglBS_CENTERŏɔr
				if((pWindowInfo->pChildInfo[i].style&BS_CENTER)==BS_CENTER) i2=DT_CENTER;
				else if(pWindowInfo->pChildInfo[i].style&BS_LEFT) i2=DT_LEFT;
				else if(pWindowInfo->pChildInfo[i].style&BS_RIGHT) i2=DT_RIGHT;
				else i2=DT_CENTER;

				//rbglBS_VCENTERŏɔr
				if((pWindowInfo->pChildInfo[i].style&BS_VCENTER)==BS_VCENTER) i3=DT_VCENTER;
				else if(pWindowInfo->pChildInfo[i].style&BS_TOP) i3=DT_TOP;
				else if(pWindowInfo->pChildInfo[i].style&BS_BOTTOM) i3=DT_BOTTOM;
				else i3=DT_VCENTER;

				hOldFont=(HFONT)SelectObject(hdc,hFont);
				if(pWindowInfo->pChildInfo[i].style&WS_DISABLED){
					SetTextColor(hdc,RGB(255,255,255));
					rc2.left=rect.left+1;
					rc2.top=rect.top+1;
					rc2.right=rect.right+1;
					rc2.bottom=rect.bottom+1;
					DrawText(hdc,pWindowInfo->pChildInfo[i].caption,-1,&rc2,i4|i2|i3);
					SetTextColor(hdc,GetSysColor(COLOR_GRAYTEXT));
				}
				else SetTextColor(hdc,GetSysColor(COLOR_BTNTEXT));

				DrawText(hdc,pWindowInfo->pChildInfo[i].caption,-1,&rect,i4|i2|i3);
				SelectObject(hdc,hOldFont);
			}
		}
		else if(pWindowInfo->pChildInfo[i].Control==CT_CHECKBOX){
			//////////////////////////
			// CheckBox Rg[

			if(pWindowInfo->pChildInfo[i].style&BS_PUSHLIKE){
				//{^̉`
				DrawButtonEdge(WndNum,&pos,&size);
			}
			else{
				//`FbN{bNX`
				size2.cx=13;
				size2.cy=13;
				if(pWindowInfo->pChildInfo[i].style&BS_LEFTTEXT)
					pos2.x=pos.x+size.cx-size2.cx;
				else pos2.x=pos.x;
				if((pWindowInfo->pChildInfo[i].style&BS_VCENTER)==BS_VCENTER||
					(pWindowInfo->pChildInfo[i].style&BS_VCENTER)==0)
					pos2.y=pos.y+(size.cy/2)-(size2.cy/2);
				else if(pWindowInfo->pChildInfo[i].style&BS_TOP)
					pos2.y=pos.y+1;
				else if(pWindowInfo->pChildInfo[i].style&BS_BOTTOM)
					pos2.y=pos.y+size.cy-size2.cy-1;
				DrawItemEdgeByExStyle(WndNum,WS_EX_CLIENTEDGE,&pos2,&size2);

				if(pWindowInfo->pChildInfo[i].style&WS_DISABLED)
					rgb=GetSysColor(COLOR_3DFACE);
				else rgb=GetSysColor(COLOR_WINDOW);
				DrawRectangleInClient(WndNum,pos2.x, pos2.y,
					pos2.x+size2.cx, pos2.y+size2.cy,
					rgb,rgb,1);
				if(!(pWindowInfo->pChildInfo[i].style&BS_LEFTTEXT)) pos.x+=17;
				else pos.x++;
				size.cx-=17;
			}

			if(!(pWindowInfo->pChildInfo[i].style&(BS_ICON|BS_BITMAP))){
				//LvV eLXg
				rect.left=pos.x+1+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
				rect.top=pos.y+1+MdiInfo[WndNum].MdiRadInfo->ClientPos.y;
				rect.right=pos.x+size.cx-2+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
				rect.bottom=pos.y+size.cy-2+MdiInfo[WndNum].MdiRadInfo->ClientPos.y;

				if(pWindowInfo->pChildInfo[i].style&BS_MULTILINE) i4=0;
				else i4=DT_SINGLELINE;

				//rbglBS_CENTERŏɔr
				if((pWindowInfo->pChildInfo[i].style&BS_CENTER)==BS_CENTER) i2=DT_CENTER;
				else if(pWindowInfo->pChildInfo[i].style&BS_LEFT) i2=DT_LEFT;
				else if(pWindowInfo->pChildInfo[i].style&BS_RIGHT) i2=DT_RIGHT;
				else i2=DT_LEFT;

				//rbglBS_VCENTERŏɔr
				if((pWindowInfo->pChildInfo[i].style&BS_VCENTER)==BS_VCENTER) i3=DT_VCENTER;
				else if(pWindowInfo->pChildInfo[i].style&BS_TOP) i3=DT_TOP;
				else if(pWindowInfo->pChildInfo[i].style&BS_BOTTOM) i3=DT_BOTTOM;
				else i3=DT_VCENTER;

				hOldFont=(HFONT)SelectObject(hdc,hFont);
				if(pWindowInfo->pChildInfo[i].style&WS_DISABLED){
					SetTextColor(hdc,RGB(255,255,255));
					rc2.left=rect.left+1;
					rc2.top=rect.top+1;
					rc2.right=rect.right+1;
					rc2.bottom=rect.bottom+1;
					DrawText(hdc,pWindowInfo->pChildInfo[i].caption,-1,&rc2,i4|i2|i3);
					SetTextColor(hdc,GetSysColor(COLOR_GRAYTEXT));
				}
				else SetTextColor(hdc,GetSysColor(COLOR_BTNTEXT));

				DrawText(hdc,pWindowInfo->pChildInfo[i].caption,-1,&rect,i4|i2|i3);
				SelectObject(hdc,hOldFont);
			}
		}
		else if(pWindowInfo->pChildInfo[i].Control==CT_COMBOBOX){
			//////////////////////////
			// ComboBox Rg[

			pos2=pos;
			size2.cx=size.cx;
			size2.cy=20;
			DrawItemEdgeByExStyle(WndNum,WS_EX_CLIENTEDGE,&pos2,&size2);

			//
			if(pWindowInfo->pChildInfo[i].style&WS_DISABLED)
				rgb=GetSysColor(COLOR_3DFACE);
			else rgb=GetSysColor(COLOR_WINDOW);
			DrawRectangleInClient(WndNum,
				pos2.x,pos2.y,
				pos2.x+size2.cx,pos2.y+size2.cy,
				rgb,rgb,1);

			if((pWindowInfo->pChildInfo[i].style&0x000F)==CBS_SIMPLE){
				pos.y+=20;
				size.cy-=20;
				DrawItemEdgeByExStyle(WndNum,WS_EX_CLIENTEDGE,&pos,&size);

				//
				rgb=GetSysColor(COLOR_WINDOW);
				DrawRectangleInClient(WndNum,
					pos.x,pos.y,
					pos.x+size.cx,pos.y+size.cy,
					rgb,rgb,1);
			}
			else{
				//{^
				pos2.x+=size2.cx-16;
				size2.cx=16;
				size2.cy=16;
				DrawItemEdgeByExStyle(WndNum,WS_EX_DLGMODALFRAME,&pos2,&size2);

				//
				DrawRectangleInClient(WndNum,
					pos2.x,pos2.y,
					pos2.x+size2.cx,pos2.y+size2.cy,
					GetSysColor(COLOR_3DFACE),GetSysColor(COLOR_3DFACE),1);

				pos2.x--;
				if(pWindowInfo->pChildInfo[i].style&WS_DISABLED){
					hPen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_3DHIGHLIGHT));
					hOldPen=(HPEN)SelectObject(hdc,hPen);
					pos2.x++;
					pos2.y++;
					i3=pos2.x+(size2.cx/2);
					for(i2=3;i2>=0;i2--,i3--){
						DrawLineInClient(WndNum,i3,i2+pos2.y+3,i3+((3-i2)*2)+1,i2+pos2.y+3);
					}
					SelectObject(hdc,hOldPen);
					DeleteObject(hPen);
					rgb=GetSysColor(COLOR_GRAYTEXT);
					pos2.x--;
					pos2.y--;
				}
				else rgb=GetSysColor(COLOR_BTNTEXT);
				hPen=CreatePen(PS_SOLID,0,rgb);
				hOldPen=(HPEN)SelectObject(hdc,hPen);
				i3=pos2.x+(size2.cx/2);
				for(i2=3;i2>=0;i2--,i3--){
					DrawLineInClient(WndNum,i3,i2+pos2.y+3,i3+((3-i2)*2)+1,i2+pos2.y+3);
				}
				SelectObject(hdc,hOldPen);
				DeleteObject(hPen);
			}
		}
		else if(pWindowInfo->pChildInfo[i].Control==CT_EDIT){
			//////////////////////
			// Edit Rg[

			//
			if(pWindowInfo->pChildInfo[i].style&WS_DISABLED||pWindowInfo->pChildInfo[i].style&ES_READONLY)
				rgb=GetSysColor(COLOR_3DFACE);
			else rgb=GetSysColor(COLOR_WINDOW);
			DrawRectangleInClient(WndNum,
				pos.x,pos.y,
				pos.x+size.cx,pos.y+size.cy,
				rgb,rgb,1);

			//LvV eLXg
			rect.left=pos.x+1+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
			rect.top=pos.y+1+MdiInfo[WndNum].MdiRadInfo->ClientPos.y;
			rect.right=pos.x+size.cx-1+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
			rect.bottom=pos.y+size.cy-1+MdiInfo[WndNum].MdiRadInfo->ClientPos.y;

			if(pWindowInfo->pChildInfo[i].style&ES_MULTILINE) i4=0;
			else i4=DT_SINGLELINE;

			//rbglES_LEFTŌɌ
			if(pWindowInfo->pChildInfo[i].style&ES_CENTER) i2=DT_CENTER;
			else if(pWindowInfo->pChildInfo[i].style&ES_RIGHT) i2=DT_RIGHT;
			else i2=DT_LEFT;

			//Fݒ
			if(pWindowInfo->pChildInfo[i].style&WS_DISABLED)
				SetTextColor(hdc,GetSysColor(COLOR_GRAYTEXT));
			else
				SetTextColor(hdc,GetSysColor(COLOR_WINDOWTEXT));

			hOldFont=(HFONT)SelectObject(hdc,hFont);
			DrawText(hdc,pWindowInfo->pChildInfo[i].caption,-1,&rect,i4|i2);
			SelectObject(hdc,hOldFont);
		}

		else if(pWindowInfo->pChildInfo[i].Control==CT_GROUPBOX){
			///////////////////////////////////
			// O[v {bNX Rg[

			hOldFont=(HFONT)SelectObject(hdc,hFont);
			GetTextExtentPoint32(hdc,pWindowInfo->pChildInfo[i].caption,lstrlen(pWindowInfo->pChildInfo[i].caption),&size2);

			//g`
			rect.left=pos.x+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
			rect.top=pos.y+MdiInfo[WndNum].MdiRadInfo->ClientPos.y+(size2.cy/2);
			rect.right=pos.x+size.cx+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
			rect.bottom=pos.y+size.cy+MdiInfo[WndNum].MdiRadInfo->ClientPos.y;
			DrawEdge(hdc,&rect,EDGE_ETCHED,BF_RECT);

			//rbglBS_CENTERŏɌ
			if((pWindowInfo->pChildInfo[i].style&BS_CENTER)==BS_CENTER){
				rect.left=pos.x+(size.cx/2)-(size2.cx/2)-3;
				rect.right=rect.left+size2.cx+4;
			}
			else if(pWindowInfo->pChildInfo[i].style&BS_RIGHT){
				rect.right=pos.x+size.cx-7;
				rect.left=rect.right-size2.cx-4;
			}
			else{
				rect.left=pos.x+7;
				rect.right=rect.left+size2.cx+4;
			}
			rect.top=pos.y;
			rect.bottom=pos.y+size2.cy;

			if(pWindowInfo->bgColor==COLOR_3DFACE) rgb=GetSysColor(COLOR_3DFACE);
			else rgb=-pWindowInfo->bgColor;
			DrawRectangleInClient(WndNum,rect.left,rect.top,rect.right,rect.bottom,rgb,rgb,1);

			if(!((pWindowInfo->pChildInfo[i].style&BS_ICON)||(pWindowInfo->pChildInfo[i].style&BS_BITMAP))){
				rect.left+=MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
				rect.top+=MdiInfo[WndNum].MdiRadInfo->ClientPos.y;
				rect.right+=MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
				rect.bottom+=MdiInfo[WndNum].MdiRadInfo->ClientPos.y;
				rect.left+=2;
				rect.right-=2;

				//eLXg`
				if(pWindowInfo->pChildInfo[i].style&WS_DISABLED){
					SetTextColor(hdc,RGB(255,255,255));
					rc2.left=rect.left+1;
					rc2.top=rect.top+1;
					rc2.right=rect.right+1;
					rc2.bottom=rect.bottom+1;
					DrawText(hdc,pWindowInfo->pChildInfo[i].caption,-1,&rc2,DT_SINGLELINE);
					SetTextColor(hdc,GetSysColor(COLOR_GRAYTEXT));
				}
				else
					SetTextColor(hdc,GetSysColor(COLOR_BTNTEXT));

				DrawText(hdc,pWindowInfo->pChildInfo[i].caption,-1,&rect,DT_SINGLELINE);
			}
			SelectObject(hdc,hOldFont);
		}

		else if(pWindowInfo->pChildInfo[i].Control==CT_HSCROLLBAR){
			////////////////////////////////////
			// XN[o[ Rg[
			DrawScrollBar(WndNum,pWindowInfo->pChildInfo[i].style,0,&pos,&size);
		}

		else if(pWindowInfo->pChildInfo[i].Control==CT_IMAGEBOX){
			/////////////////////
			// C[W {bNX
			HDC memdc;

			if((pWindowInfo->pChildInfo[i].style&0x0000000F)==SS_BLACKFRAME)
				DrawRectangleInClient(WndNum,pos.x,pos.y,pos.x+size.cx,pos.y+size.cy,RGB(0,0,0),0,0);
			else if((pWindowInfo->pChildInfo[i].style&0x0000000F)==SS_GRAYFRAME)
				DrawRectangleInClient(WndNum,pos.x,pos.y,pos.x+size.cx,pos.y+size.cy,GetSysColor(COLOR_3DSHADOW),0,0);
			else if((pWindowInfo->pChildInfo[i].style&0x0000000F)==SS_WHITEFRAME)
				DrawRectangleInClient(WndNum,pos.x,pos.y,pos.x+size.cx,pos.y+size.cy,RGB(255,255,255),0,0);
			else if((pWindowInfo->pChildInfo[i].style&0x0000001F)==SS_ETCHEDFRAME){
				rect.left=pos.x+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
				rect.top=pos.y+MdiInfo[WndNum].MdiRadInfo->ClientPos.y;
				rect.right=pos.x+size.cx+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
				rect.bottom=pos.y+size.cy+MdiInfo[WndNum].MdiRadInfo->ClientPos.y;
				DrawEdge(hdc,&rect,EDGE_ETCHED,BF_RECT);
			}
			else if((pWindowInfo->pChildInfo[i].style&0x0000000F)==SS_BLACKRECT)
				DrawRectangleInClient(WndNum,pos.x,pos.y,pos.x+size.cx,pos.y+size.cy,GetSysColor(COLOR_3DDKSHADOW),GetSysColor(COLOR_3DDKSHADOW),1);
			else if((pWindowInfo->pChildInfo[i].style&0x0000000F)==SS_GRAYRECT)
				DrawRectangleInClient(WndNum,pos.x,pos.y,pos.x+size.cx,pos.y+size.cy,GetSysColor(COLOR_3DSHADOW),GetSysColor(COLOR_3DSHADOW),1);
			else if((pWindowInfo->pChildInfo[i].style&0x0000000F)==SS_WHITERECT)
				DrawRectangleInClient(WndNum,pos.x,pos.y,pos.x+size.cx,pos.y+size.cy,RGB(255,255,255),RGB(255,255,255),1);
			else if((pWindowInfo->pChildInfo[i].style&0x0000000F)==SS_ICON){
				if(pWindowInfo->pChildInfo[i].ImageCtrlInfo.type==IMGTYPE_FILE)
					lstrcpy(temporary,pWindowInfo->pChildInfo[i].ImageCtrlInfo.path);
				else{
					for(i2=0;i2<ProjectInfo.res.NumberOfIconRes;i2++){
						if(lstrcmp(pWindowInfo->pChildInfo[i].ImageCtrlInfo.path,
							ProjectInfo.res.pIconResInfo[i2].IdName)==0) break;
					}
					if(i2==ProjectInfo.res.NumberOfIconRes) goto NonIconImage;

					lstrcpy(temporary,ProjectInfo.res.pIconResInfo[i2].path);
				}
				GetFullPath(temporary,ProjectInfo.dir);
				hImage=LoadImage(NULL,temporary,IMAGE_ICON,0,0,LR_DEFAULTSIZE|LR_LOADFROMFILE);
				if(hImage){
					pWindowInfo->pChildInfo[i].size.cx=32+(pWindowInfo->pChildInfo[i].size.cx-size.cx);
					pWindowInfo->pChildInfo[i].size.cy=32+(pWindowInfo->pChildInfo[i].size.cy-size.cy);
					pos=pWindowInfo->pChildInfo[i].pos;
					size=pWindowInfo->pChildInfo[i].size;

					//ExStyleɂ鉏ĕ`
					DrawItemEdgeByExStyle(WndNum,pWindowInfo->pChildInfo[i].ExStyle,&pos,&size);

					DrawIcon(hdc,
						pos.x+MdiInfo[WndNum].MdiRadInfo->ClientPos.x,
						pos.y+MdiInfo[WndNum].MdiRadInfo->ClientPos.y,
						(HICON)hImage);
					DestroyIcon((HICON)hImage);
				}
				else{
NonIconImage:
					DrawRectangleInClient(WndNum,pos.x,pos.y,pos.x+size.cx,pos.y+size.cy,RGB(0,0,0),0,0);
					hOldFont=(HFONT)SelectObject(hdc,hFont);
					rect.left=pos.x+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
					rect.top=pos.y+MdiInfo[WndNum].MdiRadInfo->ClientPos.y;
					rect.right=pos.x+size.cx+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
					rect.bottom=pos.y+size.cy+MdiInfo[WndNum].MdiRadInfo->ClientPos.y;
					SetTextColor(hdc,GetSysColor(COLOR_WINDOWTEXT));
					DrawText(hdc,"icon...",-1,&rect,DT_SINGLELINE|DT_CENTER|DT_VCENTER);
					SelectObject(hdc,hOldFont);
				}
			}
			else if((pWindowInfo->pChildInfo[i].style&0x0000000F)==SS_BITMAP){
				BITMAP Bitmap;

				if(pWindowInfo->pChildInfo[i].ImageCtrlInfo.type==IMGTYPE_FILE)
					lstrcpy(temporary,pWindowInfo->pChildInfo[i].ImageCtrlInfo.path);
				else{
					for(i2=0;i2<ProjectInfo.res.NumberOfBitmapRes;i2++){
						if(lstrcmp(pWindowInfo->pChildInfo[i].ImageCtrlInfo.path,
							ProjectInfo.res.pBitmapResInfo[i2].IdName)==0) break;
					}
					if(i2==ProjectInfo.res.NumberOfBitmapRes) goto NonBitmapImage;

					lstrcpy(temporary,ProjectInfo.res.pBitmapResInfo[i2].path);
				}
				GetFullPath(temporary,ProjectInfo.dir);
				hImage=LoadImage(NULL,temporary,IMAGE_BITMAP,0,0,LR_DEFAULTSIZE|LR_LOADFROMFILE);
				if(hImage){
					GetObject(hImage,sizeof(BITMAP),&Bitmap);

					pWindowInfo->pChildInfo[i].size.cx=Bitmap.bmWidth+(pWindowInfo->pChildInfo[i].size.cx-size.cx);
					pWindowInfo->pChildInfo[i].size.cy=Bitmap.bmHeight+(pWindowInfo->pChildInfo[i].size.cy-size.cy);
					pos=pWindowInfo->pChildInfo[i].pos;
					size=pWindowInfo->pChildInfo[i].size;

					//ExStyleɂ鉏ĕ`
					DrawItemEdgeByExStyle(WndNum,pWindowInfo->pChildInfo[i].ExStyle,&pos,&size);

					memdc=CreateCompatibleDC(hdc);
					SelectObject(memdc,hImage);
					BitBlt(hdc,
						pos.x+MdiInfo[WndNum].MdiRadInfo->ClientPos.x,
						pos.y+MdiInfo[WndNum].MdiRadInfo->ClientPos.y,
						size.cx, size.cy,
						memdc, 0,0,
						SRCCOPY);
					DeleteDC(memdc);
					DeleteObject(hImage);
				}
				else{
NonBitmapImage:
					DrawRectangleInClient(WndNum,pos.x,pos.y,pos.x+size.cx,pos.y+size.cy,RGB(0,0,0),0,0);
					hOldFont=(HFONT)SelectObject(hdc,hFont);
					rect.left=pos.x+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
					rect.top=pos.y+MdiInfo[WndNum].MdiRadInfo->ClientPos.y;
					rect.right=pos.x+size.cx+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
					rect.bottom=pos.y+size.cy+MdiInfo[WndNum].MdiRadInfo->ClientPos.y;
					SetTextColor(hdc,GetSysColor(COLOR_WINDOWTEXT));
					DrawText(hdc,"bmp...",-1,&rect,DT_SINGLELINE|DT_CENTER|DT_VCENTER);
					SelectObject(hdc,hOldFont);
				}
			}
		}

		else if(pWindowInfo->pChildInfo[i].Control==CT_LISTBOX){
			/////////////////////////
			// ListBox Rg[

			//
			if(pWindowInfo->pChildInfo[i].style&WS_DISABLED)
				rgb=GetSysColor(COLOR_3DFACE);
			else rgb=GetSysColor(COLOR_WINDOW);
			DrawRectangleInClient(WndNum,
				pos.x,pos.y,
				pos.x+size.cx,pos.y+size.cy,
				rgb,rgb,1);

			if(pWindowInfo->pChildInfo[i].style&LBS_DISABLENOSCROLL)
				DrawWindowScrollBar(WndNum,pWindowInfo->pChildInfo[i].style|WS_DISABLED,&pos,&size);
		}

		else if(pWindowInfo->pChildInfo[i].Control==CT_LISTVIEW){
			//////////////////////////
			// ListView Rg[

			//
			if(pWindowInfo->pChildInfo[i].style&WS_DISABLED)
				rgb=GetSysColor(COLOR_3DFACE);
			else rgb=GetSysColor(COLOR_WINDOW);
			DrawRectangleInClient(WndNum,
				pos.x,pos.y,
				pos.x+size.cx,pos.y+size.cy,
				rgb,rgb,1);

			if((pWindowInfo->pChildInfo[i].style&LVS_REPORT)&&
				(!((pWindowInfo->pChildInfo[i].style&LVS_LIST)==LVS_LIST))){
				//|[g r[
				size.cy=16;
				DrawButtonEdge(WndNum,&pos,&size);
			}
		}

		else if(pWindowInfo->pChildInfo[i].Control==CT_PROGRESSBAR){
			/////////////////////////////
			// ProgressBar Rg[

			//
			pos.x++;
			pos.y++;
			size.cx-=2;
			size.cy-=2;
			rgb=GetSysColor(COLOR_ACTIVECAPTION);
			if(pWindowInfo->pChildInfo[i].style&PBS_SMOOTH){
				if(pWindowInfo->pChildInfo[i].style&PBS_VERTICAL){
					pos.y+=(long)((double)size.cy*0.3);
					DrawRectangleInClient(WndNum,
						pos.x,pos.y,
						pos.x+size.cx,pos.y+(long)((double)size.cy*0.7),
						rgb,rgb,1);
				}
				else{
					DrawRectangleInClient(WndNum,
						pos.x,pos.y,
						pos.x+(long)((double)size.cx*0.7),pos.y+size.cy,
						rgb,rgb,1);
				}
			}
			else{
				if(pWindowInfo->pChildInfo[i].style&PBS_VERTICAL){
					pos.y+=(long)((double)size.cy*0.3);
					i3=(size.cx*2)/3;
					i2=(int)((double)size.cy*0.7);
					for(;i2>i3;i2-=i3+2){
						DrawRectangleInClient(WndNum,
							pos.x,pos.y+i2-i3,
							pos.x+size.cx,pos.y+i2,
							rgb,rgb,1);
					}
				}
				else{
					i3=(size.cy*2)/3;
					i4=(int)((double)size.cx*0.7);
					for(i2=0;i2+i3<i4;i2+=i3+2){
						DrawRectangleInClient(WndNum,
							pos.x+i2,pos.y,
							pos.x+i2+i3,pos.y+size.cy,
							rgb,rgb,1);
					}
				}
			}
		}

		else if(pWindowInfo->pChildInfo[i].Control==CT_RADIOBUTTON){
			/////////////////////////////
			// RadioButton Rg[

			if(pWindowInfo->pChildInfo[i].style&BS_PUSHLIKE){
				//{^̉`
				DrawButtonEdge(WndNum,&pos,&size);
			}
			else{
				//WI{^`
				size2.cx=12;
				size2.cy=12;
				if(pWindowInfo->pChildInfo[i].style&BS_LEFTTEXT)
					pos2.x=pos.x+size.cx-size2.cx;
				else pos2.x=pos.x+1;
				if((pWindowInfo->pChildInfo[i].style&BS_VCENTER)==BS_VCENTER||
					(pWindowInfo->pChildInfo[i].style&BS_VCENTER)==0)
					pos2.y=pos.y+(size.cy/2)-(size2.cy/2);
				else if(pWindowInfo->pChildInfo[i].style&BS_TOP)
					pos2.y=pos.y+1;
				else if(pWindowInfo->pChildInfo[i].style&BS_BOTTOM)
					pos2.y=pos.y+size.cy-size2.cy-1;

				hResource=LoadResource(hResInst,FindResource(hResInst,MAKEINTRESOURCE(IDB_RADIOBUTTON),RT_BITMAP));
				pBitmapInfo=(BITMAPINFO *)LockResource(hResource);
				pByte=(BYTE *)pBitmapInfo+pBitmapInfo->bmiHeader.biSize;
				pByte2=(BYTE *)GlobalAlloc(GMEM_FIXED,pBitmapInfo->bmiHeader.biWidth*pBitmapInfo->bmiHeader.biHeight*3);
				for(i2=0,i3=0;i2<pBitmapInfo->bmiHeader.biWidth*pBitmapInfo->bmiHeader.biHeight;i2++,i3+=3){
					rgb=RGB(pByte[i3+2],pByte[i3+1],pByte[i3]);

					if(rgb==RGB(255,255,0)){
						if(pWindowInfo->bgColor==COLOR_3DFACE) rgb=GetSysColor(COLOR_3DFACE);
						else rgb=-pWindowInfo->bgColor;
					}

					//e
					else if(rgb==RGB(0,0,0)) rgb=GetSysColor(COLOR_3DSHADOW);
					else if(rgb==RGB(255,0,0)) rgb=GetSysColor(COLOR_3DDKSHADOW);

					//
					else if(rgb==RGB(0,0,255)) rgb=GetSysColor(COLOR_3DLIGHT);
					else if(rgb==RGB(0,255,0)) rgb=GetSysColor(COLOR_3DHIGHLIGHT);

					//
					else if(rgb==RGB(255,255,255)){
						if(pWindowInfo->pChildInfo[i].style&WS_DISABLED) rgb=GetSysColor(COLOR_3DFACE);
					}

					pByte2[i3+2]=LOBYTE(LOWORD(rgb));
					pByte2[i3+1]=HIBYTE(LOWORD(rgb));
					pByte2[i3]=LOBYTE(HIWORD(rgb));
				}
				SetDIBitsToDevice(hdc,
					pos2.x+MdiInfo[WndNum].MdiRadInfo->ClientPos.x,
					pos2.y+MdiInfo[WndNum].MdiRadInfo->ClientPos.y,
					pBitmapInfo->bmiHeader.biWidth, pBitmapInfo->bmiHeader.biHeight,
					0,0,
					0,pBitmapInfo->bmiHeader.biHeight,
					pByte2,
					pBitmapInfo,
					DIB_RGB_COLORS);
				GlobalFree(pByte2);

				if(!(pWindowInfo->pChildInfo[i].style&BS_LEFTTEXT)) pos.x+=17;
				else pos.x++;
				size.cx-=17;
			}

			if(!(pWindowInfo->pChildInfo[i].style&(BS_ICON|BS_BITMAP))){
				//LvV eLXg
				rect.left=pos.x+1+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
				rect.top=pos.y+1+MdiInfo[WndNum].MdiRadInfo->ClientPos.y;
				rect.right=pos.x+size.cx-2+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
				rect.bottom=pos.y+size.cy-2+MdiInfo[WndNum].MdiRadInfo->ClientPos.y;

				if(pWindowInfo->pChildInfo[i].style&BS_MULTILINE) i4=0;
				else i4=DT_SINGLELINE;

				//rbglBS_CENTERŏɔr
				if((pWindowInfo->pChildInfo[i].style&BS_CENTER)==BS_CENTER) i2=DT_CENTER;
				else if(pWindowInfo->pChildInfo[i].style&BS_LEFT) i2=DT_LEFT;
				else if(pWindowInfo->pChildInfo[i].style&BS_RIGHT) i2=DT_RIGHT;
				else i2=DT_LEFT;

				//rbglBS_VCENTERŏɔr
				if((pWindowInfo->pChildInfo[i].style&BS_VCENTER)==BS_VCENTER) i3=DT_VCENTER;
				else if(pWindowInfo->pChildInfo[i].style&BS_TOP) i3=DT_TOP;
				else if(pWindowInfo->pChildInfo[i].style&BS_BOTTOM) i3=DT_BOTTOM;
				else i3=DT_VCENTER;

				hOldFont=(HFONT)SelectObject(hdc,hFont);
				if(pWindowInfo->pChildInfo[i].style&WS_DISABLED){
					SetTextColor(hdc,RGB(255,255,255));
					rc2.left=rect.left+1;
					rc2.top=rect.top+1;
					rc2.right=rect.right+1;
					rc2.bottom=rect.bottom+1;
					DrawText(hdc,pWindowInfo->pChildInfo[i].caption,-1,&rc2,i4|i2|i3);
					SetTextColor(hdc,GetSysColor(COLOR_GRAYTEXT));
				}
				else SetTextColor(hdc,GetSysColor(COLOR_BTNTEXT));

				DrawText(hdc,pWindowInfo->pChildInfo[i].caption,-1,&rect,i4|i2|i3);
				SelectObject(hdc,hOldFont);
			}
		}

		else if(pWindowInfo->pChildInfo[i].Control==CT_STATIC){
			////////////////////////
			// Static Rg[

			//LvV eLXg
			rect.left=pos.x+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
			rect.top=pos.y+MdiInfo[WndNum].MdiRadInfo->ClientPos.y;
			rect.right=pos.x+size.cx+MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
			rect.bottom=pos.y+size.cy+MdiInfo[WndNum].MdiRadInfo->ClientPos.y;

			//rbglSS_LEFTŌɌ
			if(pWindowInfo->pChildInfo[i].style&SS_CENTER) i2=DT_CENTER;
			else if(pWindowInfo->pChildInfo[i].style&SS_RIGHT) i2=DT_RIGHT;
			else i2=DT_LEFT;

			hOldFont=(HFONT)SelectObject(hdc,hFont);
			if(pWindowInfo->pChildInfo[i].style&WS_DISABLED){
				SetTextColor(hdc,RGB(255,255,255));
				rc2.left=rect.left+1;
				rc2.top=rect.top+1;
				rc2.right=rect.right+1;
				rc2.bottom=rect.bottom+1;
				DrawText(hdc,pWindowInfo->pChildInfo[i].caption,-1,&rc2,i2);
				SetTextColor(hdc,GetSysColor(COLOR_GRAYTEXT));
			}
			else
				SetTextColor(hdc,GetSysColor(COLOR_BTNTEXT));

			//܂Ԃǂ
			if(!(pWindowInfo->pChildInfo[i].style&SS_LEFTNOWORDWRAP)){
				i2|=DT_WORDBREAK;
			}

			DrawText(hdc,pWindowInfo->pChildInfo[i].caption,-1,&rect,i2);
			SelectObject(hdc,hOldFont);
		}

		else if(pWindowInfo->pChildInfo[i].Control==CT_TRACKBAR){
			//////////////////////////
			// TrackBar Rg[

			if(pWindowInfo->pChildInfo[i].style&TBS_VERT){
				pos.x+=2;
				size.cx-=2;
				if(size.cx>21) size.cx=21;
				pos.y+=8;
				size.cy-=16;

				rect.left=MdiInfo[WndNum].MdiRadInfo->ClientPos.x+pos.x+(size.cx/2)-2;
				rect.right=MdiInfo[WndNum].MdiRadInfo->ClientPos.x+pos.x+(size.cx/2)+2;
				rect.top=MdiInfo[WndNum].MdiRadInfo->ClientPos.y+pos.y;
				rect.bottom=MdiInfo[WndNum].MdiRadInfo->ClientPos.y+pos.y+size.cy;
				DrawEdge(hdc,&rect,EDGE_SUNKEN,BF_RECT);

				size.cy=size.cx/2;
				DrawButtonEdge(WndNum,&pos,&size);
			}
			else{
				pos.x+=8;
				size.cx-=16;
				pos.y+=2;
				size.cy-=2;
				if(size.cy>21) size.cy=21;

				rect.left=MdiInfo[WndNum].MdiRadInfo->ClientPos.x+pos.x;
				rect.right=MdiInfo[WndNum].MdiRadInfo->ClientPos.x+pos.x+size.cx;
				rect.top=MdiInfo[WndNum].MdiRadInfo->ClientPos.y+pos.y+(size.cy/2)-2;
				rect.bottom=MdiInfo[WndNum].MdiRadInfo->ClientPos.y+pos.y+(size.cy/2)+2;
				DrawEdge(hdc,&rect,EDGE_SUNKEN,BF_RECT);

				size.cx=size.cy/2;
				DrawButtonEdge(WndNum,&pos,&size);
			}
		}

		else if(pWindowInfo->pChildInfo[i].Control==CT_TREEVIEW){
			//////////////////////////
			// TreeView Rg[

			//
			if(pWindowInfo->pChildInfo[i].style&WS_DISABLED)
				rgb=GetSysColor(COLOR_3DFACE);
			else rgb=GetSysColor(COLOR_WINDOW);
			DrawRectangleInClient(WndNum,
				pos.x,pos.y,
				pos.x+size.cx,pos.y+size.cy,
				rgb,rgb,1);
		}

		else if(pWindowInfo->pChildInfo[i].Control==CT_UPDOWN){
			///////////////////////////////
			// Abv _E Rg[
			if(pWindowInfo->pChildInfo[i].style&UDS_HORZ)
				DrawUpDownControl(WndNum,pWindowInfo->pChildInfo[i].style,0,&pos,&size);
			else DrawUpDownControl(WndNum,pWindowInfo->pChildInfo[i].style,1,&pos,&size);
		}

		else if(pWindowInfo->pChildInfo[i].Control==CT_VSCROLLBAR){
			////////////////////////////////////
			// XN[o[ Rg[
			DrawScrollBar(WndNum,pWindowInfo->pChildInfo[i].style,1,&pos,&size);
		}
	}
	DeleteObject(hFont);
}
void DrawRadWindow(int WndNum,WINDOW_INFO *pWindowInfo){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	HBRUSH hOldBrush;
	POINT pos;

	SetBkMode(MdiInfo[WndNum].MdiRadInfo->hMemDC,TRANSPARENT);

	hOldBrush=(HBRUSH)SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,GetStockObject(WHITE_BRUSH));
	PatBlt(MdiInfo[WndNum].MdiRadInfo->hMemDC,0,0,ScreenX*2,ScreenY*2,PATCOPY);
	SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,hOldBrush);

	pos.x=LEVER_THICK;
	pos.y=LEVER_THICK;
	DesigningWindow(WndNum,MdiInfo[WndNum].MdiRadInfo->hMemDC,&pos,pWindowInfo);

	InvalidateRect(MdiInfo[WndNum].MdiRadInfo->hRad,NULL,0);
}
