#include "stdafx.h"

#include "common.h"


char szBackupDirPath[MAX_PATH];

void CreateBackupDir(void){
	//obNAbvp̃tH_擾
	extern char szBackupDirPath[MAX_PATH];
	GUID guid;
	char *temp2;
	CoCreateGuid(&guid);
	UuidToString(&guid,(unsigned char **)&temp2);

	char temporary[MAX_PATH];
	GetTempPath(MAX_PATH,temporary);
	ShortPathToLongPath(temporary,szBackupDirPath);
	if(szBackupDirPath[lstrlen(szBackupDirPath)-1]!='\\') lstrcat(szBackupDirPath,"\\");

#ifdef THETEXT
	lstrcat(szBackupDirPath,"TheText_Temporary_");
#else
	lstrcat(szBackupDirPath,"abdev_temporary_");
#endif
	lstrcat(szBackupDirPath,temp2);
	RpcStringFree((unsigned char **)&temp2);

	CreateDirectory(szBackupDirPath,NULL);
	lstrcat(szBackupDirPath,"\\");
}


void backup(void *dummy){
	extern char szBackupDirPath[MAX_PATH];
	int i,iNum=0;
	char temporary[MAX_PATH];

	lstrcpy( temporary, szBackupDirPath );
	if( temporary[lstrlen(temporary)-1] == '\\' ) temporary[lstrlen(temporary)-1] = 0;
	if( !IsExistDirectory( temporary ) ){
		//obNAbvpꎞfBNg݂ȂƂ͍
		CreateDirectory( temporary, NULL );
	}

	char *temp2;
	temp2=(char *)malloc(8192);
	sprintf(temp2,"%x\r\n",hOwner);

	for(i=0;i<MAX_WNDNUM;i++){
		if(MdiInfo[i].hwnd){
			int WndNum;
			WndNum=i;

			if(!IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)) continue;

			//t@Cۑ
			sprintf(temporary,"%sdocument%02d.txt",szBackupDirPath,iNum);
			WriteBuffer(temporary,MdiInfo[WndNum].pMdiTextEdit->buffer,lstrlen(MdiInfo[WndNum].pMdiTextEdit->buffer), false);

			//ǉ
			sprintf(temp2+lstrlen(temp2),"%s\r\n",MdiInfo[WndNum].path);

			iNum++;
		}
	}

	//obNAbvwb_
	sprintf(temporary,"%sinfo.txt",szBackupDirPath);
	WriteBuffer_NonErrMsg(temporary,temp2,lstrlen(temp2));

	free(temp2);
}


void RestoreBeforeState(const char *dir_path,char *pHeaderBuffer){
	int i,i2;
	for(i=0;;i++){
		if(pHeaderBuffer[i]=='\0') break;
		if(pHeaderBuffer[i]=='\r'&&pHeaderBuffer[i+1]=='\n') break;
	}
	if(pHeaderBuffer[i]=='\0') return;
	i+=2;


	int iDocNum=0;
	char temporary[MAX_PATH];
	while(1){
		//̃t@CpX擾
		char szBeforeFilePath[MAX_PATH];
		for(i2=0;;i++,i2++){
			if(pHeaderBuffer[i]=='\r'&&pHeaderBuffer[i+1]=='\n'){
				szBeforeFilePath[i2]=0;
				break;
			}
			szBeforeFilePath[i2]=pHeaderBuffer[i];
			if(pHeaderBuffer[i]=='\0') break;
		}
		if(pHeaderBuffer[i]=='\0') break;

		sprintf(temporary,"%sdocument%02d.txt",dir_path,iDocNum);

		HWND hChild;
		hChild=NewTextEditWindow(temporary,WNDTYPE_TEXT);
		int WndNum;
		WndNum=GetWndNum(hChild);

		char szOldTitle[MAX_PATH];
		lstrcpy(szOldTitle,MdiInfo[WndNum].title);

		//hLg ZNg R{{bNX
		extern HWND hDocCombo;
		i2=SendMessage(hDocCombo,CB_FINDSTRINGEXACT,0,(long)MdiInfo[WndNum].title);
		SendMessage(hDocCombo,CB_DELETESTRING,i2,0);

		//pXύX
		GlobalFree(MdiInfo[WndNum].path);
		MdiInfo[WndNum].path=(char *)GlobalAlloc(GMEM_FIXED,lstrlen(szBeforeFilePath)+1);
		lstrcpy(MdiInfo[WndNum].path,szBeforeFilePath);

		//hLg ZNg R{{bNXɑ}
		char str[MAX_PATH],str2[MAX_PATH];
		if(szBeforeFilePath[0]){
			_splitpath(szBeforeFilePath,NULL,NULL,str,str2);
			lstrcat(str,str2);
		}
		else{
			extern int DocumentCounter;
			DocumentCounter++;
			sprintf(str,"Document[%d]",DocumentCounter);
		}
		DuplicateTitleCheck(str);
		GlobalFree(MdiInfo[WndNum].title);
		MdiInfo[WndNum].title=(char *)GlobalAlloc(GMEM_FIXED,lstrlen(str)+1);
		lstrcpy(MdiInfo[WndNum].title,str);
		SendMessage(hDocCombo,CB_ADDSTRING,0,(long)MdiInfo[WndNum].title);
		i2=SendMessage(hDocCombo,CB_FINDSTRINGEXACT,0,(long)MdiInfo[WndNum].title);
		SendMessage(hDocCombo,CB_SETCURSEL,i2,0);

		//MDIEBhẼ^CgĐݒ
		SetWindowText(hChild,MdiInfo[WndNum].title);

		//^uRg[Đݒ
		COLORREF TabColor;
		TabColor=pobj_nv->pobj_ExtLink->GetTabColorFromFilePath(MdiInfo[WndNum].path);
		pobj_MainTab->DeleteItem( szOldTitle, false );
		pobj_MainTab->InsertItem( MdiInfo[WndNum].title, false, TabColor );

		MdiInfo[WndNum].pMdiTextEdit->Modify();


		iDocNum++;

		i+=2;
		if(pHeaderBuffer[i]=='\0') break;
	}

	RemoveDirectoryStrong(dir_path);
}


BOOL restore(void){
	HANDLE hFind;
	WIN32_FIND_DATA wfd;
	char temporary[MAX_PATH],*temp2;

	char szTempPath[MAX_PATH];
	GetTempPath(MAX_PATH,temporary);
	ShortPathToLongPath(temporary,szTempPath);
	if(szTempPath[lstrlen(szTempPath)-1]!='\\') lstrcat(szTempPath,"\\");

	sprintf(temporary,"%s*",szTempPath);
	hFind=FindFirstFile(temporary,&wfd);
	if(hFind!=INVALID_HANDLE_VALUE){
		do{
			if(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY){
#ifdef THETEXT
				if(memcmp(wfd.cFileName,"TheText_Temporary_",18)==0){
#else
				if(memcmp(wfd.cFileName,"abdev_temporary_",16)==0){
#endif
					sprintf(temporary,"%s%s\\info.txt",szTempPath,wfd.cFileName);
					temp2=ReadBuffer_NonErrMsg(temporary);
					if(temp2){
						HWND hTemp;
						sscanf(temp2,"%x",&hTemp);
						if(!IsWindow(hTemp)){
							sprintf(temporary,"OA%sُI\܂Bf[^𕜌܂H",APPLICATION_NAME);
							if(MessageBox(hOwner,temporary,APPLICATION_NAME,MB_YESNO)==IDNO){
								HeapDefaultFree(temp2);

								sprintf(temporary,"%s%s\\",szTempPath,wfd.cFileName);
								RemoveDirectoryStrong(temporary);
								return 0;
							}

							sprintf(temporary,"%s%s\\",szTempPath,wfd.cFileName);
							RestoreBeforeState(temporary,temp2);

							HeapDefaultFree(temp2);

							return 1;
						}

						HeapDefaultFree(temp2);
					}
				}
			}
		}while(FindNextFile(hFind,&wfd));
	}

	return 0;
}
