#include <boost/foreach.hpp>
#include <jenga/include/common/String.h>


bool Jenga::Common::IsExistString( const Jenga::Common::Strings &strings, const std::string &findStr )
{
	BOOST_FOREACH( const std::string &str, strings )
	{
		if( str == findStr )
		{
			return true;
		}
	}
	return false;
}

std::string& Jenga::Common::StringReplace( std::string& str, const std::string sb, const std::string sa )
{
	std::string::size_type n, nb = 0;
	
	while ((n = str.find(sb,nb)) != std::string::npos)
	{
		str.replace(n,sb.size(),sa);
		nb = n + sa.size();
	}
	
	return str;
}
