#include "stdafx.h"

#include <shlwapi.h>

#include <jenga/include/common/Environment.h>

#include <Program.h>

Jenga::Common::Logger Program::logger( Jenga::Common::Environment::GetAppDir() + "\\logger.log", true );

Program program;

bool Program::AnalysisCommandLines()
{
	// R}hC
	const Jenga::Common::CmdLines cmdLines( PathGetArgs( GetCommandLine() ) );
	int cmdLineIndex = 0;

	if( cmdLines.size() == 0 )
	{
		// w肳ĂȂƂ
		return true;
	}

	if( cmdLines[cmdLineIndex].IsNamelessCommand() )
	{
		// 擪ɖR}hꍇA\[Xt@CƂĔF
		Program::SetSourceFilePath( cmdLines[cmdLineIndex].GetParameter() );

		cmdLineIndex ++;

		if( cmdLines.size() == 1 )
		{
			// \[Xt@Ĉ݂̎w肾Ƃ
			return true;
		}

		// o̓t@C擾
		if( cmdLines[cmdLineIndex].IsNamelessCommand() )
		{
			// ԖڂɂR}hꍇA\[Xt@CƂĔF
			SetOutputFilePath( cmdLines[cmdLineIndex].GetParameter() );

			cmdLineIndex ++;
		}
	}

	for( ; cmdLineIndex < static_cast<int>(cmdLines.size()); cmdLineIndex++ )
	{
		const Jenga::Common::CmdLine &cmdLine = cmdLines[cmdLineIndex];

		if( cmdLine.GetCommand() == "wnd" )
		{
			// eGfB^̃EBhE nh
			isKickedFromEditor = true;
			sscanf( cmdLine.GetParameter().c_str(), "%08x", &hOwnerEditor );
		}
		else if( cmdLine.GetCommand() == "show_dlg" )
		{
			isShowDlg = true;
		}
		else if( cmdLine.GetCommand() == "debug" )
		{
			// fobO rh
			compiler.SetDebugMark( true );
		}
		else if( cmdLine.GetCommand() == "run" )
		{
			// fobOs
			isDebugRun = true;
		}
		else if( cmdLine.GetCommand() == "attach" )
		{
			// A^b`
			isDebugRun = true;
			isAttach = true;
			sscanf( cmdLine.GetParameter().c_str(), "%08x", &attachProcessId );
		}
		else if( cmdLine.GetCommand() == "dll" )
		{
			// DLLƂărh
			compiler.SetTargetModuleType( Compiler::Dll );
		}
		else if( cmdLine.GetCommand() == "static_library" )
		{
			// ÓINCuƂărh
			compiler.SetTargetModuleType( Compiler::StaticLibrary );
		}
		else if( cmdLine.GetCommand() == "unicode" )
		{
			// Unicode
			compiler.SetUnicodeMark( true );
			typeOfPtrChar = MAKE_PTR_TYPE(DEF_WORD,1);
			typeOfPtrUChar = MAKE_PTR_TYPE(DEF_WORD,1);
		}
		else if( cmdLine.GetCommand() == "clip_compile_view" )
		{
			//ߍ݌^RpCr[
			isClipCompileView = true;
		}
		else if( cmdLine.GetCommand() == "include_dir" )
		{
			//CN[h fBNg
			includeDir = cmdLine.GetParameter();
		}
		else
		{
			// sȃR}h
			std::string keyword = cmdLine.GetCommand();
			if( keyword.size() == 0 )
			{
				keyword = cmdLine.GetParameter();
			}
			std::cout << keyword << " R}hƂĔFł܂B" << std::endl;
			return false;
		}
	}

	return true;
}
