#pragma once

#include <logger.h>

class Program
{
	std::string sourceFilePath;
	std::string outputFilePath;

	bool isKickedFromEditor;
	bool isShowDlg;
	bool isDebugRun;
	bool isAttach;
	DWORD attachProcessId;
	bool isClipCompileView;
	std::string includeDir;

public:
	static Jenga::Common::Logger logger;

	Program()
		: isKickedFromEditor( false )
		, isShowDlg( false )
		, isDebugRun( false )
		, isAttach( false )
		, attachProcessId( 0 )
		, isClipCompileView( false )
	{
	}

	bool AnalysisCommandLines();

	const std::string &GetSourceFilePath() const
	{
		return sourceFilePath;
	}
	void SetSourceFilePath( const std::string &sourceFilePath )
	{
		this->sourceFilePath = sourceFilePath;
	}
	const std::string &GetOutputFilePath() const
	{
		return outputFilePath;
	}
	void SetOutputFilePath( const std::string &outputFilePath )
	{
		this->outputFilePath = outputFilePath;
	}

	bool IsKickedFromEditor() const
	{
		return isKickedFromEditor;
	}

	bool IsShowDlg() const
	{
		return isShowDlg;
	}

	bool IsDebugRun() const
	{
		return isDebugRun;
	}

	bool IsAttach() const
	{
		return isAttach;
	}

	DWORD GetAttachProcessId() const
	{
		return attachProcessId;
	}

	bool IsClipCompileView() const
	{
		return isClipCompileView;
	}

	const std::string &GetIncludeDir() const
	{
		return includeDir;
	}
	void SetIncludeDir( const std::string &includeDir )
	{
		this->includeDir = includeDir;
	}
};

extern Program program;
