#include "stdafx.h"

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"


/////////////////////////
// X^bNt[Ǘ
/////////////////////////

StackFrame::StackFrame(){
	lowest_sp=0;
	now_sp=0;
	max_parm_size=0;
}
StackFrame::~StackFrame(){
	//IuWFNgjɕsȂ`FbNioOj
	error_check();
}
int StackFrame::GetFrameSize( int localParamSize ){
	int answer_sp;

	answer_sp=lowest_sp-max_parm_size;

	if(((answer_sp-localParamSize)%0x10)==0){
		//֐̃Gg|Cg128rbgECɍ킹邽
		return -(answer_sp-0x08);
	}
	return -(answer_sp-0x10);
}
int StackFrame::GetNowSp(){
	return now_sp;
}
void StackFrame::mov_sp( int reg ){
	//mov reg,rsp
	compiler.codeGenerator.op_mov_RR( reg, REG_RSP );

	//add reg,now_sp
	pertialSchedules.push_back(
		compiler.codeGenerator.op_add_RV( reg, now_sp, Schedule::None, true )
	);
}
int StackFrame::push(int reg){
	now_sp-=sizeof(_int64);
	if(lowest_sp>now_sp) lowest_sp=now_sp;

	if(reg==REG_NON) return now_sp;

	//mov qword ptr[rsp+offset],reg
	pertialSchedules.push_back(
		compiler.codeGenerator.op_mov_MR(sizeof(_int64),reg,REG_RSP,now_sp,MOD_BASE_DISP32, Schedule::None, true)
	);

	return now_sp;
}
void StackFrame::push(int xmm_reg,int varSize){
	now_sp-=sizeof(_int64);
	if(lowest_sp>now_sp) lowest_sp=now_sp;

	if(varSize==sizeof(double)){
		//movlpd qword ptr[rsp+offset],xmm_reg
		pertialSchedules.push_back(
			compiler.codeGenerator.op_movlpd_MR(xmm_reg,REG_RSP,now_sp,MOD_BASE_DISP32, Schedule::None, true )
		);
	}
	if(varSize==sizeof(float)){
		//movss dword ptr[rsp+offset],xmm_reg
		pertialSchedules.push_back(
			compiler.codeGenerator.op_movss_MR( xmm_reg, REG_RSP, now_sp, MOD_BASE_DISP32, Schedule::None, true )
		);
	}
}
void StackFrame::ref_offset_data( int reg, int sp_offset ){
	//mov reg,qword ptr[rsp+offset]     X^bNt[𗘗p
	pertialSchedules.push_back(
		compiler.codeGenerator.op_mov_RM(sizeof(_int64),reg,REG_RSP,sp_offset,MOD_BASE_DISP32, Schedule::None, true )
	);
}
void StackFrame::ref(int reg){
	ref_offset_data( reg, now_sp );
}
void StackFrame::ref(int xmm_reg,int varSize){
	if(varSize==sizeof(double)){
		//movlpd xmm_reg,qword ptr[rsp+offset]
		pertialSchedules.push_back(
			compiler.codeGenerator.op_movlpd_RM(xmm_reg,REG_RSP,now_sp,MOD_BASE_DISP32, Schedule::None, true )
		);
	}
	if(varSize==sizeof(float)){
		//movss xmm_reg,dword ptr[rsp+offset]
		pertialSchedules.push_back(
			compiler.codeGenerator.op_movss_MR( xmm_reg, REG_RSP, now_sp, MOD_BASE_DISP32, Schedule::None, true )
		);
	}
}
void StackFrame::pop(int reg){
	if(reg!=REG_NON) ref(reg);

	now_sp+=sizeof(_int64);
}
void StackFrame::pop(int xmm_reg,int varSize){
	ref(xmm_reg,varSize);

	now_sp+=sizeof(_int64);
}
void StackFrame::parameter_allocate(int size){
	if(max_parm_size<size) max_parm_size=size;
}
void StackFrame::RunningSchedule( int stackFrameSize ){
	BOOST_FOREACH( const PertialSchedule *pPertialSchedule, pertialSchedules )
	{
		compiler.codeGenerator.opfix_offset( pPertialSchedule, stackFrameSize );
	}
}

void StackFrame::error_check(){
	if(now_sp){
		compiler.errorMessenger.Output(300,NULL,cp);
	}
}

//X^bNt[ǗpIuWFNg|C^
StackFrame *pobj_sf;
