#include <boost/foreach.hpp>
#include <jenga/include/common/Path.h>

#include <windows.h>


bool Jenga::Common::Path::IsExistFile() const
{
	WIN32_FIND_DATA wfd;
	HANDLE hFind = FindFirstFile( fullPath.c_str() , &wfd );
	if( hFind != INVALID_HANDLE_VALUE ){
		FindClose( hFind );
		if( wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY )
		{
			// fBNg
			return false;
		}

		return true;
	}

	return false;
}

std::string Jenga::Common::Path::MakeFullPath( const std::string &relativePath, const std::string &baseDirPath )
{
	int i,i2,i3,i4;
	char temporary[MAX_PATH];

	char resultPath[MAX_PATH];
	lstrcpy( resultPath, relativePath.c_str() );

	// '/''\'
	for( i=0;resultPath[i];i++ ){
		if( resultPath[i] == '/' ){
			resultPath[i]='\\';
		}
	}

	if(strstr(resultPath,":")||strstr(resultPath,"\\\\")) return resultPath;

	i=0;i2=0;
	while(1){
		if(resultPath[i]=='.'&&resultPath[i+1]=='\\') i+=2;
		if(resultPath[i]=='.'&&resultPath[i+1]=='.'&&resultPath[i+2]=='\\'){
			i2++;
			i+=3;
		}
		else break;
	}

	i3=(int)baseDirPath.size();i4=0;
	while(i4<i2){
		for(i3--;;i3--){
			if(baseDirPath[i3-1]=='\\'){
				i4++;
				break;
			}
		}
	}
	memcpy(temporary,baseDirPath.c_str(),i3);
	temporary[i3]=0;
	lstrcat(temporary,resultPath+i);
	lstrcpy(resultPath,temporary);

	return resultPath;
}
