#pragma once

#include <Messenger.h>
#include <CodeGenerator.h>
#include <NamespaceSupporter.h>
#include <Meta.h>
#include <DataTable.h>
#include <CodeGenerator.h>
#include <ObjectModule.h>
#include <Linker.h>
#include <Delegate.h>
#include <Exception.h>
#include <Enum.h>

class Compiler
{
public:
	// ^[Qbg
	enum TargetModuleType
	{
		Exe,
		Dll,
		StaticLibrary,
	};

private:
	// W[
	std::string moduleName;

	// W[ ^Cv
	TargetModuleType targetModuleType;

	// fobO rhǂ
	bool isDebug;

	// UnicodeΉW[ǂ
	bool isUnicode;

	// OԃT|[g
	NamespaceSupporter namespaceSupporter;

	// IuWFNgW[
	ObjectModule *pObjectModule;
	ObjectModule *pNowObjectModule;

public:

	Compiler()
		: pObjectModule( new ObjectModule )
		, pNowObjectModule( pObjectModule )
		, targetModuleType( Exe )
		, isDebug( false )
		, isUnicode( false )
		, isCore( false )
	{
	}
	~Compiler()
	{
		delete pObjectModule;
		Clear();
	}
	void Clear()
	{
		BOOST_FOREACH( ObjectModule *pStaticLibrary, staticLibraries )
		{
			delete pStaticLibrary;
		}
		staticLibraries.clear();
	}

	void StaticLink( ObjectModules &staticLibraries );

	// W[
	void SetModuleName( const std::string &moduleName )
	{
		this->moduleName = moduleName;
	}
	const std::string &GetModuleName() const
	{
		return moduleName;
	}

	// OԃT|[g
	NamespaceSupporter &GetNamespaceSupporter()
	{
		return namespaceSupporter;
	}

	// bZW[
	Messenger messenger;
	ErrorMessenger errorMessenger;

	// R[h@\
	CodeGenerator codeGenerator;

	// J
	Linker linker;

	// ÓINIuWFNgt@C
	std::vector<std::string> staticLibraryFilePaths;

	// ÓINIuWFNgW[
	ObjectModules staticLibraries;

	// IuWFNgW[
	ObjectModule &GetObjectModule()
	{
		return *pNowObjectModule;
	}
	void SelectObjectModule( ObjectModule &objectModule )
	{
		pNowObjectModule = &objectModule;
	}

	bool IsExe() const
	{
		if( targetModuleType == Exe )
		{
			return true;
		}
		return false;
	}
	bool IsDll() const
	{
		if( targetModuleType == Dll )
		{
			return true;
		}
		return false;
	}
	bool IsStaticLibrary() const
	{
		if( targetModuleType == StaticLibrary )
		{
			return true;
		}
		return false;
	}
	void SetTargetModuleType( TargetModuleType targetModuleType )
	{
		this->targetModuleType = targetModuleType;
	}

	void SetDebugMark( bool isDebug )
	{
		this->isDebug = isDebug;
	}
	bool IsDebug() const
	{
		return isDebug;
	}

	void SetUnicodeMark( bool isUnicode )
	{
		this->isUnicode = isUnicode;
	}
	bool IsUnicode()
	{
		return isUnicode;
	}


	// RAW[ǂ
	bool isCore;
	void SetCoreMark( bool isCore )
	{
		this->isCore = isCore;
	}
	bool IsCore() const
	{
		return isCore;
	}

	// O[oGAu֐
	std::string globalAreaProcName;

	// 񋓌^
	EnumInfoCollection enumInfoCollection;


	bool StringToType( const std::string &typeName, Type &type );
	const std::string TypeToString( const Type &type );

	// RpC̃NX
	const CClass *pCompilingClass;
};

extern Compiler compiler;
