#include "stdafx.h"


bool Parameter::Equals( const Parameter &param, bool isContravariant ) const
{
	if( Type::Equals( param ) )
	{
		return true;
	}
	else
	{
		if( this->isRef && this->GetBasicType() == DEF_ANY &&
			param.isRef == false && param.IsPointer()
			||
			this->isRef == false && this->IsPointer() &&
			param.isRef && param.GetBasicType() == DEF_ANY )
		{
			/* ByRef var As Any
					
				var As VoidPtr
				͓
			*/
			return true;
		}
	}

	if( isContravariant )
	{
		// ψ
		if( this->IsContravariant( param ) )
		{
			// ψƂ
			return true;
		}
	}

	return false;
}
bool Parameter::Equals( const Types &actualTypeParametersForThisProc, const Parameter &param, bool isContravariant ) const
{
	if( Equals( param, isContravariant ) )
	{
		return true;
	}
	
	if( this->IsTypeParameter() )
	{
		// ^p[^Ƃ
		if( actualTypeParametersForThisProc[this->GetFormalTypeIndex()].Equals( param ) )
		{
			// ߂l
			return true;
		}
	}

	return false;
}

bool Parameters::Equals( const Parameters &params, bool isContravariant ) const
{
	if( this->size() != params.size() ){
		return false;
	}

	int max = (int)this->size();
	for( int i=0; i<max; i++ ){
		if( !(*this)[i]->Equals( *params[i], isContravariant ) ){
			return false;
		}
	}

	return true;
}
bool Parameters::Equals( const Types &actualTypeParametersForThisProc, const Parameters &params, bool isContravariant ) const
{
	if( this->size() != params.size() ){
		return false;
	}

	int max = (int)this->size();
	for( int i=0; i<max; i++ ){
		if( !(*this)[i]->Equals( actualTypeParametersForThisProc, *params[i], isContravariant ) ){
			return false;
		}
	}

	return true;
}

bool Parameters::Analyze( const char *sourceOfParams, int nowLine )
{
	int i2,i3,sw;
	char temporary[8192],temp2[VN_SIZE];

	//p[^
	int i = 0;
	while(1){
		if( sourceOfParams[i] == '\0' )
		{
			break;
		}

		//ByRef
		bool isRef;
		if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_BYVAL){
			isRef = false;
			i+=2;
		}
		else if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_BYREF){
			isRef = true;
			i+=2;
		}
		else isRef = false;

		//p[^
		bool isArray = false;
		Subscripts subscripts;
		char name[VN_SIZE];
		sw=0;
		for(i2=0;;i++,i2++){
			if(sourceOfParams[i]=='('){
				if(!sw) sw=1;

				i3=GetStringInPare(name+i2,sourceOfParams+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(sourceOfParams[i]=='['){
				if(!sw) sw=1;

				i3=GetStringInBracket(name+i2,sourceOfParams+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(!IsVariableChar(sourceOfParams[i])){
				name[i2]=0;
				break;
			}
			name[i2]=sourceOfParams[i];
		}
		if(sw){
			//zp[^
			if( isRef == false )
			{
				compiler.errorMessenger.Output(29,NULL,nowLine);
			}
			isArray = true;

			if((name[i2-2]=='('&&name[i2-1]==')')||
				(name[i2-2]=='['&&name[i2-1]==']'))
			{
				subscripts.push_back( LONG_MAX );

				name[i2-2]=0;
			}
			else{
				GetArrange(name,temp2,subscripts);
				lstrcpy(name,temp2);
			}

			i2=lstrlen(name);
		}

		Type type( DEF_NON );
		char initValue[8192] = "";
		if( sourceOfParams[i] == '=' ){
			i++;
			i = GetOneParameter( sourceOfParams, i, initValue );

			// TODO: G[p fix me!!!
			//cp = nowLine;

			NumOpe_GetType( initValue, GetStringTypeInfo(), type );
			
			if( IS_LITERAL(type.GetIndex()) )
			{
				type.SetIndex( -1 );
			}
		}
		else if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_AS){
			// Asw
			i+=2;

			i2=0;
			while(sourceOfParams[i]=='*'){
				temporary[i2]=sourceOfParams[i];
				i++;
				i2++;
			}
			for(;;i++,i2++){
				if(!IsVariableChar(sourceOfParams[i])){
					if(sourceOfParams[i]==1&&(sourceOfParams[i+1]==ESC_FUNCTION||sourceOfParams[i+1]==ESC_SUB)){
						temporary[i2++]=sourceOfParams[i++];
						temporary[i2]=sourceOfParams[i];
						continue;
					}
					temporary[i2]=0;
					break;
				}
				temporary[i2]=sourceOfParams[i];
			}

			compiler.StringToType( temporary, type );

			if( type.IsNull() ){
				compiler.errorMessenger.Output(3,temporary,nowLine);
				type.SetBasicType( DEF_PTR_VOID );
			}

			if( type.IsObject() ){
				if( type.GetClass().IsBlittableType() ){
					// Blittable^̂Ƃ͊{^ƂĈ
					type = type.GetClass().GetBlittableType();
				}
			}
		}
		else{
			type.SetBasicType( Type::GetBasicTypeFromSimpleName(temporary) );
			compiler.errorMessenger.Output(-103,temporary,nowLine);
		}

		Parameter *pParam = new Parameter( name, type, isRef, initValue );
		if( isArray ){
			pParam->SetArray( subscripts );
		}

		//p[^ǉ
		this->push_back( pParam );

		if( sourceOfParams[i] == ',' )
		{
			i++;
			continue;
		}
		else if( sourceOfParams[i] == '\0' )
		{
			break;
		}
		else{
			compiler.errorMessenger.Output(1,NULL,nowLine);
			break;
		}
	}

	return true;
}

std::string Parameters::GetString() const
{
	std::string result;

	const Parameters &params = *this;
	BOOST_FOREACH( const Parameter *pParam, params )
	{
		if( result.size() )
		{
			result += ",";
		}

		result += pParam->GetVarName() + " As " + compiler.TypeToString( *pParam );
	}
	return result;
}
