#include "stdafx.h"

#include <Delegate.h>

void Delegate::RefleshParameterAndReturnType()
{
	compiler.GetNamespaceSupporter().SetImportedNamespaces( this->importedNamespaces );
	compiler.GetNamespaceSupporter().SetLivingNamespaceScopes( this->GetNamespaceScopes() );

	// p[^
	params.Analyze( paramStr.c_str(), sourceIndex );

	// Ip[^
	dynamicParams = params;
	dynamicParams.insert( dynamicParams.begin(), new Parameter( "_System_LocalThis", Type( DEF_PTR_VOID ) ) );

	if( IsFunction() )
	{
		// ߂l擾
		if( !compiler.StringToType( returnTypeName, returnType ) )
		{
			compiler.errorMessenger.Output(3,returnTypeName,sourceIndex);
		}
	}
}

bool Delegate::IsSimilar( const Delegate &dgt ) const
{
	if( this->Params().Equals( dgt.Params(), true ) )			// p[^A͔
	{
		if( this->returnType.Equals( dgt.returnType ) )
		{
			// ߂l
			return true;
		}
		else if( this->returnType.IsCovariant( dgt.returnType ) )
		{
			// ߂l
			return true;
		}
	}
	return false;
}

void Delegates::Collect( const BasicSource &source )
{
	int i2;
	char temporary[VN_SIZE];

	// OԊǗ
	NamespaceScopes &namespaceScopes = compiler.GetNamespaceSupporter().GetLivingNamespaceScopes();
	namespaceScopes.clear();

	// ImportsꂽOԂ̊Ǘ
	NamespaceScopesCollection &importedNamespaces = compiler.GetNamespaceSupporter().GetImportedNamespaces();
	importedNamespaces.clear();

	for( int i=0; i<source.GetLength(); i++ )
	{
		if( source[i] == 1 && source[i+1] == ESC_NAMESPACE ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			namespaceScopes.push_back( temporary );

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				compiler.errorMessenger.Output(12, "End Namespace", i );
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_IMPORTS ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			if( !compiler.GetNamespaceSupporter().ImportsNamespace( temporary ) )
			{
				compiler.errorMessenger.Output(64,temporary,i );
			}

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_CLEARNAMESPACEIMPORTED ){
			importedNamespaces.clear();
			continue;
		}

		else if( source[i] == 1 && source[i+1] == ESC_DELEGATE )
		{
			int nowLine = i;

			i += 2;
			if( !( source[i] == 1 && ( source[i+1] == ESC_SUB || source[i+1] == ESC_FUNCTION ) ) )
			{
				compiler.errorMessenger.Output(1,NULL,i);
				continue;
			}

			Procedure::Kind procKind = Procedure::Sub;
			if( source[i+1] == ESC_FUNCTION )
			{
				procKind = Procedure::Function;
			}
			i += 2;

			// O
			char name[VN_SIZE];
			GetIdentifierToken( name, source.GetBuffer(), i );

			if( source[i] != '(' )
			{
				compiler.errorMessenger.Output(1,NULL,nowLine);
				continue;
			}

			// p[^
			char paramStr[8192];
			i += GetStringInPare( paramStr, source.GetBuffer() + i, true );

			// ߂ľ^̕
			char returnTypeName[VN_SIZE] = "";
			if( source[i] == 1 && source[i+1] == ESC_AS )
			{
				i += 2;
				GetCommandToken( returnTypeName, source.GetBuffer(), i );

				if( procKind != Procedure::Function )
				{
					compiler.errorMessenger.Output(38,name,nowLine);
				}
			}
			else
			{
				if( procKind == Procedure::Function )
				{
					compiler.errorMessenger.Output(-104,name,nowLine);
					lstrcpy( returnTypeName, "Double" );
				}
			}

			this->Put( new Delegate( namespaceScopes, importedNamespaces, name, procKind, paramStr, returnTypeName, nowLine ) );
		}
	}
}

void Delegates::GenerateSourceCode( std::string &destSource )
{
	destSource = "";

	SourceTemplate sourceTemplate( "\\SubOperation\\templates\\delegate_class.tab" );

	this->Iterator_Reset();
	while( this->Iterator_HasNext() )
	{
		const Delegate &dg = *this->Iterator_GetNext();

		if( !dg.isTargetObjectModule )
		{
			// ÓINCȕꍇ͔΂iɃCX^X`ς݂ł邽߁j
			continue;
		}

		std::map<std::string,std::string> values;

		if( dg.GetNamespaceScopes().size() )
		{
			std::string namespaceScopesCommandStr = "";
			std::string endNamespaceScopesCommandStr = "";
			BOOST_FOREACH( const std::string &namespaceStr, dg.GetNamespaceScopes() )
			{
				if( namespaceScopesCommandStr.size() )
				{
					namespaceScopesCommandStr += ":";
					endNamespaceScopesCommandStr += ":";
				}
				namespaceScopesCommandStr += "Namespace " + namespaceStr;
				endNamespaceScopesCommandStr += "End Namespace";
			}

			values.insert( std::map<std::string,std::string>::value_type(
				"#namespace_begin#",
				namespaceScopesCommandStr
			) );
			values.insert( std::map<std::string,std::string>::value_type(
				"#namespace_end#",
				endNamespaceScopesCommandStr
			) );
		}
		else
		{
			values.insert( std::map<std::string,std::string>::value_type( "#namespace_begin#", "" ) );
			values.insert( std::map<std::string,std::string>::value_type( "#namespace_end#", "" ) );
		}

		values.insert( std::map<std::string,std::string>::value_type( "#name#", dg.GetName() ) );

		if( dg.IsFunction() )
		{
			values.insert( std::map<std::string,std::string>::value_type(
				"#call_method_begin#",
				(string)"Function Call(" + dg.paramStr + ") As " + dg.returnTypeName
			) );

			values.insert( std::map<std::string,std::string>::value_type(
				"#call_method_end#",
				"End Function"
			) );

			values.insert( std::map<std::string,std::string>::value_type( "#result#", "Call=" ) );
		}
		else
		{
			values.insert( std::map<std::string,std::string>::value_type(
				"#call_method_begin#",
				(string)"Sub Call(" + dg.paramStr + ")"
			) );

			values.insert( std::map<std::string,std::string>::value_type(
				"#call_method_end#",
				"End Sub"
			) );

			values.insert( std::map<std::string,std::string>::value_type( "#result#", "" ) );
		}

		values.insert( std::map<std::string,std::string>::value_type( "#params#", dg.paramStr ) );

		destSource += sourceTemplate.GetResult( values );
	}
/*
	ofstream ofs( ( Jenga::Common::Environment::GetAppDir() + "\\generated_delegate_code.log" ).c_str() );
	ofs << destSource;
	ofs.close();
	*/
}

void Delegates::RefleshParameterAndReturnType()
{
	this->Iterator_Reset();
	while( this->Iterator_HasNext() )
	{
		Delegate &dg = *this->Iterator_GetNext();
		dg.RefleshParameterAndReturnType();
	}
}
