#include "stdafx.h"

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void SetVariableFromRax( const Type &varType, int CalcType,RELATIVE_VAR *pRelativeVar){
	/////////////////////////////////////////////////
	// rax̓eϐɃRs[R[h𒊏o
	/////////////////////////////////////////////////

	if( varType.IsBoolean() )
	{
		//bool
		SetBooleanVariable(CalcType,pRelativeVar);
	}
	else if( varType.IsReal() )
	{
		// Double/Single^ϐփWX^̒l
		SetRealVariable(varType.GetBasicType(), CalcType, pRelativeVar);
	}
	else if( varType.IsWhole() || varType.IsObject() )
	{
		//ϐrax̒li[
		SetWholeVariable( varType.GetSize(), CalcType, pRelativeVar );
	}
	else{
		SetError(300,NULL,cp);
	}
}
void OpcodeCalc(const char *Command){
	int i,i2,i3;
	char variable[VN_SIZE];


	//////////////////////////////////////
	// CNgEfNg
	//////////////////////////////////////

	for(i=0;;i++){
		if(Command[i]=='\"'){
			//_uNH[g͕sȂ̂ŃG[
			variable[i]=0;
			SetError(3,variable,cp);
			return;
		}

		if(Command[i]=='('){
			i2=GetStringInPare(variable+i,Command+i);
			i+=i2-1;
			continue;
		}
		if(Command[i]=='['){
			i2=GetStringInBracket(variable+i,Command+i);
			i+=i2-1;
			continue;
		}
		if(Command[i]=='\0'){

			///////////////////////////////////
			// CNgEfNg
			///////////////////////////////////

			if(i>2){
				if(Command[i-2]=='+'&&Command[i-1]=='+'){
					//CNg
					variable[i-2]=0;
					IncDec(CALC_ADDITION,variable,"1");
					return;
				}
				else if(Command[i-2]=='-'&&Command[i-1]=='-'){
					//fNg
					variable[i-2]=0;
					IncDec(CALC_SUBTRACTION,variable,"1");
					return;
				}
			}


			//[̎ʎqG[L[[hɂ
			for(i=0;;i++){
				if(!IsVariableChar(Command[i])){
					variable[i]=0;
					break;
				}
				variable[i]=Command[i];
			}

			if(GetVarType(variable,Type(),0)){
				//ϐXgɊYƂ
				SetError(1,NULL,cp);
			}
			else{
				if( compiler.GetObjectModule().meta.GetGlobalConsts().IsExist(variable)
					|| compiler.GetObjectModule().meta.GetGlobalConstMacros().IsExist(variable) )
				{
					//萔XgɊYƂ
					SetError(1,NULL,cp);
				}
				else{
					//ϐXgA萔XgɊYȂƂ
					SetError(3,variable,cp);
				}
			}
			return;
		}

		i2=GetCalcId(Command+i,&i3);
		if(i2){
			variable[i]=0;

			if(Command[i]=='=') break;

			if(Command[i+1+i3]=='='){
				IncDec(i2,variable,Command+i+1+i3+1);
				return;
			}
		}

		variable[i]=Command[i];
	}

	if(Command[i+1]=='\0'){
		SetError(1,NULL,cp);
		return;
	}



	///////////////////////////////////////////////////////////////
	// CfNTsetANZTi[]=Zq̃I[o[[hɑΉj
	///////////////////////////////////////////////////////////////

	char ObjName[VN_SIZE],array_element[VN_SIZE];
	GetArrayElement(variable,ObjName,array_element);
	if(array_element[0]){
		Type varType;
		if( GetVarType(ObjName,varType,0) && varType.IsObject() ){
			char temporary[VN_SIZE];
			sprintf(temporary,"%s.%c%c%c",ObjName,1,ESC_OPERATOR,CALC_ARRAY_SET);

			char temp2[VN_SIZE];
			sprintf(temp2,"%s,%s",array_element,Command+i+1);

			int idProc;
			void *pProc;
			idProc=GetProc(temporary,(void **)&pProc);
			if( idProc )
			{
				CallProc(
					idProc,
					pProc,
					temporary,
					temp2,
					Type(),			// x[X^Cv͂Ȃ
					Type()
				);
				return;
			}
		}
	}


	if( lstrcmpi( variable, "This" ) == 0 ){
		SetError(133,NULL,cp);
		return;
	}


	////////////////////////////////////////
	// ϐ̃^Cv^ʂāAZs
	////////////////////////////////////////

	Type varType;

	//^
	if( !GetTermTypeOnlyVariable(variable,varType) ){

		// vpeBp̃\bhĂяo
		if(!CallPropertyMethod( variable, Command+i+1, Type() )){
			//G[\
			GetVarType(variable,varType,true);
		}

		return;
	}

	//NumOpe...iraxA܂xmm0ɓi[j
	int reg=REG_RAX;
	Type calcType;
	bool isNeedHeapFreeStructure;
	if( !NumOpe(&reg,Command+i+1,varType,calcType,&isNeedHeapFreeStructure) ){
		return;
	}

	if(reg!=REG_RAX&&calcType.IsWhole()||
		varType.IsNull()||calcType.IsNull()){
		SetError(300,NULL,cp);
	}

	//ʂi[Ă郌WX^ubLO
	pobj_BlockReg->lock(reg);

	//ϐAhX擾
	RELATIVE_VAR VarRelativeVar;
	if( !TermOpeOnlyVariable( variable, varType, VarRelativeVar, true ) )
	{
		SetError();
		return;
	}

	//WX^̃ubLO
	pobj_BlockReg->clear();

	if(varType.GetBasicType()&FLAG_PTR){
		SetError(14,variable,cp);
		return;
	}

	if( varType.IsStruct() ){
		//\̃CX^Xւ̑
		SetStructVariableFromRax(varType,calcType,&VarRelativeVar,isNeedHeapFreeStructure);
		return;
	}

	if( calcType.IsObject() && !calcType.Equals( varType ) ){
		bool isUpCast = false;
		if( varType.IsObject() ){
			if( varType.GetClass().IsEqualsOrSubClass( &calcType.GetClass() ) ){
				isUpCast = true;
			}
		}
		if( !isUpCast ){
			//LXgZq̃I[o[[hɑΉ
			CallCastOperatorProc(REG_RAX,calcType,isNeedHeapFreeStructure,varType);
		}
	}

	if( varType.IsObject() && compiler.GetObjectModule().meta.GetBlittableTypes().IsExist( calcType ) ){
		// Blittable^IuWFNgƂĈ
		vector<const UserProc *> userProcs;
		compiler.GetObjectModule().meta.GetBlittableTypes().GetClass( calcType ).GetStaticMethods().Enum( "_Create", userProcs );
		if( userProcs.size() != 1 ){
			SetError();
			return;
		}
		const UserProc *pUserProc = userProcs[0];

		// mov rcx, rax
		compiler.codeGenerator.op_mov_RR( REG_RCX, REG_RAX );

		// call System.[TypeClass]._Create
		compiler.codeGenerator.op_call( pUserProc );

		calcType = pUserProc->ReturnType();
	}

	/////////////////////////////////
	// EӁAӂ̌^`FbNs
	/////////////////////////////////

	CheckDifferentType(varType,calcType,0,0);


	/////////////////////////////////////////////////
	// raxixmm0j̓eϐɃRs[
	/////////////////////////////////////////////////
	SetVariableFromRax(varType,calcType.GetBasicType(),&VarRelativeVar);


	// R[hߒŔ\̂̈ꎞj
	compiler.codeGenerator.op_FreeTempStructure();
}
