#include "stdafx.h"

#include <DataTable.h>

#include <memory.h>
#include <stdlib.h>

int DataTable::AddBinary( const void *buffer, int size ){
	int retSize = this->size;

	Realloc( this->size + size );
	memcpy( (char *)this->buffer + retSize, buffer, size );

	return retSize;
}
int DataTable::Add( _int64 i64data ){
	int retSize = size;
	AddBinary( &i64data, sizeof( _int64 ) );
	return retSize;
}
int DataTable::Add( int i32data ){
	int retSize = size;
	AddBinary( &i32data, sizeof( int ) );
	return retSize;
}
int DataTable::Add( double dbl ){
	int retSize = size;
	AddBinary( &dbl, sizeof( double ) );
	return retSize;
}
int DataTable::Add( float flt ){
	int retSize = size;
	AddBinary( &flt, sizeof( float ) );
	return retSize;
}
int DataTable::AddString( const char *str, int length ){
	int retSize = size;

	if( compiler.IsUnicode() ){
		//Shift-JIS  Unicode
		int size = MultiByteToWideChar(
			CP_ACP,
			0,
			str, length + 1,
			NULL, 0 ) * 2;

		LPWSTR pwstr = (LPWSTR)malloc( size );

		MultiByteToWideChar(
			CP_ACP,
			0,
			str, length + 1,
			pwstr, length + 1 );

		AddBinary( pwstr, size );

		free( pwstr );
	}
	else{
		AddBinary( str, length + 1 );
	}

	return retSize;
}
int DataTable::AddString( const char *str )
{
	return AddString( str, lstrlen( str ) );
}
int DataTable::AddString( const std::string &str )
{
	return AddString( str.c_str(), static_cast<int>(str.length()) );
}
int DataTable::AddSpace( int size )
{
	int retSize = this->size;
	Realloc( this->size + size );
	return retSize;
}
void DataTable::AddAlignment( int size )
{
	if( this->size % size == 0 )
	{
		// ɋÊƂ
		return;
	}
	Realloc( this->size + ( size - (int)(this->size%size) ) );
}

bool DataTable::MakeConstObjectToProcessStaticBuffer( const CClass &objClass, const Jenga::Common::Strings &initMemberValues, int &dataTableOffset )
{
	// NXɕKvȃobt@TCY擾
	int size = objClass.GetSize();

	// NX̃obt@C[W쐬
	BYTE *buffer = (BYTE *)calloc( size, 1 );

	// NX̃obt@C[Wf[^̈֒ǉ
	dataTableOffset = this->AddBinary( buffer, size );

	this->lastMadeConstObjectDataTableOffset = dataTableOffset;

	// com_vtblXPW[
	this->schedules.push_back( Schedule( Schedule::ComVtbl, &objClass, dataTableOffset ) );

	// vtblXPW[
	this->schedules.push_back( Schedule( Schedule::Vtbl, &objClass, dataTableOffset + PTR_SIZE ) );

	// TypeInfoXPW[
	int offsetForTypeInfo = objClass.GetMemberOffset( "_system_object_member_typeInfo" );
	//this->schedules.push_back( Schedule( Schedule::TypeInfo, &objClass, dataTableOffset + offsetForTypeInfo ) );

	BOOST_FOREACH( const std::string &initMemberValue, initMemberValues )
	{
		int i = 0;

		// o
		char memberName[VN_SIZE];
		for( i=0; ; i++ )
		{
			if( initMemberValue[i] == '\0' )
			{
				// G[
				SetError();
				return false;
			}
			if( initMemberValue[i] == '=' )
			{
				memberName[i] = 0;
				break;
			}
			memberName[i] = initMemberValue[i];
		}

		// l
		const char *initValue = initMemberValue.c_str() + i + 1;

		// o擾
		const CMember *member = objClass.FindDynamicMember( memberName );

		// oItZbg擾
		int memberOffset = objClass.GetMemberOffset( member->GetName().c_str() );

		if( member->GetType().IsPointer() && initValue[0] == '[' )
		{
			// |C^^Ńobt@ŵƂ
			int memberDataTableOffset;
			if( !this->MakeLiteralArrayBuffer( initValue, member->GetType(),memberDataTableOffset ) )
			{
				return false;
			}

			this->Overwrite( dataTableOffset + memberOffset, memberDataTableOffset );
			this->schedules.push_back( Schedule( Schedule::DataTable, dataTableOffset + memberOffset ) );
		}
		else if( member->GetType().IsWhole() )
		{
			// 
			Type resultType;
			_int64 i64data;
			if( !StaticCalculation( true, initValue, member->GetType().GetBasicType(), &i64data, resultType ) ){
				return false;
			}

			this->Overwrite( dataTableOffset + memberOffset, static_cast<long>(i64data) );
		}
		else if( member->GetType().IsStringClass() )
		{
			// ^
			char temporary[VN_SIZE];
			lstrcpy( temporary, initValue );
			RemoveStringQuotes( temporary );
			int memberDataTableOffset = MakeConstStringObjectToProcessStaticBuffer( temporary );
			this->Overwrite( dataTableOffset + memberOffset, memberDataTableOffset );
			this->schedules.push_back( Schedule( Schedule::DataTable, dataTableOffset + memberOffset ) );
		}
	}

	return true;
}
bool DataTable::MakeConstObjectToProcessStaticBuffer( const char *expression, Type &resultType, int &dataTableOffset )
{
	char CreateParameter[VN_SIZE];
	int i,i2;

	i=0;

	// NX擾
	char typeName[VN_SIZE];
	for(i2=0;;i++,i2++){
		if(expression[i]=='['){
			typeName[i2]=0;

			// ȍl擾
			i2=GetStringInBracket(CreateParameter,expression+i);
			RemoveStringBracket(CreateParameter);
			i+=i2;
			if(expression[i]!='\0'){
				SetError(42,NULL,cp);
				return false;
			}
			break;
		}
		typeName[i2]=expression[i];
		if(expression[i]=='\0'){
			CreateParameter[0]=0;
			break;
		}
	}

	// p[^擾
	Jenga::Common::Strings initMemberValues;
	SplitParameter( CreateParameter, initMemberValues );

	if( !compiler.StringToType( typeName, resultType ) ){
		SetError(3,typeName,cp);
		return false;
	}

	if( !resultType.IsObject() ){
		////////////////////////
		// ʏ̃f[^^̏ꍇ
		////////////////////////

		SetError(121,NULL,cp);
		return false;
	}

	return MakeConstObjectToProcessStaticBuffer( resultType.GetClass(), initMemberValues, dataTableOffset );
}

int DataTable::MakeConstStringObjectToProcessStaticBuffer( const char *str )
{
	const CClass &strClass = *compiler.GetObjectModule().meta.GetClasses().GetStringClassPtr();
	const CClass &objClass = strClass.GetSuperClass();

	// NXɕKvȃobt@TCY擾
	int size = strClass.GetSize();

	// oʒu擾
	int offsetForTypeInfo = strClass.GetMemberOffset( "_system_object_member_typeInfo" );
	int offsetForLength = strClass.GetMemberOffset( "m_Length" );
	int offsetForChars = strClass.GetMemberOffset( "Chars" );

	// ݂̃f[^̈̃wb_ʒu擾
	int headOffset = this->GetSize();

	// NX̃obt@C[W쐬
	BYTE *buffer = (BYTE *)calloc( size, 1 );
	*(long *)(buffer + offsetForLength) = lstrlen( str );
	*(LONG_PTR *)(buffer + offsetForChars) = headOffset + size;

	// NX̃obt@C[Wf[^̈֒ǉ
	int dataTableOffset = this->AddBinary( buffer, size );

	// XPW[O
	this->schedules.push_back( Schedule( Schedule::ComVtbl, &strClass, headOffset ) );
	this->schedules.push_back( Schedule( Schedule::Vtbl, &strClass, headOffset + PTR_SIZE ) );
	this->schedules.push_back( Schedule( Schedule::TypeInfo, &strClass, headOffset + offsetForTypeInfo ) );
	this->schedules.push_back( Schedule( Schedule::DataTable, headOffset + offsetForChars ) );

	// obt@f[^̈֒ǉ
	this->AddString( str );

	return dataTableOffset;
}

bool DataTable::MakeLiteralArrayBuffer( const char *expression, const Type &baseType, int &dataTableOffset )
{
	if( !baseType.IsPointer() ){
		SetError(1,NULL,cp);
		return false;
	}
	Type tempBaseType( baseType );
	tempBaseType.PtrLevelDown();

	char *buffer = (char *)malloc( lstrlen( expression ) + 1 );
	lstrcpy( buffer, expression );
	RemoveStringBracket( buffer );

	Jenga::Common::Strings parameters;
	SplitParameter( buffer, parameters );

	// ACg
	AddAlignment( tempBaseType.GetSize() );

	// f[^e[uɋԂm
	dataTableOffset = AddSpace( static_cast<int>(tempBaseType.GetSize() * parameters.size()) );

	bool isSuccessful = true;
	int i = 0;
	BOOST_FOREACH( const std::string &paramStr, parameters )
	{
		if( paramStr.size() == 0 )
		{
			throw;
		}
		if( paramStr[0] == '\"' )
		{
			// 
			std::string tempParamStr = paramStr;
			if( !RemoveStringQuotes( tempParamStr ) )
			{
				SetError();
			}

			// ǉ
			_int64 strOffset;
			if( tempBaseType.IsStringClass() )
			{
				// StringNX
				strOffset = MakeConstStringObjectToProcessStaticBuffer( tempParamStr.c_str() );
			}
			else
			{
				// Char|C^
				strOffset = this->AddString( tempParamStr );
			}

			// |C^l㏑
			int tempOffset = dataTableOffset + i * tempBaseType.GetSize();
			this->OverwriteBinary( tempOffset, &strOffset, tempBaseType.GetSize() );

			// DataTableXPW[
			this->schedules.push_back( Schedule( Schedule::DataTable, tempOffset  ) );
		}
		else
		{
			// l
			Type resultType;
			_int64 i64data;
			if( !StaticCalculation( true, paramStr.c_str(), tempBaseType.GetBasicType(), &i64data, resultType ) ){
				isSuccessful = false;
				break;
			}
			if( !resultType.IsWhole() ){
				// TODO: ɖΉ
				SetError();
				isSuccessful = false;
				break;
			}

			// ㏑
			this->OverwriteBinary( dataTableOffset + i * tempBaseType.GetSize(), &i64data, tempBaseType.GetSize() );
		}

		i++;
	}

	free( buffer );

	return isSuccessful;
}

void DataTable::ResetDataSectionBaseOffset( long dataSectionBaseOffset )
{
	BOOST_FOREACH( const Schedule &schedule, schedules )
	{
		if( schedule.GetType() == Schedule::DataTable )
		{
#ifdef _WIN64
			OverwriteInt64(
				schedule.GetOffset(),
				GetInt64( schedule.GetOffset() ) + dataSectionBaseOffset
			);
#else
			Overwrite(
				schedule.GetOffset(),
				GetLong( schedule.GetOffset() ) + dataSectionBaseOffset
			);
#endif
		}
	}
}
