#include "stdafx.h"

#include <jenga/include/common/Path.h>

#include <Compiler.h>

#include "common.h"

void StepCompileProgress(void){
	extern HWND hMainDlg;
	PostMessage(GetDlgItem(hMainDlg,IDC_PROGRESS),PBM_STEPIT,0,0);
}

void MakeMiddleCode( char *buffer )
{
	// sR[hCRLFLFɂ
	ChangeReturnCode( buffer );

	// Rg
	DeleteComment( buffer );

	//GXP[vV[PXݒ
	SetEscapeSequenceFormat( buffer );

	//R}hΉ
	ChangeCommandToCode( buffer );
}

void AddSourceCode(const char *buffer){
	char *temp;
	temp=(char *)HeapAlloc(hHeap,0,lstrlen(buffer)+8192);
	lstrcpy(temp,buffer);

	MakeMiddleCode( temp );

	//Ōɓ\t
	compiler.GetObjectModule().GetCurrentSource().Addition( temp );

	HeapDefaultFree(temp);
}

void OutputExe(void){
	extern HANDLE hHeap;
	extern char *basbuf;
	extern int ErrorNum;
	extern BOOL bStopCompile;
	extern HWND hMainDlg;
	int i3;
	char temp2[MAX_PATH];

	// JnL^
	DWORD beforeTickCount = GetTickCount();

	//vOXo[̐ݒ
	PostMessage(GetDlgItem(hMainDlg,IDC_PROGRESS),PBM_SETRANGE,0,MAKELPARAM(0,6));
	PostMessage(GetDlgItem(hMainDlg,IDC_PROGRESS),PBM_SETSTEP,1,0);

	//"f"
	SetDlgItemText(hMainDlg,IDOK,STRING_STOP);

	//ftO
	bStopCompile=0;

	//TuVXẽ^Cv
	extern unsigned short TypeOfSubSystem;
	TypeOfSubSystem=IMAGE_SUBSYSTEM_WINDOWS_GUI;

	//vOt@Cǂݍ
	extern char SourceFileName[MAX_PATH];
	compiler.GetObjectModule().SetCurrentSourceIndex( (int)compiler.GetObjectModule().GetSources().size() );
	compiler.GetObjectModule().GetSources().push_back( BasicSource() );
	if( !compiler.GetObjectModule().GetCurrentSource().ReadFile( SourceFileName ) ){
		SetError(201,SourceFileName,-1);
		goto EndCompile;
	}

	//C[Wx[X̐ݒ
	extern DWORD ImageBase;
	if(compiler.IsDll()) ImageBase=0x10000000;
	else ImageBase=0x00400000;

	extern BOOL bError;
	if(bError||bStopCompile) goto EndCompile;


	//////////////////////////
	// ԃR[h̐Jn
	extern BOOL bClipCompileView;

	//"œK..."
	CompileMessage(STRING_COMPILE_OPTIMIZING);

	//JbR𑊌݃`FbNi_uNH[g`FbN`FbN܂ށj
	CheckParenthesis(basbuf);

	if(bError||bStopCompile) goto EndCompile;

	//RpC_CAÕvOXo[グ
	StepCompileProgress();

	//fBNeBu
	DirectiveCheck();

	//Nextߌ𐳋K\ɕϊ
	//NextCommandFormat(basbuf);

	//GXP[vV[PXݒ
	SetEscapeSequenceFormat(basbuf);

	//DefߌFunctionߌɕϊ
	DefCommandFormat(basbuf);

	//ׂĂIfߌubN`ɕϊ
	IfCommandFormat(basbuf);

	//΂ɂȂ閽ߌ𑊌݃`FbN
	//CheckPareCommand();

	if(bError||bStopCompile) goto EndCompile;

	//RpC_CAÕvOXo[グ
	StepCompileProgress();

	//dG[Ǘ̃m
	extern char **SynonymErrorWords;
	extern int SynonymErrorNum;
	SynonymErrorNum=0;
	SynonymErrorWords=(char **)HeapAlloc(hHeap,0,1);

	ChangeCommandToCode(basbuf);
	compiler.GetObjectModule().GetSources()[0]._ResetLength();

	//dG[Ǘ̃
	for(i3=0;i3<SynonymErrorNum;i3++) HeapDefaultFree(SynonymErrorWords[i3]);
	HeapDefaultFree(SynonymErrorWords);
	SynonymErrorWords=0;

	if(bError||bStopCompile){
		//萔Ɋւ
		goto EndCompile;
	}

	StepCompileProgress();


	/////////////////////////////////////////////////////////////////
	// ÓINCu[h
	/////////////////////////////////////////////////////////////////
	{
		bool isSuccessfulLoadStaticLinkLibrary = true;
		if( !compiler.IsCore() )
		{
			// RAW[[h
			extern BOOL bDebugCompile;
			extern char szIncludeDir[MAX_PATH];

			const char *coreFileName = "core.lib";
			if( compiler.IsDebug() )
			{
				coreFileName = "cored.lib";
			}

			char coreFilePath[MAX_PATH];
#ifdef _AMD64_
			sprintf( coreFilePath, "..\\lib\\x64\\%s", coreFileName );
#else
			sprintf( coreFilePath, "..\\lib\\%s", coreFileName );
#endif
			GetFullPath( coreFilePath, szIncludeDir );

			Jenga::Common::Path path( coreFilePath );
			if( path.IsExistFile() )
			{
				compiler.staticLibraries.push_back( new ObjectModule() );
				if( compiler.staticLibraries.back()->Read( coreFilePath ) )
				{
					CompileMessage( ((string)"\"" + path.GetFileName() + path.GetExt() + "\" ǂݍ݂܂B").c_str() );
				}
				else
				{
					CompileMessage( ((string)"\"" + path.GetFileName() + path.GetExt() + "\" t@CĂ܂B").c_str() );
					isSuccessfulLoadStaticLinkLibrary = false;
				}
			}
			else
			{
				CompileMessage( ((string)"\"" + path.GetFileName() + path.GetExt() + "\" t@C݂܂B").c_str() );
				isSuccessfulLoadStaticLinkLibrary = false;
			}
		}

		BOOST_FOREACH( const std::string &filePath, compiler.staticLibraryFilePaths )
		{
			Jenga::Common::Path path( filePath );
			if( path.IsExistFile() )
			{
				compiler.staticLibraries.push_back( new ObjectModule() );
				if( compiler.staticLibraries.back()->Read( filePath ) )
				{
					CompileMessage( ((string)"\"" + path.GetFileName() + path.GetExt() + "\" ǂݍ݂܂B").c_str() );
				}
				else
				{
					CompileMessage( ((string)"\"" + path.GetFileName() + path.GetExt() + "\" t@CĂ܂B").c_str() );
					isSuccessfulLoadStaticLinkLibrary = false;
				}
			}
			else
			{
				CompileMessage( ((string)"\"" + path.GetFileName() + path.GetExt() + "\" t@C݂܂B").c_str() );
				isSuccessfulLoadStaticLinkLibrary = false;
			}
		}

		if( !isSuccessfulLoadStaticLinkLibrary )
		{
			// ÓINCũ[hɎsƂ
			goto EndCompile;
		}
	}


	///////////////////////
	// RpCJn

	//"RpC..."
	CompileMessage(STRING_COMPILE_COMPILING);

	Compile();

	//\[X
	extern RESOURCEDATAINFO *pCursorResourceInfo;
	extern RESOURCEDATAINFO *pIconResourceInfo;
	extern RESOURCEDATAINFO *pBitmapResourceInfo;
	HeapDefaultFree(pCursorResourceInfo);
	HeapDefaultFree(pBitmapResourceInfo);
	HeapDefaultFree(pIconResourceInfo);

	//RpC_CAÕvOXo[グ
	StepCompileProgress();


	//////////////////////////
	// I
EndCompile:
	if(bStopCompile){
		PostMessage(GetDlgItem(hMainDlg,IDC_PROGRESS),PBM_SETPOS,0,0);

		//"RpC̓[U[ɂ蒆f܂B"
		CompileMessage(STRING_COMPILE_STOP);
	}
	else{
		extern int CompileMsgNum;
		extern int WarningNum;
		if(bError==0){
			//"RpC͐Ɋ܂iG[:%dAx:%dj"
			sprintf(temp2,
				STRING_COMPILE_SUCCESS,
				ErrorNum-CompileMsgNum-WarningNum,
				WarningNum,
				((double)(GetTickCount() - beforeTickCount))/1000
			);
		}
		else{
			//"RpC͒f܂iG[:%dAx:%dj"
			sprintf(temp2,STRING_COMPILE_ERROR,ErrorNum-CompileMsgNum-WarningNum,WarningNum);
		}

		CompileMessage("");
		CompileMessage("-----------------------------------------------------");
		CompileMessage(temp2);
	}

	//""
	SetDlgItemText(hMainDlg,IDOK,STRING_CLOSE);

#ifdef _DEBUG
	// fobO[ĥƂ̓_CAOBĂ
	ShowWindow(hMainDlg,SW_SHOW);
#endif
}
int MainThread(DWORD dummy){
	extern BOOL bDebugRun;
	extern int bError;

	if(bDebugRun){
		if( compiler.IsDebug() )
		{
			bDebugRun=0;

			//fobORpC
			OutputExe();

			bDebugRun=1;
		}

		//fobOs
		if(bError==0) DebugProgram();
	}
	else{
		//[XRpC
		OutputExe();
	}

	return 0;
}
