#include "stdafx.h"

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void ExtendStackTo32( const Type &oldType );

void ExtendStackTo64( const Type &oldType )
{
	if( oldType.Is64() )
	{
		return;
	}

	//32rbgɊg
	ExtendStackTo32( oldType );

	//64rbgɊg
	if( oldType.IsSigned() )
	{
		//

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//cdq
		compiler.codeGenerator.op_cdq();

		//push edx
		compiler.codeGenerator.op_push(REG_EDX);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else{
		//Ȃ

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//push 0
		compiler.codeGenerator.op_push_V(0);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
}
void ExtendStackTo32( const Type &oldType )
{
	if( oldType.GetSize() == sizeof(long) )
	{
		return;
	}

	if( oldType.Is64() )
	{
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//pop edx
		compiler.codeGenerator.op_pop(REG_EDX);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else if( oldType.IsInteger() )
	{
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//movsx eax,ax
		compiler.codeGenerator.op_movsx_R32R16( REG_EAX );

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else if( oldType.IsWord() )
	{
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//and eax,0000FFFFh
		compiler.codeGenerator.op_and_RV( REG_EAX, 0x0000FFFF );

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else if( oldType.IsSByte() )
	{
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//movsx eax,al
		compiler.codeGenerator.op_movsx_R32R8( REG_EAX );

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else if( oldType.IsByte() || oldType.IsBoolean() )
	{
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//and eax,000000FFh
		compiler.codeGenerator.op_and_RV( REG_EAX, 0x000000FF );

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
}
void ExtendStackTo16( const Type &oldType ){
	if( oldType.IsSByte() )
	{
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//movsx eax,al
		compiler.codeGenerator.op_movsx_R32R8( REG_EAX );

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else if( oldType.IsByte() )
	{
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//and eax,000000FFh
		compiler.codeGenerator.op_and_RV( REG_EAX, 0x000000FF );

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
}
void ExtendStackTo8( const Type &oldType )
{
	if( oldType.Is64() )
	{
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//pop edx
		compiler.codeGenerator.op_pop(REG_EDX);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
}


void ChangeTypeToWhole( const Type &oldType, const Type &newType ){
	if( oldType.IsDouble() )
	{
		if( newType.Is64() )
		{
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//fistp qword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(_int64) );
		}
		else{
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );
		}
	}
	else if( oldType.IsSingle() )
	{
		if( newType.Is64() )
		{
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//sub esp,4
			compiler.codeGenerator.op_sub_esp(4);

			//fistp qword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(_int64) );
		}
		else{
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );
		}
	}
	else{
		//琮֕ϊ

		if( newType.Is64() )
		{
			ExtendStackTo64( oldType );
		}
		else if( newType.GetSize()==sizeof(long)){
			ExtendStackTo32( oldType );
		}
		else if( newType.GetSize()==sizeof(short)){
			ExtendStackTo16( oldType );
		}
		else if( newType.GetSize()==sizeof(char)){
			ExtendStackTo8( oldType );
		}
	}
}
