#include "../BasicCompiler_Common/common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif

//RpC̊֐
SUBINFO *pCompilingSubInfo;

int GetCallProcName(char *buffer,char *name){
	int i2,i3,IsStr=0;

	for(i2=0;;i2++){
		if(buffer[i2]=='\"') IsStr^=1;
		if(IsDBCSLeadByte(buffer[i2])){
			name[i2]=buffer[i2];
			i2++;
			name[i2]=buffer[i2];
			continue;
		}
		if(buffer[i2]=='['&&IsStr==0){
			i3=GetStringInBracket(name+i2,buffer+i2);
			i2+=i3-1;
			continue;
		}
		if(buffer[i2]=='('&&IsStr==0){
			name[i2]=0;
			break;
		}
		if(buffer[i2]=='='&&IsStr==0){
			name[i2]=0;
			break;
		}

		name[i2]=buffer[i2];
		if(buffer[i2]=='\0') break;
	}
	return i2;
}

int GetProc(char *name,void **ppInfo){

	//[U[`֐
	*ppInfo=(void *)GetSubHash(name);
	if(*ppInfo) return PROC_DEFAULT;

	//DLL֐
	*ppInfo=(void *)GetDeclareHash(name);
	if(*ppInfo) return PROC_DLL;

	//RpCߍ݌^
	*ppInfo=(void *)(_int64)GetFunctionFromName(name);
	if(*ppInfo) return PROC_BUILTIN;

	//֐|C^
	int type;
	LONG_PTR lpIndex;
	type=GetVarType(name,&lpIndex,0);
	if(type==DEF_PTR_PROC) return PROC_PTR;

	return 0;
}

void SplitObjectName(const char *name,char *ObjectName,int *pRefType){
	int i4;
	for(i4=lstrlen(name)-1;i4>=0;i4--){
		if(name[i4]=='.'||(name[i4]==1&&name[i4+1]==ESC_PSMEM))
			break;
	}
	if(i4==-1) ObjectName[0]=0;
	else{
		//Qƃ^Cv𔻕
		if(name[i4]=='.') *pRefType=DEF_OBJECT;
		else *pRefType=DEF_PTR_OBJECT;

		if(i4==0) GetWithName(ObjectName);
		else{
			memcpy(ObjectName,name,i4);
			ObjectName[i4]=0;
		}
	}
}
bool SplitMemberName( const char *desc, char *object, char *member ){
	int i;
	for(i=lstrlen(desc)-1;i>=0;i--){
		if(desc[i]=='.'||(desc[i]==1&&desc[i+1]==ESC_PSMEM))
			break;
	}
	if(i==-1) return false;
	else{
		if(desc[i]=='.')
			lstrcpy(member,desc+i+1);
		else
			lstrcpy(member,desc+i+2);

		if( object ){
			lstrcpy( object, desc );
			object[i]=0;
		}
	}

	return true;
}
int GetReturnTypeOfProc(int idProc,void *pInfo,char *name,char *Parameter,LONG_PTR *plpRetIndex){
	int ret_type;

	if(idProc==PROC_DEFAULT){
		/////////////////////
		// [U[`֐
		/////////////////////

		SUBINFO *psi;
		psi=(SUBINFO *)pInfo;

		//GetSubHashŃG[񎦂sꂽꍇ
		if(psi==(SUBINFO *)-1) return -1;


		//IuWFNg擾
		char ObjectName[VN_SIZE];
		int RefType;
		SplitObjectName(name,ObjectName,&RefType);


		////////////////////////
		// I[o[[h
		////////////////////////

		SUBINFO **ppsi;
		int num;
		ppsi=GetOverloadSubHash(name,&num);
		if(num){
			//I[o[[h
			psi=OverloadSolutionWithStrParam(name,ppsi,num,Parameter,ObjectName,NULL);
			HeapDefaultFree(ppsi);

			if(!psi) return 0;
		}


		ret_type=psi->ReturnType;
		*plpRetIndex=psi->u.ReturnIndex;
	}
	else if(idProc==PROC_DLL){
		/////////////////////////
		// DLL֐
		/////////////////////////
		DECLAREINFO *pdi;
		pdi=(DECLAREINFO *)pInfo;

		ret_type=pdi->ReturnType;
		*plpRetIndex=pdi->u.ReturnIndex;
	}
	else if(idProc==PROC_BUILTIN){
		/////////////////////////
		// gݍ݊֐
		/////////////////////////
		int FuncId;
		FuncId=(int)(_int64)pInfo;

		ret_type=GetFunctionType(FuncId);
		*plpRetIndex=-1;
	}
	else if(idProc==PROC_PTR){
		/////////////////
		// ֐|C^
		/////////////////

		LONG_PTR lpIndex;
		GetVarType(name,&lpIndex,0);

		extern PROCPTRINFO *pProcPtrInfo;
		ret_type=pProcPtrInfo[lpIndex].ReturnType;
		*plpRetIndex=pProcPtrInfo[lpIndex].u.ReturnIndex;
	}

	return ret_type;
}
BOOL GetReturnTypeOfPropertyMethod(char *variable,char *RightSide,TYPEINFO *pRetTypeInfo){
	//vpeBp̃\bhĂяo

	//zvf擾
	char VarName[VN_SIZE],ArrayElements[VN_SIZE];
	GetArrayElement(variable,VarName,ArrayElements);

	//IuWFNg擾
	char ObjectName[VN_SIZE];
	int RefType;
	SplitObjectName(VarName,ObjectName,&RefType);

	//I[o[[hp̊֐Xg쐬
	SUBINFO **ppsi;
	int num;
	ppsi=GetOverloadSubHash(VarName,&num);
	if(num==0){
		return 0;
	}

	//p[^𐮔
	char *Parameter;
	Parameter=(char *)HeapAlloc(hHeap,0,lstrlen(ArrayElements)+lstrlen(RightSide)+32);
	lstrcpy(Parameter,ArrayElements);
	if(RightSide){
		if(Parameter[0]&&RightSide[0]) lstrcat(Parameter,",");
		lstrcat(Parameter,RightSide);
	}

	//I[o[[h
	SUBINFO *psi;
	psi=OverloadSolutionWithStrParam(VarName,ppsi,num,Parameter,ObjectName,NULL);
	HeapDefaultFree(ppsi);

	if(psi){
		if(pRetTypeInfo){
			pRetTypeInfo->type=psi->ReturnType;
			pRetTypeInfo->u.lpIndex=psi->u.ReturnIndex;
		}
	}

	return 1;
}

//CfNTigetterj̖߂l擾
bool GetReturnTypeOfIndexerGetterProc(CClass *pobj_Class,TYPEINFO &RetTypeInfo){
	SUBINFO **ppsi;
	int num;
	ppsi=pobj_Class->GetOperatorSubInfo(CALC_ARRAY_GET,num);
	if(num==0){
		HeapDefaultFree(ppsi);

		return false;
	}

	RetTypeInfo.type = ppsi[0]->ReturnType;
	RetTypeInfo.u.lpIndex = ppsi[0]->u.ReturnIndex;

	HeapDefaultFree(ppsi);

	return true;
}


void AddDeclareData(char *buffer,int NowLine){
	extern HANDLE hHeap;
	int i,i2,i3,i4,sw,IsFunction;
	char temporary[VN_SIZE];

	i=0;

	DWORD dwType;
	BOOL bCdecl=0;

	//Static/Dynamic
	if(buffer[i]==ESC_STATIC){
		dwType=DECLARE_STATIC;
		i++;
	}
	else dwType=DECLARE_DYNAMIC;

	//Sub/Function
	if(buffer[i]==ESC_SUB) IsFunction=0;
	else if(buffer[i]==ESC_FUNCTION) IsFunction=1;
	else{
		SetError(1,NULL,NowLine);
		return;
	}
	i++;

	//vV[W
	for(i2=0;;i++,i2++){
		if(buffer[i]==1&&buffer[i+1]==ESC_CDECL){
			bCdecl=1;

			i+=2;
			temporary[i2]=0;
			break;
		}
		if(buffer[i]==','){
			temporary[i2]=0;
			break;
		}
		if(buffer[i]=='\0'){
			SetError(1,NULL,NowLine);
			return;
		}
		temporary[i2]=buffer[i];
	}

	//[U[`֐Ƃ̏d`FbN
	if(GetSubHash(temporary)){
		SetError(15,temporary,NowLine);
		return;
	}


	/////////////////////////////////
	// i[ʒuvZpciɃZbg
	/////////////////////////////////

	//nbVl擾
	int key;
	key=hash_default(temporary);

	extern DECLAREINFO **ppDeclareHash;
	DECLAREINFO *pdi;
	if(ppDeclareHash[key]){
		pdi=ppDeclareHash[key];
		while(1){
			if(lstrcmpi(pdi->name,temporary)==0){
				//dG[
				SetError(15,temporary,NowLine);
				return;
			}

			if(pdi->pNextData==0){
				pdi->pNextData=(DECLAREINFO *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,sizeof(DECLAREINFO));
				break;
			}
			pdi=pdi->pNextData;
		}
		pdi=pdi->pNextData;
	}
	else{
		ppDeclareHash[key]=(DECLAREINFO *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,sizeof(DECLAREINFO));
		pdi=ppDeclareHash[key];
	}

	pdi->dwType=dwType;
	pdi->bCdecl=bCdecl;

	pdi->name=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
	lstrcpy(pdi->name,temporary);
	i++;

	//Cu
	if(buffer[i]!='\"'){
		SetError(1,NULL,NowLine);
		return;
	}
	for(i++,i2=0;;i++,i2++){
		if(buffer[i]=='\"'){
			temporary[i2]=0;
			break;
		}
		if(buffer[i]=='\0'){
			SetError(1,NULL,NowLine);
			return;
		}
		temporary[i2]=buffer[i];
	}
	CharUpper(temporary);
	if(!strstr(temporary,".")){
		if(pdi->dwType==DECLARE_STATIC) lstrcat(temporary,".LIB");
		else{
			lstrcat(temporary,".DLL");
			if(lstrlen(temporary)>=16){
				SetError(7,NULL,NowLine);
				return;
			}
		}
	}
	pdi->file=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
	lstrcpy(pdi->file,temporary);
	i++;

	if(buffer[i]==','){
		i++;
		if(buffer[i]!='\"'){
			SetError(1,NULL,NowLine);
			return;
		}
		for(i++,i2=0;;i++,i2++){
			if(buffer[i]=='\"'){
				temporary[i2]=0;
				break;
			}
			if(buffer[i]=='\0'){
				SetError(1,NULL,NowLine);
				return;
			}
			temporary[i2]=buffer[i];
		}
		pdi->alias=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
		lstrcpy(pdi->alias,temporary);
		i++;
	}
	else{
		pdi->alias=(char *)HeapAlloc(hHeap,0,lstrlen(pdi->name)+1);
		lstrcpy(pdi->alias,pdi->name);
	}

	//p[^̎n߂̃JbR
	if(buffer[i]!='('){
		SetError(1,NULL,NowLine);
		return;
	}
	i++;

	pdi->pParmInfo=(PARAMETER_INFO *)HeapAlloc(hHeap,0,1);

	//ep[^
	for(i3=0;;i3++){
		if(buffer[i]==')') break;

		pdi->pParmInfo=(PARAMETER_INFO *)HeapReAlloc(hHeap,0,pdi->pParmInfo,(i3+1)*sizeof(PARAMETER_INFO));

		//ByVal
		if(buffer[i]==1&&buffer[i+1]==ESC_BYVAL){
			pdi->pParmInfo[i3].bByVal=1;
			i+=2;
		}
		else if(buffer[i]==1&&buffer[i+1]==ESC_BYREF){
			pdi->pParmInfo[i3].bByVal=0;
			i+=2;
		}
		else pdi->pParmInfo[i3].bByVal=1;

		//ϐ͖itemporary̕ϐ͌^錾f̂߁j
		sw=0;
		for(i2=0;;i++,i2++){
			if(buffer[i]=='('){
				if(!sw) sw=1;

				i4=GetStringInPare(temporary+i2,buffer+i);
				i2+=i4-1;
				i+=i4-1;
				continue;
			}
			if(buffer[i]=='['){
				if(!sw) sw=1;

				i4=GetStringInBracket(temporary+i2,buffer+i);
				i2+=i4-1;
				i+=i4-1;
				continue;
			}
			if(!IsVariableChar(buffer[i])){
				temporary[i2]=0;
				break;
			}
			temporary[i2]=buffer[i];
		}
		if(lstrcmp(temporary,"...")==0) pdi->pParmInfo[i3].type=DEF_ELLIPSE;
		else{
			//^
			if(buffer[i]==1&&buffer[i+1]==ESC_AS){
				i+=2;
				for(i2=0;;i++,i2++){
					if(!(IsVariableChar(buffer[i])||buffer[i]=='*')){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=buffer[i];
				}
				pdi->pParmInfo[i3].type=GetTypeFixed(temporary,&pdi->pParmInfo[i3].u.index);
			}
			else{
				pdi->pParmInfo[i3].type=GetTypeFromSimpleName(temporary);
				SetError(-103,temporary,NowLine);
			}

			if(sw){
				//z|C^nƂ
				pdi->pParmInfo[i3].type=GetPtrType(pdi->pParmInfo[i3].type,pdi->pParmInfo[i3].u.index);
			}
		}

		//O̓_~[igpȂ߁j
		pdi->pParmInfo[i3].name="";

		//\̂̏ꍇ̓G[`FbN
		if(pdi->pParmInfo[i3].type==-1) SetError(3,temporary,NowLine);
		if(pdi->pParmInfo[i3].type==DEF_OBJECT){
			if(pdi->pParmInfo[i3].bByVal) pdi->pParmInfo[i3].type=DEF_LONG;//SetError(28,temporary,NowLine);
		}

		//\̃AhX̋󔒕
		while(buffer[i]==' ') i++;

		if(buffer[i]==','){
			i++;
			continue;
		}
		else if(buffer[i]==')') continue;
		else{
			SetError(1,NULL,NowLine);
			break;
		}
	}
	pdi->ParmNum=i3;

	//߂l
	i++;
	if(buffer[i]==1&&buffer[i+1]==ESC_AS){
		if(IsFunction==0) SetError(1,NULL,NowLine);
		i+=2;
		pdi->ReturnType=GetTypeFixed(buffer+i,&pdi->u.ReturnIndex);
		if(pdi->ReturnType==-1) SetError(3,buffer+i,NowLine);
		if(pdi->ReturnType==DEF_OBJECT) SetError(40,NULL,NowLine);
	}
	else if(buffer[i]) SetError(1,NULL,NowLine);
	else pdi->ReturnType=-1;

	pdi->pos=NowLine;
}

BOOL CompareParameter(PARAMETER_INFO *ppi1,int pi_num1,PARAMETER_INFO *ppi2,int pi_num2){
	if(pi_num1!=pi_num2) return 1;

	int i;
	for(i=0;i<pi_num1;i++){
		if(ppi1[i].type!=ppi2[i].type){

			if(ppi1[i].bByVal==0&&ppi1[i].type==DEF_ANY&&
				ppi2[i].bByVal==1&&IsPtrType(ppi2[i].type)||
				ppi1[i].bByVal==1&&IsPtrType(ppi1[i].type)&&
				ppi2[i].bByVal==0&&ppi2[i].type==DEF_ANY){
					/* ByRef var As Any
							
						var As VoidPtr
						͓
					*/
					continue;
			}

			return 1;
		}
		else{
			if(NATURAL_TYPE(ppi1[i].type)==DEF_OBJECT){
				if(ppi1[i].u.index!=ppi2[i].u.index) return 1;
			}
		}
	}

	return 0;
}
SUBINFO *AddSubData(char *buffer,int NowLine,BOOL bVirtual,CClass *pobj_c,BOOL bStatic){
	int i,i2,i3,sw;
	DWORD dwType;
	char temporary[8192],temp2[VN_SIZE];

	i=1;
	if(buffer[i]==ESC_SUB) dwType=SUBTYPE_SUB;
	else if(buffer[i]==ESC_FUNCTION) dwType=SUBTYPE_FUNCTION;
	else if(buffer[i]==ESC_MACRO) dwType=SUBTYPE_MACRO;

	i++;

	BOOL bExport=0,bCdecl=0;
	while(1){
		if(buffer[i]==1&&buffer[i+1]==ESC_EXPORT&&bExport==0){
			bExport=1;

			i+=2;
		}
		else if(buffer[i]==1&&buffer[i+1]==ESC_CDECL&&bCdecl==0){
			bCdecl=1;

			i+=2;
		}
		else break;
	}

	i2=0;
	if(buffer[i]==1&&buffer[i+1]==ESC_OPERATOR){
		if(!pobj_c){
			SetError(126,NULL,NowLine);
			return 0;
		}

		//Iy[^̏ꍇ
		temporary[i2++]=buffer[i++];
		temporary[i2++]=buffer[i++];

		int iCalcId;
		if(buffer[i]=='='&&buffer[i+1]=='='){
			iCalcId=CALC_EQUAL;
			i3=2;
		}
		else if(buffer[i]=='='){
			iCalcId=CALC_SUBSITUATION;
			i3=1;
		}
		else if(buffer[i]=='('){
			iCalcId=CALC_AS;
			i3=0;
		}
		else if(buffer[i]=='['&&buffer[i+1]==']'&&buffer[i+2]=='='){
			iCalcId=CALC_ARRAY_SET;
			i3=3;
		}
		else if(buffer[i]=='['&&buffer[i+1]==']'){
			iCalcId=CALC_ARRAY_GET;
			i3=2;
		}
		else{
			iCalcId=GetCalcId(buffer+i,&i3);
			i3++;
		}
		if(!iCalcId){
			SetError(1,NULL,NowLine);
			return 0;
		}
		temporary[i2++]=iCalcId;
		temporary[i2]=0;

		i+=i3;
	}
	else{
		if(pobj_c){
			//NXȍꍇAfXgN^ɂ~tƂl
			if(buffer[i]=='~'){
				temporary[i2]='~';
				i++;
				i2++;
			}
		}

		for(;;i++,i2++){
			if(!IsVariableChar(buffer[i])){
				temporary[i2]=0;
				break;
			}
			temporary[i2]=buffer[i];
		}
	}

	if(dwType==SUBTYPE_MACRO){
		//啶ɕϊ
		CharUpper(temporary);

		//}N֐̏ꍇ͖OXgɒǉ
		extern char **ppMacroNames;
		extern int MacroNum;
		ppMacroNames=(char **)HeapReAlloc(hHeap,0,ppMacroNames,(MacroNum+1)*sizeof(char *));
		ppMacroNames[MacroNum]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
		lstrcpy(ppMacroNames[MacroNum],temporary);
		MacroNum++;
	}

	if(!pobj_c){
		//NXoȊȌꍇ̂
		//d`FbN

		if(GetDeclareHash(temporary)){
			SetError(15,temporary,NowLine);
			return 0;
		}
	}

	extern int SubNum;
	SubNum++;

	SUBINFO *psi;
	psi=(SUBINFO *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,sizeof(SUBINFO));

	//NX
	psi->pobj_ParentClass=pobj_c;

	//ID
	static int id_base=0;
	psi->id=(id_base++);

	//֐
	psi->name=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
	lstrcpy(psi->name,temporary);

	//\[XR[ḧʒu
	psi->address=NowLine;

	psi->bExport=bExport;
	psi->bCdecl=bCdecl;
	psi->bVirtual=bVirtual;
	if(bExport) psi->bUse=1;
	else psi->bUse=0;
	psi->bCompile=0;
	psi->bSystem=0;

	psi->dwType=dwType;


	if(psi->dwType==SUBTYPE_FUNCTION){
		///////////////////
		// ߂l擾
		///////////////////

		psi->isReturnRef = false;

		if(pobj_c){
			if(lstrcmp(psi->name,pobj_c->name)==0||
				psi->name[0]=='~'){
				//NX̃RXgN^AfXgN^Function`̏ꍇ̓G[
				SetError(115,NULL,NowLine);
			}
		}


		i2=lstrlen(buffer)-2;

		int sw_as=0;
		for(;i2>0;i2--){
			if(buffer[i2]==')') break;

			if(buffer[i2]==1&&buffer[i2+1]==ESC_AS){
				if( buffer[i2-2] == 1 && buffer[i2-1] == ESC_BYREF ){
					//Qƌ^
					psi->isReturnRef = true;
				}

				i2+=2;
				i3=0;
				while(buffer[i2]=='*') temporary[i3++]=buffer[i2++];
				for(;;i2++,i3++){
					if(!IsVariableChar(buffer[i2])){
						temporary[i3]=0;
						break;
					}
					temporary[i3]=buffer[i2];
				}
				psi->ReturnType=GetTypeFixed(temporary,&psi->u.ReturnIndex);
				if(psi->ReturnType==-1) SetError(3,temporary,NowLine);

				sw_as=1;
				break;
			}
		}

		if(!sw_as){
			SetError(-104,psi->name,NowLine);

			psi->ReturnType=DEF_DOUBLE;
		}
	}
	else{
		//߂lȂSub`
		psi->ReturnType=-1;
		psi->u.ReturnIndex=-1;
	}



	psi->pParmInfo=(PARAMETER_INFO *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,sizeof(PARAMETER_INFO)*2);
	psi->ParmNum=0;

	//p[^
	if(buffer[i]!='('){
		SetError(1,NULL,NowLine);
		return 0;
	}
	i++;
	if(buffer[i]!=')'&&pobj_c){
		//NX̃o֐̏ꍇ̂݁AfXgN^Ƀp[^ꍇɃG[
		if(psi->name[0]=='~'){
			SetError(114,NULL,NowLine);
			i=JumpStringInPare(buffer,i);
		}
	}
	while(1){
		if(buffer[i]==')') break;

		psi->pParmInfo=(PARAMETER_INFO *)HeapReAlloc(hHeap,0,psi->pParmInfo,(psi->ParmNum+1)*sizeof(PARAMETER_INFO));

		//ByVal
		if(buffer[i]==1&&buffer[i+1]==ESC_BYVAL){
			psi->pParmInfo[psi->ParmNum].bByVal=1;
			i+=2;
		}
		else if(buffer[i]==1&&buffer[i+1]==ESC_BYREF){
			psi->pParmInfo[psi->ParmNum].bByVal=0;
			i+=2;
		}
		else psi->pParmInfo[psi->ParmNum].bByVal=1;

		//p[^
		sw=0;
		for(i2=0;;i++,i2++){
			if(buffer[i]=='('){
				if(!sw) sw=1;

				i3=GetStringInPare(temporary+i2,buffer+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(buffer[i]=='['){
				if(!sw) sw=1;

				i3=GetStringInBracket(temporary+i2,buffer+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(!IsVariableChar(buffer[i])){
				temporary[i2]=0;
				break;
			}
			temporary[i2]=buffer[i];
		}
		if(sw){
			//zp[^
			if(psi->pParmInfo[psi->ParmNum].bByVal) SetError(29,NULL,NowLine);
			psi->pParmInfo[psi->ParmNum].bArray=1;

			if((temporary[i2-2]=='('&&temporary[i2-1]==')')||
				(temporary[i2-2]=='['&&temporary[i2-1]==']')){
				psi->pParmInfo[psi->ParmNum].SubScripts[0]=LONG_MAX;
				psi->pParmInfo[psi->ParmNum].SubScripts[1]=-1;

				temporary[i2-2]=0;
			}
			else{
				GetArrange(temporary,temp2,psi->pParmInfo[psi->ParmNum].SubScripts);
				lstrcpy(temporary,temp2);
			}

			i2=lstrlen(temporary);
		}
		else{
			psi->pParmInfo[psi->ParmNum].bArray=0;
			psi->pParmInfo[psi->ParmNum].SubScripts[0]=-1;
		}
		psi->pParmInfo[psi->ParmNum].name=(char *)HeapAlloc(hHeap,0,i2+1);
		lstrcpy(psi->pParmInfo[psi->ParmNum].name,temporary);

		//^
		if(buffer[i]==1&&buffer[i+1]==ESC_AS){
			i+=2;

			i2=0;
			while(buffer[i]=='*'){
				temporary[i2]=buffer[i];
				i++;
				i2++;
			}
			for(;;i++,i2++){
				if(!IsVariableChar(buffer[i])){
					if(buffer[i]==1&&(buffer[i+1]==ESC_FUNCTION||buffer[i+1]==ESC_SUB)){
						temporary[i2++]=buffer[i++];
						temporary[i2]=buffer[i];
						continue;
					}
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}

			psi->pParmInfo[psi->ParmNum].type=
				GetTypeFixed(temporary,&psi->pParmInfo[psi->ParmNum].u.index);

			if(temporary[0]=='*'&&
				temporary[1]==1&&
				(temporary[2]==ESC_FUNCTION||temporary[2]==ESC_SUB)){
				if(buffer[i]!='('){
					SetError(10,temporary,NowLine);
					return 0;
				}
				i3=GetStringInPare(temporary+i2,buffer+i);
				i+=i3;
				i2+=i3;

				if(temporary[2]==ESC_FUNCTION&&buffer[i]==1&&buffer[i+1]==ESC_AS){
					temporary[i2++]=buffer[i++];
					temporary[i2++]=buffer[i++];
					for(;;i++,i2++){
						if(!IsVariableChar(buffer[i])){
							temporary[i2]=0;
							break;
						}
						temporary[i2]=buffer[i];
					}
				}
			}
			else{
				//TypeDefÕx[X^擾
				GetOriginalTypeName(temporary);
			}

			if(psi->pParmInfo[psi->ParmNum].type==-1){
				SetError(3,temporary,NowLine);
				psi->pParmInfo[psi->ParmNum].type=DEF_PTR_VOID;
			}

			/*i\̃p[^lQƂƂēnĂ悢̂IHj
			if(psi->pParmInfo[psi->ParmNum].type==DEF_OBJECT){
				if(psi->pParmInfo[psi->ParmNum].bByVal) SetError(28,temporary,NowLine);
			}*/
		}
		else{
			psi->pParmInfo[psi->ParmNum].type=GetTypeFromSimpleName(temporary);
			SetError(-103,temporary,NowLine);
		}

		if(psi->pParmInfo[psi->ParmNum].type==DEF_PTR_PROC){
			//֐|C^̏ꍇ
			psi->pParmInfo[psi->ParmNum].u.index=AddProcPtrInfo(temporary+3,temporary[2]);
		}

		//p[^̐XV
		psi->ParmNum++;

		if(buffer[i]==','){
			i++;
			continue;
		}
		else if(buffer[i]==')') continue;
		else{
			SetError(1,NULL,NowLine);
			return 0;
		}
	}
	psi->SecondParmNum=psi->ParmNum;
	i++;
	if(buffer[i]=='('){
		i++;
		while(1){
			if(buffer[i]==')') break;

			psi->pParmInfo=(PARAMETER_INFO *)HeapReAlloc(hHeap,0,psi->pParmInfo,(psi->ParmNum+1)*sizeof(PARAMETER_INFO));

			//ByVal
			if(buffer[i]==1&&buffer[i+1]==ESC_BYVAL){
				psi->pParmInfo[psi->ParmNum].bByVal=1;
				i+=2;
			}
			else if(buffer[i]==1&&buffer[i+1]==ESC_BYREF){
				psi->pParmInfo[psi->ParmNum].bByVal=0;
				i+=2;
			}
			else psi->pParmInfo[psi->ParmNum].bByVal=1;

			//p[^
			sw=0;
			for(i2=0;;i++,i2++){
				if(buffer[i]=='('){
					if(!sw) sw=1;

					i3=GetStringInPare(temporary+i2,buffer+i);
					i2+=i3-1;
					i+=i3-1;
					continue;
				}
				if(buffer[i]=='['){
					if(!sw) sw=1;

					i3=GetStringInBracket(temporary+i2,buffer+i);
					i2+=i3-1;
					i+=i3-1;
					continue;
				}
				if(!IsVariableChar(buffer[i])){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			if(sw){
				//zp[^
				if(psi->pParmInfo[psi->ParmNum].bByVal) SetError(29,NULL,NowLine);
				psi->pParmInfo[psi->ParmNum].bArray=1;

				if((temporary[i2-2]=='('&&temporary[i2-1]==')')||
					(temporary[i2-2]=='['&&temporary[i2-1]==']')){
					psi->pParmInfo[psi->ParmNum].SubScripts[0]=LONG_MAX;
					psi->pParmInfo[psi->ParmNum].SubScripts[1]=-1;

					temporary[i2-2]=0;
				}
				else{
					GetArrange(temporary,temp2,psi->pParmInfo[psi->ParmNum].SubScripts);
					lstrcpy(temporary,temp2);
				}

				i2=lstrlen(temporary);
			}
			else{
				psi->pParmInfo[psi->ParmNum].bArray=0;
				psi->pParmInfo[psi->ParmNum].SubScripts[0]=-1;
			}
			psi->pParmInfo[psi->ParmNum].name=(char *)HeapAlloc(hHeap,0,i2+1);
			lstrcpy(psi->pParmInfo[psi->ParmNum].name,temporary);

			//^
			if(buffer[i]==1&&buffer[i+1]==ESC_AS){
				i+=2;
				i2=0;
				while(buffer[i]=='*'){
					temporary[i2]=buffer[i];
					i++;
					i2++;
				}
				for(;;i++,i2++){
					if(!IsVariableChar(buffer[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=buffer[i];
				}
				psi->pParmInfo[psi->ParmNum].type=
					GetTypeFixed(temporary,&psi->pParmInfo[psi->ParmNum].u.index);
				if(psi->pParmInfo[psi->ParmNum].type==-1) SetError(3,temporary,NowLine);
			}
			else{
				psi->pParmInfo[psi->ParmNum].type=GetTypeFromSimpleName(temporary);
				SetError(-103,temporary,NowLine);
			}

			psi->ParmNum++;

			if(buffer[i]==','){
				i++;
				continue;
			}
			else if(buffer[i]==')') continue;
			else{
				SetError(1,NULL,NowLine);
				return 0;
			}
		}
		i++;
	}

	//Ap[^̈擾i_System_LocalThisA_System_ReturnValuel2mۂj
	psi->pRealParmInfo=(PARAMETER_INFO *)HeapAlloc(hHeap,0,(psi->ParmNum+2)*sizeof(PARAMETER_INFO));
	psi->RealParmNum=0;

	if(pobj_c&&bStatic==0){
		i = psi->RealParmNum;

		//IuWFNgȍꍇ́Ap[^_System_LocalThisnpƂėp
		psi->pRealParmInfo[i].name = "_System_LocalThis";
		psi->pRealParmInfo[i].type=DEF_PTR_VOID;
		psi->pRealParmInfo[i].u.index=-1;
		psi->pRealParmInfo[i].bByVal=1;
		psi->pRealParmInfo[i].bArray=0;
		psi->pRealParmInfo[i].SubScripts[0]=-1;

		psi->RealParmNum++;
	}

	if(psi->ReturnType==DEF_OBJECT && psi->isReturnRef == false){
		i = psi->RealParmNum;

		//̃IuWFNg߂lƂĎꍇ
		//p[^iThis|C^̏ꍇ͑p[^j߂lp̎QƐ錾ɂ

		if(psi->name[0]==1&&psi->name[1]==ESC_OPERATOR)
			psi->pRealParmInfo[i].name="_System_ReturnValue";
		else psi->pRealParmInfo[i].name=psi->name;
		psi->pRealParmInfo[i].type=DEF_OBJECT;
		psi->pRealParmInfo[i].u.index=psi->u.ReturnIndex;
		psi->pRealParmInfo[i].bByVal=0;
		psi->pRealParmInfo[i].bArray=0;
		psi->pRealParmInfo[i].SubScripts[0]=-1;
		
		psi->RealParmNum++;
	}

	//p[^Rs[
	for( i = 0; i < psi->ParmNum; i++, psi->RealParmNum++ ){
		psi->pRealParmInfo[psi->RealParmNum]=psi->pParmInfo[i];
	}


	/////////////////////////////////
	// nbVf[^ɒǉ
	/////////////////////////////////

	int key;
	key=hash_default(psi->name);

	extern SUBINFO **ppSubHash;
	if(ppSubHash[key]){
		SUBINFO *psi2;
		psi2=ppSubHash[key];
		while(1){
			if(pobj_c==psi2->pobj_ParentClass){
				//dG[`FbNs
				if(lstrcmp(psi2->name,psi->name)==0){
					if(CompareParameter(psi2->pParmInfo,psi2->ParmNum,psi->pParmInfo,psi->ParmNum)==0){
						SetError(15,psi->name,NowLine);
						return 0;
					}
				}
			}

			if(psi2->pNextData==0) break;
			psi2=psi2->pNextData;
		}
		psi2->pNextData=psi;
	}
	else{
		ppSubHash[key]=psi;
	}

	return psi;
}

void GetSubInfo(void){	//Tu[`擾
	extern HANDLE hHeap;
	extern char *basbuf;
	int i,i2,i3;
	char temporary[8192];

	//DeclareiDLL֐j
	extern DECLAREINFO **ppDeclareHash;
	ppDeclareHash=(DECLAREINFO **)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,MAX_HASH*sizeof(DECLAREINFO *));

	//Tu[`i[U[`j
	extern SUBINFO **ppSubHash;
	extern int SubNum;
	ppSubHash=(SUBINFO **)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,MAX_HASH*sizeof(SUBINFO *));
	SubNum=0;

	//}N֐̖OXg
	extern char **ppMacroNames;
	extern int MacroNum;
	ppMacroNames=(char **)HeapAlloc(hHeap,0,1);
	MacroNum=0;

	i=-1;
	while(1){
		i++;

		if(basbuf[i]==1&&(basbuf[i+1]==ESC_CLASS||basbuf[i+1]==ESC_INTERFACE)){
			/*	Class ` End Class
				Interface ` End Interface
				щz			*/
			i3=GetEndXXXCommand(basbuf[i+1]);
			for(i+=2,i2=0;;i++,i2++){
				if(basbuf[i]=='\0') break;
				if(basbuf[i]==1&&basbuf[i+1]==(char)i3){
					i++;
					break;
				}
			}
			if(basbuf[i]=='\0') break;
			continue;
		}

		if(basbuf[i]==1&&basbuf[i+1]==ESC_DECLARE){
			for(i+=2,i2=0;;i2++,i++){
				if(basbuf[i]=='\n'){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=basbuf[i];
				if(basbuf[i]=='\0') break;
			}
			AddDeclareData(temporary,i);

			continue;
		}
		if(basbuf[i]==1&&(basbuf[i+1]==ESC_SUB||basbuf[i+1]==ESC_FUNCTION||basbuf[i+1]==ESC_MACRO)){
			for(i2=0;;i2++,i++){
				if(IsCommandDelimitation(basbuf[i])){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=basbuf[i];
				if(basbuf[i]=='\0') break;
			}
			AddSubData(temporary,i,0,0);

			continue;
		}

		//̍s
		for(;;i++){
			if(IsCommandDelimitation(basbuf[i])) break;
		}
		if(basbuf[i]=='\0') break;
	}

	////////////
	// ֐
	////////////

	sprintf(temporary,"%c%c_allrem()",1,ESC_SUB);
	AddSubData(temporary,0,0,0);

	sprintf(temporary,"%c%c_aullrem()",1,ESC_SUB);
	AddSubData(temporary,0,0,0);

	sprintf(temporary,"%c%c_allmul()",1,ESC_SUB);
	AddSubData(temporary,0,0,0);

	sprintf(temporary,"%c%c_alldiv()",1,ESC_SUB);
	AddSubData(temporary,0,0,0);

	sprintf(temporary,"%c%c_aulldiv()",1,ESC_SUB);
	AddSubData(temporary,0,0,0);

	sprintf(temporary,"%c%c_allshl()",1,ESC_SUB);
	AddSubData(temporary,0,0,0);

	sprintf(temporary,"%c%c_allshr()",1,ESC_SUB);
	AddSubData(temporary,0,0,0);

	sprintf(temporary,"%c%c_aullshr()",1,ESC_SUB);
	AddSubData(temporary,0,0,0);

	sprintf(temporary,"%c%c_System_InitStaticLocalVariables()",1,ESC_SUB);
	AddSubData(temporary,0,0,0);
}
void Delete_si(SUBINFO *psi){
	int i2;

	for(i2=0;i2<psi->ParmNum;i2++){
		HeapDefaultFree(psi->pParmInfo[i2].name);
	}
	HeapDefaultFree(psi->pRealParmInfo);
	if(psi->pParmInfo) HeapDefaultFree(psi->pParmInfo);
	psi->pRealParmInfo=0;
	psi->pParmInfo=0;

	if(psi->pNextData) Delete_si(psi->pNextData);

	HeapDefaultFree(psi->name);
	HeapDefaultFree(psi);
}
void DeleteSubInfo(SUBINFO **ppSubHash,char **ppMacroNames,int MacroNum){	//Tu[`̃
	int i;
	for(i=0;i<MAX_HASH;i++){
		if(!ppSubHash[i]) continue;

		Delete_si(ppSubHash[i]);
	}
	HeapDefaultFree(ppSubHash);

	//}N̖OXg
	if(ppMacroNames){
		for(i=0;i<MacroNum;i++){
			HeapDefaultFree(ppMacroNames[i]);
		}
		HeapDefaultFree(ppMacroNames);
	}
}
void Delete_di(DECLAREINFO *pdi){
	if(pdi->pParmInfo) HeapDefaultFree(pdi->pParmInfo);

	HeapDefaultFree(pdi->name);
	if(pdi->file) HeapDefaultFree(pdi->file);
	if(pdi->alias) HeapDefaultFree(pdi->alias);

	if(pdi->pNextData) Delete_di(pdi->pNextData);

	HeapDefaultFree(pdi);
}
void DeleteDeclareInfo(void){
	//DLL
	extern DECLAREINFO **ppDeclareHash;
	int i;
	for(i=0;i<MAX_HASH;i++){
		if(!ppDeclareHash[i]) continue;

		Delete_di(ppDeclareHash[i]);
	}
	HeapDefaultFree(ppDeclareHash);
}



///////////////////////
// ֐|C^̊Ǘ
///////////////////////

int AddProcPtrInfo(char *buffer,DWORD dwProcType){
	extern HANDLE hHeap;
	extern int cp;
	extern PROCPTRINFO *pProcPtrInfo;
	extern int ProcPtrInfoNum;
	int i,i2,i3,sw;
	PROCPTRINFO *pi;
	char temporary[VN_SIZE],temp2[VN_SIZE];

	pProcPtrInfo=(PROCPTRINFO *)HeapReAlloc(hHeap,0,pProcPtrInfo,(ProcPtrInfoNum+1)*sizeof(PROCPTRINFO));
	pi=&pProcPtrInfo[ProcPtrInfoNum];
	ProcPtrInfoNum++;

	pi->pParmInfo=(PARAMETER_INFO *)HeapAlloc(hHeap,0,1);
	pi->ParmNum=0;

	//buffer[0]'('ƂȂĂ
	i=1;

	while(1){
		if(buffer[i]==')') break;

		pi->pParmInfo=(PARAMETER_INFO *)HeapReAlloc(hHeap,0,pi->pParmInfo,(pi->ParmNum+1)*sizeof(PARAMETER_INFO));

		//ByVal
		if(buffer[i]==1&&buffer[i+1]==ESC_BYVAL){
			pi->pParmInfo[pi->ParmNum].bByVal=1;
			i+=2;
		}
		else if(buffer[i]==1&&buffer[i+1]==ESC_BYREF){
			pi->pParmInfo[pi->ParmNum].bByVal=0;
			i+=2;
		}
		else pi->pParmInfo[pi->ParmNum].bByVal=1;

		//p[^
		sw=0;
		for(i2=0;;i++,i2++){
			if(buffer[i]=='('){
				if(!sw) sw=1;

				i3=GetStringInPare(temporary+i2,buffer+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(buffer[i]=='['){
				if(!sw) sw=1;

				i3=GetStringInBracket(temporary+i2,buffer+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(!IsVariableChar(buffer[i])){
				temporary[i2]=0;
				break;
			}
			temporary[i2]=buffer[i];
		}
		pi->pParmInfo[pi->ParmNum].name=0;

		if(sw){
			//zp[^
			if(pi->pParmInfo[pi->ParmNum].bByVal) SetError(29,NULL,cp);
			pi->pParmInfo[pi->ParmNum].bArray=1;

			if((temporary[i2-2]=='('&&temporary[i2-1]==')')||
				(temporary[i2-2]=='['&&temporary[i2-1]==']')){
				pi->pParmInfo[pi->ParmNum].SubScripts[0]=LONG_MAX;
				pi->pParmInfo[pi->ParmNum].SubScripts[1]=-1;

				temporary[i2-2]=0;
			}
			else{
				GetArrange(temporary,temp2,pi->pParmInfo[pi->ParmNum].SubScripts);
				lstrcpy(temporary,temp2);
			}

			i2=lstrlen(temporary);
		}
		else{
			pi->pParmInfo[pi->ParmNum].bArray=0;
			pi->pParmInfo[pi->ParmNum].SubScripts[0]=-1;
		}

		//^
		if(buffer[i]==1&&buffer[i+1]==ESC_AS){
			i+=2;

			i2=0;
			while(buffer[i]=='*'){
				temporary[i2]=buffer[i];
				i++;
				i2++;
			}
			for(;;i++,i2++){
				if(!IsVariableChar(buffer[i])){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}

			pi->pParmInfo[pi->ParmNum].type=
				GetTypeFixed(temporary,&pi->pParmInfo[pi->ParmNum].u.index);
			if(pi->pParmInfo[pi->ParmNum].type==-1){
				SetError(3,temporary,cp);
				pi->pParmInfo[pi->ParmNum].type=DEF_PTR_VOID;
			}
			if(pi->pParmInfo[pi->ParmNum].type==DEF_OBJECT){
				if(pi->pParmInfo[pi->ParmNum].bByVal) SetError(28,temporary,cp);
			}
		}
		else{
			pi->pParmInfo[pi->ParmNum].type=GetTypeFromSimpleName(temporary);
			SetError(-103,temporary,cp);
		}

		pi->ParmNum++;

		if(buffer[i]==','){
			i++;
			continue;
		}
		else if(buffer[i]==')') continue;
		else{
			SetError(1,NULL,cp);
			return 0;
		}
	}
	i++;

	//߂l
	if(dwProcType==ESC_FUNCTION){
		if(buffer[i]==1&&buffer[i+1]==ESC_AS){
			i+=2;
			i2=0;
			if(buffer[i]=='*') temporary[i2++]=buffer[i++];
			for(;;i++,i2++){
				if(!IsVariableChar(buffer[i])){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			pi->ReturnType=GetTypeFixed(temporary,&pi->u.ReturnIndex);
			if(pi->ReturnType==-1) SetError(3,temporary,cp);
			if(pi->ReturnType==DEF_OBJECT) SetError(40,NULL,cp);
		}
		else pi->ReturnType=DEF_DOUBLE;
	}
	else pi->ReturnType=-1;

	return ProcPtrInfoNum-1;
}
void DeleteProcPtrInfo(void){
	extern PROCPTRINFO *pProcPtrInfo;
	extern int ProcPtrInfoNum;
	int i;

	for(i=0;i<ProcPtrInfoNum;i++){
		HeapDefaultFree(pProcPtrInfo[i].pParmInfo);
	}

	HeapDefaultFree(pProcPtrInfo);
}
