#include "stdafx.h"

#include <jenga/include/common/Environment.h>

#include <Source.h>
#include <Compiler.h>

#include "common.h"

//////////////////////////
// u[N|Cg
//////////////////////////

CDBBreakPoint *pobj_DBBreakPoint;

CFileBreakPoint::CFileBreakPoint(char *lpszFileName,int iLineNum){
	this->lpszFileName=(char *)HeapAlloc(hHeap,0,lstrlen(lpszFileName)+1);
	lstrcpy(this->lpszFileName,lpszFileName);

	piLine=(int *)HeapAlloc(hHeap,0,sizeof(int));
	piLine[0]=iLineNum;
	num=1;
}
CFileBreakPoint::~CFileBreakPoint(){
	HeapDefaultFree(lpszFileName);
	HeapDefaultFree(piLine);
}
void CFileBreakPoint::add(int iLineNum){
	piLine=(int *)HeapReAlloc(hHeap,0,piLine,(num+1)*sizeof(int));
	piLine[num]=iLineNum;
	num++;
}
void CFileBreakPoint::remove(int iLineNum){
	int i;
	for(i=0;i<num;i++){
		if(iLineNum==piLine[i]) break;
	}
	if(i==num) return;

	num--;
	for(;i<num;i++){
		piLine[i]=piLine[i+1];
	}
}

void CFileBreakPoint::update(char *nativeCodeBuffer)
{
	int FileNum;
	const IncludedFilesRelation *pIncludedFilesRelation = NULL;
	const BasicSource *pNowSource = NULL;
	BOOST_FOREACH( const BasicSource &source, compiler.GetObjectModule().GetSources() )
	{
		pIncludedFilesRelation = &source.GetIncludedFilesRelation();

		for(FileNum=0;FileNum<pIncludedFilesRelation->GetFileCounts();FileNum++)
		{
			if(lstrcmpi(pIncludedFilesRelation->GetFilePathFromFileNumber(FileNum).c_str(),lpszFileName)==0)
			{
				pNowSource = &source;
				break;
			}
		}
		if( FileNum == pIncludedFilesRelation->GetFileCounts() )
		{
			pIncludedFilesRelation = NULL;
		}
		else
		{
			break;
		}
	}

	if( !pIncludedFilesRelation )
	{
		Jenga::Throw( "CFileBreakPoint::updateŕsȏ" );
		return;
	}

	int i;
	for(i=0;;i++){
		if( pIncludedFilesRelation->GetFileNumber( i ) == FileNum
			|| pIncludedFilesRelation->GetFileNumber( i ) == -1 )
		{
			break;
		}
	}
	if( pIncludedFilesRelation->GetFileNumber( i ) == -1 )
	{
		return;
	}

	int FileBaseLine;
	FileBaseLine=i;

	int i2,nCount=0;
	for(i2=0;;i2++){
		if( pIncludedFilesRelation->GetFileNumber( FileBaseLine+i2 ) == -1 )
		{
			//\[XR[h̏I[s
			break;
		}

		if(i2==piLine[nCount]){
			extern SourceLines oldSourceLines;

loop:
			int tempCp = GetSourceCodeIndexFromLine( pNowSource->GetBuffer(), FileBaseLine+i2 );

			int i3;
			for(i3=0;i3<(int)oldSourceLines.size()-1;i3++){
				if(oldSourceLines[i3].GetSourceCodePos()==tempCp) break;
			}
			if(i3==oldSourceLines.size()-1){
				i2--;
				goto loop;
			}

			nativeCodeBuffer[oldSourceLines[i3].GetNativeCodePos()]=(char)0xCC;

			nCount++;
			if(nCount>=num) break;
		}
	}
}


CDBBreakPoint::CDBBreakPoint(){
	ppItem=(CFileBreakPoint **)HeapAlloc(hHeap,0,1);
	num=0;

	char *buffer;
	buffer=(char *)HeapAlloc(hHeap,0,65535);

	HANDLE hFile=CreateFile(
		( Jenga::Common::Environment::GetAppDir() + "\\ab_breakpoint.tmp" ).c_str(),
		GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile!=INVALID_HANDLE_VALUE){
		DWORD dwAccBytes;
		ReadFile(hFile,buffer,MAX_PATH,&dwAccBytes,NULL);
		CloseHandle(hFile);
		buffer[dwAccBytes]=0;
	}
	else buffer[0]=0;

	int i=0,i2;
	char szFilePath[MAX_PATH];
	while(buffer[i]){
		//t@CpX
		i=GetOneParameter(buffer,i,szFilePath);
		RemoveStringQuotes(szFilePath);

		while(buffer[i]!='\n'&&buffer[i]!='\0'){
			//sԍ
			char temporary[1024];
			i=GetOneParameter(buffer,i,temporary);
			i2=atoi(temporary);

			insert(szFilePath,i2);
		}

		while(buffer[i]=='\n') i++;

		if(buffer[i]=='\0') break;
	}

	HeapDefaultFree(buffer);
}
CDBBreakPoint::~CDBBreakPoint(){
	int i;
	for(i=0;i<num;i++){
		delete ppItem[i];
	}
	HeapDefaultFree(ppItem);
}
void CDBBreakPoint::insert(char *lpszFileName,int iLineNum){
	int i;
	for(i=0;i<num;i++){
		if(lstrcmpi(ppItem[i]->lpszFileName,lpszFileName)==0){
			ppItem[i]->add(iLineNum);
			return;
		}
	}

	if(i==num){
		ppItem=(CFileBreakPoint **)HeapReAlloc(hHeap,0,ppItem,(num+1)*sizeof(CFileBreakPoint *));
		ppItem[num]=new CFileBreakPoint(lpszFileName,iLineNum);
		num++;
	}
}
void CDBBreakPoint::remove(char *lpszFileName,int iLineNum){
	int i;
	for(i=0;i<num;i++){
		if(lstrcmpi(lpszFileName,ppItem[i]->lpszFileName)==0){
			ppItem[i]->remove(iLineNum);
			break;
		}
	}
	if(i==num) return;

	if(ppItem[i]->num==0){
		delete ppItem[i];

		num--;
		for(;i<num;i++){
			ppItem[i]=ppItem[i+1];
		}
	}
}

char *CDBBreakPoint::update(char *nativeCodeBuffer,int SizeOf_CodeSection){
	char *buffer;
	buffer=(char *)HeapAlloc(hHeap,0,SizeOf_CodeSection);
	memcpy(buffer,nativeCodeBuffer,SizeOf_CodeSection);

	int i;
	for(i=0;i<num;i++){
		ppItem[i]->update(buffer);
	}

	return buffer;
}
