#include "stdafx.h"

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

BOOL CalcTwoTerm_Logical(int idCalc,int *type,LONG_PTR *index_stack,int *pStackPointer){
	//value[sp-2] xor= value[sp-1]
	//xorZ

	int sp;
	sp=*pStackPointer;

	if(IsRealNumberType(type[sp-2])||IsRealNumberType(type[sp-1])){
		//ꂩ̍̂Ƃ
		SetError(45,"xor",cp);
		return 0;
	}

	int reg1,reg2;

	if(Is64Type(type[sp-2])||Is64Type(type[sp-1])){
		//////////////////////
		// 64rbgZ
		//////////////////////

		SetTowTermToReg_Whole64Calc(type,sp,&reg1,&reg2);

		if(idCalc==CALC_XOR){
			//xor reg1,reg2
			compiler.codeGenerator.op_xor_reg(sizeof(_int64),reg1,reg2);
		}
		else if(idCalc==CALC_OR){
			//or reg1,reg2
			compiler.codeGenerator.op_or_reg(sizeof(_int64),reg1,reg2);
		}
		else if(idCalc==CALC_AND){
			//and reg1,reg2
			compiler.codeGenerator.op_and_reg(sizeof(_int64),reg1,reg2);
		}
		else
		{
			throw;
		}

		if(reg1==REG_R14){
			//mov qword ptr[rsp+offset],r14     X^bNt[𗘗p
			pobj_sf->push(REG_R14);
		}

		sp--;
		type[sp-1]=NeutralizationType(type[sp-1],index_stack[sp-1],type[sp],index_stack[sp]);
	}
	else{
		//32rbgȉ̐Z

		SetTowTermToReg_Whole32Calc(type,sp,&reg1,&reg2);

		if(idCalc==CALC_XOR){
			//xor reg1,reg2
			compiler.codeGenerator.op_xor_reg(sizeof(long),reg1,reg2);
		}
		else if(idCalc==CALC_OR){
			//or reg1,reg2
			compiler.codeGenerator.op_or_reg(sizeof(long),reg1,reg2);
		}
		else if(idCalc==CALC_AND){
			//and reg1,reg2
			compiler.codeGenerator.op_and_reg(sizeof(long),reg1,reg2);
		}
		else
		{
			throw;
		}

		if(reg1==REG_R14){
			//mov qword ptr[rsp+offset],r14     X^bNt[𗘗p
			pobj_sf->push(REG_R14);
		}

		sp--;
		type[sp-1]=NeutralizationType(type[sp-1],index_stack[sp-1],type[sp],index_stack[sp]);
	}

	*pStackPointer=sp;
	return 1;
}

BOOL Calc_Not(int *type,int sp){
	//value[sp-1]=Not value[sp-1]
	//NOTZq

	if(IsRealNumberType(type[sp-1])){
		//̂Ƃ
		SetError(45,"Not",cp);
		return 0;
	}

	int reg;

	if( type[sp - 1] == DEF_BOOLEAN ){
		SetOneTermToReg_Whole32Calc(type[sp-1],&reg);

		if( reg != REG_RAX ){
			// raxZWX^Ƃėp邽߁AꎞIɑޔĂ

			//mov qword ptr[rsp+offset],rax     X^bNt[𗘗p
			pobj_sf->push(REG_RAX);
		}

		//cmp reg,0
		compiler.codeGenerator.op_cmp_value(Type(type[sp-1]).GetSize(),reg,0);

		//setne al
		compiler.codeGenerator.op_setne( REG_RAX );

		//and rax,000000FFh
		compiler.codeGenerator.op_and64_value(REG_RAX,(int)0xFF);

		//neg
		compiler.codeGenerator.op_neg( REG_RAX );

		//sbb rax, rax
		compiler.codeGenerator.op_sbb_RR( sizeof(_int64), REG_RAX, REG_RAX );

		//add rax, 1
		compiler.codeGenerator.op_add_RV( REG_RAX, 1 );

		if( reg != REG_RAX ){
			//mov reg,rax
			compiler.codeGenerator.op_mov_RR( reg, REG_RAX );

			//mov rax,qword ptr[rsp+offset]     X^bNt[𗘗p
			pobj_sf->pop(REG_RAX);
		}

		if(reg==REG_R14){
			//mov qword ptr[rsp+offset],r14     X^bNt[𗘗p
			pobj_sf->push(REG_R14);
		}
	}
	else if(type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
		SetOneTermToReg_Whole64Calc(type[sp-1],&reg);

		//not reg
		compiler.codeGenerator.op_not_reg(sizeof(_int64),reg);

		if(reg==REG_R14){
			//mov qword ptr[rsp+offset],r14     X^bNt[𗘗p
			pobj_sf->push(REG_R14);
		}
	}
	else if(IsWholeNumberType(type[sp-1])){
		SetOneTermToReg_Whole32Calc(type[sp-1],&reg);

		//not reg
		compiler.codeGenerator.op_not_reg(sizeof(long),reg);

		if(reg==REG_R14){
			//mov qword ptr[rsp+offset],r14     X^bNt[𗘗p
			pobj_sf->push(REG_R14);
		}
	}

	return 1;
}
