#include "common.h"

CMdiTextEdit::CMdiTextEdit( MDIINFO *pMdiInfo ){
	this->pMdiInfo = pMdiInfo;

	isModified = false;

	BaseNumOfUndoRedo = 0;

	pTextEditUndoState = (TEXTEDIT_UNDOSTATE *)HeapAlloc( hHeap, HEAP_ZERO_MEMORY, sizeof( TEXTEDIT_UNDOSTATE ) );
	pTextEditUndoState->NowPos = 0;
}
CMdiTextEdit::~CMdiTextEdit(){
	for( int i=0; i<MAX_UNDONUM; i++ ){
		if( pTextEditUndoState->Command[i] ){
			TextEdit_DeleteUndoData( pTextEditUndoState, i );
		}
	}
	HeapDefaultFree( pTextEditUndoState );
}

void CMdiTextEdit::Modify(){
	//ύX
	isModified = true;

	//^uɕύXAX^XNt
	pobj_MainTab->NofityModifyDocument( pMdiInfo->title );
}
void CMdiTextEdit::UnModify(){
	//ύXԉ
	isModified = false;

	//AX^XN\
	pobj_MainTab->NofityUnModifyDocument( pMdiInfo->title );

	//AhD[hD[̃x[Xԍ擾
	BaseNumOfUndoRedo = pTextEditUndoState->NowPos;
}
bool CMdiTextEdit::IsModified(){
	return isModified;
}

void CMdiTextEdit::NofityUndoRedoToModify(){
	if( BaseNumOfUndoRedo == pTextEditUndoState->NowPos ){
		//ύXȂ
		if( IsModified() ){
			UnModify();
		}
	}
	else{
		//ύX
		if( ! IsModified() ){
			Modify();
		}
	}
}
