#include "stdafx.h"

#include <jenga/include/smoothie/SmoothieException.h>

#include <Compiler.h>
#include <Type.h>

Compiler compiler;

void Compiler::StaticLink( ObjectModules &staticLibraries )
{
	BOOST_FOREACH( ObjectModule *pStaticLibrary, staticLibraries )
	{
		// ^
		pNowObjectModule->StaticLink( *pStaticLibrary );
	}
}

bool Compiler::StringToType( const string &typeName, Type &type ){
	type.SetIndex( -1 );


	/////////////////////////////////////////////////////////
	//  WFlNXT|[g 

	if( strstr( typeName.c_str(), "<" ) )
	{
		// WFlbNNXCX^X^̏ꍇ
		int i = 0;
		char className[VN_SIZE];
		GetIdentifierToken( className, typeName.c_str(), i );

		// WFlNXNX擾
		const CClass *pGenericClass = this->GetObjectModule().meta.GetClasses().Find( className );

		if( !pGenericClass )
		{
			return false;
		}

		if( typeName[i] != '<' )
		{
			Jenga::Throw( "StringToTypeŃWFlNX\̉͂Ɏs" );
		}

		GenericTypes genericTypes;
		while( true )
		{
			i++;

			char typeParameter[VN_SIZE];
			GetIdentifierToken( typeParameter, typeName.c_str(), i );

			// ^p[^̌^擾
			Type baseType;
			StringToType( typeParameter, baseType );

			genericTypes.push_back( GenericType( "(non support)", baseType ) );

			if( typeName[i] != ',' )
			{
				break;
			}
		}

		// {^Zbg
		type.SetBasicType( DEF_OBJECT );

		// gZbg
		type.SetClassPtr( pGenericClass );
		type.SetActualGenericTypes( genericTypes );

		return true;
	}

	//
	/////////////////////////////////////////////////////////


	if( typeName[0] == '*' ){
		if( typeName.size() >= 3
			&& typeName[1] == 1 && ( typeName[2] == ESC_FUNCTION || typeName[2] == ESC_SUB ) ){
				//֐|C^i*Functionj
				type.SetBasicType( DEF_PTR_PROC );
				type.SetIndex( this->GetObjectModule().meta.GetProcPointers().Add( typeName ) );
				return true;
		}

		const string &nextTypeName = typeName.substr( 1 );

		if( !StringToType( nextTypeName, type ) ){
			return false;
		}

		type.PtrLevelUp();

		return true;
	}

	{
		int basicType;
		if( Type::StringToBasicType( typeName, basicType ) ){
			// {^Ƃ
			type.SetBasicType( basicType );
			return true;
		}
	}

	// Object^Ƃ
	if( typeName == "Object" ){
		type.SetType( DEF_OBJECT, this->GetObjectModule().meta.GetClasses().GetObjectClassPtr() );
		return true;
	}

	// String^Ƃ
	if( typeName == "String" ){
		type.SetType( DEF_OBJECT, this->GetObjectModule().meta.GetClasses().GetStringClassPtr() );
		return true;
	}


	////////////////////
	// TypeDefꂽ^
	////////////////////
	int i=this->GetObjectModule().meta.GetTypeDefs().GetIndex( typeName );
	if(i!=-1){
		type = this->GetObjectModule().meta.GetTypeDefs()[i].GetBaseType();
		return true;
	}

	//NX
	const CClass *pobj_c = this->GetObjectModule().meta.GetClasses().Find( typeName );
	if(pobj_c){
		if( pobj_c->IsStructure() ){
			type.SetBasicType( DEF_STRUCT );
		}
		else{
			type.SetBasicType( DEF_OBJECT );
		}
		type.SetClassPtr( pobj_c );
		return true;
	}


	/////////////////////////////////////////////////////////
	//  WFlNXT|[g 

	// ^p[^
	if( this->pCompilingClass )
	{
		// NXɑ郁\bhRpCĂƂ
		int formalTypeIndex = this->pCompilingClass->GetFormalGenericTypeParameterIndex( typeName );
		if( formalTypeIndex != -1 )
		{
			// RpCNXɂWFlNXp̌^p[^̂Ƃ
			type.SetBasicType( DEF_TYPE_PARAMETER );
			type.SetClassPtr( &this->pCompilingClass->GetFormalGenericTypes()[formalTypeIndex].GetType().GetClass() );
			type.SetFormalTypeName( typeName );
			type.SetFormalTypeIndex( formalTypeIndex );
			return true;
		}
	}

	//
	/////////////////////////////////////////////////////////

	return false;
}

const string Compiler::TypeToString( const Type &type )
{
	if( PTR_LEVEL( type.GetBasicType() ) ){
		//|C^x1ȏ̏ꍇ
		Type tempType( type );
		tempType.PtrLevelDown();

		return (string)"*" + TypeToString( tempType );
	}
	else if( type.IsObject() || type.IsStruct() ){
		//IuWFNg܂͍\

		if( !( type.GetIndex() == 0 || type.GetIndex() == -1 ) ){
			if( type.GetClass().GetNamespaceScopes().size() >= 1 )
			{
				return type.GetClass().GetNamespaceScopes().ToString() + "." + type.GetClass().GetName();
			}
			return type.GetClass().GetName();
		}
	}
	else if( type.IsProcPtr() ){
		if( type.GetIndex() == 0 || type.GetIndex() == -1 ){
			return "VoidPtr";
		}
		else{
			if( this->GetObjectModule().meta.GetProcPointers()[type.GetIndex()]->ReturnType().IsNull() ){
				return "*Sub";
			}
			return "*Function";
		}
	}
	else{
		// {^
		const char *lpszTypeName = Type::BasicTypeToCharPtr( type );
		if( lpszTypeName )
		{
			return (const string)lpszTypeName;
		}
	}

	SmoothieException::Throw( 1 );

	return (string)"(null)";
}
