#include "common.h"

CRegExp obj_RegExp;

CRegExp::CRegExp(){
	char temporary[MAX_PATH];
	sprintf(temporary,"%sSubOperation\\BREGEXP.DLL",pj_editor_Dir);

	hLib=LoadLibrary(temporary);

	BMatch=(PFUNC_BMatch)GetProcAddress(hLib,"BMatch");
	BSubst=(PFUNC_BSubst)GetProcAddress(hLib,"BSubst");
	BTrans=(PFUNC_BTrans)GetProcAddress(hLib,"BTrans");
	BSplit=(PFUNC_BSplit)GetProcAddress(hLib,"BSplit");
	BRegfree=(PFUNC_BRegfree)GetProcAddress(hLib,"BRegfree");
	BRegexpVersion=(PFUNC_BRegexpVersion)GetProcAddress(hLib,"BRegexpVersion");
}
CRegExp::~CRegExp(){
	FreeLibrary(hLib);
}

char *CRegExp::compare(HWND hFindDlg,char *buffer,char *exp,BOOL IsBigSmall, bool isWordUnit ,int *pLength){
	BREGEXP *rxp=0;
	char msg[255];

	char *pTemp;
	pTemp=(char *)HeapAlloc(hHeap,0,lstrlen(exp)+255);
	if(strstr(exp,"/")){
		if(strstr(exp,"#")){
			sprintf(pTemp,"m@(%s)@",exp);
		}
		else sprintf(pTemp,"m#(%s)#",exp);
	}
	else sprintf(pTemp,"m/(%s)/",exp);

	//Shift-JISŕ\
	lstrcat(pTemp,"k");

	//啶E
	if(!IsBigSmall) lstrcat(pTemp,"i");

	int result;
	result=BMatch(pTemp,buffer,buffer+lstrlen(buffer),&rxp,msg);

	HeapDefaultFree(pTemp);

	if(!result){
		if(rxp) BRegfree(rxp);
		return 0;
	}
	else if(result==-1){
		if(rxp) BRegfree(rxp);
		MessageBox(hFindDlg,msg,APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);
		return (char *)-1;
	}

	*pLength=(rxp->outendp) - (rxp->outp);
	if((*pLength)==0) return 0;

	pTemp=ComparisonString(buffer,(char *)rxp->outp,false, isWordUnit);

	if(rxp) BRegfree(rxp);

	return pTemp;
}
char *CRegExp::GetPermuStr(HWND hFindDlg,char *buffer,char *exp,char *szPermu,BOOL IsBigSmall){
	BREGEXP *rxp=0;
	char msg[255];

	char *pTemp;
	pTemp=(char *)HeapAlloc(hHeap,0,lstrlen(exp)+255);
	if(strstr(exp,"/")||strstr(szPermu,"/")){
		if(strstr(exp,"#")||strstr(szPermu,"#")){
			sprintf(pTemp,"s@%s@%s@",exp,szPermu);
		}
		else sprintf(pTemp,"s#%s#%s#",exp,szPermu);
	}
	else sprintf(pTemp,"s/%s/%s/",exp,szPermu);

	//Shift-JISŕ\
	lstrcat(pTemp,"k");

	//啶E
	if(!IsBigSmall) lstrcat(pTemp,"i");

	int result;
	result=BSubst(pTemp,buffer,buffer+lstrlen(buffer),&rxp,msg);

	HeapDefaultFree(pTemp);

	if(!result){
		if(rxp) BRegfree(rxp);
		return 0;
	}
	else if(result==-1){
		if(rxp) BRegfree(rxp);
		MessageBox(hFindDlg,msg,APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);
		return (char *)-1;
	}

	int length;
	length=(rxp->outendp) - (rxp->outp);

	pTemp=(char *)HeapAlloc(hHeap,0,length+1);
	memcpy(pTemp,rxp->outp,length);
	pTemp[length]=0;

	if(rxp) BRegfree(rxp);

	return pTemp;
}
