
class CDebugger{
	BOOL bDebugging;
public:
	HWND hwnd;

	CDebugger::CDebugger();
	CDebugger::~CDebugger();

	BOOL IsDebugging(void);
	BOOL IsDebuggerView(void);

	void resize(int x,int y,int cx,int cy);

	void ResetCommandEnabled(void);

	void SaftyCheck(void);

	void begin(void);
	void end(void);
	void watch_start(HWND hDebuggerView);
	void watch_quit(void);


	/////////////////////////////////
	// CxgɂAvԒʐM
	/////////////////////////////////

	void DebugContinue(void);
	void StepIn(void);
	void StepOver(void);
	void StepToCursor(void);

	void DebugStop(void);
	void DebugPause(void);
};

extern CDebugger *pobj_Debugger;





/////////////////////////////////
// u[N|Cg
/////////////////////////////////

class CFileBreakPoint{
public:
	char *lpszFileName;

	int *piLine;
	int num;

	CFileBreakPoint(char *lpszFileName,int iLineNum);
	~CFileBreakPoint();

	void add(int iLineNum);
	void remove(int iLineNum);

	BOOL check(int iLineNum);

	void replace(LPSTR lpszBuffer,CHARRANGE *pDelRange,CHARRANGE *pRange,LPSTR lpszNewStr);
};

class CDBBreakPoint{
	CFileBreakPoint **ppItem;
	int num;

public:
	CDBBreakPoint();
	~CDBBreakPoint();

	void insert(char *lpszFileName,int iLineNum);
	void remove(char *lpszFileName,int iLineNum);

	void Event_BreakPoint(void);
	void SaveToTempFile(void);

	CFileBreakPoint *EnumLines(char *lpszFilePath);

	void replace(LPSTR lpszFilePath,LPSTR lpszBuffer,CHARRANGE *pDelRange,CHARRANGE *pRange,LPSTR lpszNewStr);
};
