/*
Visual Basic 炨ĝƂ͎DeclaregĂB
Private Declare Function Match Lib "bregexp" _
      (szRegstr As String, szTarget As String) As String


Private Declare Function Replace Lib "bregexp" _
      (szRegstr As String, szTarget As String) As String

Private Declare Function Translate Lib "bregexp" _
      (szRegstr As String, szTarget As String, ret As String) As Long

Private Declare Function Split Lib "bregexp" _
      (szRegstr As String, szTarget As String, limit As Long) As Variant

Private Declare Function MatchEx Lib "bregexp" _
      (szRegstr As String, szTarget As String, mode As Long) As Variant

*/


#ifdef _BREGEXP_
#define BREGEXPAPI __declspec(dllexport) 
#else
#define BREGEXPAPI __declspec(dllimport) 
#endif

typedef struct bregexp {
	const char *outp;			/* result string start ptr   */
	const char *outendp;		/* result string end ptr     */ 
	const int  splitctr;		/* split result counter     */ 
	const char **splitp;		/* split result pointer ptr     */ 
	int     rsv1;				/* reserved for external use    */ 
} BREGEXP;

#if defined(__cplusplus)
extern "C"
{
#endif

typedef BREGEXPAPI int (*PFUNC_BMatch)(char* str,char *target,char *targetendp,
								BREGEXP **rxp,char *msg) ;
typedef BREGEXPAPI int (*PFUNC_BSubst)(char* str,char *target,char *targetendp,
								BREGEXP **rxp,char *msg) ;
typedef BREGEXPAPI int (*PFUNC_BTrans)(char* str,char *target,char *targetendp,
								BREGEXP **rxp,char *msg) ;
typedef BREGEXPAPI int (*PFUNC_BSplit)(char* str,char *target,char *targetendp,
						int limit,BREGEXP **rxp,char *msg);
typedef BREGEXPAPI void (*PFUNC_BRegfree)(BREGEXP* rx);

typedef BREGEXPAPI char *(*PFUNC_BRegexpVersion)(void);


class CRegExp{
	HINSTANCE hLib;
public:
	CRegExp();
	~CRegExp();
	PFUNC_BMatch BMatch;
	PFUNC_BSubst BSubst;
	PFUNC_BTrans BTrans;
	PFUNC_BSplit BSplit;
	PFUNC_BRegfree BRegfree;
	PFUNC_BRegexpVersion BRegexpVersion;

	char *compare(HWND hFindDlg,char *buffer,char *exp,BOOL IsBigSmall, bool isWordUnit, int *pLength);
	char *GetPermuStr(HWND hFindDlg,char *buffer,char *exp,char *szPermu,BOOL IsBigSmall);
};
extern CRegExp obj_RegExp;


#if defined(__cplusplus)
}
#endif


#undef BREGEXPAPI
