#include "common.h"

extern int font_width,font_height;

BOOL IsRightTurn(char *pBuf,int i,int now_x){
	if(pobj_nv->bRightTurn==0) return 0;
	if(pobj_nv->iMaxOneLineTextLength-1<=now_x && pBuf[i]!='\r') return 1;
	return 0;
}

int GetBufferIndexFromCaretPos(char *pBuf,int now_x,int now_y){
	int i,i2;
	int x,y;

	// s̊mF
	for(i=0,x=0,y=0;;i++,x++){
		if(y>=now_y) break;
		if(pBuf[i]=='\0') return 0;
		if(IsRightTurn(pBuf,i,x)){
			//E[Ő܂Ԃ
			y++;
			x=-1;
			i--;
			continue;
		}
		if(pBuf[i]=='\t'){
			//^u
			int tab;
			tab=pobj_nv->TabSize;

			if(x%tab==0) i2=tab;
			else i2=tab-x%tab;
			x+=i2-1;
			continue;
		}
		else if(IsDBCSLeadByte(pBuf[i])){
			//}`oCg
			x++;
			i++;
			continue;
		}

		if(pBuf[i]=='\r'&&pBuf[i+1]=='\n'){
			y++;
			i++;
			x=-1;
		}
	}

	//̊mF
	for(x=0;x<now_x;i++,x++){
		if(pBuf[i]=='\r'&&pBuf[i+1]=='\n'||pBuf[i]=='\0') return 0;

		if(pBuf[i]=='\t'){
			//^u
			int tab;
			tab=pobj_nv->TabSize;

			if(x%tab==0) i2=tab;
			else i2=tab-x%tab;
			x+=i2-1;
			continue;
		}
		else if(IsDBCSLeadByte(pBuf[i])){
			//}`oCg
			x++;
			i++;
			continue;
		}
	}

	return i;
}
void GetCaretPosFromBufferIndex(char *pBuf,int index,POINT *pCaretPos){
	int i,i2;

	pCaretPos->x=0;
	pCaretPos->y=0;
	for(i=0;i<index;i++,pCaretPos->x++){
		if(pBuf[i]=='\0') break;
		if(IsRightTurn(pBuf,i,pCaretPos->x)){
			//E[Ő܂Ԃ
			pCaretPos->y++;
			pCaretPos->x=-1;
			i--;
			continue;
		}
		if(pBuf[i]=='\r'&&pBuf[i+1]=='\n'){
			pCaretPos->x=-1;
			pCaretPos->y++;
			i++;
			continue;
		}
		if(IsDBCSLeadByte(pBuf[i])){
			i++;
			pCaretPos->x++;
			continue;
		}
		if(pBuf[i]=='\t'){
			//^u
			int tab;
			tab=pobj_nv->TabSize;

			if(pCaretPos->x%tab==0) i2=tab;
			else i2=tab-pCaretPos->x%tab;
			pCaretPos->x+=i2-1;
			continue;
		}
		else if(IsDBCSLeadByte(pBuf[i])){
			//}`oCg
			pCaretPos->x++;
			i++;
			continue;
		}
	}
}

void TextEdit_GetSel(int WndNum,CHARRANGE *pCharRange){
	//////////////////////////////////////////
	// Í͈iobt@CfbNXj擾
	//////////////////////////////////////////
	extern MDIINFO MdiInfo[MAX_WNDNUM];

	pCharRange->cpMin=GetBufferIndexFromCaretPos(
		MdiInfo[WndNum].pMdiTextEdit->buffer,
		MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x,
		MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y);

	if(MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x==MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.x&&
		MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y==MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.y){
		//IĂȂƂ
		pCharRange->cpMax=pCharRange->cpMin;
	}
	else{
		pCharRange->cpMax=GetBufferIndexFromCaretPos(
			MdiInfo[WndNum].pMdiTextEdit->buffer,
			MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.x,
			MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.y);
	}

	if(pCharRange->cpMin>pCharRange->cpMax){
		long temp;
		temp=pCharRange->cpMin;
		pCharRange->cpMin=pCharRange->cpMax;
		pCharRange->cpMax=temp;
	}
}
void TextEdit_GetSelText(int WndNum,CHARRANGE *pCharRange,char *buffer){
	extern MDIINFO MdiInfo[MAX_WNDNUM];

	memcpy(buffer,
		MdiInfo[WndNum].pMdiTextEdit->buffer+pCharRange->cpMin,
		pCharRange->cpMax-pCharRange->cpMin);
	buffer[pCharRange->cpMax-pCharRange->cpMin]=0;
}

void GetScrollBaseCaretPos(int WndNum,int *pNaturalBaseX,int *pNaturalBaseY){
	extern MDIINFO MdiInfo[MAX_WNDNUM];

	HWND hEdit;
	hEdit=MdiInfo[WndNum].pMdiTextEdit->hEdit;

	//XN[o[̈ʒu
	SCROLLINFO si;
	si.cbSize=sizeof(SCROLLINFO);
	si.fMask=SIF_POS;
	GetScrollInfo(hEdit,SB_VERT,&si);
	*pNaturalBaseY-=si.nPos;		//P

	//XN[o[̈ʒu
	GetScrollInfo(hEdit,SB_HORZ,&si);
	*pNaturalBaseX-=si.nPos;		//P
}

void GetNaturalBaseCaretPos(int WndNum,int *pScrollBaseX,int *pScrollBaseY){
	extern MDIINFO MdiInfo[MAX_WNDNUM];

	HWND hEdit;
	hEdit=GetWindow(MdiInfo[WndNum].hwnd,GW_CHILD);

	//XN[o[̈ʒu
	SCROLLINFO si;
	si.cbSize=sizeof(SCROLLINFO);
	si.fMask=SIF_POS;
	GetScrollInfo(hEdit,SB_VERT,&si);
	*pScrollBaseY+=si.nPos;		//P

	//XN[o[̈ʒu
	GetScrollInfo(hEdit,SB_HORZ,&si);
	*pScrollBaseX+=si.nPos;		//P
}

void TextEdit_SetSel(int WndNum,int StartIndex,int EndIndex,BOOL bShowCenter){
	extern MDIINFO MdiInfo[MAX_WNDNUM];

	GetCaretPosFromBufferIndex(
		MdiInfo[WndNum].pMdiTextEdit->buffer,
		StartIndex,
		&MdiInfo[WndNum].pMdiTextEdit->StartCaretPos);

	GetCaretPosFromBufferIndex(
		MdiInfo[WndNum].pMdiTextEdit->buffer,
		EndIndex,
		&MdiInfo[WndNum].pMdiTextEdit->EndCaretPos);

	HWND hEdit;
	hEdit=GetWindow(MdiInfo[WndNum].hwnd,GW_CHILD);

	if(!TextEdit_ScrollCaret(WndNum,0,bShowCenter))
		InvalidateRect(hEdit,NULL,0);
	ResetCaretPos(WndNum);

	ResetState_EditMenu();
}
void TextEdit_SelectOneLine(int WndNum,int code_pos,BOOL bShowCenter){
	extern MDIINFO MdiInfo[MAX_WNDNUM];

	///////////////////////
	// `s̑I͈
	///////////////////////

	int iStartPos;
	iStartPos=code_pos;
	while(MdiInfo[WndNum].pMdiTextEdit->buffer[iStartPos]!='\n'&&iStartPos>0) iStartPos--;
	if(MdiInfo[WndNum].pMdiTextEdit->buffer[iStartPos]=='\n') iStartPos++;

	int iEndPos;
	iEndPos=code_pos;
	while(MdiInfo[WndNum].pMdiTextEdit->buffer[iEndPos]!='\r'&&MdiInfo[WndNum].pMdiTextEdit->buffer[iEndPos]!='\0') iEndPos++;

	TextEdit_SetSel(WndNum,iStartPos,iEndPos,bShowCenter);
}
void ResetCaretPos(int WndNum,BOOL bInputAndReset){
	extern HANDLE hHeap;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int x,y;

	POINT OldPos;
	GetCaretPos(&OldPos);

	x=MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x;
	y=MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y;
	GetScrollBaseCaretPos(WndNum,&x,&y);

	//GfB^ʍ[̃Rg[^u
	int iControlTabSpace;
	iControlTabSpace=MdiInfo[WndNum].pMdiTextEdit->iWidth_ControlTabSpace;

	//Rg[^uɃJ[\ƂɁA\ɂ
	if(OldPos.x>=iControlTabSpace&&x<0) HideCaret(MdiInfo[WndNum].pMdiTextEdit->hEdit);
	else if(OldPos.x<iControlTabSpace&&x>=0) ShowCaret(MdiInfo[WndNum].pMdiTextEdit->hEdit);

	SetCaretPos(
		x*font_width     +iControlTabSpace,
		y*font_height);

	SetStatusText(NULL);


	//////////////////////////////////////////////
	// Web
	//////////////////////////////////////////////
	if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
		int start,end;
		if(MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x==MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.x&&
			MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y==MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.y){
			//I𒆂łȂƂ

			int sw=0;
			if(bInputAndReset){
				if(MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x>1){
					MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x-=2;
					sw=1;
				}
			}

			TextEdit_GetWordCaret(
				MdiInfo[WndNum].pMdiTextEdit->hEdit,
				WndNum,
				&MdiInfo[WndNum].pMdiTextEdit->StartCaretPos,
				&start,&end,
				WORDCARET_BEFORE);

			if(sw) MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x+=2;

			//pȊSpƂ̃YC
			POINT pos;
			GetCaretPosFromBufferIndex(MdiInfo[WndNum].pMdiTextEdit->buffer,start,&pos);
			start=GetBufferIndexFromCaretPos(MdiInfo[WndNum].pMdiTextEdit->buffer,pos.x,pos.y);
			GetCaretPosFromBufferIndex(MdiInfo[WndNum].pMdiTextEdit->buffer,end,&pos);
			end=GetBufferIndexFromCaretPos(MdiInfo[WndNum].pMdiTextEdit->buffer,pos.x,pos.y);
		}
		else{
			//I𒆂̂Ƃ
			start=GetBufferIndexFromCaretPos(
				MdiInfo[WndNum].pMdiTextEdit->buffer,
				MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x,
				MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y);
			end=GetBufferIndexFromCaretPos(
				MdiInfo[WndNum].pMdiTextEdit->buffer,
				MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.x,
				MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.y);
		}

		if(start>end){
			int iTemp;
			iTemp=start;
			start=end;
			end=iTemp;
		}

		char *pTemp;
		int length;
		length=end-start;
		if(length<0) length=0;
		pTemp=(char *)HeapAlloc(hHeap,0,length+1024);
		memcpy(pTemp,MdiInfo[WndNum].pMdiTextEdit->buffer+start,length);
		pTemp[length]=0;

		char *temp2;
		temp2=strstr(pTemp,"\r\n");
		if(temp2) temp2[0]=0;

		extern HWND hWebSearchCombo;
		SetWindowText(GetWindow(hWebSearchCombo,GW_CHILD),pTemp);

		//
		HeapDefaultFree(pTemp);
		/*if((!IsHiragana(pTemp))&&pTemp[0]&&pTemp[1]){
			//obNOEhWeb
			_beginthread(WebSearchThread,0,(void *)pTemp);

			//pTempWebSearchThreadXbhŔj
		}
		else{
			HeapDefaultFree(pTemp);
		}*/
	}


	////////////////////////////////////////////////////
	// p[^qgXV
	////////////////////////////////////////////////////

	extern METHODCHECKINFO MethodCheckInfo;
	if(MethodCheckInfo.hWnd){
		if(MdiInfo[WndNum].DocType==WNDTYPE_BASIC)
			ShowParameterHint(WndNum);
	}


	//////////////////////////////////
	// R[h⊮@\𗘗p̏ꍇ
	//////////////////////////////////

	extern COMPLEMENT_WINDOW_INFO ComplementWndInfo;
	if(ComplementWndInfo.hWnd){
		int i,i2;
		char *pTemp,temporary[VN_SIZE];

		i=GetBufferIndexFromCaretPos(MdiInfo[WndNum].pMdiTextEdit->buffer,
			MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x,
			MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y);

		if(i<ComplementWndInfo.iPos||ComplementWndInfo.iPos+ComplementWndInfo.iLength<i){
			//QƕȊOɃJ[\ړꍇ̓R[h⊮Xgj

			DestroyWindow(ComplementWndInfo.hWnd);
			ComplementWndInfo.hWnd=0;
		}
		if(ComplementWndInfo.pMemberInfo[0].dwAccess==ACCESS_PAIRCOMMAND){
			/////////////////////////////////////
			// yAXe[gg⊮
			/////////////////////////////////////
			//XgIAꍇɂj

			if(ComplementWndInfo.iLength==0){
				//I̎wWƂȂ镶񂪂ȂƂ́A⊮EBhEj
				DestroyWindow(ComplementWndInfo.hWnd);
				ComplementWndInfo.hWnd=0;
				return;
			}

			pTemp=(char *)HeapAlloc(hHeap,0,ComplementWndInfo.iLength+1);
			memcpy(pTemp,
				MdiInfo[WndNum].pMdiTextEdit->buffer+ComplementWndInfo.iPos,
				ComplementWndInfo.iLength);
			pTemp[ComplementWndInfo.iLength]=0;

			for(i=0;i<ComplementWndInfo.MemberNum;i++){
				ListView_GetItemText(ComplementWndInfo.hList,i,0,temporary,VN_SIZE);

				if(memicmp(pTemp,temporary,ComplementWndInfo.iLength)==0){
					if(lstrcmpi(pTemp,temporary)==0){
						//Sv̏ꍇ
						SendMessage(ComplementWndInfo.hList,WM_KEYDOWN,VK_RETURN,0);
					}
					break;
				}
			}
			if(i==ComplementWndInfo.MemberNum){
				//GhyAXe[gg̐[ƈvȂƂ
				DestroyWindow(ComplementWndInfo.hWnd);
				ComplementWndInfo.hWnd=0;
			}

			//ACeI
			ListView_SetItemState(ComplementWndInfo.hList,
				i,
				LVIS_SELECTED|LVIS_FOCUSED,
				LVIS_SELECTED|LVIS_FOCUSED);

			//Kvł΃XN[
			ListView_EnsureVisible(ComplementWndInfo.hList,i,0);

			HeapDefaultFree(pTemp);
		}
		else{
			/////////////////////////////////
			// NXõR[h⊮@\
			/////////////////////////////////
			//XgI

			if(ComplementWndInfo.iLength==0){
				//I̎wWƂȂ镶񂪂ȂƂ
				return;
			}

			if(ComplementWndInfo.iLength<0){
				//}CiXlɂȂƂi.>ꂽƂj
				//  ⊮EBhEj
				DestroyWindow(ComplementWndInfo.hWnd);
				ComplementWndInfo.hWnd=0;
				return;
			}

			pTemp=(char *)HeapAlloc(hHeap,0,ComplementWndInfo.iLength+1);
			memcpy(pTemp,
				MdiInfo[WndNum].pMdiTextEdit->buffer+ComplementWndInfo.iPos,
				ComplementWndInfo.iLength);
			pTemp[ComplementWndInfo.iLength]=0;

			for(i=0;i<ComplementWndInfo.MemberNum;i++){
				ListView_GetItemText(ComplementWndInfo.hList,i,0,temporary,VN_SIZE);

				i2=lstrcmpi(pTemp,temporary);
				if(i2<=0) break;
			}
			if(i==ComplementWndInfo.MemberNum) i--;

			//ACeI
			ListView_SetItemState(ComplementWndInfo.hList,
				i,
				LVIS_SELECTED|LVIS_FOCUSED,
				LVIS_SELECTED|LVIS_FOCUSED);

			//Kvł΃XN[
			ListView_EnsureVisible(ComplementWndInfo.hList,i,0);

			HeapDefaultFree(pTemp);
		}
	}
}
BOOL TextEdit_ScrollCaret(int WndNum,BOOL bScrollOneStep_x,BOOL bShowCenter){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int x,y;
	BOOL bScroll=0;

	HWND hEdit;
	hEdit=MdiInfo[WndNum].pMdiTextEdit->hEdit;

	x=MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x;
	y=MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y;
	GetScrollBaseCaretPos(WndNum,&x,&y);

	//
	SCROLLINFO si;
	si.cbSize=sizeof(SCROLLINFO);
	si.fMask=SIF_POS|SIF_PAGE|SIF_RANGE;
	GetScrollInfo(hEdit,SB_VERT,&si);
	if(bShowCenter==0){
		//ʏLbgXN[
		if(y<0){
			//փXN[

			si.nPos+=y;
			SetScrollInfo(hEdit,SB_VERT,&si,1);
			InvalidateRect(hEdit,NULL,0);
			bScroll=1;
		}
		if(si.nPage&&y>(int)si.nPage-1){
			//փXN[

			si.nPos+=y-si.nPage;

			SetScrollInfo(hEdit,SB_VERT,&si,1);
			InvalidateRect(hEdit,NULL,0);
			bScroll=1;
		}
	}
	else{
		//㕔ɃLbg悤ɃXN[

		if(y<0||
			si.nPage&&y>(int)si.nPage-1){

			si.nPos+=y-si.nPage/3;
			SetScrollInfo(hEdit,SB_VERT,&si,1);
			InvalidateRect(hEdit,NULL,0);
			bScroll=1;
		}
	}


	//
	GetScrollInfo(hEdit,SB_HORZ,&si);
	if(x<0){
		si.nPos+=x-1;
		if(!bScrollOneStep_x) si.nPos-=si.nPage/4;
		if(si.nPos<0) si.nPos=0;
		SetScrollInfo(hEdit,SB_HORZ,&si,1);
		InvalidateRect(hEdit,NULL,0);
		bScroll=1;
	}
	if(si.nPage&&x>(int)si.nPage){
		si.nPos+=x-si.nPage;
		if(!bScrollOneStep_x) si.nPos+=si.nPage/3;
		SetScrollInfo(hEdit,SB_HORZ,&si,1);
		InvalidateRect(hEdit,NULL,0);
		bScroll=1;
	}

	return bScroll;
}

void CaretPos_LooseToNatural(int WndNum,int loose_x,int loose_y,POINT *pCaretPos){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i,i2,LastPos;
	int x,y;
	char *pBuf;

	//̏ꍇ0Zbg
	if(loose_x<0) loose_x=0;
	if(loose_y<0) loose_y=0;

	pBuf=MdiInfo[WndNum].pMdiTextEdit->buffer;

	// s̊mF
	LastPos=0;
	for(i=0,x=0,y=0;;i++,x++){
		if(y>=loose_y){
			pCaretPos->y=y;
			break;
		}
		if(pBuf[i]=='\0'){
			pCaretPos->y=y;
			i=LastPos;
			break;
		}

		if(IsRightTurn(pBuf,i,x)){
			LastPos=i;

			//E[Ő܂Ԃ
			y++;
			x=-1;
			i--;
			continue;
		}
		if(pBuf[i]=='\r'&&pBuf[i+1]=='\n'){
			LastPos=i+2;
			y++;
			i++;
			x=-1;
		}

		if(pBuf[i]=='\t'){
			//^u
			int tab;
			tab=pobj_nv->TabSize;

			if(x%tab==0) i2=tab;
			else i2=tab-x%tab;
			x+=i2-1;
			continue;
		}
		else if(IsDBCSLeadByte(pBuf[i])){
			//}`oCg
			x++;
			i++;
			continue;
		}
	}

	//̊mF
	x=0;
	for(;;i++,x++){
		if(IsRightTurn(pBuf,i,x)){
			//܂ԂEwꏊ̂Ƃ
			pCaretPos->x=x;
			break;
		}

		if(pBuf[i]=='\t'){
			//^u
			int tab;
			tab=pobj_nv->TabSize;

			if(x%tab==0) i2=tab;
			else i2=tab-x%tab;
			if(x+i2-1>=loose_x){
				//wꏊɃLbg݂Ƃi^uj
				pCaretPos->x=x;
				break;
			}
			x+=i2-1;
			continue;
		}
		else if(IsDBCSLeadByte(pBuf[i])){
			//}`oCg
			x++;
			i++;
			if(x>=loose_x){
				//}`oCg̊ԂɃLbg݂Ƃ
				pCaretPos->x=x-1;
				break;
			}
			continue;
		}

		if(x>=loose_x){
			//wꏊɃLbg݂Ƃiʏj
			pCaretPos->x=x;
			break;
		}

		if(pBuf[i]=='\r'&&pBuf[i+1]=='\n'||pBuf[i]=='\0'){
			//sEwꏊ̂Ƃ
			pCaretPos->x=x;
			break;
		}
	}
}

void GetNaturalCaretPos_Click(int WndNum,int mouse_x,int mouse_y,POINT *pCaretPos){
	/////////////////////////////
	// LbgړiNbNj
	/////////////////////////////

	extern MDIINFO MdiInfo[MAX_WNDNUM];

	//sNZWJ[\WiPʁjɕύX
	mouse_x=(int)((double)mouse_x/(double)font_width+0.5);
	mouse_y/=font_height;
	GetNaturalBaseCaretPos(WndNum,&mouse_x,&mouse_y);

	CaretPos_LooseToNatural(WndNum,mouse_x,mouse_y,pCaretPos);
}
void GetNaturalCaretPos_Left(int WndNum){
	///////////////////////////
	// LbgړiL[j
	///////////////////////////

	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i;
	int x,y;
	char *pBuf;

	POINT *pCaretPos;
	pCaretPos=&MdiInfo[WndNum].pMdiTextEdit->StartCaretPos;

	if(pCaretPos->x==0&&pCaretPos->y==0){
		//t@C̐擪獶ւ͍sȂ
		return;
	}

	pBuf=MdiInfo[WndNum].pMdiTextEdit->buffer;

	i=GetBufferIndexFromCaretPos(pBuf,
		pCaretPos->x,
		pCaretPos->y);

	if(i>=2){
		if(pBuf[i-2]=='\r'&&pBuf[i-1]=='\n'){
			//擪Os̏I[
			x=INT_MAX;
			y=pCaretPos->y-1;
			CaretPos_LooseToNatural(WndNum,
				x,y,
				pCaretPos);
			return;
		}
	}

	x=pCaretPos->x-1;
	y=pCaretPos->y;

	BOOL sw=0;
	if(x<0){
		x=INT_MAX;
		y--;

		sw=1;
	}

	CaretPos_LooseToNatural(WndNum,
		x,y,
		pCaretPos);

	if(sw){
		GetNaturalCaretPos_Left(WndNum);
	}
}
void GetNaturalCaretPos_Right(int WndNum,POINT *pCaretPos){
	///////////////////////////
	// LbgړiEL[j
	///////////////////////////

	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i,i2;
	char *pBuf;

	pBuf=MdiInfo[WndNum].pMdiTextEdit->buffer;

	i=GetBufferIndexFromCaretPos(pBuf,
		pCaretPos->x,
		pCaretPos->y);

	if(pBuf[i]=='\0'){
		//t@C̏I[Eւ͍sȂ
		return;
	}
	else if(pBuf[i]=='\r'&&pBuf[i+1]=='\n'){
		//sR[hE
		pCaretPos->x=0;
		pCaretPos->y++;
	}
	else if(pBuf[i]=='\t'){
		//^uE
		int tab;
		tab=pobj_nv->TabSize;

		if(pCaretPos->x%tab==0) i2=tab;
		else i2=tab-pCaretPos->x%tab;
		pCaretPos->x+=i2;
	}
	else if(IsDBCSLeadByte(pBuf[i])){
		//}`oCg
		pCaretPos->x+=2;
	}
	else{
		//Eցiʏj
		pCaretPos->x++;
	}

	//܂Ԃ
	int iMax_OneLine_TextLength;
	iMax_OneLine_TextLength=40;
	if(IsRightTurn(pBuf,i,pCaretPos->x)){
		pCaretPos->x=0;
		pCaretPos->y++;
	}

	CaretPos_LooseToNatural(WndNum,
		pCaretPos->x,
		pCaretPos->y,
		pCaretPos);
}
void GetNaturalCaretPos_Up(int WndNum,POINT *pCaretPos){
	///////////////////////////
	// LbgړiL[j
	///////////////////////////
	extern MDIINFO MdiInfo[MAX_WNDNUM];

	if(pCaretPos->y==0){
		//1sڂɃLbgƂ
		return;
	}

	//㉺̃Lbgړɂ́AËʒuێ
	if(MdiInfo[WndNum].pMdiTextEdit->Temp_UpDown_CaretXPos==-1)
		MdiInfo[WndNum].pMdiTextEdit->Temp_UpDown_CaretXPos=pCaretPos->x;

	pCaretPos->y--;

	CaretPos_LooseToNatural(WndNum,
		MdiInfo[WndNum].pMdiTextEdit->Temp_UpDown_CaretXPos,
		pCaretPos->y,
		pCaretPos);
}
void GetNaturalCaretPos_Down(int WndNum,POINT *pCaretPos){
	///////////////////////////
	// LbgړiL[j
	///////////////////////////
	extern MDIINFO MdiInfo[MAX_WNDNUM];

	//㉺̃Lbgړɂ́AËʒuێ
	if(MdiInfo[WndNum].pMdiTextEdit->Temp_UpDown_CaretXPos==-1)
		MdiInfo[WndNum].pMdiTextEdit->Temp_UpDown_CaretXPos=pCaretPos->x;

	pCaretPos->y++;

	CaretPos_LooseToNatural(WndNum,
		MdiInfo[WndNum].pMdiTextEdit->Temp_UpDown_CaretXPos,
		pCaretPos->y,
		pCaretPos);
}
void GetNaturalCaretPos_PageUp(int WndNum,POINT *pCaretPos){
	///////////////////////////////
	// LbgړiPageUpL[j
	///////////////////////////////
	extern MDIINFO MdiInfo[MAX_WNDNUM];

	if(pCaretPos->y==0){
		//1sڂɃLbgƂ
		return;
	}

	//㉺̃Lbgړɂ́AËʒuێ
	if(MdiInfo[WndNum].pMdiTextEdit->Temp_UpDown_CaretXPos==-1)
		MdiInfo[WndNum].pMdiTextEdit->Temp_UpDown_CaretXPos=pCaretPos->x;

	SCROLLINFO si;
	si.cbSize=sizeof(SCROLLINFO);
	si.fMask=SIF_PAGE;
	GetScrollInfo(MdiInfo[WndNum].pMdiTextEdit->hEdit,SB_VERT,&si);
	pCaretPos->y-=si.nPage;
	if(pCaretPos->y<0) pCaretPos->y=0;

	CaretPos_LooseToNatural(WndNum,
		MdiInfo[WndNum].pMdiTextEdit->Temp_UpDown_CaretXPos,
		pCaretPos->y,
		pCaretPos);
}
void GetNaturalCaretPos_PageDown(int WndNum,POINT *pCaretPos){
	///////////////////////////////
	// LbgړiPageUpL[j
	///////////////////////////////
	extern MDIINFO MdiInfo[MAX_WNDNUM];

	//㉺̃Lbgړɂ́AËʒuێ
	if(MdiInfo[WndNum].pMdiTextEdit->Temp_UpDown_CaretXPos==-1)
		MdiInfo[WndNum].pMdiTextEdit->Temp_UpDown_CaretXPos=pCaretPos->x;

	SCROLLINFO si;
	si.cbSize=sizeof(SCROLLINFO);
	si.fMask=SIF_PAGE;
	GetScrollInfo(MdiInfo[WndNum].pMdiTextEdit->hEdit,SB_VERT,&si);
	pCaretPos->y+=si.nPage;

	CaretPos_LooseToNatural(WndNum,
		MdiInfo[WndNum].pMdiTextEdit->Temp_UpDown_CaretXPos,
		pCaretPos->y,
		pCaretPos);
}
