#pragma once

//#define _CRT_SECURE_NO_DEPRECATE
#pragma warning(disable : 4996)

#include <option.h>

using namespace std;

#ifdef _AMD64_
#include "../BasicCompiler64/resource.h"
#include "../BasicCompiler64/CommandValue.h"
#define OPCODE_H_PATH "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/resource.h"
#include "../BasicCompiler32/CommandValue.h"
#define OPCODE_H_PATH "../BasicCompiler32/opcode.h"
#endif

#include <jenga/include/smoothie/BasicFixed.h>
#include "../BasicCompiler_Common/NonVolatile.h"
#include "../BasicCompiler_Common/psapi.h"
#include "../BasicCompiler_Common/BreakPoint.h"



#if defined(JPN)
//{
#include "common_msg_jpn.h"
#else
//p
#include "common_msg_eng.h"
#endif


#define PTR_SIZE		sizeof(LONG_PTR)
#define OBJECT_HEAD_SIZE PTR_SIZE*4

#define MAX_LEN			65535
#define DIGIT_SIZE		128
#define MAX_PARMS		64
#define MAX_ARRAYDIM	16
#define MAX_HASH		32761


#ifdef _AMD64_
	#define PLATFORM	64
#else
#define PLATFORM	32
	#ifndef LONG_PTR
		typedef long LONG_PTR;
		typedef DWORD ULONG_PTR;
	#endif
#endif


//`̒萔
#ifndef IMAGE_FILE_MACHINE_AMD64
	#define IMAGE_FILE_MACHINE_AMD64 0x8664
#endif

#ifdef _AMD64_
	#ifndef IMAGE_SIZEOF_NT_OPTIONAL64_HEADER
		#define IMAGE_SIZEOF_NT_OPTIONAL64_HEADER    240
	#endif
#else
	#ifndef IMAGE_SIZEOF_NT_OPTIONAL32_HEADER
		#define IMAGE_SIZEOF_NT_OPTIONAL32_HEADER    224
	#endif
#endif


extern HWND hOwnerEditor;
extern HANDLE hHeap;
extern int cp;
extern int typeOfPtrChar;
extern int typeOfPtrUChar;



//////////////////////////////////////////
// BasicCompilerAProjectEditorʂ̒萔
//////////////////////////////////////////

//TCYύXg̑
#define LEVER_THICK 5

#define WM_SHOWERROR			WM_USER+70	//G[\bZ[W

#define WM_SETCOMPILEVIEW		WM_USER+71	//RpCEBhE\ꂽƂ
#define WM_DESTROYCOMPILEVIEW	WM_USER+72	//RpCEBhEjꂽƂ

#define WM_SETDEBUGGERBASE		WM_USER+73	//fobKx[XEBhE\ꂽƂ
#define WM_DESTROYDEBUGGERBASE	WM_USER+74	//fobKx[XEBhEjꂽƂ

#define WM_SETDEBUGGERVIEW		WM_USER+75	//fobKEBhE\ꂽƂ
#define WM_DESTROYDEBUGGERVIEW	WM_USER+76	//fobKEBhE\ꂽƂ

///////////////////////////////////////////


#define WM_SHOWVARLIST			WM_USER+80
#define WM_VARLIST_CLOSE		WM_USER+81	//ϐXg̏IbZ[Wiĵ݁AȂj



///////////////////////////////////////////
// fobO R}h

#define WM_DEBUG_CONTINUE	WM_USER+200
#define WM_STEP_IN			WM_USER+201
#define WM_STEP_OVER		WM_USER+202
#define WM_STEP_CURSOR		WM_USER+203
#define WM_DEBUG_STOP		WM_USER+204
#define WM_DEBUG_PAUSE		WM_USER+205
#define WM_CLOSE_DEBUGGER	WM_USER+206

///////////////////////////////////////////




#define FILE_ALIGNMENT	0x1000
#define MEM_ALIGNMENT	0x1000
#define EXE_HEADER_SIZE	0x1000



struct ERRORINFO{
	char *FileName;
	int line;
};

//ϐ̑Ώ
struct RELATIVE_VAR{
	DWORD dwKind;
	LONG_PTR offset;
	BOOL bOffsetOffset;
};


struct RESOURCEDATAINFO{
	DWORD dwId;
	char FileName[MAX_PATH];
};


//////////////////////////////////////////
// \[X wb_iACRAJ[\pj
typedef struct{
	WORD idReserved;
	WORD idType;
	WORD idCount;
}ICONDIR,CURSORDIR;


/////////////////////////////
// .curt@C̃wb_
struct CURSORDIRENTRY{
	BYTE bWidth;
	BYTE bHeight;
	BYTE bColorCount;
	BYTE bReserved;
	WORD wXHotspot;
	WORD wYHotspot;
	DWORD dwBytesInRes;
	DWORD dwImageOffset;
};
struct CURSORDIRENTRY_RES{
	WORD wWidth;
	WORD wHeight;
	WORD wXHotspot;
	WORD wYHotspot;
	DWORD dwBytesInRes;
	WORD wCursorNum;
};


////////////////////////////
//.icot@C̃wb_
struct ICONDIRENTRY{
	BYTE bWidth;
	BYTE bHeight;
	BYTE bColorCount;
	BYTE bReserved;
	WORD wPlanes;
	WORD wBitCount;
	DWORD dwBytesInRes;
	DWORD dwImageOffset;
};
struct ICONDIRENTRY_RES{
	BYTE bWidth;
	BYTE bHeight;
	BYTE bColorCount;
	BYTE bReserved;
	WORD wPlanes;
	WORD wBitCount;
	DWORD dwBytesInRes;
	WORD wIconNum;
};



#include "../BasicCompiler_Common/PESchedule.h"
#include "../BasicCompiler_Common/StrOperation.h"
#include "../BasicCompiler_Common/VariableOpe.h"



bool StaticCalculation(bool enableerror, const char *Command,int BaseType,_int64 *pi64data,Type &resultType,BOOL bDebuggingWatchList=0, bool *pIsMemoryAccessError=NULL);


//BasicCompiler.cpp
void HeapDefaultFree(LPVOID lpMem);
void ts(int i = 0);
void ts(int i,int i2);
void ts(const char *msg);
void ts(const char *msg,const char *title);
void epi_check();
void GetRelationalPath(char *path,char *dir);
void GetFullPath( char *path, const string &baseDirPath );
std::string GetApplicationBaseFullPath( const std::string &relationalPath );
void ShowErrorLine(int LineNum,const char *FileName);
BOOL GetFilePathDialog(HWND hwnd,char *filename,LPSTR Filter,LPSTR Title,BOOL bOpen);
void MakeMessageText(char *buffer,char *msg,int flag);

//hash.cpp
int hash_default(const char *name);
DllProc *GetDeclareHash(const char *name);
void GetOverloadSubHash( const char *lpszName, std::vector<const UserProc *> &subs );
const UserProc *GetSubHash(const char *name,BOOL bError=0);
const UserProc *GetMethodHash(const char *ObjectName,const char *MethodName,const char *Parameter,BOOL bError=0);
const UserProc *GetClassMethod( const char *className, const char *methodName );

//Object.cpp
void CallConstructor( const char *ObjectName,const Subscripts &subscripts, const Type &type,const char *Parameter);
bool Operator_New( const char *expression, const Type &baseType, Type &resultType );

//Overload.sbp
class Parameters;
const UserProc *OverloadSolutionWithStrParam(
	const char *name,
	std::vector<const UserProc *> &subs,
	const char *Parameter,
	const char *ObjectName);
const UserProc *OverloadSolution(
	const char *name,
	std::vector<const UserProc *> &subs,
	const Parameters &params,
	const Type &returnType,
	const Type &leftType );

//Debug.cpp
void Debugger_StepIn(void);
void Debugger_StepOver(void);
void Debugger_StepCursor(void);
void Debugger_Stop(void);
void Debugger_Pause(void);
ULONG_PTR rva_to_real(DWORD p);
UserProc *GetSubFromObp(ULONG_PTR pos);
void ReadOpBuffer();
void DebugProgram(void);

//VarList.cpp
void InitVarList(DWORD dwThreadId);
BOOL CALLBACK DlgDebugger(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam);
BOOL CALLBACK DlgVarList(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam);

//WatchList.cpp
ULONG_PTR Debugging_GetVarPtr(RELATIVE_VAR *pRelativeVar);
ULONG_PTR Debugging_GetThisPtrOffset(LONG_PTR obp_Rip);
int Debugging_GetVarOffset( char *variable,RELATIVE_VAR *pRelativeVar, Type &resultType, Subscripts *pResultSubscripts = NULL );

//MakeExe.cpp
void StepCompileProgress(void);
void MakeMiddleCode( char *buffer );
void AddSourceCode(const char *buffer);
void OutputExe(void);
int MainThread(DWORD dummy);

//Intermediate_Step1.cpp
void ChangeReturnCode(char *buffer);
void DeleteComment(char *buffer);
void KillReturnCode(char *buffer);
void CheckParenthesis(char *buffer);
BOOL CheckParenthesis2(char *buffer);
void DirectiveCheck(void);
void NextCommandFormat(char *buffer);
void SetEscapeSequenceFormat(char *buffer);
void DefCommandFormat(char *buffer);
void IfCommandFormat(char *buffer);
void CheckPareCommand(void);

//Intermediate_Step2.cpp
bool GetConstInfo(void);
void ChangeCommandToCode(char *buffer);

//preprocessor.cpp
char *OpenBasicFile(char *FileName);

//Resource.cpp
void GetResourceData(char *FileName);

//CommandFormat.cpp
void ComOpen(char *Parameter,char *buffer,int nowLine);
void ComClose(char *Parameter,char *buffer);
void ComField(char *Parameter,char *buffer);
void ComLine(char *Parameter,char *buffer,int nowLine);
void ComCircle(char *Parameter,char *buffer,int nowLine);
void ComPSet(char *Parameter,char *buffer,int nowLine);
void ComPaint(char *Parameter,char *buffer,int nowLine);

// StrOperation.cpp
void KillSpaces(char *str1,char *str2);
void KillStringSpaces(char *str);
BOOL RemoveStringQuotes(char *str);
bool RemoveStringQuotes( std::string &str );
void RemoveStringPare(char *str);
void RemoveStringBracket(char *str);
void SetStringQuotes(char *str);
int FormatString_EscapeSequence(char *buffer);
void SlideString(char *str,int slide);
void SlideBuffer(char *buffer,int length,int slide);
int GetSourceCodeIndexFromLine( const char *source, int LineNum );
char GetEndXXXCommand(char es);
void GetDefaultNameFromES(char es,char *name);
const std::string &FormatEscapeSequenceStringToDefaultString( const std::string &source );
bool IsFileExist(const char *path);
BOOL ShortPathToLongPath(char ShortPath[MAX_PATH],char *LongPath);
BOOL GetFolder(HWND hWnd,char *folder,char *OpenFolderTitle);
void ShortPathToLongPath(const char *ShortPath,char *LongPath);

//calculation.cpp
bool IsNumberTopChar(const char *buffer);
bool IsNumberChar(const char c);
BOOL IsNumCalcMark(const char *Command,int p);
BOOL IsNumCalcMark_Back(const char *Command,int p);
BOOL IsStrCalcMark(const char c);
BOOL IsExponent(const char *Command,int p);
int GetLiteralIndex(_int64 i64data);
int NeutralizationType(int type1,LONG_PTR index1,int type2,LONG_PTR index2);
DWORD GetLiteralValue(char *value,_int64 *pi64,int BaseType, bool isNotifyError = true );
int IsStrCalculation(const char *Command);
BYTE GetCalcId(const char *Command,int *pi);
BOOL GetNumOpeElements(const char *Command,int *pnum,
					   char *values[255],long calc[255],long stack[255]);

//NumOpe_GetType.cpp
int AutoBigCast(int BaseType,int CalcType);
BOOL CheckCalcType(int idCalc,int *type,int sp);
bool GetTermType( const char *term, const Type &baseType, Type &resultType, bool &isLiteral, bool *pIsClassName = NULL, bool *pIsVariable = NULL );
bool GetTermType( const char *term, Type &resultType );
bool GetTermTypeOnlyVariable( const char *term, Type &resultType );
bool NumOpe_GetType( const char *expression, const Type &baseType, Type &resultType, bool *pIsLiteralCalculation = NULL );

//Subroutine.cpp
int GetCallProcName(char *buffer,char *name);
int GetProc(char *name,void **ppInfo);
void SplitObjectName(const char *name,char *ObjectName, ReferenceKind &referenceFind );
bool CallProc( int kind, const void *pProc, const char *fullCallName, const char *lpszParms, const Type &baseType, Type &resultType, bool isCallOn = true );
bool CallPropertyMethod( const char *variable, const char *rightSide, Type &resultType);
bool GetReturnTypeOfPropertyMethod( const char *variable, const char *rightSide, Type &resultType );
bool GetReturnTypeOfIndexerGetterProc( const Type &classType, Type &resultType );
int AddProcPtrInfo( const string &typeExpression, int nowLine );
bool IsNeedProcCompile();
void CompileLocal();

//OldStatement.cpp
void Opcode_Input(const char *Parameter);
void Opcode_Print(const char *Parameter,BOOL bWrite);

//error.cpp
void SetError(int ErrorNum,const char *KeyWord,int pos);
void SetError(int ErrorNum,const string &keyWord,int pos);
void SetError();
void CompileMessage(const char *buffer);
bool CheckDifferentType( const Type &varType,const Type &calcType,const char *pszFuncName,const int ParmNum);

//Compile.cpp
void GetIdentifierToken( char *token, const char *source, int &pos );
void GetCommandToken( char *token, const char *source, int &pos );
void GetCustomToken( char *token, const char *source, int &pos, char delimitation, bool isEscapeSequence );
void SplitGenericClassInstance( const char *fullName, char *className, Jenga::Common::Strings &typeParameters, bool isDefiningClass = false, Jenga::Common::Strings *pTypeParameterBaseClassNames = NULL );
int JumpStatement(const char *source, int &pos);
void Compile(void);

//Diagnose.cpp
void Diagnose();

//gc.cpp
void InitGCVariables(void);



#ifdef _DEBUG
/*Debug*/
/*
#define HeapAlloc CheckHeapAlloc
#define HeapReAlloc CheckHeapReAlloc
LPVOID CheckHeapAlloc(HANDLE hHeap,DWORD dwFlags,DWORD dwBytes);
LPVOID CheckHeapReAlloc(HANDLE hHeap,DWORD dwFlags,LPVOID lpMem,DWORD dwBytes);
*/
#endif
