#pragma once

#include <Hashmap.h>
#include <Procedure.h>

class Delegates;

class Delegate
	: public Procedure
	, public Jenga::Common::ObjectInHashmap<Delegate>
{
	friend Delegates;

	std::string paramStr;
	std::string returnTypeName;
	int sourceIndex;

	Parameters dynamicParams;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - Delegate" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Procedure );
		ar & BOOST_SERIALIZATION_NVP( dynamicParams );
	}

public:
	Delegate( const NamespaceScopes &namespaceScopes, const std::string &name, Procedure::Kind procKind, const char *paramStr, const std::string &returnTypeName, int sourceIndex )
		: Procedure( namespaceScopes, name, procKind, false )
		, paramStr( paramStr )
		, returnTypeName( returnTypeName )
		, sourceIndex( sourceIndex )
	{
	}
	Delegate()
	{
	}

	void RefleshParameterAndReturnType();

	virtual const std::string &GetKeyName() const
	{
		return GetName();
	}

	const Parameters &GetDynamicParams() const
	{
		return dynamicParams;
	}
};

class Delegates : public Jenga::Common::Hashmap<Delegate>
{
public:
	void Collect( const BasicSource &source );
	void GenerateSourceCode( std::string &destSource );
	void RefleshParameterAndReturnType();
};
