#include "stdafx.h"

#include <jenga/include/smoothie/Smoothie.h>

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void Call_DebugSys_SaveContext(){
	//call _System_GetEip
	extern const UserProc *pSub_System_GetEip;
	compiler.codeGenerator.op_call(pSub_System_GetEip);

	//push eax
	compiler.codeGenerator.op_push(REG_EAX);

	//push ebp
	compiler.codeGenerator.op_push(REG_EBP);

	//call _DebugSys_SaveContext
	extern const UserProc *pSub_DebugSys_SaveContext;
	compiler.codeGenerator.op_call(pSub_DebugSys_SaveContext);
}

bool Opcode_CallProcPtr( const char *variable, const char *lpszParms,ProcPointer *pProcPointer){

	extern BOOL bDebugCompile;
	extern BOOL bDebugSupportProc;
	if(bDebugCompile&&bDebugSupportProc==0)
		Call_DebugSys_SaveContext();


	////////////////////////
	// p[^̃Zbg
	////////////////////////

	//p[^IuWFNg𐶐
	ParamImpl *pobj_parameter=0;
	pobj_parameter=new ParamImpl(lpszParms);

	// ftHgKp
	pobj_parameter->ApplyDefaultParameters( pProcPointer->Params() );

	//G[`FbN
	if( !pobj_parameter->ErrorCheck(variable,pProcPointer->Params() ) ){
		//p[^ɃG[Ƃ͏I
		return false;
	}

	//ꎞIuWFNg𐶐
	pobj_parameter->NewTempParameters( variable,pProcPointer->Params() );

	//WX^AX^bNt[ɃZbg
	pobj_parameter->SetParameter(variable,pProcPointer->Params() );



	////////////////////////
	// call
	////////////////////////
	RELATIVE_VAR RelativeVar;
	GetVarOffsetReadOnly(variable,&RelativeVar,Type());
	SetVarPtrToEax(&RelativeVar);

	//mov eax,dword ptr[eax]
	compiler.codeGenerator.op_mov_RM( sizeof(long), REG_EAX, REG_EAX, 0, MOD_BASE );

	//call eax
	compiler.codeGenerator.op_call_R( REG_EAX );



	//ꎞIuWFNgj
	pobj_parameter->DeleteTempParameters();

	//p[^IuWFNgj
	delete pobj_parameter;

	return true;
}

bool Opcode_CallProc(const char *Parameter,const UserProc *pUserProc,DWORD dwFlags,const char *ObjectName )
{
	if( pUserProc->IsMacro() ){
		if( lstrcmpi( pUserProc->GetName().c_str(), "Print" ) == 0 ){
			Opcode_Print(Parameter,0);
			return true;
		}
		if( lstrcmpi( pUserProc->GetName().c_str(), "Input" ) == 0 ){
			Opcode_Input(Parameter);
			return true;
		}
		if( lstrcmpi( pUserProc->GetName().c_str(), "Write" ) == 0 ){
			Opcode_Print(Parameter,1);
			return true;
		}
	}

	pUserProc->Using();

	bool isStatic = false;
	const CClass *pobj_c = NULL;
	const CMethod *pMethod = NULL;
	Type leftType;
	bool isFixedClass = false;
	if( pUserProc->GetParentClassPtr() ){
		//NX̃o֐Ăяoꍇ̓ANZX`FbNs
		if(ObjectName[0] && (dwFlags&PROCFLAG_NEW)==0)
		{
			if(lstrcmpi(ObjectName,"Super")==0)
			{
				//NXo֐NX̌Ăяo
				pobj_c=&compiler.pCompilingClass->GetSuperClass();

				isFixedClass = true;
			}
			else
			{
				//"->"ɂăIuWFNgw肷ʏ̃o֐Ăяo
				Type varType;
				if( GetTermType( ObjectName, varType ) )
				{
					if( varType.IsObject() )
					{
						pobj_c = &varType.GetClass();
						leftType = varType;
					}
				}

				if( !pobj_c )
				{
					pobj_c=compiler.GetObjectModule().meta.GetClasses().Find(ObjectName);
					if( pobj_c ){
						isStatic = true;
					}
					else{
						SetError(300,NULL,cp);
					}
				}
			}
		}
		else{
			if(dwFlags&PROCFLAG_NEW){
				GetVarType( ObjectName, leftType, false );

				//NewZqɂRXgN^Ăяo
				pobj_c=pUserProc->GetParentClassPtr();
			}
			else{
				//NXo֐瓯NX̃o֐̌Ăяo
				pobj_c=compiler.pCompilingClass;
			}
		}


		/////////////////////////////////
		// \bh擾
		/////////////////////////////////
		pMethod = NULL;
		if( ! isStatic ) pMethod = pobj_c->GetDynamicMethodOrInterfaceMethod( pUserProc );
		if( ! pMethod ){
			//I\bh擾łȂƂ͐ÓI\bh𓖂
			pMethod = pobj_c->GetStaticMethods().GetMethodPtr( pUserProc );
			if( !pMethod ){
				SetError(300,NULL,cp);
				return false;
			}

			//ÓIo
			isStatic = true;
		}


		//////////////////////////////
		// ANZXG[`FbN
		//////////////////////////////

		if(ObjectName[0]){
			//ǑĂяo
			if(pobj_c==compiler.pCompilingClass){
				//NXIuWFNg̏ꍇ̓vCx[gANZXeF
				if( pMethod->IsNoneAccess() ){
					SetError(109,pUserProc->GetName(),cp);
					return false;
				}
			}
			else{
				if( pMethod->IsPrivate()
					|| pMethod->IsNoneAccess() ){
					SetError(109,pUserProc->GetName(),cp);
					return false;
				}
				if( !pMethod->GetUserProc().GetParentClass().IsEqualsOrSubClass( pobj_c ) && pMethod->IsProtected() ){
					SetError(110,pUserProc->GetName(),cp);
					return false;
				}
			}
		}
		else{
			//NX̌ĂяoipɂACCESS_NON݂̂G[Ƃj
			if( pMethod->IsNoneAccess() ){
				SetError(109,pUserProc->GetName(),cp);
				return false;
			}
		}
	}


	///////////////////////////////////////////////////////////////
	// _System_LocalThis̃_~[Zbg
	///////////////////////////////////////////////////////////////

	char temporary[VN_SIZE]={0};
	if( pUserProc->GetParentClassPtr() && isStatic == false ){
		//_System_LocalThisip[^j̃_~[쐬
		lstrcpy(temporary,"0,");
	}
	if( pUserProc->ReturnType().IsStruct() ){
		// ByRef _System_ReturnValue p[^̃_~[Zbg
		lstrcat(temporary,"0,");
	}

	if(Parameter[0]=='\0'&&temporary[0])
		temporary[lstrlen(temporary)-1]=0;
	else lstrcat(temporary,Parameter);


	////////////////////////
	// p[^Zbg
	////////////////////////

	//p[^IuWFNg𐶐
	ParamImpl *pobj_parameter=0;
	pobj_parameter=new ParamImpl(temporary);

	// ftHgKp
	pobj_parameter->ApplyDefaultParameters( pUserProc->RealParams() );

	// ^p[^Kp
	pobj_parameter->SetLeftType( leftType );

	//G[`FbN
	if( !pobj_parameter->ErrorCheck(pUserProc->GetName(),pUserProc->RealParams(),pUserProc->GetSecondParmNum() ) ){
		//p[^ɃG[Ƃ͏I
		return false;
	}

	if(pUserProc->IsMacro()){
		//}N֐̏ꍇ́Ap[^ȗl
		pobj_parameter->MacroParameterSupport( pUserProc->RealParams() );
	}

	//ꎞIuWFNg𐶐
	int tempSize = pobj_parameter->NewTempParameters( pUserProc->GetName(),pUserProc->RealParams(),pUserProc->GetRealSecondParmNum() );

	//WX^AX^bNt[ɃZbg
	int ParmSize = pobj_parameter->SetParameter(pUserProc->GetName(),pUserProc->RealParams(),pUserProc->GetRealSecondParmNum(), pUserProc );

	if(pUserProc->ReturnType().IsStruct() ){
		//////////////////////////////////////////////////////
		// ߂lɍ\̃CX^Xꍇ
		// ByRef _System_ReturnValue p[^Zbg
		//////////////////////////////////////////////////////

		int object_size = pUserProc->ReturnType().GetClass().GetSize();

		//push object_size
		compiler.codeGenerator.op_push_V(object_size);

		//call calloc
		extern const UserProc *pSub_calloc;
		compiler.codeGenerator.op_call(pSub_calloc);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);

		ParmSize += PTR_SIZE;
	}


	if( pUserProc->GetParentClassPtr() && isStatic == false ){
		//////////////////////////////////////////////////////
		// o֐̏ꍇ
		// _System_LocalThis p[^ecxɃZbg
		//////////////////////////////////////////////////////

		if(ObjectName[0] && (dwFlags&PROCFLAG_NEW)==0){
			if(lstrcmpi(ObjectName,"Super")==0) goto InClassMember;
			else{
				bool isLiteral;
				Type baseType( DEF_OBJECT, *pUserProc->GetParentClassPtr() ) , resultType;
				if( !TermOpe( ObjectName, baseType, resultType, isLiteral, NULL, NULL, false, !pMethod->IsConst() ) )
				{
					return false;
				}

				// ԃ|C^eaxɃRs[
				compiler.codeGenerator.op_mov_RR( REG_ECX, REG_EAX );
			}
		}
		else{
InClassMember:
			if(dwFlags&PROCFLAG_NEW){
				//NewZqɂRXgN^Ăяȍꍇ

				//mov ecx,dword ptr[esp+ParmSize]
				compiler.codeGenerator.op_mov_RM( sizeof(long), REG_ECX, REG_ESP, ParmSize + tempSize, MOD_BASE_DISP32 );
			}
			else{
				//This|C^ecxɃRs[
				SetThisPtrToReg(REG_ECX);
			}
		}
	}

	if( pUserProc->IsVirtual() && !isFixedClass )
	{
		int vtblIndex;
		if( pobj_c->IsInterface() )
		{
			// C^[tFCX \bhĂяo

			int offset_vtbl = compiler.GetObjectModule().meta.GetClasses().GetInterfaceInfoClassPtr()->GetMemberOffset( "__vtbl" );


			// vtbl̃|C^擾
			//mov edx,dword ptr[ecx+offset_vtbl]
			compiler.codeGenerator.op_mov_RM( sizeof(long), REG_EDX, REG_ECX, offset_vtbl, MOD_BASE_DISP8 );

			int offset_this = compiler.GetObjectModule().meta.GetClasses().GetInterfaceInfoClassPtr()->GetMemberOffset( "__this" );



			// C^[tFCX̏ꍇ͍X__this擾
			//mov ecx,qword ptr[ecx+offset_this]
			compiler.codeGenerator.op_mov_RM( sizeof(long), REG_ECX, REG_ECX, offset_this, MOD_BASE_DISP8 );

			int vtblMasterListIndex;
			pobj_c->GetVtblMasterListIndexAndVtblIndex( pUserProc, vtblMasterListIndex, vtblIndex );
			if( vtblMasterListIndex != 0 )
			{
				SetError();
			}
		}
		else if( pobj_c->IsComInterface() )
		{
			// COMC^[tFCX \bhĂяo

			//z֐iIuWFNg\bhjĂяo
			// pObj -> vtbl1 -> func1
			//               -> func2
			//               -> func3

			int vtblMasterListIndex;
			pobj_c->GetVtblMasterListIndexAndVtblIndex( pUserProc, vtblMasterListIndex, vtblIndex );

			// vtbl̃|C^擾
			//mov edx,dword ptr[ecx]
			compiler.codeGenerator.op_mov_RM( sizeof(long), REG_EDX, REG_ECX, 0, MOD_BASE );
		}
		else
		{
			//z֐iIuWFNg\bhjĂяo
			// pObj -> vtbl_master_list -> vtbl1 -> func1
			//                                   -> func2
			//                                   -> func3
			//                          -> vtbl2 -> func1
			//                                   -> func2
			//                                   -> func3

			int vtblMasterListIndex;
			pobj_c->GetVtblMasterListIndexAndVtblIndex( pUserProc, vtblMasterListIndex, vtblIndex );

			// vtbl}X^[Xg̃|C^擾
			//mov edx,dword ptr[ecx+sizeof(com_vtbl)]
			compiler.codeGenerator.op_mov_RM( sizeof(long), REG_EDX, REG_ECX, PTR_SIZE, MOD_BASE_DISP8 );
			
			// vtbl̃|C^擾
			//mov edx,dword ptr[edx+vtblMasterListIndex]
			compiler.codeGenerator.op_mov_RM( sizeof(long), REG_EDX, REG_EDX, vtblMasterListIndex*PTR_SIZE, MOD_BASE_DISP32 );
		}

		//push ecx
		compiler.codeGenerator.op_push(REG_ECX);	

		//call dword ptr[edx+func_index]
		if( vtblIndex * PTR_SIZE <= 0x7F )
		{
			compiler.codeGenerator.PutOld(
				(char)0xFF,
				(char)0x52,
				(char)(vtblIndex*PTR_SIZE)
			);
		}
		else{
			compiler.codeGenerator.PutOld(
				(char)0xFF,
				(char)0x92
			);
			compiler.codeGenerator.PutOld( (long)(vtblIndex*PTR_SIZE), Schedule::None );
		}
	}
	else{
		//ʏĂяo

		if( pUserProc->GetParentClassPtr() && isStatic == false )
		{
			//push ecx
			compiler.codeGenerator.op_push(REG_ECX);
		}

		//call ProcAddr
		compiler.codeGenerator.op_call(pUserProc);
	}

	if(pUserProc->IsCdecl()){
		//add esp,ParmSize
		compiler.codeGenerator.op_add_esp(ParmSize);
	}

	//ꎞIuWFNgj
	pobj_parameter->DeleteTempParameters();

	//p[^IuWFNgj
	delete pobj_parameter;

	return true;
}

bool Opcode_CallDllProc( const char *lpszParms, const DllProc *pDllProc ){

	extern BOOL bDebugCompile;
	extern BOOL bDebugSupportProc;
	if(bDebugCompile&&bDebugSupportProc==0&& pDllProc->IsEqualSymbol( "DebugBreak" ) ){
		Call_DebugSys_SaveContext();
	}


	////////////////////////
	// p[^̃Zbg
	////////////////////////

	//p[^IuWFNg𐶐
	ParamImpl *pobj_parameter=0;
	pobj_parameter=new ParamImpl(lpszParms);

	// ftHgKp
	pobj_parameter->ApplyDefaultParameters( pDllProc->Params() );

	//G[`FbN
	if( !pobj_parameter->ErrorCheck( pDllProc->GetName(), pDllProc->Params() ) ){
		//p[^ɃG[Ƃ͏I
		return false;
	}

	//ꎞIuWFNg𐶐
	pobj_parameter->NewTempParameters( pDllProc->GetName(), pDllProc->Params() );

	//WX^AX^bNt[ɃZbg
	int ParmSize = pobj_parameter->SetParameter(pDllProc->GetName(), pDllProc->Params() );


	//INꂽvV[W̌Ăяo

	//call dword ptr[LookupTable]
	compiler.codeGenerator.op_call( pDllProc );

	if(pDllProc->IsCdecl()){
		//add esp,ParmSize
		compiler.codeGenerator.op_add_esp(ParmSize);
	}

	//ꎞIuWFNgj
	pobj_parameter->DeleteTempParameters();

	//p[^IuWFNgj
	delete pobj_parameter;

	return true;
}

void Opcode_CallDelegate( const Delegate &dg, const char *methodPtrValueStr, const char *objPtrValueStr, const char *params )
{
	extern BOOL bDebugCompile;
	extern BOOL bDebugSupportProc;
	if(bDebugCompile&&bDebugSupportProc==0)
		Call_DebugSys_SaveContext();


	///////////////////////////////////////////////////////////////
	// _System_LocalThis̃_~[Zbg
	///////////////////////////////////////////////////////////////

	char temporary[VN_SIZE]={0};
	bool isDynamicCall = false;
	if( objPtrValueStr && objPtrValueStr[0] ){
		//_System_LocalThisip[^j̃_~[쐬
		lstrcpy(temporary,"0,");

		isDynamicCall = true;
	}
	if( dg.ReturnType().IsStruct() ){
		// ByRef _System_ReturnValue p[^̃_~[Zbg
		lstrcat(temporary,"0,");
	}

	if(params[0]=='\0'&&temporary[0])
		temporary[lstrlen(temporary)-1]=0;
	else lstrcat(temporary,params);


	const Parameters *pParams = &dg.Params();
	if( isDynamicCall )
	{
		pParams = &dg.GetDynamicParams();
	}


	ParamImpl *pobj_parameter = new ParamImpl( temporary );

	//ꎞIuWFNg𐶐
	pobj_parameter->NewTempParameters( dg.GetName(), *pParams );

	//WX^AX^bNt[ɃZbg
	int ParmSize = pobj_parameter->SetParameter( dg.GetName(), *pParams );


	if( objPtrValueStr && objPtrValueStr[0] )
	{
		RELATIVE_VAR RelativeVar;
		//ConstANZXs\ȃ\bh̏ꍇ
		if( !GetVarOffsetReadWrite( objPtrValueStr, &RelativeVar, Type() ) ){
			Jenga::Throw( "Opcode_CallDelegate֐ŌĂ΂GetVarOffsetReadWrite֐Ɏs" );
			return;
		}

		SetVarPtrToEax(&RelativeVar);

		// QƂ̃|C^ɂ
		compiler.codeGenerator.op_mov_RM( sizeof(long), REG_ECX, REG_EAX, 0, MOD_BASE );

		//push ecx
		compiler.codeGenerator.op_push(REG_ECX);
	}


	{
		////////////////////////
		// call
		////////////////////////
		RELATIVE_VAR RelativeVar;
		GetVarOffsetReadOnly( methodPtrValueStr, &RelativeVar, Type() );
		SetVarPtrToEax( &RelativeVar );

		//mov eax,dword ptr[eax]
		compiler.codeGenerator.op_mov_RM( sizeof(long), REG_EAX, REG_EAX, 0, MOD_BASE );

		//call eax
		compiler.codeGenerator.op_call_R( REG_EAX );
	}


	//ꎞIuWFNgj
	pobj_parameter->DeleteTempParameters();

	//p[^IuWFNgj
	delete pobj_parameter;
}
