#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void SystemProc(char *name){
	if(lstrcmp(name,"_System_GetEip")==0){
		//mov rax,qword ptr[rsp]
		op_mov_RM(sizeof(_int64),REG_RAX,REG_RSP,0,MOD_BASE);

		//ret
		OpBuffer[obp++]=(char)0xC3;
	}
	else if(lstrcmp(name,"_System_InitDllGlobalVariables")==0){
		////////////////////////////////////////
		// DLL̃O[öRpC
		////////////////////////////////////////
		extern BOOL bDll;
		if(!bDll){
			//ret
			OpBuffer[obp++]=(char)0xC3;

			return;
		}

		extern BOOL bCompilingGlobal;
		BOOL bBackCompilingGlobal;
		bBackCompilingGlobal=bCompilingGlobal;
		bCompilingGlobal=1;

		int BackCp;
		BackCp=cp;
		cp=-1;

		//sub rsp,X^bNt[TCY
		int StackFrameSchedule;
		op_sub_rsp(0xFFFFFFFF);
		StackFrameSchedule=obp-sizeof(long);

		extern BOOL bDebugCompile;
		if(bDebugCompile){
			//fobOp̕ϐ`
			DebugVariable();
		}

		//GCp̕ϐ`
		InitGCVariables();

		//NXɑÓIo`
		CMember::InitStaticMember();

		GetGlobalDataForDll();

		//add rsp,X^bNt[TCY
		op_add64_value(REG_RSP,pobj_sf->GetFrameSize());

		//X^bNt[XPW[isubR}hɓnlj
		*((long *)(OpBuffer+StackFrameSchedule))=pobj_sf->GetFrameSize();

		bCompilingGlobal=bBackCompilingGlobal;
		cp=BackCp;

		//ret
		OpBuffer[obp++]=(char)0xC3;
	}
	else if(lstrcmp(name,"_System_InitStaticLocalVariables")==0){
		//ÓI[JIuWFNg̃RXgN^Ăяo

		//sub rsp,X^bNt[TCY
		int StackFrameSchedule;
		op_sub_rsp(0xFFFFFFFF);
		StackFrameSchedule=obp-sizeof(long);

		extern int MaxGlobalVarNum;
		extern VARIABLE *GlobalVar;
		int i;
		for(i=0;i<MaxGlobalVarNum;i++){
			if(memicmp(GlobalVar[i].name,"Static%",7)==0){
				//RXgN^Ăяo
				if(GlobalVar[i].type==DEF_OBJECT){

					//G[p
					cp=GlobalVar[i].source_code_address;

					TYPEINFO TypeInfo;
					TypeInfo.type=GlobalVar[i].type;
					TypeInfo.u.lpIndex=GlobalVar[i].u.index;
					CallConstractor(
						GlobalVar[i].name,
						GlobalVar[i].SubScripts,
						TypeInfo,
						GlobalVar[i].ConstractParameter);
				}
			}
		}

		//add rsp,X^bNt[TCY
		op_add64_value(REG_RSP,pobj_sf->GetFrameSize());

		//X^bNt[XPW[isubR}hɓnlj
		*((long *)(OpBuffer+StackFrameSchedule))=pobj_sf->GetFrameSize();

		//ret
		OpBuffer[obp++]=(char)0xC3;
	}
	else if(lstrcmp(name,"_System_Call_Destructor_of_GlobalObject")==0){
		//sub rsp,8iRSP16oCgEɂ킹邽߁j
		op_sub_rsp(0x8);


		extern BOOL bCompilingGlobal;
		BOOL bBackCompilingGlobal;
		bBackCompilingGlobal=bCompilingGlobal;
		bCompilingGlobal=1;

		obj_LexScopes.CallDestructorsOfScopeEnd();

		bCompilingGlobal=bBackCompilingGlobal;


		//add rsp,8
		op_add64_value(REG_RSP,0x8);

		//ret
		OpBuffer[obp++]=(char)0xC3;
	}
	else if(lstrcmp(name,"_System_GetSp")==0){
		//mov rax,rsp
		op_mov_RR(REG_RAX,REG_RSP);

		//add rax,PTR_SIZE
		op_add64_value(REG_RAX,PTR_SIZE);

		//ret
		OpBuffer[obp++]=(char)0xC3;
	}
	else if(lstrcmp(name,"_allrem")==0){
		//揜Zp̓֐i64rbgΉj
		BYTE Buffer_allrem[]={
			0x53,0x57,0x33,0xFF,0x8B,0x44,0x24,0x10,0x0B,0xC0,0x7D,0x14,0x47,0x8B,0x54,0x24,0x0C,0xF7,0xD8,0xF7,0xDA,0x83,0xD8,0x00,0x89,0x44,0x24,0x10,0x89,0x54,0x24,0x0C,0x8B,0x44,0x24,0x18,0x0B,0xC0,0x7D,0x13,0x8B,0x54,0x24,0x14,0xF7,0xD8,0xF7,0xDA,0x83,0xD8,0x00,0x89,0x44,0x24,0x18,0x89,0x54,0x24,0x14,0x0B,0xC0,0x75,0x1B,0x8B,0x4C,0x24,0x14,0x8B,0x44,0x24,0x10,0x33,0xD2,0xF7,0xF1,0x8B,0x44,0x24,0x0C,0xF7,0xF1,0x8B,0xC2,0x33,0xD2,0x4F,0x79,0x4E,0xEB,0x53,0x8B,0xD8,0x8B,0x4C,0x24,0x14,0x8B,0x54,0x24,0x10,0x8B,0x44,0x24,0x0C,0xD1,0xEB,0xD1,0xD9,0xD1,0xEA,0xD1,0xD8,0x0B,0xDB,0x75,0xF4,0xF7,0xF1,0x8B,0xC8,0xF7,0x64,0x24,0x18,0x91,0xF7,0x64,0x24,0x14,0x03,0xD1,0x72,0x0E,0x3B,0x54,0x24,0x10,0x77,0x08,0x72,0x0E,0x3B,0x44,0x24,0x0C,0x76,0x08,0x2B,0x44,0x24,0x14,0x1B,0x54,0x24,0x18,0x2B,0x44,0x24,0x0C,0x1B,0x54,0x24,0x10,0x4F,0x79,0x07,0xF7,0xDA,0xF7,0xD8,0x83,0xDA,0x00,0x5F,0x5B,0xC2,0x10,0x00
		};

		memcpy(OpBuffer+obp,Buffer_allrem,178);
		obp+=178;
	}
	else if(lstrcmp(name,"_allmul")==0){
		//Zp̓֐i64rbgΉj
		BYTE Buffer_allmul[]={
			0x8B,0x44,0x24,0x08,0x8B,0x4C,0x24,0x10,0x0B,0xC8,0x8B,0x4C,0x24,0x0C,0x75,0x09,0x8B,0x44,0x24,0x04,0xF7,0xE1,0xC2,0x10,0x00,0x53,0xF7,0xE1,0x8B,0xD8,0x8B,0x44,0x24,0x08,0xF7,0x64,0x24,0x14,0x03,0xD8,0x8B,0x44,0x24,0x08,0xF7,0xE1,0x03,0xD3,0x5B,0xC2,0x10,0x00
		};

		memcpy(OpBuffer+obp,Buffer_allmul,52);
		obp+=52;
	}
	else if(lstrcmp(name,"_alldiv")==0){
		//Zp̓֐i64rbgΉj
		BYTE Buffer_alldiv[]={
			0x57,0x56,0x53,0x33,0xFF,0x8B,0x44,0x24,0x14,0x0B,0xC0,0x7D,0x14,0x47,0x8B,0x54,0x24,0x10,0xF7,0xD8,0xF7,0xDA,0x83,0xD8,0x00,0x89,0x44,0x24,0x14,0x89,0x54,0x24,0x10,0x8B,0x44,0x24,0x1C,0x0B,0xC0,0x7D,0x14,0x47,0x8B,0x54,0x24,0x18,0xF7,0xD8,0xF7,0xDA,0x83,0xD8,0x00,0x89,0x44,0x24,0x1C,0x89,0x54,0x24,0x18,0x0B,0xC0,0x75,0x18,0x8B,0x4C,0x24,0x18,0x8B,0x44,0x24,0x14,0x33,0xD2,0xF7,0xF1,0x8B,0xD8,0x8B,0x44,0x24,0x10,0xF7,0xF1,0x8B,0xD3,0xEB,0x41,0x8B,0xD8,0x8B,0x4C,0x24,0x18,0x8B,0x54,0x24,0x14,0x8B,0x44,0x24,0x10,0xD1,0xEB,0xD1,0xD9,0xD1,0xEA,0xD1,0xD8,0x0B,0xDB,0x75,0xF4,0xF7,0xF1,0x8B,0xF0,0xF7,0x64,0x24,0x1C,0x8B,0xC8,0x8B,0x44,0x24,0x18,0xF7,0xE6,0x03,0xD1,0x72,0x0E,0x3B,0x54,0x24,0x14,0x77,0x08,0x72,0x07,0x3B,0x44,0x24,0x10,0x76,0x01,0x4E,0x33,0xD2,0x8B,0xC6,0x4F,0x75,0x07,0xF7,0xDA,0xF7,0xD8,0x83,0xDA,0x00,0x5B,0x5E,0x5F,0xC2,0x10,0x00
		};

		memcpy(OpBuffer+obp,Buffer_alldiv,170);
		obp+=170;
	}
	else if(lstrcmp(name,"_allshl")==0){
		//荶rbgVtgp̓֐i64rbgΉj
		BYTE Buffer_allshl[]={
			0x80,0xF9,0x40,0x73,0x15,0x80,0xF9,0x20,0x73,0x06,0x0F,0xA5,0xC2,0xD3,0xE0,0xC3,0x8B,0xD0,0x33,0xC0,0x80,0xE1,0x1F,0xD3,0xE2,0xC3,0x33,0xC0,0x33,0xD2,0xC3
		};

		memcpy(OpBuffer+obp,Buffer_allshl,31);
		obp+=31;
	}
	else if(lstrcmp(name,"_allshr")==0){
		//ErbgVtgp̓֐i64rbgΉj
		BYTE Buffer_allshr[]={
			0x80,0xF9,0x40,0x73,0x16,0x80,0xF9,0x20,0x73,0x06,0x0F,0xAD,0xD0,0xD3,0xFA,0xC3,0x8B,0xC2,0xC1,0xFA,0x1F,0x80,0xE1,0x1F,0xD3,0xF8,0xC3,0xC1,0xFA,0x1F,0x8B,0xC2,0xC3
		};

		memcpy(OpBuffer+obp,Buffer_allshr,33);
		obp+=33;
	}
	else if(lstrcmp(name,"_aullshr")==0){
		//ȂErbgVtgp̓֐i64rbgΉj
		BYTE Buffer_aullshr[]={
			0x80,0xF9,0x40,         //cmp         cl,40h
			0x73,0x15,              //jae         RETZERO (0040d71a)
			0x80,0xF9,0x20,         //cmp         cl,20h
			0x73,0x06,              //jae         MORE32 (0040d710)
			0x0F,0xAD,0xD0,         //shrd        eax,edx,cl
			0xD3,0xEA,              //shr         edx,cl
			0xC3,                   //ret
			//MORE32:
			0x8B,0xC2,              //mov         eax,edx
			0x33,0xD2,              //xor         edx,edx
			0x80,0xE1,0x1F,         //and         cl,1Fh
			0xD3,0xE8,              //shr         eax,cl
			0xC3,                   //ret
			//RETZERO:
			0x33,0xC0,              //xor         eax,eax
			0x33,0xD2,              //xor         edx,edx
			0xC3                    //ret
		};

		memcpy(OpBuffer+obp,Buffer_aullshr,31);
		obp+=31;
	}
}
void CompileBufferInProcedure(SUBINFO *psi){
	extern char *basbuf;
	extern HANDLE hHeap;
	extern SUBINFO **ppSubHash;
	extern BOOL bDebugCompile;
	int i3,i4,i5,VarSize,BufferSize;
	char temporary[VN_SIZE];

	BufferSize=128;

	if(psi->bUse==0||psi->bCompile) return;


	psi->bCompile=1;

	extern BOOL bSystemProc;
	if(memcmp(psi->name,"_System_",8)==0) bSystemProc=1;
	else bSystemProc=0;

	extern BOOL bDebugSupportProc;
	if(memcmp(psi->name,"_DebugSys_",10)==0){
		if(!bDebugCompile){
			psi->pVar=(VARIABLE *)HeapAlloc(hHeap,0,1);
			psi->VarNum=0;
			return;
		}
		bDebugSupportProc=1;
	}
	else bDebugSupportProc=0;

	psi->CompileAddress=obp;

	if(psi->bSystem){
		////////////////////
		// ֐
		////////////////////

		extern int MaxLocalVarNum;
		extern int AllLocalVarSize;
		MaxLocalVarNum=0;
		AllLocalVarSize=0;

		//X^bNt[ǗpIuWFNg
		extern CStackFrame *pobj_sf;
		pobj_sf=new CStackFrame();

		SystemProc(psi->name);

		//X^bNt[ǗpIuWFNgj
		delete pobj_sf;
		pobj_sf=0;

		psi->EndOpAddr=obp;
		psi->pVar=(VARIABLE *)HeapAlloc(hHeap,0,1);
		psi->VarNum=0;
		return;
	}

	cp=psi->address;
	for(;;cp++){
		if(IsCommandDelimitation(basbuf[cp])) break;
	}
	cp--;

	//vV[WoXPW[iExit Sub/Functionj
	extern DWORD *pExitSubSchedule;
	extern int ExitSubScheduleNum;
	pExitSubSchedule=(DWORD *)HeapAlloc(hHeap,0,1);
	ExitSubScheduleNum=0;

	//xp̃m
	extern LABEL *pLabelNames;
	extern int MaxLabelNum;
	pLabelNames=(LABEL *)HeapAlloc(hHeap,0,1);
	MaxLabelNum=0;

	//GotoxXPW[
	extern GOTOLABELSCHEDULE *pGotoLabelSchedule;
	extern int GotoLabelScheduleNum;
	pGotoLabelSchedule=(GOTOLABELSCHEDULE *)HeapAlloc(hHeap,0,1);
	GotoLabelScheduleNum=0;

	//With̃m
	extern WITHINFO WithInfo;
	WithInfo.ppName=(char **)HeapAlloc(hHeap,0,1);
	WithInfo.pWithCp=(int *)HeapAlloc(hHeap,0,1);
	WithInfo.num=0;

	//dG[Ǘ̃m
	extern char **SynonymErrorWords;
	extern int SynonymErrorNum;
	SynonymErrorNum=0;
	SynonymErrorWords=(char **)HeapAlloc(hHeap,0,1);

	//ContinueAhX
	extern DWORD dwContinueAddress;
	dwContinueAddress=-1;

	//[JϐɊւ
	extern VARIABLE *LocalVar;
	extern int MaxLocalVarNum;
	extern int AllLocalVarSize;
	LocalVar=(VARIABLE *)HeapAlloc(hHeap,0,sizeof(VARIABLE));
	MaxLocalVarNum=0;
	AllLocalVarSize=0;

	//[JϐAhXXPW[
	extern DWORD *pLocalVarAddrSchedule;
	extern int LocalVarAddrScheduleNum;
	pLocalVarAddrSchedule=(DWORD *)HeapAlloc(hHeap,0,1);
	LocalVarAddrScheduleNum=0;

	//LVJXR[v
	obj_LexScopes.Init(obp);


	/////////////////////////////////////
	// p[^p̕ϐf[^l
	/////////////////////////////////////

	for(i3=psi->RealParmNum-1;i3>=0;i3--){
		//ϐf[^ǉ
		LocalVar=(VARIABLE *)HeapReAlloc(hHeap,0,LocalVar,(MaxLocalVarNum+1)*sizeof(VARIABLE));

		lstrcpy(LocalVar[MaxLocalVarNum].name,psi->pRealParmInfo[i3].name);

		// TODO: p[^Const`̎w肪
		LocalVar[MaxLocalVarNum].bConst=false;

		LocalVar[MaxLocalVarNum].bArray=psi->pRealParmInfo[i3].bArray;
		memcpy(LocalVar[MaxLocalVarNum].SubScripts,psi->pRealParmInfo[i3].SubScripts,MAX_ARRAYDIM*sizeof(int));

		LocalVar[MaxLocalVarNum].type=psi->pRealParmInfo[i3].type;
		if(LocalVar[MaxLocalVarNum].type==DEF_OBJECT){
			if(psi->bExport)
				SetError(24,NULL,cp);
		}

		LocalVar[MaxLocalVarNum].u.index=psi->pRealParmInfo[i3].u.index;

		if(psi->pRealParmInfo[i3].bByVal&&psi->pRealParmInfo[i3].type==DEF_OBJECT){
			//ԃIuWFNgByValp[^
			LocalVar[MaxLocalVarNum].fRef=REF_PARAMETER | OBJECT_PARAMETER;
			VarSize=PTR_SIZE;
		}
		else{
			if(psi->pRealParmInfo[i3].bByVal&&psi->pRealParmInfo[i3].bArray==0){
				LocalVar[MaxLocalVarNum].fRef=0;
				VarSize=GetTypeSize(LocalVar[MaxLocalVarNum].type,LocalVar[MaxLocalVarNum].u.index);
				if(VarSize%PTR_SIZE) VarSize+=PTR_SIZE-(VarSize%PTR_SIZE);
			}
			else{
				LocalVar[MaxLocalVarNum].fRef=REF_PARAMETER;
				VarSize=PTR_SIZE;
			}
		}
		AllLocalVarSize+=VarSize;
		LocalVar[MaxLocalVarNum].offset=AllLocalVarSize;

		//LVJXR[v
		LocalVar[MaxLocalVarNum].ScopeLevel=obj_LexScopes.GetNowLevel();
		LocalVar[MaxLocalVarNum].ScopeStartAddress=obj_LexScopes.GetStartAddress();
		LocalVar[MaxLocalVarNum].bLiving=TRUE;

		MaxLocalVarNum++;
	}

	//This|C^[JItZbglZbg
	extern int LocalVar_ThisPtrOffset;
	LocalVar_ThisPtrOffset=AllLocalVarSize;

	//RpC̊֐NX
	pobj_CompilingClass=psi->pobj_ParentClass;
	
	//RpCX^[gNXǗNXɒǉ
	pobj_DBClass->StartCompile( psi );

	//RpC̊֐
	extern SUBINFO *pCompilingSubInfo;
	pCompilingSubInfo=psi;

	//X^bNt[ǗpNX
	extern CStackFrame *pobj_sf;
	pobj_sf=new CStackFrame();


	///////////////////////
	// R[h

	for(i3=psi->RealParmNum-1;i3>=0;i3--){
		if(i3==3){
			if(IsRealNumberType(psi->pRealParmInfo[i3].type)&&psi->pRealParmInfo[i3].bByVal){
				//movsd qword ptr[rsp+0x20],xmm3
				op_movsd_MR(REG_XMM3,REG_RSP,0x20,MOD_BASE_DISP32);
			}
			else{
				//mov qword ptr[rsp+0x20],r9
				op_mov_MR(sizeof(_int64),REG_R9,REG_RSP,0x20,MOD_BASE_DISP32);
			}
		}
		if(i3==2){
			if(IsRealNumberType(psi->pRealParmInfo[i3].type)&&psi->pRealParmInfo[i3].bByVal){
				//movsd qword ptr[rsp+0x18],xmm2
				op_movsd_MR(REG_XMM2,REG_RSP,0x18,MOD_BASE_DISP32);
			}
			else{
				//mov qword ptr[rsp+0x18],r8
				op_mov_MR(sizeof(_int64),REG_R8,REG_RSP,0x18,MOD_BASE_DISP32);
			}
		}
		if(i3==1){
			if(IsRealNumberType(psi->pRealParmInfo[i3].type)&&psi->pRealParmInfo[i3].bByVal){
				//movsd qword ptr[rsp+0x10],xmm1
				op_movsd_MR(REG_XMM1,REG_RSP,0x10,MOD_BASE_DISP32);
			}
			else{
				//mov qword ptr[rsp+0x10],rdx
				op_mov_MR(sizeof(_int64),REG_RDX,REG_RSP,0x10,MOD_BASE_DISP32);
			}
		}
		if(i3==0){
			if(IsRealNumberType(psi->pRealParmInfo[i3].type)&&psi->pRealParmInfo[i3].bByVal){
				//movsd qword ptr[rsp+0x8],xmm0
				op_movsd_MR(REG_XMM0,REG_RSP,0x8,MOD_BASE_DISP32);
			}
			else{
				//mov qword ptr[rsp+0x8],rcx
				op_mov_MR(sizeof(_int64),REG_RCX,REG_RSP,0x8,MOD_BASE_DISP32);
			}
		}
	}

	//retp̃AhXl
	AllLocalVarSize+=sizeof(_int64);

	//sub rsp,X^bNt[TCY
	int StackFrameSchedule;
	op_sub_rsp(0xFFFFFFFF);
	StackFrameSchedule=obp-sizeof(long);

	//mov qword ptr[rsp+offset],reg     X^bNt[𗘗p
	pobj_sf->push(REG_RBX);
	pobj_sf->push(REG_RSI);
	pobj_sf->push(REG_RDI);
	pobj_sf->push(REG_R12);
	pobj_sf->push(REG_R13);
	pobj_sf->push(REG_R14);
	pobj_sf->push(REG_R15);

	//[Jϐ̃x[Xl
	int BaseLocalVar;
	BaseLocalVar=AllLocalVarSize;

	if(psi->ReturnType!=-1){
		//߂l݂Ƃ

		char *temp;
		if(psi->name[0]==1&&psi->name[1]==ESC_OPERATOR) temp="_System_ReturnValue";
		else temp=psi->name;

		if(psi->ReturnType==DEF_OBJECT && psi->isReturnRef == false){
			//߂lpIuWFNg̃RXgN^Ăяo
			if(psi->u.Return_pobj_c->ConstructorMemberSubIndex!=-1){
				sprintf(temporary,"%s.%s()",temp,psi->u.Return_pobj_c->name);
				OpcodeOthers(temporary);
			}
		}
		else{
			//߂lp̕ϐ̒`
			if( psi->isReturnRef ){
				sprintf(temporary,"%c%c",1,ESC_BYREF);
			}
			else temporary[0]=0;

			sprintf(temporary+lstrlen(temporary),"%s%c%c",temp,1,ESC_AS);
			GetTypeName(psi->ReturnType,psi->u.ReturnIndex,temporary+lstrlen(temporary));

			OpcodeDim(temporary,0);
		}
	}

	int RspOffsetSchedule=0;
	int RspOffsetSchedule2;
	if(bDebugCompile&&bDebugSupportProc==0){
		//mov rdx, qword ptr[rsp+X^bNt[TCY]
		op_mov_RM(sizeof(_int64),REG_RDX,REG_RSP,0,MOD_BASE_DISP32);
		RspOffsetSchedule=obp-sizeof(long);

		//mov rcx,rsp
		op_mov64_ToReg_FromReg(REG_RCX,REG_RSP);

		//add rcx,X^bNt[TCY+sizeof(_int64) retp̃TCYl
		op_add64_value(REG_RCX,0);
		RspOffsetSchedule2=obp-sizeof(long);

		//call _DebugSys_StartProc
		extern SUBINFO *pSub_DebugSys_StartProc;
		op_call(pSub_DebugSys_StartProc);
	}

	if(pobj_CompilingClass){
		if(lstrcmp(psi->name,pobj_CompilingClass->name)==0){
			////////////////////////////////////
			// RXgN^RpCƂ
			////////////////////////////////////

			//RXgN^̃RpCJnʒm
			pobj_CompilingClass->NotifyStartConstructorCompile();

			//NXǂ̎
			//ipC^[tFCX̏ꍇNXƌȂj
			BOOL bThisIsSuperClass;
			if(pobj_CompilingClass->pobj_InheritsClass==0) bThisIsSuperClass=1;
			else if(pobj_CompilingClass->pobj_InheritsClass->ConstructorMemberSubIndex==-1){
				//C^[tFCXpƂ̓RXgN^Ȃ
				bThisIsSuperClass=1;
			}
			else bThisIsSuperClass=0;

			if(!bThisIsSuperClass){
				/* TuNXRXgN^RpCĂƂ́A
					NX̃RXgN^Ăяo */

				i3=cp+1;
				while(IsCommandDelimitation(basbuf[i3])) i3++;
				for(i4=0;;i3++,i4++){
					if(!IsVariableChar(basbuf[i3])){
						temporary[i4]=0;
						break;
					}
					temporary[i4]=basbuf[i3];
				}
				if(lstrcmp(temporary,
					pobj_CompilingClass->pobj_InheritsClass->name)==0){
					//NX̃RXgN^Ăяo
					cp=i3;
					for(i4=0;;cp++,i4++){
						if(IsCommandDelimitation(basbuf[cp])){
							temporary[i4]=0;
							break;
						}
						temporary[i4]=basbuf[cp];
					}
					if(!(temporary[0]=='('&&temporary[lstrlen(temporary)-1]==')')){
						SetError(1,NULL,cp);
					}
					RemoveStringPare(temporary);

					i3=pobj_CompilingClass->pobj_InheritsClass->ConstructorMemberSubIndex;
					Opcode_CallProc(temporary,
						pobj_CompilingClass->ppobj_Method[i3]->psi,
						0,
						"",
						0);
				}
				else{
					//NX̃RXgN^ÖٓIɌĂяo
					i3=pobj_CompilingClass->pobj_InheritsClass->ConstructorMemberSubIndex;
					Opcode_CallProc("",
						pobj_CompilingClass->ppobj_Method[i3]->psi,
						0,
						"",
						0);
				}
			}

			//̃NXõRXgN^iLjĂяo
			int offset;
			int MemberTypeSize;
			int MemberObjectNum;
			if(pobj_CompilingClass->vtbl_num) offset=PTR_SIZE;
			else offset=0;
			for(i3=0;i3<pobj_CompilingClass->iMemberNum;i3++){
				CMember *pMember = pobj_CompilingClass->ppobj_Member[i3];
				MemberTypeSize=
					GetTypeSize(pMember->TypeInfo.type,
						pMember->TypeInfo.u.lpIndex);

				MemberObjectNum=
					JumpSubScripts(pMember->SubScripts);

				offset=GetSizeOfClassMember(pobj_CompilingClass,pMember->name,NULL);

				if(pMember->TypeInfo.type==DEF_OBJECT && pMember->IsRef() == false){
					if(pMember->TypeInfo.u.pobj_Class->ConstructorMemberSubIndex!=-1){
						i5=pMember->TypeInfo.u.pobj_Class->ConstructorMemberSubIndex;
						if(pMember->TypeInfo.u.pobj_Class->ppobj_Method[i5]->psi->RealParmNum==1){	//This|C^Ɏ킹邽߁AȂ̏ꍇ͂̒l1ɂȂ
							for(i4=0;i4<MemberObjectNum;i4++){
								//This|C^rcxɃRs[
								SetThisPtrToReg(REG_RCX);

								//add rcx,offset
								op_add64_value(REG_RCX,offset+i4*MemberTypeSize);

								//call constructor
								op_call(pMember->TypeInfo.u.pobj_Class->ppobj_Method[i5]->psi);
							}
						}
					}
				}
			}

			//z֐e[u
			if(pobj_CompilingClass->vtbl_num&&
				pobj_CompilingClass->IsAbstract()==false){
					//֐e[uɒlZbg
					offset=(int)pobj_CompilingClass->GetVtblGlobalOffset();

					//mov rax,offset
					op_mov_RV(sizeof(_int64),REG_RAX,offset);
					obp-=sizeof(long);
					pobj_DataTableSchedule->add();
					obp+=sizeof(long);

					//This|C^rcxɃRs[
					SetThisPtrToReg(REG_RCX);

					//mov qword ptr[rcx],rax
					op_mov_MR(sizeof(_int64),REG_RAX,REG_RCX,0,MOD_BASE);
			}
		}
		else if(psi->name[0]=='~'){
			//fXgN^RpCƂ

			//fXgN^̃RpCJnʒm
			pobj_CompilingClass->NotifyStartDestructorCompile();
		}
	}

	//R[hɊ֐̐擪̈DimXe[ggĔzuł悤ɂ
	extern int DimStatementInsertPoint;
	DimStatementInsertPoint=obp;

	//////////////////////////////////////////
	//////////////////////////////////////////
	////// vV[WRpC ////////
	if(psi->dwType==SUBTYPE_SUB) CompileBuffer(ESC_ENDSUB,0);
	else if(psi->dwType==SUBTYPE_FUNCTION) CompileBuffer(ESC_ENDFUNCTION,0);
	else if(psi->dwType==SUBTYPE_MACRO) CompileBuffer(ESC_ENDMACRO,0);
	//////////////////////////////////////////
	//////////////////////////////////////////

	if( pobj_CompilingClass ){

		if( pobj_CompilingClass->IsCompilingConstructor() ){
			// RXgN^RpCĂƂ

			// RXgN^̃RpCƂʒm
			pobj_CompilingClass->NotifyFinishConstructorCompile();
		}
		else if(psi->name[0]=='~'){
			////////////////////////////////////
			//fXgN^RpCƂ
			////////////////////////////////////

			// fXgN^̃RpCƂʒm
			pobj_CompilingClass->NotifyFinishDestructorCompile();

			if(pobj_CompilingClass->pobj_InheritsClass){
				/* TuNX̃fXgN^RpCĂƂ́A
					NX̃fXgN^Ăяo */

				i3=pobj_CompilingClass->pobj_InheritsClass->DestructorMemberSubIndex;
				if(i3!=-1){
					Opcode_CallProc("",
						pobj_CompilingClass->ppobj_Method[i3]->psi,
						0,
						"",
						0);
				}
			}

			//̃NXõfXgN^Ăяo
			//RXgN^ƋtŌĂяo
			int offset;
			int MemberTypeSize;
			int MemberObjectNum;
			for(i3=pobj_CompilingClass->iMemberNum-1;i3>=0;i3--){
				CMember *pMember = pobj_CompilingClass->ppobj_Member[i3];
				MemberTypeSize=
					GetTypeSize(pMember->TypeInfo.type,
						pMember->TypeInfo.u.lpIndex);

				MemberObjectNum=
					JumpSubScripts(pMember->SubScripts);

				offset=GetSizeOfClassMember(pobj_CompilingClass,pMember->name,NULL);

				if(pMember->TypeInfo.type==DEF_OBJECT && pMember->IsRef() == false){
					if(pMember->TypeInfo.u.pobj_Class->DestructorMemberSubIndex!=-1){
						for(i4=MemberObjectNum-1;i4>=0;i4--){
							//This|C^rcxɃRs[
							SetThisPtrToReg(REG_RCX);

							//add rcx,offset
							op_add64_value(REG_RCX,offset+i4*MemberTypeSize);

							//call destructor
							i5=pMember->TypeInfo.u.pobj_Class->DestructorMemberSubIndex;
							op_call(pMember->TypeInfo.u.pobj_Class->ppobj_Method[i5]->psi);
						}
					}
				}
			}
		}
	}

	//xp̃
	for(i3=0;i3<MaxLabelNum;i3++){
		if(pLabelNames[i3].pName) HeapDefaultFree(pLabelNames[i3].pName);
	}
	HeapDefaultFree(pLabelNames);

	//GotomxXPW[
	for(i3=0;i3<GotoLabelScheduleNum;i3++){
		if(pGotoLabelSchedule[i3].pName){
			SetError(6,pGotoLabelSchedule[i3].pName,pGotoLabelSchedule[i3].now_cp);
			HeapDefaultFree(pGotoLabelSchedule[i3].pName);
		}
		else{
			sprintf(temporary,"%d",pGotoLabelSchedule[i3].line);
			SetError(6,temporary,pGotoLabelSchedule[i3].now_cp);
		}
	}
	HeapDefaultFree(pGotoLabelSchedule);

	//With̃
	for(i3=0;i3<WithInfo.num;i3++){
		SetError(22,"With",WithInfo.pWithCp[i3]);
		HeapDefaultFree(WithInfo.ppName[i3]);
	}
	HeapDefaultFree(WithInfo.ppName);
	HeapDefaultFree(WithInfo.pWithCp);

	//dG[Ǘ̃
	for(i3=0;i3<SynonymErrorNum;i3++) HeapDefaultFree(SynonymErrorWords[i3]);
	HeapDefaultFree(SynonymErrorWords);

	//[JIuWFNgiLVJXR[vx=0j̉
	obj_LexScopes.CallDestructorsOfScopeEnd();

	//vV[WoXPW[iExit Sub/Functionj
	for(i3=0;i3<ExitSubScheduleNum;i3++){
		*((long *)(OpBuffer+pExitSubSchedule[i3]))=obp-(pExitSubSchedule[i3]+sizeof(long));
	}
	HeapDefaultFree(pExitSubSchedule);

	if(bDebugCompile&&bDebugSupportProc==0){
		//call _DebugSys_EndProc
		extern SUBINFO *pSub_DebugSys_EndProc;
		op_call(pSub_DebugSys_EndProc);
	}

	if(psi->ReturnType!=-1){
		//////////////////////////////////
		// ߂lrax܂xmm0ɐݒ
		//////////////////////////////////

		RELATIVE_VAR RelativeVar;
		LONG_PTR lpIndex;

		char *temp;
		if(psi->name[0]==1&&psi->name[1]==ESC_OPERATOR)
			temp="_System_ReturnValue";
		else temp=psi->name;
		GetVarOffsetReadWrite(temp,&i3,&RelativeVar,&lpIndex);

		i3=psi->ReturnType;

		if(i3==DEF_OBJECT){
			SetVarPtrToReg(REG_RAX,&RelativeVar);
		}
		else if(i3==DEF_DOUBLE){
			//64rbg^
			SetXmmReg_DoubleVariable(&RelativeVar,REG_XMM0);
		}
		else if(i3==DEF_SINGLE){
			//32rbg^
			SetXmmReg_SingleVariable(&RelativeVar,REG_XMM0);
		}
		else if(IsWholeNumberType(i3)){
			//^
			SetReg_WholeVariable(i3,&RelativeVar,REG_RAX);
		}
		else SetError(300,NULL,cp);
	}

	//[Jϐ̈̃TCYX^bNt[ɒʒm
	int iLocalParmSize;
	iLocalParmSize=AllLocalVarSize-BaseLocalVar;
	pobj_sf->SetLocalParmSize(iLocalParmSize);

	//[JϐAhXXPW[
	for(i3=0;i3<LocalVarAddrScheduleNum;i3++){
		*((long *)(OpBuffer+pLocalVarAddrSchedule[i3]))+=AllLocalVarSize+pobj_sf->GetFrameSize();
	}
	HeapDefaultFree(pLocalVarAddrSchedule);
	for(i3=0;i3<MaxLocalVarNum;i3++){
		//ɃfobOŗp
		LocalVar[i3].offset=AllLocalVarSize+pobj_sf->GetFrameSize()-LocalVar[i3].offset;
	}

	//mov reg,qword ptr[rsp+offset]     X^bNt[𗘗p
	pobj_sf->pop(REG_R15);
	pobj_sf->pop(REG_R14);
	pobj_sf->pop(REG_R13);
	pobj_sf->pop(REG_R12);
	pobj_sf->pop(REG_RDI);
	pobj_sf->pop(REG_RSI);
	pobj_sf->pop(REG_RBX);

	int iStackFrameSize;
	iStackFrameSize=iLocalParmSize + pobj_sf->GetFrameSize();

	//add rsp,X^bNt[TCY
	op_add_rsp(iStackFrameSize);

	//ret 0
	OpBuffer[obp++]=(char)0xC3;


	//fobOp
	if(RspOffsetSchedule){
		*((long *)(OpBuffer+RspOffsetSchedule))=iStackFrameSize;
		*((long *)(OpBuffer+RspOffsetSchedule2))=iStackFrameSize+sizeof(_int64);
	}


	//X^bNt[XPW[isubR}hj
	*((long *)(OpBuffer+StackFrameSchedule))=iStackFrameSize;

	//X^bNt[XPW[s
	pobj_sf->RunningSchedule();
	delete pobj_sf;
	pobj_sf=0;


	psi->EndOpAddr=obp;
	psi->pVar=LocalVar;
	psi->VarNum=MaxLocalVarNum;

	//[Jϐ̃l[͌ɉ
}
void CompileLocal(){
	extern SUBINFO **ppSubHash;
	int i2;
	SUBINFO *psi;

	extern BOOL bDll;
	if(bDll){
		//DLL̏ꍇ̓O[oϐ邽߂̊֐ԏ߂ɃRpC
		psi=GetSubHash("_System_InitDllGlobalVariables");
		if(psi){
			CompileBufferInProcedure(psi);
		}
		else SetError(300,NULL,cp);
	}

	//_System_InitStaticLocalVariables͈ԍŌɃRpC
	//ʊ֐̐ÓIϐIuWFNgׂĎWȂ΂ȂȂ
	extern SUBINFO *pSub_System_InitStaticLocalVariables;
	pSub_System_InitStaticLocalVariables->bCompile=1;

	//_System_Call_Destructor_of_GlobalObject͈ԍŌɃRpC
	extern SUBINFO *pSub_System_Call_Destructor_of_GlobalObject;
	pSub_System_Call_Destructor_of_GlobalObject->bCompile=1;

Repeat:
	for(i2=0;i2<MAX_HASH;i2++){
		psi=ppSubHash[i2];
		while(psi){
			CompileBufferInProcedure(psi);
			psi=psi->pNextData;
		}
	}

	//vV[WRpCɂāAvV[WRpCKvɂȂꍇ
	for(i2=0;i2<MAX_HASH;i2++){
		psi=ppSubHash[i2];
		while(psi){
			if(psi->bUse&&psi->bCompile==0&&psi->bVirtual==0){
				goto Repeat;
			}

			psi=psi->pNextData;
		}
	}

	//_System_InitStaticLocalVariables͈ԍŌɃRpC
	pSub_System_InitStaticLocalVariables->bCompile=0;
	CompileBufferInProcedure(pSub_System_InitStaticLocalVariables);

	//_System_Call_Destructor_of_GlobalObject͈ԍŌɃRpC
	pSub_System_Call_Destructor_of_GlobalObject->bCompile=0;
	CompileBufferInProcedure(pSub_System_Call_Destructor_of_GlobalObject);
}
