#include "stdafx.h"

void EnumInfo::Collect( const char *buffer,int nowLine)
{
	this->members.clear();

	int i=nowLine,i2;

	if(!(buffer[i]==1&&buffer[i+1]==ESC_ENUM)) return;
	i+=2;

	//񋓑̖̂O擾
	char temporary[VN_SIZE];
	for(i2=0;;i++,i2++){
		if(IsCommandDelimitation(buffer[i])){
			temporary[i2]=0;
			break;
		}
		if(!IsVariableChar(buffer[i])){
			SetError(1,NULL,i);
			break;
		}
		temporary[i2]=buffer[i];
	}

	if(buffer[i]=='\0'){
		SetError(22,"Enum",nowLine);
		return;
	}

	int currentValue = 0;
	bool isUseCurrentValue = true;
	std::string currentValueStr;
	std::string lastMemberName;
	char temp2[VN_SIZE];
	while(1){
		i++;

		if(buffer[i]==1&&buffer[i+1]==ESC_ENDENUM) break;

		for(i2=0;;i2++,i++){
			if(IsCommandDelimitation(buffer[i])){
				temporary[i2]=0;
				break;
			}
			if(buffer[i]=='='){
				temporary[i2]=0;
				break;
			}
			temporary[i2]=buffer[i];
		}
		if(temporary[0]=='\0'){
			if(buffer[i]=='\0'){
				SetError(22,"Enum",nowLine);
				break;
			}
			continue;
		}

		if( buffer[i] != '=' )
		{
			if( isUseCurrentValue )
			{
				currentValue++;

				sprintf( temp2, "%d", currentValue );
				currentValueStr = temp2;
			}
			else
			{
				currentValueStr = lastMemberName + "+1";
			}
		}
		else
		{
			i++;
			GetCommandToken( temp2, buffer, i );

			_int64 i64data;
			if( StaticCalculation( false, temp2, 0, &i64data, Type() ) )
			{
				currentValue = static_cast<int>(i64data);

				sprintf( temp2, "%d", currentValue );
				currentValueStr = temp2;
			}
			else
			{
				// 擾łȂiȂ炩̎ʎq܂މ\j
				isUseCurrentValue = false;

				currentValueStr = temp2;
			}
		}

		//oǉ
		this->members.push_back( EnumMember( temporary, currentValueStr, i ) );

		lastMemberName = temporary;
	}
}


void EnumInfoCollection::InitEnum(void)
{
	this->clear();

	const char *source = compiler.GetObjectModule().GetCurrentSource().GetBuffer();

	// OԊǗ
	NamespaceScopes &namespaceScopes = compiler.GetNamespaceSupporter().GetLivingNamespaceScopes();
	namespaceScopes.clear();

	int i2;
	char temporary[VN_SIZE];
	for(int i=0;;i++){
		if(source[i]=='\0') break;

		if( source[i] == 1 && source[i+1] == ESC_NAMESPACE ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			namespaceScopes.push_back( temporary );

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				SetError(12, "End Namespace", i );
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}

		if(source[i]==1&&source[i+1]==ESC_ENUM){
			if(i>=2){
				if(source[i-2]==1&&source[i-1]==ESC_CONST) continue;
			}

			i2 = i + 2;
			GetCommandToken( temporary, source, i2 );

			// ǉ
			this->push_back( EnumInfo( namespaceScopes, temporary ) );

			// W
			this->back().Collect( source, i );
		}
	}
}

char *EnumInfoCollection::GenerateSourceCode(void){
	char *buffer;
	int MaxSize,length;
	MaxSize=65535;
	buffer=(char *)HeapAlloc(hHeap,0,MaxSize+65535);
	length=0;

	buffer[0]=0;

	const EnumInfoCollection &thisEnumInfoCollection = *this;
	BOOST_FOREACH( const EnumInfo &enumInfo, thisEnumInfoCollection )
	{
		BOOST_FOREACH( const string &namespaceStr, enumInfo.GetNamespaceScopes() ){
			sprintf(buffer+length,"Namespace %s\n",namespaceStr.c_str());
			length+=lstrlen(buffer+length);
		}

		sprintf(buffer+length,"Class Enum %s\n",enumInfo.GetName().c_str());
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\tInherits EnumBase\n");
		length+=lstrlen(buffer+length);
		sprintf(buffer+length,"\tSub %s(value As Long,lpszName As LPSTR)\n",enumInfo.GetName().c_str());
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\t\tEnumBase(value,lpszName)\n");
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\tEnd Sub\n");
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"Public\n");
		length+=lstrlen(buffer+length);
		sprintf(buffer+length,"\tSub %s()\n",enumInfo.GetName().c_str());
		length+=lstrlen(buffer+length);
		if( enumInfo.GetMembers().size()){
			sprintf(buffer+length,"\t\tEnumBase(%s)\n",
				enumInfo.GetMembers().begin()->GetName().c_str() );
			length+=lstrlen(buffer+length);
		}
		lstrcpy(buffer+length,"\tEnd Sub\n");
		length+=lstrlen(buffer+length);
		sprintf(buffer+length,"\tSub ~%s()\n",enumInfo.GetName().c_str());
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\tEnd Sub\n");
		length+=lstrlen(buffer+length);

		BOOST_FOREACH( const EnumMember &member, enumInfo.GetMembers() )
		{
			sprintf(buffer+length,"\tStatic %s As %s((%s) As Long,\"%s\")\n",
				member.GetName().c_str(),
				enumInfo.GetName().c_str(),
				member.GetValueStr().c_str(),
				member.GetName().c_str());
			length+=lstrlen(buffer+length);
		}

		sprintf(buffer+length,"\tFunction Operator or (enumBase As %s) As %s\n",enumInfo.GetName().c_str(),enumInfo.GetName().c_str());
		length+=lstrlen(buffer+length);
		sprintf(buffer+length,"\t\tReturn New %s(This.value or enumBase.value, \"custom\")\n",enumInfo.GetName().c_str());
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\tEnd Function\n");
		length+=lstrlen(buffer+length);

		sprintf(buffer+length,"\tFunction Operator and (enumBase As %s) As %s\n",enumInfo.GetName().c_str(),enumInfo.GetName().c_str());
		length+=lstrlen(buffer+length);
		sprintf(buffer+length,"\t\tReturn New %s(This.value and enumBase.value, \"custom\")\n",enumInfo.GetName().c_str());
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\tEnd Function\n");
		length+=lstrlen(buffer+length);

		/*
		sprintf(buffer+length,"\tOverride Function ToString() As String\n",enumInfo.TypeName);
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\t\tSelect Case value\n");
		length+=lstrlen(buffer+length);
		for(i2=0;i2<enumInfo.iEnumMemberNum;i2++){
			CEnumMember *member;
			member=enumInfo.ppobj_EnumMember[i2];

			sprintf(buffer+length,"\t\t\tCase %d\n",member->m_value);
			length+=lstrlen(buffer+length);
			sprintf(buffer+length,"\t\t\t\tReturn \"%s\"\n",member->m_name);
			length+=lstrlen(buffer+length);
		}
		lstrcpy(buffer+length,"\t\tEnd Select\n");
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\tEnd Function\n");
		length+=lstrlen(buffer+length);

		
		sprintf(buffer+length,"\tSub Operator= (ByRef value As %s)\n",enumInfo.TypeName);
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\t\tThis.Copy(ByVal VarPtr(value))\n");
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\tEnd Sub\n");
		length+=lstrlen(buffer+length);

		sprintf(buffer+length,"\tSub Operator= (ByRef value As String)\n",enumInfo.TypeName);
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\t\tSelect Case value\n");
		length+=lstrlen(buffer+length);
		for(i2=0;i2<enumInfo.iEnumMemberNum;i2++){
			CEnumMember *member;
			member=enumInfo.ppobj_EnumMember[i2];

			sprintf(buffer+length,"\t\t\tCase \"%s\"\n",member->m_name);
			length+=lstrlen(buffer+length);
			sprintf(buffer+length,"\t\t\t\tThis=%s.%s\n",enumInfo.TypeName,member->m_name);
			length+=lstrlen(buffer+length);
		}
		lstrcpy(buffer+length,"\t\tEnd Select\n");
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\tEnd Sub\n");
		length+=lstrlen(buffer+length);

		sprintf(buffer+length,"\tSub Operator= (value As Long)\n",enumInfo.TypeName);
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\t\tm_Value=value\n");
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\tEnd Sub\n");
		length+=lstrlen(buffer+length);*/

		lstrcpy(buffer+length,"End Class\n");
		length+=lstrlen(buffer+length);

		BOOST_FOREACH( const string &namespaceStr, enumInfo.GetNamespaceScopes() ){
			lstrcpy( buffer+length, "End Namespace\n" );
			length+=lstrlen(buffer+length);
		}


		//obt@̈悪ȂȂꍇ̓obt@𑝗ʂ
		if(length>MaxSize){
			MaxSize+=65535;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,MaxSize+65535);
		}
	}

#ifdef _DEBUG
	// O𐶐
	Jenga::Common::Logger logger( Jenga::Common::Environment::GetAppDir() + "\\enum_generated.log", false );
	logger << buffer << endl;
#endif

	return buffer;
}
