#include "stdafx.h"

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void FreeTempObject(int reg,const CClass *pobj_c){
	if(!IsSafeReg(reg)) SetError(300,NULL,cp);

	const CMethod *method = pobj_c->GetDestructorMethod();
	if( method ){
		//push reg
		compiler.codeGenerator.op_push(reg);

		//call DestructorProcAddr
		compiler.codeGenerator.op_call( &method->GetUserProc() );
	}

	//push reg
	compiler.codeGenerator.op_push(reg);

	//call free
	extern const UserProc *pSub_free;
	compiler.codeGenerator.op_call(pSub_free);
}

int CallOperatorProc(int idCalc, const Type &baseType, int *type_stack, LONG_PTR *index_stack,BOOL *bUseHeap,int &sp)
{
	Type leftType( type_stack[sp-2], index_stack[sp-2] );
	Type rightType( type_stack[sp-1] & (~FLAG_CAST), index_stack[sp-1] );

	//I[o[[hꂽIy[^֐Ăяo
	const CClass *pobj_c = &leftType.GetClass();

	std::vector<const UserProc *> subs;
	pobj_c->GetDynamicMethods().Enum( idCalc, subs );
	if( subs.size() == 0 ){
		return 0;
	}


	//̐
	BOOL bTwoTerm=1;
	if(idCalc==CALC_AS) bTwoTerm=0;


	/////////////////////////////////////////////
	// I[o[[hp̃p[^ݒ
	/////////////////////////////////////////////

	Parameters params;

	if(bTwoTerm){
		params.push_back( new Parameter( "", rightType ) );
	}

	//I[o[[h
	char temporary[255];
	if(idCalc==CALC_EQUAL) lstrcpy(temporary,"==");
	else GetCalcName(idCalc,temporary);
	const UserProc *pUserProc = OverloadSolution( temporary, subs, params, baseType );

	if(!pUserProc){
		if(bTwoTerm){
			delete params[0];
		}
		return -1;
	}
	else{
		//I[o[[hĂȂAp[^vȂƂ
		if(params.size()!=pUserProc->Params().size()){
			if(bTwoTerm){
				delete params[0];
			}
			return -1;
		}
	}

	for(int i=0;i<(int)params.size();i++){
		CheckDifferentType(
			*pUserProc->Params()[i],
			*params[i],
			"",
			i);
	}

	if(bTwoTerm){
		delete params[0];
	}

	int right_side_size = rightType.GetSize();

	if(bTwoTerm){
		if( pUserProc->RealParams()[1]->IsStruct() &&pUserProc->RealParams()[1]->IsRef() == false ){
			//ꎞIuWFNg̓\bhŔj
			bUseHeap[sp-1]=0;
		}
	}


	if( pUserProc->ReturnType().IsStruct() ){
		//////////////////////////////////////////////////////
		// ߂lɍ\̃CX^Xꍇ
		// ByRef _System_ReturnValue p[^p̈擾
		//////////////////////////////////////////////////////

		int object_size = pUserProc->ReturnType().GetClass().GetSize();

		//push object_size
		compiler.codeGenerator.op_push_V(object_size);

		//call calloc
		extern const UserProc *pSub_calloc;
		compiler.codeGenerator.op_call(pSub_calloc);

		//mov ebx,eax
		compiler.codeGenerator.op_mov_RR(REG_EBX,REG_EAX);
	}


	//2̍o
	if(bTwoTerm){
		if(right_side_size==sizeof(_int64)){
			//pop eax
			compiler.codeGenerator.op_pop(REG_EAX);

			//pop edx
			compiler.codeGenerator.op_pop(REG_EDX);
		}
		else{
			//pop eax
			compiler.codeGenerator.op_pop(REG_EAX);
		}
	}

	//pop ecx
	compiler.codeGenerator.op_pop(REG_ECX);


	//q[vpɑޔ
	if(bUseHeap[sp-1]){
		//mov esi,eax
		compiler.codeGenerator.op_mov_RR(REG_ESI,REG_EAX);
	}
	if(bUseHeap[sp-2]){
		//mov edi,ecx
		compiler.codeGenerator.op_mov_RR(REG_EDI,REG_ECX);
	}



	if(bTwoTerm){
		if(right_side_size==sizeof(_int64)){
			//push edx
			compiler.codeGenerator.op_push(REG_EDX);

			//push eax
			compiler.codeGenerator.op_push(REG_EAX);
		}
		else{
			//push eax
			compiler.codeGenerator.op_push(REG_EAX);
		}

		if( pUserProc->RealParams()[1]->IsRef() ){
			//ꎞQƂ쐬

			//mov eax,esp
			compiler.codeGenerator.op_mov_RR( REG_EAX, REG_ESP );

			//push eax
			compiler.codeGenerator.op_push( REG_EAX );
		}
	}

	if( pUserProc->ReturnType().IsStruct() ){
		//push ebx
		compiler.codeGenerator.op_push(REG_EBX);
	}

	//push ecx
	compiler.codeGenerator.op_push(REG_ECX);

	//call operator_proc
	compiler.codeGenerator.op_call(pUserProc);

	if(bTwoTerm){
		if( pUserProc->RealParams()[1]->IsRef() ){
			//ꎞQƂj
			compiler.codeGenerator.op_pop( REG_NON );
		}
	}

	if( !pUserProc->ReturnType().IsNull() ){
		//X^bNփvbV
		PushReturnValue(pUserProc->ReturnType().GetBasicType());
	}

	if(bUseHeap[sp-1]){
		FreeTempObject(REG_ESI,(CClass *)index_stack[sp-1]);
	}
	if(bUseHeap[sp-2]){
		FreeTempObject(REG_EDI,(CClass *)index_stack[sp-2]);
	}

	sp--;
	type_stack[sp-1]=pUserProc->ReturnType().GetBasicType();
	index_stack[sp-1]=pUserProc->ReturnType().GetIndex();

	if( pUserProc->ReturnType().IsStruct() ){
		//\̂߂Ƃ̓q[v̈ɃCX^Xi[Ă
		//freeKv
		bUseHeap[sp-1]=1;
	}
	else bUseHeap[sp-1]=0;

	return 1;
}

void CallCastOperatorProc(Type &calcType,BOOL bCalcUseHeap,const Type &toType){
	int type_stack[10];
	LONG_PTR index_stack[10];
	BOOL array_bUseHeap[10];
	int sp=2;

	if(bCalcUseHeap){
		//̃CX^X݂|x
		SetError(-105,NULL,cp);
	}

	//
	type_stack[0]=calcType.GetBasicType();
	index_stack[0]=calcType.GetIndex();
	array_bUseHeap[0]=0;
	type_stack[1]=toType.GetBasicType();
	index_stack[1]=toType.GetIndex();
	array_bUseHeap[1]=0;

	int iRet = CallOperatorProc(CALC_AS,toType,type_stack,index_stack,array_bUseHeap,sp);

	if(iRet==1){
		//Ƃ
		calcType.SetType( type_stack[0], index_stack[0] );
		return;
	}
	else if(iRet==-1){
		//G[sꂽƂ
		return;
	}

	//G[𔭍s
	SetError(-1,"LXgZqI[o[[hĂ܂B",cp);
}
void CallIndexerGetterProc( const Type &classType, const char *ObjectName, char *Parameter,Type &resultType, DWORD dwProcFlags ){
	std::vector<const UserProc *> subs;
	classType.GetClass().GetDynamicMethods().Enum( CALC_ARRAY_GET, subs );
	if( subs.size() == 0 ){
		return;
	}

	const UserProc *pUserProc = subs[0];

	Opcode_CallProc(Parameter,pUserProc,dwProcFlags,ObjectName);
	resultType = pUserProc->ReturnType();

	// ^p[^
	ResolveFormalGenericTypeParameter( resultType, classType, pUserProc );
}
