#include "common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler/opcode.h"
#endif

int Schedule_GlobalRoot_StartPtr;
int Schedule_GlobalRoot_Size;

void InitGCVariables(void){
	char temporary[255];
	int type;
	RELATIVE_VAR RelativeVar;
	LONG_PTR lpIndex;


	///////////////////////////////
	// O[oϐ̊Jnʒu
	///////////////////////////////

	sprintf(temporary,"_System_gc_GlobalRoot_StartPtr%c%cVoidPtr",1,ESC_AS);
	OpcodeDim(temporary,0);

	GetVarOffset(1,"_System_gc_GlobalRoot_StartPtr",&type,&RelativeVar,&lpIndex);

	//mov rax,ptr
	op_mov_RV(PTR_SIZE,REG_RAX,0);
	Schedule_GlobalRoot_StartPtr=obp-sizeof(long);

	//mov ptr[offset],rax/eax
	op_mov_MR(PTR_SIZE,REG_RAX,0,(int)RelativeVar.offset,MOD_DISP32);
	obp-=sizeof(long);
	pobj_GlobalVarSchedule->add();
	obp+=sizeof(long);


	///////////////////////////////
	// O[oϐ̑傫
	///////////////////////////////

	sprintf(temporary,"_System_gc_GlobalRoot_Size%c%cLong",1,ESC_AS);
	OpcodeDim(temporary,0);

	GetVarOffset(1,"_System_gc_GlobalRoot_Size",&type,&RelativeVar,&lpIndex);

	//mov rax,ptr
	op_mov_RV(PTR_SIZE,REG_RAX,0);
	Schedule_GlobalRoot_Size=obp-sizeof(long);

	//mov ptr[offset],rax/eax
	op_mov_MR(PTR_SIZE,REG_RAX,0,(int)RelativeVar.offset,MOD_DISP32);
	obp-=sizeof(long);
	pobj_GlobalVarSchedule->add();
	obp+=sizeof(long);



	///////////////////////////////
	// X^bNt[̊Jnʒu
	///////////////////////////////

	sprintf(temporary,"_System_gc_StackRoot_StartPtr%c%c*LONG_PTR",1,ESC_AS);
	OpcodeDim(temporary,0);

	GetVarOffset(1,"_System_gc_StackRoot_StartPtr",&type,&RelativeVar,&lpIndex);

	//mov rax,rsp
	op_mov_RR(REG_RAX,REG_RSP);

	//mov ptr[offset],rax/eax
	op_mov_MR(PTR_SIZE,REG_RAX,0,(int)RelativeVar.offset,MOD_DISP32);
	obp-=sizeof(long);
	pobj_GlobalVarSchedule->add();
	obp+=sizeof(long);

}

void PerformedGcVarSchedule(void){
	//O[oϐ̈̊Jnʒu
	extern DWORD ImageBase;
	extern int MemPos_RWSection;
	*((long *)(OpBuffer+Schedule_GlobalRoot_StartPtr))=ImageBase+MemPos_RWSection;
	pobj_Reloc->AddSchedule_CodeSection(Schedule_GlobalRoot_StartPtr);

	//O[oϐ̈̃TCY
	extern int AllInitGlobalVarSize;
	extern int AllGlobalVarSize;
	*((long *)(OpBuffer+Schedule_GlobalRoot_Size))=AllInitGlobalVarSize+AllGlobalVarSize;
}
