#include "../BasicCompiler_Common/common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler/opcode.h"
#endif

extern HANDLE hHeap;

/////////////////////////////////////////////
// ĔzuXPW[
//
// ̍Ĕzu.textZNVA܂.dataZNVɍs邱Ƃ\zB
//        .textZNV c ZNVf[^ւ̃|C^
//        .dataZNV c vtbl̍Ĕzu
/////////////////////////////////////////////

CReloc *pobj_Reloc;

CReloc::CReloc(){
	buffer=0;
	length=0;
	NowPageRVAToReloc=0;

	pdwData_CodeSection=(DWORD *)HeapAlloc(hHeap,0,1);
	iNum_CodeSection=0;
	pdwData_DataSection=(DWORD *)HeapAlloc(hHeap,0,1);
	iNum_DataSection=0;
}
CReloc::~CReloc(){
	AllFree();
}
void CReloc::AllFree(void){
	if(buffer){
		HeapDefaultFree(buffer);
		buffer=0;
	}

	HeapDefaultFree(pdwData_CodeSection);
	HeapDefaultFree(pdwData_DataSection);
}
void CReloc::copy(CReloc *por){
	AllFree();

	if(por->buffer){
		buffer=(char *)HeapReAlloc(hHeap,0,buffer,por->length);
		memcpy(buffer,por->buffer,por->length);
	}
	else buffer=0;

	length=por->length;

	NowPageRVAToReloc=por->NowPageRVAToReloc;
	NowCountAddrToReloc=por->NowCountAddrToReloc;

	iNum_CodeSection=por->iNum_CodeSection;
	pdwData_CodeSection=(DWORD *)HeapAlloc(hHeap,0,iNum_CodeSection*sizeof(DWORD));
	memcpy(pdwData_CodeSection,por->pdwData_CodeSection,iNum_CodeSection*sizeof(DWORD));

	iNum_DataSection=por->iNum_DataSection;
	pdwData_DataSection=(DWORD *)HeapAlloc(hHeap,0,iNum_DataSection*sizeof(DWORD));
	memcpy(pdwData_DataSection,por->pdwData_DataSection,iNum_DataSection*sizeof(DWORD));
}

void CReloc::AddSchedule_CodeSection(DWORD addr){
	extern BOOL bDll;
	if(!bDll) return;

	pdwData_CodeSection=(DWORD *)HeapReAlloc(hHeap,0,pdwData_CodeSection,(iNum_CodeSection+1)*sizeof(DWORD));
	pdwData_CodeSection[iNum_CodeSection]=addr;
	iNum_CodeSection++;
}
void CReloc::AddSchedule_DataSection(DWORD addr){
	extern BOOL bDll;
	if(!bDll) return;

	pdwData_DataSection=(DWORD *)HeapReAlloc(hHeap,0,pdwData_DataSection,(iNum_DataSection+1)*sizeof(DWORD));
	pdwData_DataSection[iNum_DataSection]=addr;
	iNum_DataSection++;
}

void CReloc::__add(DWORD addr){
	extern BOOL bDll;
	if(!bDll) return;

	BOOL sw;
	sw=0;
	while((addr-(addr%MEM_ALIGNMENT))>NowPageRVAToReloc){
		NowPageRVAToReloc+=MEM_ALIGNMENT;
		sw=1;
	}

	if(sw){
		//y[W𑝂₷
		while(length%4){
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,length+sizeof(WORD));
			(*(WORD *)(buffer+length))=0;
			length+=2;

			(*(DWORD *)(buffer+NowCountAddrToReloc))+=sizeof(WORD);
		}

		buffer=(char *)HeapReAlloc(hHeap,0,buffer,
			length+
			sizeof(DWORD)+
			sizeof(DWORD));

		//Page RVA
		*(DWORD *)(buffer+length)=NowPageRVAToReloc;
		length+=sizeof(DWORD);

		NowCountAddrToReloc=length;

		//Block size
		*(DWORD *)(buffer+length)=sizeof(DWORD)*2;
		length+=sizeof(DWORD);
	}

	//P[V̒ǉ
	buffer=(char *)HeapReAlloc(hHeap,0,buffer,length+sizeof(WORD));
	buffer[length]=0;
	buffer[length+1]=0x30;	//=IMAGE_REL_BASED_HIGHLOW
	(*(WORD *)(buffer+length))|=addr&0x0FFF;
	length+=2;

	(*(DWORD *)(buffer+NowCountAddrToReloc))+=sizeof(WORD);
}
void CReloc::ResetRelocBuffer(void){
	if(buffer) HeapDefaultFree(buffer);

	buffer=(char *)HeapAlloc(hHeap,0,1);
	length=0;
	NowPageRVAToReloc=0;

	int i;
	for(i=0;i<iNum_CodeSection;i++){
		extern int MemPos_CodeSection;
		__add(MemPos_CodeSection + pdwData_CodeSection[i]);
	}

	for(i=0;i<iNum_DataSection;i++){
		extern int MemPos_DataSection;
		__add(MemPos_DataSection + pdwData_DataSection[i]);
	}
}




//////////////////////////
// ʃXPW[
//////////////////////////

CSchedule::CSchedule(){
	pObpValues=(int *)HeapAlloc(hHeap,0,1);
	num=0;

	this->flag=0;
}
CSchedule::~CSchedule(){
	HeapDefaultFree(pObpValues);
}
void CSchedule::SetFlag(int flag){
	this->flag=flag;
}
void CSchedule::add(){
	pObpValues=(int *)HeapReAlloc(hHeap,0,pObpValues,(num+1)*sizeof(int));
	pObpValues[num]=obp;
	num++;

	if(flag&SCHEDULE_FLAG_RELOC){
		//P[Vǉ
		pobj_Reloc->AddSchedule_CodeSection(obp);
	}
}
void CSchedule::move(int iStartPos,int iSize,int offset){
	int i;
	for(i=0;i<num;i++){
		if(iStartPos<=pObpValues[i] && pObpValues[i]<iStartPos+iSize){
			pObpValues[i]+=offset;
		}
	}
}

//f[^e[uXPW[
CSchedule *pobj_DataTableSchedule;

//O[oϐAhXXPW[
CSchedule *pobj_GlobalVarSchedule;



/////////////////////////////////////////
// C|[g AhX XPW[O
/////////////////////////////////////////

CImportAddrSchedule::CImportAddrSchedule(){
	ppdi=(DECLAREINFO **)HeapAlloc(hHeap,0,1);
}
CImportAddrSchedule::~CImportAddrSchedule(){
	HeapDefaultFree(ppdi);
}

void CImportAddrSchedule::add(DECLAREINFO *pdi){
	ppdi=(DECLAREINFO **)HeapReAlloc(hHeap,0,ppdi,(num+1)*sizeof(DECLAREINFO *));
	ppdi[num]=pdi;

	CSchedule::add();
}

CImportAddrSchedule *pobj_ImportAddrSchedule;




/////////////////////////////////////////
// vV[W AhX XPW[O
/////////////////////////////////////////

CSubAddrSchedule::CSubAddrSchedule(){
	ppsi=(SUBINFO **)HeapAlloc(hHeap,0,1);
	pbCall=(BOOL *)HeapAlloc(hHeap,0,1);
}
CSubAddrSchedule::~CSubAddrSchedule(){
	HeapDefaultFree(ppsi);
	HeapDefaultFree(pbCall);
}

void CSubAddrSchedule::add(SUBINFO *psi,BOOL bCall){
	if(!psi) return;

	ppsi=(SUBINFO **)HeapReAlloc(hHeap,0,ppsi,(num+1)*sizeof(SUBINFO *));
	ppsi[num]=psi;
	pbCall=(BOOL *)HeapReAlloc(hHeap,0,pbCall,(num+1)*sizeof(BOOL));
	pbCall[num]=bCall;

	CSchedule::add();

	if(!bCall){
		//P[Vǉ
		pobj_Reloc->AddSchedule_CodeSection(obp);
	}
}

CSubAddrSchedule *pobj_SubAddrSchedule;




/////////////////////////////////////////
// ꎞXPW[O|C^
/////////////////////////////////////////
CTempSchedule::CTempSchedule(){
	ppObpValues=(int **)HeapAlloc(hHeap,0,1);
	num=0;
}
CTempSchedule::~CTempSchedule(){
	HeapDefaultFree(ppObpValues);
}
void CTempSchedule::lock(int *pobp){
	ppObpValues=(int **)HeapReAlloc(hHeap,0,ppObpValues,(num+1)*sizeof(int *));
	ppObpValues[num]=pobp;
	num++;
}
void CTempSchedule::unlock(){
	num--;
}
void CTempSchedule::move(int iStartPos,int iSize,int offset){
	int i;
	for(i=0;i<num;i++){
		if(iStartPos<=*ppObpValues[i] && *ppObpValues[i]<iStartPos+iSize){
			(*ppObpValues[i])+=offset;
		}
	}
}

CTempSchedule *pobj_TempSchedule;



/////////////////////////
// ÓIĔzu
/////////////////////////

void NativeBuffer_StaticRelocation(int iStartPos,int iSize,int offset){
	pobj_DataTableSchedule->move(iStartPos,iSize,offset);
	pobj_GlobalVarSchedule->move(iStartPos,iSize,offset);
	pobj_ImportAddrSchedule->move(iStartPos,iSize,offset);
	pobj_SubAddrSchedule->move(iStartPos,iSize,offset);

	pobj_TempSchedule->move(iStartPos,iSize,offset);

#ifdef _AMD64_
	pobj_sf->move(iStartPos,iSize,offset);
#endif
}

