#include "common.h"
#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler/opcode.h"
#endif


CLexicalScopes obj_LexScopes;

CLexicalScopes::CLexicalScopes(){
	level=0;
}
CLexicalScopes::~CLexicalScopes(){
}
void CLexicalScopes::Init(int addr){
	level=0;
	StartAddresses[level]=addr;
}
void CLexicalScopes::LevelUp(int addr){
	level++;
	StartAddresses[level]=addr;
}
void CLexicalScopes::LevelDown(void){
	//fXgN^Ă
	CallDestrouctorsOfScope();

	//XR[vx
	level--;
	if(level<0){
		SetError(300,NULL,cp);
		return;
	}

	extern BOOL bCompilingGlobal;
	VARIABLE *pVar;
	int num;
	if(bCompilingGlobal){
		//O[öRpCĂƂ
		extern VARIABLE *GlobalVar;
		extern int MaxGlobalVarNum;
		pVar=GlobalVar;
		num=MaxGlobalVarNum;
	}
	else{
		//[J̈RpCĂƂ
		extern VARIABLE *LocalVar;
		extern int MaxLocalVarNum;
		pVar=LocalVar;
		num=MaxLocalVarNum;
	}

	for(int i=0;i<num;i++){
		if(pVar[i].bLiving&&pVar[i].ScopeLevel==level+1){
			pVar[i].bLiving=0;
			extern int obp;
			pVar[i].ScopeEndAddress=obp;
		}
	}
}

int CLexicalScopes::GetNowLevel(void){
	return level;
}
int CLexicalScopes::GetStartAddress(void){
	return StartAddresses[level];
}
