#include "stdafx.h"

#include <Compiler.h>

enum ObjectModuleDataType
{
	ObjectModuleDataTypeXml,
	ObjectModuleDataTypeText,
	ObjectModuleDataTypeBinaly,
};
const ObjectModuleDataType objectModuleDataType = ObjectModuleDataTypeBinaly;


void ObjectModule::StaticLink( ObjectModule &objectModule )
{
	long dataSectionBaseOffset = dataTable.GetSize();
	int sourceIndexBase = (int)sources.size();

	// ^
	meta.StaticLink( objectModule.meta, dataSectionBaseOffset, sourceIndexBase );

	// O[o lCeBuR[h
	objectModule.globalNativeCode.ResetDataSectionBaseOffset( dataSectionBaseOffset );
	objectModule.globalNativeCode.ResetSourceIndexes( sourceIndexBase );
	globalNativeCode.PutEx( objectModule.globalNativeCode );

	// f[^e[u
	objectModule.dataTable.ResetDataSectionBaseOffset( dataSectionBaseOffset );
	dataTable.Add( objectModule.dataTable );

	// \[XR[h
	BOOST_FOREACH( const BasicSource &source, objectModule.sources )
	{
		this->sources.push_back( source );
	}

	// TODO: basbufȂȂ
	extern char *basbuf;
	basbuf = this->sources[0].GetBuffer();
}

bool ObjectModule::Read( const std::string &filePath )
{
	switch( objectModuleDataType )
	{
	case ObjectModuleDataTypeXml:
		return ReadXml( filePath );
	case ObjectModuleDataTypeText:
		return ReadText( filePath );
	case ObjectModuleDataTypeBinaly:
		return ReadBinaryFile( filePath );
	default:
		Jenga::Throw( "" );
		break;
	}
	return false;
}
bool ObjectModule::Write( const std::string &filePath ) const
{
	switch( objectModuleDataType )
	{
	case ObjectModuleDataTypeXml:
		return WriteXml( filePath );
	case ObjectModuleDataTypeText:
		return WriteText( filePath );
	case ObjectModuleDataTypeBinaly:
		return WriteBinaryFile( filePath );
	default:
		Jenga::Throw( "" );
		break;
	}
	return false;
}
bool ObjectModule::ReadString( const std::string &str )
{
	switch( objectModuleDataType )
	{
	case ObjectModuleDataTypeXml:
		return ReadXmlString( str );
	case ObjectModuleDataTypeText:
		return ReadTextString( str );
	case ObjectModuleDataTypeBinaly:
		return ReadBinaryString( str );
	default:
		Jenga::Throw( "" );
		break;
	}
	return false;
}
bool ObjectModule::WriteString( std::string &str ) const
{
	switch( objectModuleDataType )
	{
	case ObjectModuleDataTypeXml:
		return WriteXmlString( str );
	case ObjectModuleDataTypeText:
		return WriteTextString( str );
	case ObjectModuleDataTypeBinaly:
		return WriteBinaryString( str );
	default:
		Jenga::Throw( "" );
		break;
	}
	return false;
}
