#pragma once

#include <string>
#include <vector>

#include <windows.h>

#include <jenga/include/common/String.h>

typedef std::vector<int> Subscripts;

enum ReferenceKind
{
	RefNon = 0,		// no reference member
	RefDot,			// obj.member
	RefPointer,		// obj->member
};

bool IsVariableTopChar(char c);
bool IsVariableChar( char c, bool isGenericsChars = false );
bool IsBlank(char c);
int GetOneParameter(const char *Parameter,int pos,char *retAns);
int JumpOneParameter(char *Parameter,int i);
int GetStringInQuotation(char *buffer,char *ReadBuffer);
int GetStringInPare(char *buffer,const char *ReadBuffer);
int GetStringInBracket(char *buffer,const char *ReadBuffer);
int GetStringInGenericBracket(char *buffer,const char *ReadBuffer);
int JumpStringInPare(const char *buffer,int pos);
int JumpStringInBracket(const char *buffer,int pos);
bool IsCommandDelimitation( char c );
int GetStringInPare_RemovePare(char *buffer,const char *ReadBuffer);
void GetArrange(char *variable,char *variAnswer, Subscripts &subscripts );
void SplitParameter( const std::string &src, Jenga::Common::Strings &dests, bool isClear = true );
bool SplitMemberName( const char *desc, char *object, char *member, ReferenceKind &refType );
bool SplitMemberName( const char *desc, char *object, char *member );
void SplitSyntacticForAs( const char *src, char *varName, char *typeName);
void GetCalcName(int idCalc,char *name);
BYTE ToCalcId( const char *name );
std::string Operator_NaturalStringToCalcMarkString( const std::string &name );
std::string Operator_CalcMarkStringToNaturalString( const std::string &name );
bool IsGenericTypeSourcePart( const char *buffer );
