#pragma once

#include <string>
#include <vector>

#include <option.h>
#include <Program.h>
#include <Prototype.h>

using namespace std;

class CClass;

class CMember : public MemberPrototype
{
	string name;
	Type type;
	bool isConst;
	Subscripts subscripts;

	string initializeExpression;
	string constructParameter;

	// XMLVACYp
	// TODO: xml
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - CMember" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( MemberPrototype );
		ar & BOOST_SERIALIZATION_NVP( name );
		ar & BOOST_SERIALIZATION_NVP( type );
		ar & BOOST_SERIALIZATION_NVP( isConst );
		ar & BOOST_SERIALIZATION_NVP( subscripts );
		ar & BOOST_SERIALIZATION_NVP( initializeExpression );
		ar & BOOST_SERIALIZATION_NVP( constructParameter );
	}

public:

	int source_code_address;

	const string &GetName() const
	{
		return name;
	}
	void SetName( const string &name )
	{
		this->name = name;
	}

	const Type &GetType() const
	{
		return type;
	}
	void ResetType( const Type &type )
	{
		this->type = type;
	}

	bool IsConst()
	{
		return isConst;
	}

	const Subscripts &GetSubscripts() const
	{
		return subscripts;
	}

	const string &GetInitializeExpression() const
	{
		return initializeExpression;
	}
	const string &GetConstructParameter() const
	{
		return constructParameter;
	}

	CMember( Prototype::Accessibility accessibility, const string &name, const Type &newType, bool isConst, const Subscripts &subscripts, const string &initializeExpression, const string &constructParameter )
		: MemberPrototype( accessibility )
		, name( name )
		, type( newType )
		, isConst( isConst )
		, subscripts( subscripts )
		, initializeExpression( initializeExpression )
		, constructParameter( constructParameter )
	{
	}
	CMember::CMember(CMember &member)
		: MemberPrototype( member.GetAccessibility() )
		, name( member.GetName() )
		, type( member.GetType() )
		, isConst( member.IsConst() )
		, subscripts( member.GetSubscripts() )
	{
		//\[XR[ḧʒu
		source_code_address=member.source_code_address;
	}
	CMember()
	{
	}
	~CMember()
	{
	}
};
typedef std::vector<CMember *> Members;
