//Opcode.h

//`̒萔
#define IMAGE_FILE_MACHINE_AMD64 0x8664


//WX^萔
#define REG_EAX 0x00	//reg:000
#define REG_ECX 0x01	//reg:001
#define REG_EDX 0x02	//reg:010
#define REG_EBX 0x03	//reg:011
#define REG_ESP 0x04	//reg:100
#define REG_EBP 0x05	//reg:101
#define REG_ESI 0x06	//reg:110
#define REG_EDI 0x07	//reg:111

#define REG_RAX REG_EAX
#define REG_RCX REG_ECX
#define REG_RDX REG_EDX
#define REG_RBX REG_EBX
#define REG_RSP REG_ESP
#define REG_RBP REG_EBP
#define REG_RSI REG_ESI
#define REG_RDI REG_EDI

#define REGISTER_OPERAND(reg) (reg&0x07)

//ϐ̎
#define NON_VAR			0
#define VAR_GLOBAL		1	//Global Variable
#define VAR_LOCAL		2	//Local Variable
#define VAR_REFLOCAL	3	//Local Refference Variable
#define VAR_DIRECTMEM	4	//Direct memory

extern int cp;
extern int obp;
extern char *OpBuffer;

//xAhX
struct LABEL{
	char *pName;
	int line;
	DWORD address;
};

//Gotomx
struct GOTOLABELSCHEDULE{
	char *pName;
	int line;
	DWORD pos;
	DWORD now_cp;
};

//vV[W̎
#define PROC_DEFAULT	1	//[U[`֐
#define PROC_DLL		2	//DLL֐
#define PROC_BUILTIN	3	//RpCߍ݌^
#define PROC_PTR		4	//֐|C^

//vV[W
struct PROCEDURE{
	char name[255];
	int address;
	int types[MAX_PARMS];
	_int8 ByVal[MAX_PARMS];
	BOOL ReturnType;
};

//With
struct WITHINFO{
	char **ppName;
	int *pWithCp;
	int num;
};


//MakePeHdr.cpp
int AddDataTable(char *buffer,int length);

//RSrcSection.cpp
char *GetRSrcSectionBuffer(int *pLen);

//Compile.cpp
void ChangeOpcode(char *Command);
void GetGlobalDataForDll(void);
DWORD CompileBuffer(char Return_Sequence,WORD Return_Command);

//Compile_Calc.cpp
void ChangeTypeToDouble_ToFpuReg(int OldType);
void ChangeTypeToDouble(int OldType);
void ChangeTypeToSingle(int OldType);
void ChangeTypeToInt64(int OldType);
void ChangeTypeToLong(int OldType);
void ChangeTypeToInteger(int OldType);
void ChangeTypeToByte(int OldType);
void OpcodeCalc(char *Command);

//NumOpe.cpp
void PushReturnValue(int type);
int NumOpe(char *Command,int BaseType,LONG_PTR lpBaseIndex,LONG_PTR *plpIndex,BOOL *pbUseHeap=0);

//NumOpe_Arithmetic.cpp
void GetStackData_ToRegister(int *type,int sp);
BOOL CalcTwoTerm_Arithmetic(int idCalc,int *type,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_Mod(int *type,int *pStackPointer);
BOOL Calc_Divide(int *type,int *pStackPointer,int BaseType);
BOOL Calc_IntDivide(int *type,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_MinusMark(int *type,int sp);
BOOL Calc_Power(int *type,int *pStackPointer);
BOOL Calc_Cast(int *type,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_SHL(int *type,int *pStackPointer);
BOOL Calc_SHR(int *type,int *pStackPointer);

//NumOpe_Logical.cpp
BOOL Calc_Xor(int *type,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_Or(int *type,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_And(int *type,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_Not(int *type,int sp);

//NumOpe_Relation.cpp
BOOL Calc_Relation_PE(int *type_stack,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_Relation_QE(int *type_stack,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_Relation_P(int *type_stack,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_Relation_Q(int *type_stack,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_Relation_NotEqual(int *type,int *pStackPointer);
BOOL Calc_Relation_Equal(int *type,int *pStackPointer);

//NumOpe_TypeOperation.cpp
void ExtendStackTo64(int type);
void ChangeTypeToWhole(int OldType,int NewType);

//Compile_Set_Var.cpp
BOOL IsUse_ecx(RELATIVE_VAR *pRelativeVar);
void SetObjectVariable(LONG_PTR lpVarIndex,int CalcType,LONG_PTR lpCalcIndex,BOOL bUseHeap);
void SetDoubleVariable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset);
void SetSingleVariable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset);
void SetInt64Variable(int type,RELATIVE_VAR *pRelative);
void SetDWordVariable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset);
void SetLongVariable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset);
void Set16Variable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset);
void Set8Variable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset);
void SetBooleanVariable(int type,RELATIVE_VAR *pRelative);

//increment.cpp
void IncDec(int idCalc, char *lpszLeft, char *lpszRight);

//calc2.cpp
#define EXP_TYPE_NUMBER	1
#define EXP_TYPE_EAX	2
#define EXP_TYPE_FPU	3
#define EXP_TYPE_VAR	4
int NumOpEx(char *Command,double *pDbl,DWORD *pdwType,RELATIVE_VAR *pRelativeVar);

//SetVar.cpp
BOOL SetVariable(DWORD dwVarType,RELATIVE_VAR *pVarRelativeVar,
				 DWORD dwExpType,DWORD dwType,void *data);

//Compile_Calc_PushVar.cpp
void SetReg_RealVariable(int type,RELATIVE_VAR *pRelativeVar);
void SetReg_WholeVariable(int type,RELATIVE_VAR *pRelativeVar,int reg);
void PushDoubleVariable(RELATIVE_VAR *pRelativeVar);
void PushLongVariable(RELATIVE_VAR *pRelativeVar);
void PushIntegerVariable(RELATIVE_VAR *pRelativeVar);
void PushWordVariable(RELATIVE_VAR *pRelativeVar);
void PushCharVariable(RELATIVE_VAR *pRelativeVar);
void PushByteVariable(RELATIVE_VAR *pRelativeVar);

//Compile_Object.cpp
int Operator_New(char *Parameter,LONG_PTR *plpIndex);
void OpcodeDelete(char *Parameter);

//Compile_Var.cpp
void GetWithName(char *buffer);
void SetThisPtrToReg(int reg);
BOOL GetVarOffset(bool isErrorEnabled,bool isWriteAccess,char *NameBuffer,int *pType,RELATIVE_VAR *pRelativeVar,LONG_PTR *plpIndex,int *pss=0);
BOOL SetInitGlobalData(int offset,int type,LONG_PTR lpIndex,int *SubScripts,char *InitBuf);
#define DIMFLAG_INITDEBUGVAR			1
#define DIMFLAG_NONCALL_CONSTRACTOR		2
#define DIMFLAG_STATIC					4
#define DIMFLAG_CONST					8
void OpcodeDim(char *Parameter,DWORD dwFlag);
void SetVarPtrToEax(RELATIVE_VAR *pRelativeVar);

//CParameter.cpp
#define OVERLOAD_LEVEL1 1
#define OVERLOAD_LEVEL2 2
#define OVERLOAD_LEVEL3 3
class CParameter{
	char *Parms[255];
	TYPEINFO types[255];
	int ParmsNum;

	TYPEINFO ReturnTypeInfo;

	//ꎞIuWFNgǗp
	bool useTempObject;
	bool useTempParameters[255];
	int nCountOfTempObjects;

public:
	CParameter(char *buffer);
	CParameter(PARAMETER_INFO *pParamInfo,int ParmNum);
	~CParameter();
	void SetReturnType(TYPEINFO *pTypeInfo);

private:
	BOOL _overload_check(PARAMETER_INFO *ppi,int pi_num,TYPEINFO *pReturnTypeInfo,int overload_level);
	SUBINFO *OverloadSolutionWithReturnType(char *name,SUBINFO **ppsi,int num);
public:
	SUBINFO *OverloadSolution(char *name,SUBINFO **ppsi,int num);

	BOOL ErrorCheck(char *FuncName,PARAMETER_INFO *ppi,int pi_num,int SecondParmNum);
	void MacroParameterSupport(PARAMETER_INFO *ppi);
	void SetObjectParameter(CClass *pobj_Class,LPSTR Parameter);
	int SetParameter(char *FuncName,PARAMETER_INFO *ppi,int pi_num,int SecondParmNum);

	//ꎞIuWFNgp[^̐Ɣj
	void NewTempParameters( char *FuncName,PARAMETER_INFO *ppi,int pi_num,int SecondParmNum );
	void DeleteTempParameters();
};

//Compile_CallProc.cpp
void AddLocalVarAddrSchedule();
int CallProc(int idProc,void *pInfo,char *name,char *Parameter,LONG_PTR *plpRetIndex);
BOOL CallPropertyMethod(char *variable,char *RightSide,TYPEINFO *pRetTypeInfo);
#define PROCFLAG_NEW	1
int Opcode_CallProcPtr(char *variable,char *Parameter,PROCPTRINFO *pi,LONG_PTR *plpIndex);
void Opcode_CallProc(char *Parameter,SUBINFO *psi,DWORD dwFlags,char *ObjectName,int RefType);
int Opcode_CallDllProc(char *Parameter,DECLAREINFO *pdi,LONG_PTR *plpIndex);

//Compile_ProcOp.cpp
void CompileLocal();

//Compile_Func.cpp
int GetFunctionType(int FuncNum);
int GetFunctionFromName(char *FuncName);
int Opcode_CallFunc(char *Parameter,int FuncNum);

//OperatorProc.cpp
void FreeTempObject(int reg,CClass *pobj_c);
int CallOperatorProc(int idCalc,TYPEINFO *pBaseTypeInfo,int *type,LONG_PTR *index_stack,BOOL *bUseHeap,int &sp);
void CallCastOperatorProc(int &CalcType,LONG_PTR &lpCalcIndex,BOOL bCalcUseHeap,int ToType,LONG_PTR lpToIndex);
void CallIndexerGetterProc(CClass *pobj_Class,char *ObjectName,char *Parameter,TYPEINFO &RetTypeInfo);

//Compile_Statement.cpp
void OpcodeOthers(char *Command);
void OpcodeIf(char *Parameter);
void OpcodeGoto(char *Parameter);
void OpcodeWhile(char *Parameter);
void OpcodeFor(char *Parameter);
void OpcodeDo(char *Parameter);
void OpcodeContinue(void);
void OpcodeExitSub(void);
void OpcodeSelect(char *Parameter);
void OpcodeCase(char *Parameter);
void OpcodeGosub(char *Parameter);
void OpcodeReturn(char *Parameter);
void Opcode_Input(char *Parameter);
void Opcode_Print(char *Parameter,BOOL bWrite);
void OpcodeCallPtr(char *Parameter);
void OpcodeSetPtrData(char *Parameter,int type);




////////////////////////////////
// IA-32@Bꐶɗp֐S
////////////////////////////////

//Modi[hj
#define MOD_BASE		(char)0x00
#define MOD_DISP32		(char)0xFF
#define MOD_BASE_DISP8	(char)0x40
#define MOD_BASE_DISP32	(char)0x80
#define MOD_REG				(char)0xC0

#define USE_OFFSET 1
#define NON_OFFSET 0

//op32_main.cpp
BOOL IsSafeReg(int reg);
void op_mov_RV			(int reg,int offset);
void op_mov_RV			(int op_size,int reg,int offset);
void op_mov_RR			(int reg1,int reg2);
void op_mov_RM			(int op_size,int reg,int base_reg,int offset,char mod);
void op_mov_RM_ex		(int op_size,int reg,int base_reg1,int base_reg2,int offset,BOOL bUseOffset);
void op_mov_MR			(int op_size,int reg,int base_reg,int offset,char mod);
void op_mov_MR_ex		(int op_size,int reg,int base_reg1,int base_reg2,int offset,BOOL bUseOffset);
void op_movsx_R32R16	(int reg32,int reg16);
void op_movsx_R32R8		(int reg32,int reg8);
void op_movsx_R16R8		(int reg16,int reg8);
void op_inc				(int reg);
void op_dec				(int reg);
void op_add_RV8			(int reg,char cValue);
void op_add_RM			(int op_size,int reg,int base_reg,int offset,char mod);
void op_adc_RV8			(int reg,char cValue);
void op_sub_RV8			(int reg,char cValue);
void op_sbb_RV8			(int reg,char cValue);
void op_sbb_RR			( int reg1, int reg2 );
void op_and_RV			(int reg,int value);
void op_or_RR			( int op_size, int reg1, int reg2 );
void op_neg				( int reg );
void op_cdq				();

void op_rep_movs		(int op_size);

void op_push(int reg);
void op_push_value(long data);
void op_pop(int reg);
void op_add_esp(int num);
void op_sub_esp(int num);
void op_cmp_value(int op_size,int reg,char byte_data);
void op_setne( int reg );
void op_test(int reg1,int reg2);
void op_fld_ptr_esp(int type);
void op_fld_basereg			(int type,int base_reg);
void op_fld_base_offset		(int type,int base_reg,int offset);
void op_fld_base_offset_ex	(int type,int base_reg1,int base_reg2,int offset,BOOL bUseOffset);
void op_fstp_basereg		(int type,int base_reg);
void op_fstp_base_offset	(int type,int base_reg,int offset);
void op_fstp_base_offset_ex	(int type,int base_reg1,int base_reg2,int offset,BOOL bUseOffset);
void op_zero_reg(int reg);
void fpu_cast();
void fpu_cast_end();

void op_call(SUBINFO *psi);
