#include "stdafx.h"

#include <jenga/include/smoothie/Smoothie.h>
#include <jenga/include/smoothie/SmoothieException.h>
#include <jenga/include/smoothie/LexicalAnalysis.h>

#include <Source.h>
#include <Class.h>
#include <Compiler.h>
#include <NamespaceSupporter.h>

#include "../common.h"
#ifdef _AMD64_
#include "../../BasicCompiler64/opcode.h"
#else
#include "../../BasicCompiler32/opcode.h"
#endif


class CLoopRefCheck{
	char **names;
	int num;
	void init(){
		int i;
		for(i=0;i<num;i++){
			free(names[i]);
		}
		free(names);
	}
public:
	CLoopRefCheck()
	{
		names=(char **)malloc(1);
		num=0;
	}
	~CLoopRefCheck()
	{
		init();
	}
	void add(const char *lpszInheritsClass)
	{
		names=(char **)realloc(names,(num+1)*sizeof(char *));
		names[num]=(char *)malloc(lstrlen(lpszInheritsClass)+1);
		lstrcpy(names[num],lpszInheritsClass);
		num++;
	}
	void del(const char *lpszInheritsClass)
	{
		int i;
		for(i=0;i<num;i++){
			if(lstrcmp(names[i],lpszInheritsClass)==0){
				free(names[i]);
				break;
			}
		}
		if(i!=num){
			num--;
			for(;i<num;i++){
				names[i]=names[i+1];
			}
		}
	}
	BOOL check(const CClass &inheritsClass) const
	{
		//[vp`FbN
		int i;
		for(i=0;i<num;i++){
			if( inheritsClass.GetName() == names[i] ){
				return 1;
			}
		}
		return 0;
	}
};
CLoopRefCheck *pobj_LoopRefCheck;


void Classes::CollectClassesForNameOnly( const BasicSource &source )
{
	int i, i2;
	char temporary[VN_SIZE];

	// OԊǗ
	NamespaceScopes &namespaceScopes = compiler.GetNamespaceSupporter().GetLivingNamespaceScopes();
	namespaceScopes.clear();

	// ImportsꂽOԂ̊Ǘ
	NamespaceScopesCollection &importedNamespaces = compiler.GetNamespaceSupporter().GetImportedNamespaces();
	importedNamespaces.clear();

	for(i=0;;i++){
		if(source[i]=='\0') break;

		if( source[i] == 1 && source[i+1] == ESC_NAMESPACE ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			namespaceScopes.push_back( temporary );

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				SmoothieException::Throw(12, "End Namespace", i );
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_IMPORTS ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			if( !compiler.GetNamespaceSupporter().ImportsNamespace( temporary ) )
			{
				SmoothieException::Throw(64,temporary,i );
			}

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_CLEARNAMESPACEIMPORTED ){
			importedNamespaces.clear();
			continue;
		}

		if(source[i]==1&&(
			source[i+1]==ESC_CLASS||
			source[i+1]==ESC_TYPE||
			source[i+1]==ESC_INTERFACE
			))
		{
			int nowLine = i;
			i += 2;

			Type blittableType;
			if(memicmp(source.GetBuffer()+i,"Align(",6)==0){
				//ACgCq
				i+=6;
				i=JumpStringInPare(source.GetBuffer(),i)+1;
			}
			else if( memicmp( source.GetBuffer() + i, "Blittable(", 10 ) == 0 ){
				// BlittableCq
				i+=10;
				i+=GetStringInPare_RemovePare(temporary,source.GetBuffer()+i)+1;
				compiler.StringToType( temporary, blittableType );
			}

			bool isEnum = false;
			bool isDelegate = false;
			if( source[i] == 1 && source[i+1] == ESC_ENUM ){
				// 񋓌^̏ꍇ
				isEnum = true;

				i += 2;
			}
			else if( source[i] == 1 && source[i+1] == ESC_DELEGATE )
			{
				// fQ[g̏ꍇ
				isDelegate = true;

				i += 2;
			}

			for(i2=0;;i++,i2++){
				if(!IsVariableChar(source[i])){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}

			//NXǉ
			CClass *pClass = this->Add(namespaceScopes, importedNamespaces, temporary,nowLine);
			if( pClass ){
				if( source[nowLine+1] == ESC_CLASS ){
					if( isEnum )
					{
						pClass->SetClassType( CClass::Enum );
					}
					else if( isDelegate )
					{
						pClass->SetClassType( CClass::Delegate );
					}
					else{
						pClass->SetClassType( CClass::Class );
					}
				}
				else if( source[nowLine+1] == ESC_INTERFACE ){
					pClass->SetClassType( CClass::Interface );
				}
				else{
					pClass->SetClassType( CClass::Structure );
				}
			}

			// Blittable^̏ꍇ
			if( !blittableType.IsNull() ){
				pClass->SetBlittableType( blittableType );

				// Blittable^Ƃēo^
				compiler.GetObjectModule().meta.GetBlittableTypes().push_back( BlittableType( blittableType, pClass ) );
			}
		}
	}
}

bool Classes::MemberVar_LoopRefCheck(const CClass &objClass){
	bool result = true;
	BOOST_FOREACH( CMember *pMember, objClass.GetDynamicMembers() ){
		if(pMember->GetType().IsStruct()){
			//zQƂłȂ`FbN
			if(pobj_LoopRefCheck->check(pMember->GetType().GetClass())){
				extern int cp;
				SetError(124,pMember->GetType().GetClass().GetName(),cp);
				return false;
			}

			pobj_LoopRefCheck->add(objClass.GetName().c_str());

			bool tempResult = MemberVar_LoopRefCheck(pMember->GetType().GetClass());
			if( result )
			{
				result = tempResult;
			}

			pobj_LoopRefCheck->del(objClass.GetName().c_str());
		}
	}

	return result;
}

void Classes::GetClass_recur(const char *lpszInheritsClass){
	extern char *basbuf;
	int i,i2,i3,sub_address,top_pos;
	char temporary[8192];

	// OԊǗ
	NamespaceScopes backupNamespaceScopes = compiler.GetNamespaceSupporter().GetLivingNamespaceScopes();
	NamespaceScopes &namespaceScopes = compiler.GetNamespaceSupporter().GetLivingNamespaceScopes();
	namespaceScopes.clear();

	// ImportsꂽOԂ̊Ǘ
	NamespaceScopesCollection backupImportedNamespaces = compiler.GetNamespaceSupporter().GetImportedNamespaces();
	compiler.GetNamespaceSupporter().GetImportedNamespaces().clear();

	// ĂяoŃRpC̃NX|C^obNAbv
	const CClass *pBackCompilingClass = compiler.pCompilingClass;

	for(i=0;;i++){
		if(basbuf[i]=='\0') break;


		// O
		if( basbuf[i] == 1 && basbuf[i+1] == ESC_NAMESPACE ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( basbuf[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=basbuf[i];
			}
			namespaceScopes.push_back( temporary );

			continue;
		}
		else if( basbuf[i] == 1 && basbuf[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				SetError(12, "End Namespace", i );
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}

		else if( basbuf[i] == 1 && basbuf[i+1] == ESC_IMPORTS ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( basbuf[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=basbuf[i];
			}
			if( !compiler.GetNamespaceSupporter().ImportsNamespace( temporary ) )
			{
				SmoothieException::Throw(64,temporary,i );
			}

			continue;
		}
		else if( basbuf[i] == 1 && basbuf[i+1] == ESC_CLEARNAMESPACEIMPORTED ){
			compiler.GetNamespaceSupporter().GetImportedNamespaces().clear();
			continue;
		}



		if(basbuf[i]==1&&basbuf[i+1]==ESC_INTERFACE){
			//////////////////////////
			// C^[tFCX
			//////////////////////////

			top_pos=i;

			i+=2;

			//C^[tFCX擾
			GetCommandToken( temporary, basbuf, i );

			char className[VN_SIZE];
			Jenga::Common::Strings typeParameters;
			SplitGenericClassInstance( temporary, className, typeParameters );

			CClass *pobj_c = const_cast<CClass *>( this->Find(namespaceScopes, className) );
			if(!pobj_c) continue;

			compiler.pCompilingClass = pobj_c;

			if(lpszInheritsClass){
				if(lstrcmp(lpszInheritsClass,pobj_c->GetName().c_str())!=0){
					//pǂݗp
					continue;
				}
			}

			if(pobj_c->IsReady()){
				//ɐǂ݂ĂƂ
				continue;
			}

			/////////////////////////////////////////////////////////
			//  WFlNXT|[g 
			BOOST_FOREACH( const std::string &typeParameter, typeParameters )
			{
				pobj_c->AddFormalGenericType( GenericType( typeParameter, Type(DEF_OBJECT,*GetObjectClassPtr()) ) );
			}
			/////////////////////////////////////////////////////////

			pobj_c->Readed();

			pobj_c->SetConstructorMemberSubIndex( -1 );
			pobj_c->SetDestructorMemberSubIndex( -1 );

			if( memcmp( basbuf+i+1, "__COM", 5 ) == 0 && IsCommandDelimitation( basbuf[i+1+5] ) )
			{
				// COMC^[tFCX
				pobj_c->SetClassType( CClass::ComInterface );

				i += 6;
			}

			if(basbuf[i+1]==1&&basbuf[i+2]==ESC_INHERITS){
				//psꍇ
				for(i+=3,i2=0;;i++,i2++){
					if(IsCommandDelimitation(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
				}

				if(lstrcmpi(temporary,pobj_c->GetName().c_str())==0){
					SetError(105,temporary,i);
					goto Interface_InheritsError;
				}

				//pNX擾
				const Classes &classes = *this;
				const CClass *pInheritsClass = classes.Find(temporary);
				if( !pInheritsClass ){
					SetError(106,temporary,i);
					goto Interface_InheritsError;
				}

				//p
				if( !pobj_c->InheritsClass( *pInheritsClass, Types(), i ) ){
					goto Interface_InheritsError;
				}
			}
			else{
				//p
				if( &pobj_c->GetSuperClass() || pobj_c->GetVtblNum() )
				{
					// TODO: ɗȂƂ؂ł炱̕͏
					Jenga::Throw( "GetClass_recur̗O" );
				}
			}
Interface_InheritsError:

			//oϐA֐擾
			while(1){
				i++;

				//G[
				if(basbuf[i]==1&&(basbuf[i+1]==ESC_CLASS||basbuf[i+1]==ESC_TYPE||basbuf[i+1]==ESC_INTERFACE)){
					SetError(22,"Interface",i);
					i--;
					break;
				}

				if(basbuf[i]==1&&basbuf[i+1]==ESC_INHERITS){
					SetError(111,NULL,i);
					break;
				}
				else if( basbuf[i] == 1 && basbuf[i+1] == ESC_IMPLEMENTS )
				{
					SetError(137, NULL, i );
					break;
				}

				sub_address=i;

				for(i2=0;;i++,i2++){
					if(IsCommandDelimitation(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
				}
				if(temporary[0]=='\0'){
					if(basbuf[i]=='\0'){
						i--;
						SetError(22,"Interface",top_pos);
						break;
					}
					continue;
				}

				//End InterfaceLq̏ꍇ
				if(temporary[0]==1&&temporary[1]==ESC_ENDINTERFACE) break;

				if(!(temporary[0]==1&&(
					temporary[1]==ESC_SUB||temporary[1]==ESC_FUNCTION
					))){
					SetError(1,NULL,i);
					break;
				}

				//o֐ǉ
				pobj_c->AddMethod(pobj_c,
					Prototype::Public,	//PublicANZX
					0,					// bStatic
					false,				// isConst
					true,				// isAbstract
					true,				// isVirtual
					false,				// isOverride
					false,				// isAutoGeneration
					temporary,
					sub_address
					);
			}
		}

		if(basbuf[i]==1&&(basbuf[i+1]==ESC_CLASS||basbuf[i+1]==ESC_TYPE)){
			//////////////////////////
			// NX
			//////////////////////////

			top_pos=i;

			const DWORD dwClassType=basbuf[i+1];

			i+=2;

			int iAlign=0;
			if(memicmp(basbuf+i,"Align(",6)==0){
				//ACgCq
				i+=6;
				i+=GetStringInPare_RemovePare(temporary,basbuf+i)+1;
				iAlign=atoi(temporary);

				if(!(iAlign==1||iAlign==2||iAlign==4||iAlign==8||iAlign==16))
					SetError(51,NULL,i);
			}
			else if( memicmp( basbuf + i, "Blittable(", 10 ) == 0 ){
				// BlittableCq
				i+=10;
				i=JumpStringInPare(basbuf,i)+1;
			}

			if( basbuf[i] == 1 && basbuf[i+1] == ESC_ENUM )
			{
				// 񋓌^̏ꍇ
				i += 2;
			}
			else if( basbuf[i] == 1 && basbuf[i+1] == ESC_DELEGATE )
			{
				// fQ[g̏ꍇ
				i += 2;
			}

			//NX擾
			GetCommandToken( temporary, basbuf, i );

			char className[VN_SIZE];
			Jenga::Common::Strings typeParameters;
			SplitGenericClassInstance( temporary, className, typeParameters );

			CClass *pobj_c =  const_cast<CClass *>( this->Find(namespaceScopes, className) );
			if(!pobj_c) continue;

			compiler.pCompilingClass = pobj_c;

			if(lpszInheritsClass){
				if( pobj_c->GetName() != lpszInheritsClass ){
					//pǂݗp
					continue;
				}
			}

			if(pobj_c->IsReady()){
				//ɐǂ݂ĂƂ
				continue;
			}


			/////////////////////////////////////////////////////////
			//  WFlNXT|[g 
			BOOST_FOREACH( const std::string &typeParameter, typeParameters )
			{
				pobj_c->AddFormalGenericType( GenericType( typeParameter, Type(DEF_OBJECT,*GetObjectClassPtr()) ) );
			}
			/////////////////////////////////////////////////////////


			pobj_c->SetFixedAlignment( iAlign );

			pobj_c->Readed();

			pobj_c->SetConstructorMemberSubIndex( -1 );
			pobj_c->SetDestructorMemberSubIndex( -1 );

			//ANZX̏lZbg
			Prototype::Accessibility accessibility;
			if(dwClassType==ESC_CLASS){
				accessibility = Prototype::Private;
			}
			else{
				accessibility = Prototype::Public;
			}

			if( pobj_c->GetName() == "Object"
				|| dwClassType == ESC_TYPE )
			{
				// pȂ

				if( &pobj_c->GetSuperClass() || pobj_c->GetVtblNum() )
				{
					// TODO: ɗȂƂ؂ł炱̕͏
					Jenga::Throw( "GetClass_recur̗O" );
				}
			}
			else{
				if(basbuf[i+1]==1&&basbuf[i+2]==ESC_INHERITS)
				{
					// NXp悪w肳ĂƂ
					i += 3;
					GetCommandToken( temporary, basbuf, i );

					if(lstrcmpi(temporary,pobj_c->GetName().c_str())==0){
						SetError(105,temporary,i);
						goto InheritsError;
					}
				}
				else
				{
					// ̎wȂƂObjectNXp
					lstrcpy( temporary, "Object" );
				}
				pobj_c->Inherits( temporary, i );

				if( basbuf[i+1] == 1 && basbuf[i+2] == ESC_IMPLEMENTS )
				{
					// C^[tFCXsꍇ
					i += 3;
					GetCommandToken( temporary, basbuf, i );

					pobj_c->Implements( temporary, i );
				}
			}
InheritsError:

			//oƃ\bh擾
			while(1){
				i++;

				//G[
				if(basbuf[i]==1&&(basbuf[i+1]==ESC_CLASS||basbuf[i+1]==ESC_TYPE)){
					SetError(22,"Class",i);
					i--;
					break;
				}

				if(basbuf[i]==1&&basbuf[i+1]==ESC_INHERITS){
					SetError(111,NULL,i);
					break;
				}
				else if( basbuf[i] == 1 && basbuf[i+1] == ESC_IMPLEMENTS )
				{
					SetError(137, NULL, i );
					break;
				}

				//StaticCq
				BOOL bStatic;
				if(basbuf[i]==1&&basbuf[i+1]==ESC_STATIC){
					bStatic=1;
					i+=2;
				}
				else bStatic=0;

				//ConstCq
				bool isConst = false;
				if( basbuf[i] == 1 && basbuf[i + 1] == ESC_CONST ){
					isConst = true;
					i += 2;
				}

				if(basbuf[i]==1&&(
					basbuf[i+1]==ESC_ABSTRACT||basbuf[i+1]==ESC_VIRTUAL||basbuf[i+1]==ESC_OVERRIDE||
					basbuf[i+1]==ESC_SUB||basbuf[i+1]==ESC_FUNCTION
					)){
					i3=basbuf[i+1];
					sub_address=i;
				}
				else i3=0;

				bool isVirtual = false, isAbstract = false, isOverride = false;
				if(i3==ESC_ABSTRACT){
					isAbstract=1;
					isVirtual=1;
					i+=2;

					i3=basbuf[i+1];
				}
				else if(i3==ESC_VIRTUAL){
					isAbstract=0;
					isVirtual=1;
					i+=2;

					i3=basbuf[i+1];
				}
				else if(i3==ESC_OVERRIDE){
					isOverride=1;
					isVirtual=1;

					i+=2;

					i3=basbuf[i+1];
				}

				for(i2=0;;i++,i2++){
					if(IsCommandDelimitation(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
				}
				if(temporary[0]=='\0'){
					if(basbuf[i]=='\0'){

						if(dwClassType==ESC_CLASS)
							SetError(22,"Class",top_pos);
						else
							SetError(22,"Type",top_pos);

						i--;
						break;
					}
					continue;
				}

				//End ClassLq̏ꍇ
				if(temporary[0]==1&&temporary[1]==ESC_ENDCLASS&&dwClassType==ESC_CLASS) break;
				if(temporary[0]==1&&temporary[1]==ESC_ENDTYPE&&dwClassType==ESC_TYPE) break;

				//ANZXύX
				if(lstrcmpi(temporary,"Private")==0){
					accessibility = Prototype::Private;
					continue;
				}
				if(lstrcmpi(temporary,"Public")==0){
					accessibility = Prototype::Public;
					continue;
				}
				if(lstrcmpi(temporary,"Protected")==0){
					accessibility = Prototype::Protected;
					continue;
				}

				extern int cp;
				if(i3==0){
					if(bStatic){
						//ÓIoǉ
						cp=i;	//G[p
						pobj_c->AddStaticMember( accessibility, isConst, false, temporary, i);
					}
					else{
						//oǉ
						cp=i;	//G[p
						pobj_c->AddMember( accessibility, isConst, false, temporary, i );


						if(pobj_c->GetDynamicMembers()[pobj_c->GetDynamicMembers().size()-1]->GetType().IsStruct()){
							if( !pobj_c->GetDynamicMembers()[pobj_c->GetDynamicMembers().size()-1]->GetType().GetClass().IsReady() ){
								//QƐ悪ǂݎĂȂƂ
								GetClass_recur(pobj_c->GetDynamicMembers()[pobj_c->GetDynamicMembers().size()-1]->GetType().GetClass().GetName().c_str());
							}
						}


						if(pobj_c->GetDynamicMembers()[pobj_c->GetDynamicMembers().size()-1]->GetType().IsStruct()){
							//zQƂ̃`FbN
							pobj_LoopRefCheck->add(pobj_c->GetName().c_str());
							if(!MemberVar_LoopRefCheck(pobj_c->GetDynamicMembers()[pobj_c->GetDynamicMembers().size()-1]->GetType().GetClass())){
								//G[
								Type &type = const_cast<Type &>(pobj_c->GetDynamicMembers().back()->GetType());
								type.SetBasicType( DEF_PTR_VOID );
							}
							pobj_LoopRefCheck->del(pobj_c->GetName().c_str());
						}
					}
				}
				else{
					//\bhǉ
					cp=i;	//G[p
					pobj_c->AddMethod(pobj_c,
						accessibility,
						bStatic,
						isConst,
						isAbstract,
						isVirtual,
						isOverride,
						false,
						temporary,
						sub_address);

					if( isAbstract ) continue;

					for(;;i++){
						if(basbuf[i]=='\0'){
							i--;
							break;
						}
						if(basbuf[i-1]!='*'&&
							basbuf[i]==1&&(
							basbuf[i+1]==ESC_SUB||
							basbuf[i+1]==ESC_FUNCTION||
							basbuf[i+1]==ESC_MACRO||
							basbuf[i+1]==ESC_TYPE||
							basbuf[i+1]==ESC_CLASS||
							basbuf[i+1]==ESC_INTERFACE||
							basbuf[i+1]==ESC_ENUM)){
							GetDefaultNameFromES(i3,temporary);
							SetError(22,temporary,i);
						}
						if(basbuf[i]==1&&basbuf[i+1]==GetEndXXXCommand((char)i3)){
							i+=2;
							break;
						}
					}
				}
			}
		}
	}

	// ĂяoŃRpC̃NX|C^ɖ߂
	compiler.pCompilingClass = pBackCompilingClass;

	// OԂɖ߂
	compiler.GetNamespaceSupporter().GetLivingNamespaceScopes() = backupNamespaceScopes;

	// C|[gꂽOԂɖ߂
	compiler.GetNamespaceSupporter().GetImportedNamespaces() = backupImportedNamespaces;
}

void Classes::LookaheadClass( const char *className )
{
	pobj_LoopRefCheck->add( className );
	compiler.GetObjectModule().meta.GetClasses().GetClass_recur( className );
	pobj_LoopRefCheck->del( className );
}

bool Classes::LoopRefCheck( const CClass &objClass )
{
	if( pobj_LoopRefCheck->check( objClass ) )
	{
		return false;
	}

	return true;
}

void Classes::GetAllClassInfo(void){
	//[vp`FbNp̃NX
	pobj_LoopRefCheck=new CLoopRefCheck();

	//NX擾
	GetClass_recur(0);

	delete pobj_LoopRefCheck;
	pobj_LoopRefCheck=0;

	// Ce[^̏
	this->Iterator_Init();
}
