#pragma once

#include <option.h>
#include <Program.h>
#include <Prototype.h>
#include <Method.h>
#include <Member.h>
#include <Source.h>

class UserProc;
class CClass;
class Delegate;

class DynamicMethodsPrototype
{
	// I\bh
	Methods dynamicMethods;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & BOOST_SERIALIZATION_NVP( dynamicMethods );
	}

public:
	DynamicMethodsPrototype(){}
	DynamicMethodsPrototype( const DynamicMethodsPrototype &dynamicMethodsPrototype )
		: dynamicMethods( dynamicMethodsPrototype.dynamicMethods )
	{
	}
	~DynamicMethodsPrototype(){}

	const Methods &GetDynamicMethods() const
	{
		return dynamicMethods;
	}
	Methods &GetDynamicMethods()
	{
		return dynamicMethods;
	}

	void AddDynamicMethods( CMethod *pMethod )
	{
		dynamicMethods.push_back( pMethod );
	}
};

class ClassPrototype : public Prototype, public DynamicMethodsPrototype
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Prototype );
		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( DynamicMethodsPrototype );
	}

public:
	ClassPrototype( const NamespaceScopes &namespaceScopes, const string &name )
		: Prototype( namespaceScopes, name )
		, DynamicMethodsPrototype()
	{
	}
	ClassPrototype()
		: Prototype()
		, DynamicMethodsPrototype()
	{
	}
};

class Interface : public DynamicMethodsPrototype
{
	const CClass *pInterfaceClass;
	mutable LONG_PTR vtblOffset;

	// ^p[^ip[^j
	Types actualTypeParameters;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - Interface" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( DynamicMethodsPrototype );
		ar & boost::serialization::make_nvp("pInterfaceClass", const_cast<CClass *&>(pInterfaceClass) );
		ar & BOOST_SERIALIZATION_NVP( vtblOffset );
		ar & BOOST_SERIALIZATION_NVP( actualTypeParameters );
	}

public:
	Interface( const CClass *pInterfaceClass, const Types &actualTypeParameters );
	Interface( const Interface &objInterface )
		: DynamicMethodsPrototype( objInterface )
		, pInterfaceClass( objInterface.pInterfaceClass )
		, vtblOffset( objInterface.vtblOffset )
	{
	}
	Interface()
	{
	}

	const CClass &GetClass() const{
		return *pInterfaceClass;
	}
	LONG_PTR GetVtblOffset() const
	{
		return vtblOffset;
	}
	void SetVtblOffset( LONG_PTR vtblOffset ) const
	{
		this->vtblOffset = vtblOffset;
	}

	const Types &GetActualTypeParameters() const
	{
		return actualTypeParameters;
	}

	std::string GetFullNameWithActualGenericTypeParameters() const;
};
typedef std::vector<Interface *> Interfaces;

class CClass: public ClassPrototype, public Jenga::Common::ObjectInHashmap<CClass>
{
public:
	// ^̎
	enum ClassType{
		Class,
		Interface,
		ComInterface,
		Enum,
		Delegate,
		Structure,
	};

private:
	ClassType classType;

	// importĂ閼O
	NamespaceScopesCollection importedNamespaces;

	// ^p[^
	GenericTypes formalGenericTypes;

	// pNX
	const CClass *pSuperClass;

	// pNX̌^p[^ip[^j
	Types superClassActualTypeParameters;

	// Blittable^
	Type blittableType;

	// C^[tFCX
	Interfaces interfaces;

	// Io
	Members dynamicMembers;

	// ÓIo
	Members staticMembers;

	// I\bh
	int ConstructorMemberSubIndex;
	int DestructorMemberSubIndex;
	int vtblNum;					// z֐̐

	// ÓI\bh
	Methods staticMethods;

	//ACgl
	int fixedAlignment;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - CClass" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( ClassPrototype );
		ar & BOOST_SERIALIZATION_NVP( classType );
		ar & BOOST_SERIALIZATION_NVP( importedNamespaces );
		ar & BOOST_SERIALIZATION_NVP( formalGenericTypes );
		ar & boost::serialization::make_nvp( "pSuperClass", const_cast<CClass *&>(pSuperClass) );
		ar & BOOST_SERIALIZATION_NVP( superClassActualTypeParameters );
		ar & BOOST_SERIALIZATION_NVP( blittableType );
		ar & BOOST_SERIALIZATION_NVP( interfaces );
		ar & BOOST_SERIALIZATION_NVP( dynamicMembers );
		ar & BOOST_SERIALIZATION_NVP( staticMembers );
		ar & BOOST_SERIALIZATION_NVP( ConstructorMemberSubIndex );
		ar & BOOST_SERIALIZATION_NVP( DestructorMemberSubIndex );
		ar & BOOST_SERIALIZATION_NVP( vtblNum );
		ar & BOOST_SERIALIZATION_NVP( staticMethods );
		ar & BOOST_SERIALIZATION_NVP( fixedAlignment );
	}

	bool isReady;
public:

	CClass( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const string &name )
		: ClassPrototype( namespaceScopes, name )
		, importedNamespaces( importedNamespaces )
		, classType( Class )
		, pSuperClass( NULL )
		, blittableType( Type() )
		, isReady( false )
		, fixedAlignment( 0 )
		, ConstructorMemberSubIndex( -1 )
		, DestructorMemberSubIndex( -1 )
		, vtblNum( 0 )
		, vtbl_offset( -1 )
		, comVtblOffset( 0 )
		, isCompilingConstructor( false )
		, isCompilingDestructor( false )
		, pobj_NextClass( NULL )
	{
	}
	CClass()
		: ClassPrototype()
		, importedNamespaces()
		, classType()
		, pSuperClass( NULL )
		, blittableType( Type() )
		, isReady( false )
		, fixedAlignment( 0 )
		, ConstructorMemberSubIndex( -1 )
		, DestructorMemberSubIndex( -1 )
		, vtblNum( 0 )
		, vtbl_offset( -1 )
		, comVtblOffset( 0 )
		, isCompilingConstructor( false )
		, isCompilingDestructor( false )
		, pobj_NextClass( NULL )
	{
	}
	~CClass()
	{
		// Io
		BOOST_FOREACH( CMember *member, dynamicMembers )
		{
			delete member;
		}

		// ÓIo
		BOOST_FOREACH( CMember *member, staticMembers )
		{
			delete member;
		}

		// C^[tFCX
		BOOST_FOREACH( ::Interface *pInterface, interfaces )
		{
			delete pInterface;
		}
	}

	virtual const std::string &GetKeyName() const
	{
		return GetName();
	}
	virtual bool IsDuplication( const CClass *pClass ) const
	{
		if( pClass->IsEqualSymbol( *this ) )
		{
			return true;
		}
		return false;
	}

	void Readed(){
		isReady = true;
	}
	bool IsReady() const{
		return isReady;
	}

	const NamespaceScopesCollection &GetImportedNamespaces() const
	{
		return importedNamespaces;
	}

	// ^p[^
	void AddFormalGenericType( GenericType genericType )
	{
		this->formalGenericTypes.push_back( genericType );
	}
	int GetFormalGenericTypeParameterIndex( const std::string &name ) const
	{
		int i = 0;
		BOOST_FOREACH( const GenericType &genericType, formalGenericTypes )
		{
			if( genericType.GetName() == name )
			{
				return i;
			}
			i++;
		}
		return -1;
	}
	bool IsExistFormalGenericTypeParameter( const std::string &name ) const
	{
		BOOST_FOREACH( const GenericType &genericType, formalGenericTypes )
		{
			if( genericType.GetName() == name )
			{
				return true;
			}
		}
		return false;
	}

	// pNX
	bool HasSuperClass() const
	{
		return ( pSuperClass != NULL );
	}
	const CClass &GetSuperClass() const
	{
		return *pSuperClass;
	}
	void SetSuperClass( const CClass *pSuperClass )
	{
		this->pSuperClass = pSuperClass;
	}
	const Types &GetSuperClassActualTypeParameters() const
	{
		return superClassActualTypeParameters;
	}
	void SetSuperClassActualTypeParameters( const Types &actualTypeParameters )
	{
		this->superClassActualTypeParameters = actualTypeParameters;
	}

	// Blittable^
	bool IsBlittableType() const
	{
		return !blittableType.IsNull();
	}
	const Type &GetBlittableType() const
	{
		return blittableType;
	}
	void SetBlittableType( const Type &type ){
		blittableType = type;
	}

	bool IsClass() const;
	bool IsInterface() const;
	bool IsComInterface() const;
	bool IsEnum() const;
	bool IsDelegate() const;
	bool IsStructure() const;
	void SetClassType( ClassType classType )
	{
		this->classType = classType;
	}


	//RXgN^RpCĂ邩ǂ̃`FbNtO
private:
	mutable bool isCompilingConstructor;
public:
	void NotifyStartConstructorCompile() const;
	void NotifyFinishConstructorCompile() const;
	bool IsCompilingConstructor() const;

	//fXgN^RpCĂ邩ǂ̃`FbNtO
private:
	mutable bool isCompilingDestructor;
public:
	void NotifyStartDestructorCompile() const;
	void NotifyFinishDestructorCompile() const;
	bool IsCompilingDestructor() const;


	//g̔hNXǂmF
	bool IsSubClass( const CClass *pClass ) const;

	//gƓ܂͔hNXǂmF
	bool IsEqualsOrSubClass( const CClass *pClass ) const;

	// gƓ܂͔hNXANXǂmF
	bool IsEqualsOrSubClassOrSuperClass( const CClass &objClass ) const;

	// C^[tFCX
	bool HasInterfaces() const
	{
		return ( interfaces.size() != 0 );
	}
	const Interfaces &GetInterfaces() const
	{
		return interfaces;
	}
	bool IsInheritsInterface( const CClass *pInterfaceClass ) const;

	// NXp
	bool Inherits( const char *inheritNames, int nowLine );
	bool InheritsClass( const CClass &inheritsClass, const Types &actualTypeParameters, int nowLine );
	bool InheritsInterface( const CClass &inheritsClass, int nowLine );

	// C^[tFCX
	bool Implements( const CClass &interfaceClass, const Types &actualTypeParameters, int nowLine );
	bool Implements( const char *interfaceNames, int nowLine );

	//oA\bh̒ǉ
	CMember *CreateMember( Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine );
	void AddMember( Prototype::Accessibility accessibility, bool idConst, bool isRef, char *buffer, int nowLine );
	void AddStaticMember( Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine );

	void AddMethod(CClass *pobj_c, Prototype::Accessibility accessibility, BOOL bStatic, bool isConst, bool isAbstract,
		bool isVirtual, bool isOverride, bool isAutoGeneration, char *buffer, int nowLine);

	//d`FbN
	bool DupliCheckAll(const char *name);
	bool DupliCheckMember(const char *name);

	const Members &GetDynamicMembers() const
	{
		return dynamicMembers;
	}
	const Members &GetStaticMembers() const
	{
		return staticMembers;
	}
	Members &GetDynamicMembers()
	{
		return dynamicMembers;
	}
	Members &GetStaticMembers()
	{
		return staticMembers;
	}
	
	const CMember *FindDynamicMember( const char *memberName ) const
	{
		BOOST_FOREACH( CMember *pMember, GetDynamicMembers() )
		{
			if( pMember->GetName() == memberName )
			{
				return pMember;
			}
		}
		return NULL;
	}

	void EnumDynamicMethodsOrInterfaceMethods( const char *methodName, std::vector<const UserProc *> &subs ) const;
	const CMethod *GetDynamicMethodOrInterfaceMethod( const UserProc *pUserProc ) const;

	const Methods &GetStaticMethods() const
	{
		return staticMethods;
	}
	Methods &GetStaticMethods()
	{
		return staticMethods;
	}

	//ftHg RXgN^
	const CMethod *GetConstructorMethod() const
	{
		if( ConstructorMemberSubIndex == -1 ) return NULL;
		return GetDynamicMethods()[ConstructorMemberSubIndex];
	}
	void SetConstructorMemberSubIndex( int constructorMemberSubIndex )
	{
		this->ConstructorMemberSubIndex = constructorMemberSubIndex;
	}

	//fXgN^ \bh擾
	const CMethod *GetDestructorMethod() const
	{
		if( DestructorMemberSubIndex == -1 ) return NULL;
		return GetDynamicMethods()[DestructorMemberSubIndex];
	}
	void SetDestructorMemberSubIndex( int destructorMemberSubIndex )
	{
		this->DestructorMemberSubIndex = destructorMemberSubIndex;
	}

	// fQ[g擾
	const ::Delegate &GetDelegate() const;

	// [Uw̃ACgŒl
	int GetFixedAlignment() const
	{
		return fixedAlignment;
	}
	void SetFixedAlignment( int fixedAlignment )
	{
		this->fixedAlignment = fixedAlignment;
	}

	// ȏTCY擾
	int GetSize() const;

	// õItZbg擾
	int GetMemberOffset( const char *memberName, int *pMemberNum = NULL ) const;
private:
	// ACgl擾
	int GetAlignment() const;


	/////////////////////////////////////////////////////////////////
	// vtbl
	/////////////////////////////////////////////////////////////////
public:
	// vtblɑ݂鉼z֐̐
	int GetVtblNum() const
	{
		return vtblNum;
	}
	void SetVtblNum( int vtblNum )
	{
		this->vtblNum = vtblNum;
	}
	void AddVtblNum( int vtblNum )
	{
		this->vtblNum += vtblNum;
	}
	bool IsExistVirtualFunctions() const
	{
		return ( vtblNum > 0 );
	}
	
private:
	long vtbl_offset;
	long comVtblOffset;
	long vtblMasterListOffset;
	std::vector<long> vtblMasterList;
public:
	void GetVtblMasterListIndexAndVtblIndex( const UserProc *pUserProc, int &vtblMasterListIndex, int &vtblIndex ) const;
	int GetVtblMasterListIndex( const CClass *pClass ) const;
	long GetComVtblOffset() const;
	long GetVtblMasterListOffset() const;
	void GenerateVTableMasterList( const std::vector<long> &vtableMasterList, long &offset );
	void GenerateFullVTables();
	void ActionVtblSchedule( LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection, LONG_PTR MemPos_DataSection );
	bool IsAbstract() const;


	// TypeInfop
	mutable int typeInfoDataTableOffset;
	void SetTypeInfoDataTableOffset( int typeInfoDataTableOffset ) const
	{
		this->typeInfoDataTableOffset = typeInfoDataTableOffset;
	}
	int GetTypeInfoDataTableOffset() const
	{
		return typeInfoDataTableOffset;
	}


	//`Xgp
	CClass *pobj_NextClass;
};

class Classes : public Jenga::Common::Hashmap<CClass>
{
	// XMLVACYp
public:
	Classes()
		: pCompilingMethod( NULL )
		, pStringClass( NULL )
		, pObjectClass( NULL )
		, pInterfaceInfo( NULL )
	{
	}
	~Classes()
	{
	}

	virtual CClass *Create( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const char *name);
	bool Insert( CClass *pClass, int nowLine );
	CClass *Add( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const char *name,int nowLine);
	virtual void CollectClassesForNameOnly( const BasicSource &source );

	// vtblꎞIɐ
	void GenerateVTables();

	// vtbl̂𐳋K̃ItZbgōč\z
	void ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection, LONG_PTR MemPos_DataSection );

	virtual void InitStaticMember();

private:
	bool MemberVar_LoopRefCheck(const CClass &objClass);
public:
	virtual void GetClass_recur(const char *lpszInheritsClass);
	void LookaheadClass( const char *className );
	bool LoopRefCheck( const CClass &objClass );
	virtual void GetAllClassInfo();
	virtual void Compile_System_InitializeUserTypes();
	virtual void Compile_System_InitializeUserTypesForBaseType();

	const CClass *Find( const NamespaceScopes &namespaceScopes, const string &name ) const;
	const CClass *Find( const string &fullName ) const;


	/////////////////////////////
	// ݃RpC̏
	/////////////////////////////
private:
	const CMethod *pCompilingMethod;
public:
	void StartCompile( const UserProc *pUserProc );

	//݃RpC̃\bh擾
	const CMethod *GetNowCompilingMethodInfo(){
		return pCompilingMethod;
	}


	/////////////////////////////
	// NX
	/////////////////////////////
	mutable const CClass *pStringClass;
	mutable const CClass *pObjectClass;
	mutable const CClass *pInterfaceInfo;
	const CClass *GetStringClassPtr() const;
	const CClass *GetObjectClassPtr() const;
	const CClass *GetInterfaceInfoClassPtr() const;
};
