#include "stdafx.h"

#include <jenga/include/smoothie/Smoothie.h>
#include <jenga/include/smoothie/SmoothieException.h>
#include <jenga/include/smoothie/LexicalAnalysis.h>

#include <Source.h>
#include <Class.h>
#include <Compiler.h>
#include <NamespaceSupporter.h>

#include "../common.h"
#ifdef _AMD64_
#include "../../BasicCompiler64/opcode.h"
#else
#include "../../BasicCompiler32/opcode.h"
#endif


Interface::Interface( const CClass *pInterfaceClass, const Types &actualTypeParameters )
	: DynamicMethodsPrototype()
	, pInterfaceClass( pInterfaceClass )
	, vtblOffset( -1 )
	, actualTypeParameters( actualTypeParameters )
{
	//\bhRs[
	BOOST_FOREACH( const CMethod *pBaseMethod, pInterfaceClass->GetDynamicMethods() )
	{
		CMethod *pMethod = new DynamicMethod( *pBaseMethod );

		// ANZVreB
		if(pBaseMethod->GetAccessibility() == Prototype::Private){
			pMethod->SetAccessibility( Prototype::None );
		}
		else{
			pMethod->SetAccessibility( pBaseMethod->GetAccessibility() );
		}

		//pobj_Inherits
		// pClassIndexZbgiqplj
		if(pBaseMethod->GetInheritsClassPtr()==0){
			pMethod->SetInheritsClassPtr( pInterfaceClass );
		}
		else{
			pMethod->SetInheritsClassPtr( pBaseMethod->GetInheritsClassPtr() );
		}

		AddDynamicMethods( pMethod );
	}
}

std::string Interface::GetFullNameWithActualGenericTypeParameters() const
{
	std::string interfaceName = this->GetClass().GetFullName();
	if( actualTypeParameters.size() )
	{
		std::string actualGenericTypesName;
		BOOST_FOREACH( const Type &typeParameter, actualTypeParameters )
		{
			if( actualGenericTypesName.size() )
			{
				actualGenericTypesName += ",";
			}
			actualGenericTypesName += typeParameter.ToString();
		}

		interfaceName += "<" + actualGenericTypesName + ">";
	}
	return interfaceName;
}

bool CClass::IsClass() const
{
	return classType == CClass::Class;
}
bool CClass::IsInterface() const
{
	return classType == CClass::Interface;
}
bool CClass::IsComInterface() const
{
	return classType == CClass::ComInterface;
}
bool CClass::IsEnum() const
{
	return classType == CClass::Enum;
}
bool CClass::IsDelegate() const
{
	return classType == CClass::Delegate;
}
bool CClass::IsStructure() const
{
	return classType == CClass::Structure;
}


// RXgN^̃RpCJn
void CClass::NotifyStartConstructorCompile() const
{
	isCompilingConstructor = true;
}

//RXgN^̃RpCI
void CClass::NotifyFinishConstructorCompile() const
{
	isCompilingConstructor = false;
}

//RXgN^RpCǂ𔻕
bool CClass::IsCompilingConstructor() const
{
	return isCompilingConstructor;
}

//fXgN^̃RpCJn
void CClass::NotifyStartDestructorCompile() const{
	isCompilingDestructor = true;
}

//fXgN^̃RpCI
void CClass::NotifyFinishDestructorCompile() const{
	isCompilingDestructor = false;
}

//fXgN^RpCǂ𔻕
bool CClass::IsCompilingDestructor() const
{
	return isCompilingDestructor;
}

//g̔hNXǂmF
bool CClass::IsSubClass( const CClass *pClass ) const
{
	if( !pClass->HasSuperClass() )
	{
		return false;
	}

	const CClass *pTempClass = &pClass->GetSuperClass();
	while( pTempClass ){
		if( this == pTempClass ) return true;
		pTempClass = &pTempClass->GetSuperClass();
	}
	return false;
}

//gƓ܂͔hNXǂmF
bool CClass::IsEqualsOrSubClass( const CClass *pClass ) const
{
	if( IsEquals( pClass ) ) return true;
	return IsSubClass( pClass );
}

// gƓ܂͔hNXANXǂmF
bool CClass::IsEqualsOrSubClassOrSuperClass( const CClass &objClass ) const
{
	if( IsEquals( &objClass ) ) return true;
	if( IsSubClass( &objClass ) ) return true;
	if( objClass.IsSubClass( this ) ) return true;
	return false;
}

bool CClass::IsInheritsInterface( const CClass *pInterfaceClass ) const
{
	BOOST_FOREACH( const ::Interface *pInterface, interfaces ){
		if( pInterfaceClass == &pInterface->GetClass() ){
			return true;
		}
	}
	return false;
}

bool CClass::Inherits( const char *inheritNames, int nowLine ){
	int i = 0;
	bool isInheritsClass = false;
	while( true ){

		char temporary[VN_SIZE];
		for( int i2=0;; i++, i2++ ){
			if( inheritNames[i] == '\0' || inheritNames[i] == ',' ){
				temporary[i2] = 0;
				break;
			}
			temporary[i2] = inheritNames[i];
		}

		// WFlNX\𕪉
		char className[VN_SIZE];
		Jenga::Common::Strings typeParameterStrings;
		SplitGenericClassInstance( temporary, className, typeParameterStrings );

		// ^p[^񂩂^f[^擾
		Types actualTypeParameters;
		BOOST_FOREACH( const std::string &typeParameterStr, typeParameterStrings )
		{
			Type type;
			compiler.StringToType( typeParameterStr, type );
			actualTypeParameters.push_back( type );
		}

		//pNX擾
		const CClass *pInheritsClass = compiler.GetObjectModule().meta.GetClasses().Find(className);
		if( !pInheritsClass ){
			SmoothieException::Throw(106,className,nowLine);
			return false;
		}

		if( pInheritsClass->IsClass() ){
			// NXp
			isInheritsClass = true;

			if( !InheritsClass( *pInheritsClass, actualTypeParameters, nowLine ) ){
				return false;
			}
		}
		else{
			SetError(135,pInheritsClass->GetFullName().c_str(),nowLine);
			return false;
		}

		if( inheritNames[i] == '\0' ){
			break;
		}
		i++;
	}

	if( !isInheritsClass ){
		// NXpĂȂƂ
		if( !InheritsClass( *compiler.GetObjectModule().meta.GetClasses().GetObjectClassPtr(), Types(), nowLine ) ){
			return false;
		}
	}

	return true;
}
bool CClass::InheritsClass( const CClass &inheritsClass, const Types &actualTypeParameters, int nowLine )
{
	//[vpłȂ`FbN
	if( !compiler.GetObjectModule().meta.GetClasses().LoopRefCheck(inheritsClass) )
	{
		SmoothieException::Throw(123,inheritsClass.GetName(),nowLine);
		return false;
	}

	if( !inheritsClass.IsReady() ){
		//p悪ǂݎĂȂƂ
		compiler.GetObjectModule().meta.GetClasses().LookaheadClass(inheritsClass.GetName().c_str());
	}

	//oRs[
	BOOST_FOREACH( CMember *inheritsClassDynamicMember, inheritsClass.GetDynamicMembers() ){
		CMember *pMember = new CMember( *inheritsClassDynamicMember );

		// ANZVreB
		if( inheritsClassDynamicMember->IsPrivate() ){
			pMember->SetAccessibility( Prototype::None );
		}
		else{
			pMember->SetAccessibility( inheritsClassDynamicMember->GetAccessibility() );
		}

		// ô݁A^p[^i\bĥق͌Ăяoɉj
		if( pMember->GetType().IsTypeParameter() )
		{
			pMember->ResetType( actualTypeParameters[pMember->GetType().GetFormalTypeIndex()] );
		}

		dynamicMembers.push_back( pMember );
	}

	//\bhRs[
	BOOST_FOREACH( const CMethod *pBaseMethod, inheritsClass.GetDynamicMethods() ){
		CMethod *pMethod = new DynamicMethod( *pBaseMethod );

		// ANZVreB
		if(pBaseMethod->GetAccessibility() == Prototype::Private){
			pMethod->SetAccessibility( Prototype::None );
		}
		else{
			pMethod->SetAccessibility( pBaseMethod->GetAccessibility() );
		}

		//pobj_Inherits
		// pClassIndexZbgiqplj
		if(pBaseMethod->GetInheritsClassPtr()==0){
			pMethod->SetInheritsClassPtr( &inheritsClass );
		}
		else{
			pMethod->SetInheritsClassPtr( pBaseMethod->GetInheritsClassPtr() );
		}

		GetDynamicMethods().push_back( pMethod );
	}

	//z֐̐
	AddVtblNum( inheritsClass.GetVtblNum() );

	//p̃NXoƂĕێ
	SetSuperClass( &inheritsClass );
	SetSuperClassActualTypeParameters( actualTypeParameters );

	// C^[tFCXp
	BOOST_FOREACH( ::Interface *pInterface, inheritsClass.GetInterfaces() )
	{
		interfaces.push_back( new ::Interface( *pInterface ) );
	}

	if( this->IsInterface() && inheritsClass.IsComInterface() )
	{
		// COMC^[tFCXpꍇCOMC^[tFCXɂ
		this->SetClassType( CClass::ComInterface );
	}

	return true;
}

bool CClass::Implements( const CClass &interfaceClass, const Types &actualTypeParameters, int nowLine )
{
	if( !interfaceClass.IsInterface() && !interfaceClass.IsComInterface() )
	{
		// C^[tFCXł͂ȂƂ
		SetError(138,interfaceClass.GetName().c_str(),nowLine );
		return false;
	}

	if( !interfaceClass.IsReady() ){
		// C^[tFCX͂̂Ƃ
		compiler.GetObjectModule().meta.GetClasses().LookaheadClass( interfaceClass.GetName().c_str() );
	}

	::Interface *pDestInterface = new ::Interface( &interfaceClass, actualTypeParameters );

	interfaces.push_back( pDestInterface );


	/////////////////////////////////////////////////////////////////
	// NX̃\bhC^[tFCX\bhĎ
	/////////////////////////////////////////////////////////////////
	BOOST_FOREACH( CMethod *pMethod, GetDynamicMethods() )
	{
		CMethod *pMethodForOverride = pDestInterface->GetDynamicMethods().FindForOverride( &pMethod->GetUserProc() );
		if( pMethodForOverride )
		{
			pMethodForOverride->Override( &pMethod->GetUserProc(), pMethod->GetAccessibility(), false );

			// ɂȂ郁\bh͌ĂяosɂĂiI[o[[h̉珜Oj
			pMethod->SetNotUseMark( true );
		}
	}


	/////////////////////////////////////////////////////////////////
	// LXg\bhǉiR[h͎邱Ɓj
	/////////////////////////////////////////////////////////////////
	if( interfaceClass.IsInterface() )
	{
		// Function Operator() As ITest

		char temporary[1024];
		sprintf(temporary,"%c%c%c%c()%c%c%s",
			1, ESC_FUNCTION,
			1, ESC_OPERATOR,
			1, ESC_AS,
			pDestInterface->GetFullNameWithActualGenericTypeParameters().c_str()
		);

		this->AddMethod(this,
			Prototype::Public,
			0,
			false,			// isConst
			false,			// isAbstract
			false,			// isVirtual
			false,			// isOverride
			true,			// isAutoGeneration
			temporary,
			-1
		);
	}


	return true;
}
bool CClass::Implements( const char *interfaceNames, int nowLine )
{
	Jenga::Common::Strings paramStrs;
	SplitParameter( interfaceNames, paramStrs );
	
	BOOST_FOREACH( const std::string &paramStr, paramStrs )
	{
		char className[VN_SIZE];
		Jenga::Common::Strings typeParameterStrings;
		SplitGenericClassInstance( paramStr.c_str(), className, typeParameterStrings );

		Types actualTypeParameters;
		BOOST_FOREACH( const std::string &typeParameterStr, typeParameterStrings )
		{
			Type type;
			compiler.StringToType( typeParameterStr, type );
			actualTypeParameters.push_back( type );
		}

		//pNX擾
		const CClass *pInterfaceClass = compiler.GetObjectModule().meta.GetClasses().Find( className );
		if( !pInterfaceClass ){
			SetError(106,paramStr.c_str(),nowLine);
			continue;
		}

		// C^[tFCXp
		Implements( *pInterfaceClass, actualTypeParameters, nowLine );
	}

	return true;
}

CMember *CClass::CreateMember( Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine )
{
	extern int cp;

	//\
	char VarName[VN_SIZE];
	char initBuffer[VN_SIZE];
	char lpszConstructParameter[VN_SIZE];
	Subscripts subscripts;
	Type type;
	GetDimentionFormat(buffer,VarName,subscripts,type,initBuffer,lpszConstructParameter);

	//d`FbN
	if(this->DupliCheckAll(VarName)){
		SetError(15,VarName,cp);
	}

	CMember *pMember = new CMember( accessibility, VarName, type, isConst, subscripts, initBuffer, lpszConstructParameter );
	pMember->source_code_address = nowLine;
	return pMember;
}
void CClass::AddMember( Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine ){
	dynamicMembers.push_back(
		CreateMember( accessibility, isConst, isRef, buffer, nowLine )
	);
}
void CClass::AddStaticMember( Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine ){
	staticMembers.push_back(
		CreateMember( accessibility, isConst, isRef, buffer, nowLine )
	);
}

void CClass::AddMethod(CClass *pobj_c, Prototype::Accessibility accessibility, BOOL bStatic, bool isConst, bool isAbstract,
						 bool isVirtual, bool isOverride, bool isAutoGeneration, char *buffer, int nowLine){
	int i,i2;
	char temporary[VN_SIZE];

	i=2;
	for(i2=0;;i++,i2++){
		if(buffer[i]=='('||buffer[i]=='\0'){
			temporary[i2]=0;
			break;
		}
		temporary[i2]=buffer[i];
	}


	//֐nbV֓o^
	char interfaceName[VN_SIZE] = "";
	UserProc *pUserProc = compiler.GetObjectModule().meta.GetUserProcs().AddUserProc( NamespaceScopes(), NamespaceScopesCollection(), buffer,nowLine,isVirtual,pobj_c, (bStatic!=0), interfaceName );
	if(!pUserProc) return;

	if( isAutoGeneration )
	{
		// R[h
		pUserProc->ThisIsAutoGenerationProc();
	}


	////////////////////////////////////////////////////////////
	// RXgN^AfXgN^̏ꍇ̏
	////////////////////////////////////////////////////////////
	BOOL fConstructor=0,bDestructor=0;

	if(lstrcmp(temporary,pobj_c->GetName().c_str())==0){
		//RXgN^̏ꍇ

		//WRXgN^iȂj
		if(pUserProc->Params().size()==0) fConstructor=1;

		//IConstCq
		isConst = true;
	}
	else if(temporary[0]=='~'){
		//fXgN^̏ꍇ̖͂O`FbNs
		if(lstrcmp(temporary+1,pobj_c->GetName().c_str())!=0)
			SetError(117,NULL,nowLine);
		else
			bDestructor=1;
	}
	if(fConstructor||bDestructor){
		// RXgN^AfXgN^̃ANZVreB`FbN

		//IConstCq
		isConst = true;
	}

	if( fConstructor == 1 )
		pobj_c->SetConstructorMemberSubIndex( (int)pobj_c->GetDynamicMethods().size() );
	else if( bDestructor )
		pobj_c->SetDestructorMemberSubIndex( (int)pobj_c->GetDynamicMethods().size() );



	//////////////////
	// d`FbN
	//////////////////

	if(pobj_c->DupliCheckMember(temporary)){
		SetError(15,temporary,nowLine);
		return;
	}

	//\bh
	BOOST_FOREACH( const CMethod *pMethod, pobj_c->GetDynamicMethods() )
	{
		//NXƏdꍇ̓I[o[Chs
		if( pMethod->GetInheritsClassPtr() ) continue;

		if( pMethod->GetUserProc().IsEqualForOverride( pUserProc ) )
		{
			//֐Ap[^A߂lvƂ
			SetError(15,pUserProc->GetName().c_str(),nowLine);
			return;
		}
	}

	//z֐̏ꍇ
	if( isAbstract ) pUserProc->CompleteCompile();

	// \bh̃I[o[Ch
	CMethod *pMethodForOverride = pobj_c->GetDynamicMethods().FindForOverride( pUserProc );
	if( pMethodForOverride )
	{
		pMethodForOverride->Override( pUserProc, accessibility, isOverride );
		pUserProc->SetMethod( pMethodForOverride );
		return;
	}
	else
	{
		ts(buffer);
		// C^[tFCX \bh̃I[o[Ch
		BOOST_FOREACH( ::Interface *pInterface, pobj_c->GetInterfaces() )
		{
			if( interfaceName[0] )
			{
				if( pInterface->GetClass().GetName() != interfaceName )
				{
					// w肳ꂽC^[tFCXƐȂƂ
					continue;
				}
			}

			if( !pInterface->GetClass().IsReady() ){
				// C^[tFCX͂̂Ƃ
				compiler.GetObjectModule().meta.GetClasses().LookaheadClass( pInterface->GetClass().GetName().c_str() );
			}

			CMethod *pMethodForOverride = pInterface->GetDynamicMethods().FindForOverride( pUserProc );
			if( pMethodForOverride )
			{
				pMethodForOverride->Override( pUserProc, accessibility, isOverride );
				pUserProc->SetMethod( pMethodForOverride );
				return;
			}
		}
	}

	if( interfaceName[0] )
	{
		SetError(139,interfaceName,nowLine);
	}

	if( isVirtual ){
		pobj_c->AddVtblNum( 1 );
	}

	if( isOverride ){
		SetError(12,"Override",nowLine);
	}

	if(bStatic){
		pobj_c->GetStaticMethods().AddStatic( pUserProc, accessibility );
	}
	else{
		pobj_c->GetDynamicMethods().Add(pUserProc, accessibility, isConst, isAbstract, isVirtual);
	}
}

bool CClass::DupliCheckAll(const char *name){
	//d`FbN

	//o
	if(DupliCheckMember(name)) return 1;

	//\bh
	BOOST_FOREACH( const CMethod *pMethod, GetDynamicMethods() ){
		if( lstrcmp( name, pMethod->GetUserProc().GetName().c_str() ) == 0 ){
			return 1;
		}
	}

	return 0;
}
bool CClass::DupliCheckMember(const char *name){
	//d`FbN

	// Io
	BOOST_FOREACH( CMember *pMember, dynamicMembers ){
		if( GetName() == pMember->GetName() ){
			return 1;
		}
	}

	// ÓIo
	BOOST_FOREACH( CMember *pMember, staticMembers ){
		if( GetName() == pMember->GetName() ){
			return 1;
		}
	}

	return 0;
}

void CClass::EnumDynamicMethodsOrInterfaceMethods( const char *methodName, std::vector<const UserProc *> &subs ) const
{
	// I\bh
	GetDynamicMethods().Enum( methodName, subs );

	// C^[tFCX \bh
	BOOST_FOREACH( ::Interface *pInterface, GetInterfaces() )
	{
		pInterface->GetDynamicMethods().Enum( methodName, subs );
	}
}
const CMethod *CClass::GetDynamicMethodOrInterfaceMethod( const UserProc *pUserProc ) const
{
	// I\bh
	const CMethod *result = GetDynamicMethods().GetMethodPtr( pUserProc );

	if( !result )
	{
		// C^[tFCX \bh
		BOOST_FOREACH( ::Interface *pInterface, GetInterfaces() )
		{
			result = pInterface->GetDynamicMethods().GetMethodPtr( pUserProc );
			if( result )
			{
				return result;
			}
		}
	}

	return result;
}

const ::Delegate &CClass::GetDelegate() const
{
	const ::Delegate *dg = compiler.GetObjectModule().meta.GetDelegates().GetHashArrayElement( GetName().c_str() );
	while( dg )
	{
		if( dg->IsEqualSymbol( GetNamespaceScopes(), GetName() ) ){
			//OԂƃNXv
			return *dg;
		}
		dg = dg->GetChainNext();
	}

	Jenga::Throw( "CClass::GetDelegate\bhɎs" );
	static ::Delegate dummy;
	return dummy;
}

//TCY擾
int CClass::GetSize() const
{
	return GetMemberOffset( NULL, NULL );
}

//õItZbg擾
int CClass::GetMemberOffset( const char *memberName, int *pMemberNum ) const
{
	int i2;

	//z֐݂ꍇvtblyvtblMasterListւ̃|C^̃TCYǉ
	int offset = IsExistVirtualFunctions() ? PTR_SIZE*2 : 0;

	int alignment = 1;
	if( GetFixedAlignment() )
	{
		alignment = GetFixedAlignment();
	}

	int iMaxAlign=0;
	int i = -1;
	BOOST_FOREACH( CMember *pMember, dynamicMembers ){
		i++;

		i2 = pMember->GetType().GetSize();

		//ACgZo
		int member_size;
		if( pMember->GetType().IsStruct() ){
			//oNX̃ACg擾
			member_size=pMember->GetType().GetClass().GetAlignment();
		}
		else{
			//oTCY擾
			member_size=i2;
		}
		if(iMaxAlign<member_size) iMaxAlign=member_size;

		//ACgl
		if(GetFixedAlignment()&&GetFixedAlignment()<member_size){
			if(offset%alignment) offset+=alignment-(offset%alignment);
		}
		else{
			if(alignment<member_size) alignment=member_size;

			if(member_size==0){
				//oȂNX
				//ȂiItZbǧvZȂj
			}
			else{
				if(offset%member_size) offset+=member_size-(offset%member_size);
			}
		}

		if(memberName){
			//ow肪ꍇ́AItZbgԂ
			if( pMember->GetName() == memberName ){
				if(pMemberNum) *pMemberNum=i;
				return offset;
			}
		}

		//zloTCY擾
		member_size = i2 * Variable::GetSubScriptCounts( pMember->GetSubscripts() );

		//oTCYZ
		offset+= member_size;
	}

	if(iMaxAlign<alignment) alignment=iMaxAlign;

	//ACgl
	if(alignment){
		if(offset%alignment) offset+=alignment-(offset%alignment);
	}

	if(pMemberNum) *pMemberNum=i;
	return offset;
}
int CClass::GetAlignment() const
{
	//z֐݂ꍇ͊֐Xgւ̃|C^̃TCYǉ
	int alignment = IsExistVirtualFunctions() ? PTR_SIZE : 0;

	BOOST_FOREACH( CMember *pMember, dynamicMembers ){
		int member_size;
		if(pMember->GetType().IsStruct()){
			//oNX̃ACg擾
			member_size=pMember->GetType().GetClass().GetAlignment();
		}
		else{
			//oTCY擾
			member_size = pMember->GetType().GetSize();
		}

		//ACgZbg
		if(alignment<member_size) alignment=member_size;
	}

	if(alignment==0) return 0;

	if(GetFixedAlignment()) alignment=GetFixedAlignment();

	return alignment;
}

void CClass::GetVtblMasterListIndexAndVtblIndex( const UserProc *pUserProc, int &vtblMasterListIndex, int &vtblIndex ) const
{
	vtblMasterListIndex = 0;

	vtblIndex = 0;
	BOOST_FOREACH( const CMethod *pMethod, GetDynamicMethods() ){
		if( &pMethod->GetUserProc() == pUserProc )
		{
			return;
		}

		if( pMethod->IsVirtual() )
		{
			vtblIndex++;
		}
	}

	BOOST_FOREACH( const ::Interface *pInterface, interfaces )
	{
		vtblMasterListIndex++;

		vtblIndex = 0;
		BOOST_FOREACH( const CMethod *pMethod, pInterface->GetDynamicMethods() ){
			if( &pMethod->GetUserProc() == pUserProc )
			{
				return;
			}

			if( pMethod->IsVirtual() )
			{
				vtblIndex++;
			}
		}
	}

	SetError();
	return;
}
int CClass::GetVtblMasterListIndex( const CClass *pClass ) const
{
	int result = 0;

	BOOST_FOREACH( const ::Interface *pInterface, interfaces )
	{
		result++;
		
		if( &pInterface->GetClass() == pClass )
		{
			return result;
		}
	}

	SetError();
	return 0;
}
long CClass::GetComVtblOffset() const
{
	return comVtblOffset;
}
long CClass::GetVtblMasterListOffset() const
{
	//ɑ݂ꍇ͂Ԃ
	if( vtblMasterListOffset == -1 )
	{
		SetError();
	}

	return vtblMasterListOffset;
}
void CClass::GenerateVTableMasterList( const std::vector<long> &vtableMasterList, long &offset )
{
	offset = compiler.GetObjectModule().dataTable.AddBinary(
		(void *)&vtableMasterList[0],
		static_cast<int>(vtableMasterList.size()*sizeof(LONG_PTR))
	);
}
void CClass::GenerateFullVTables()
{
	if( IsAbstract() )
	{
		// ۃNX͖
		return;
	}
	if( !IsUsing() )
	{
		// gĂȂNX͖
		return;
	}

	// vtbl}X^[Xǧf[^ɕsvȃf[^܂܂ĂG[
	if( vtblMasterList.size() )
	{
		SetError();
	}

	// g̃NXvtbl𐶐
	GetDynamicMethods().GenerateVTablePart( this->vtbl_offset );
	vtblMasterList.push_back( this->vtbl_offset );

	// C^[tFCXvtbl𐶐
	BOOST_FOREACH( const ::Interface *pInterface, interfaces )
	{
		long tempVtblOffset;
		pInterface->GetDynamicMethods().GenerateVTablePart( tempVtblOffset );
		vtblMasterList.push_back( tempVtblOffset );

		pInterface->SetVtblOffset( tempVtblOffset );

		if( pInterface->GetClass().IsComInterface() )
		{
			if( this->comVtblOffset )
			{
				SetError();
			}
			this->comVtblOffset = tempVtblOffset;
		}
	}

	// vtbl}X^[Xg𐶐
	GenerateVTableMasterList( vtblMasterList, this->vtblMasterListOffset );
}
void CClass::ActionVtblSchedule( LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection, LONG_PTR MemPos_DataSection )
{
	if( IsAbstract() )
	{
		// ۃNX͖
		return;
	}
	if( !IsUsing() )
	{
		// gĂȂNX͖
		return;
	}
	if(vtbl_offset==-1) return;

	// g̃NXvtbl
	{
		LONG_PTR *pVtbl = (LONG_PTR *)((char *)compiler.GetObjectModule().dataTable.GetPtr() + vtbl_offset);

		for( int i=0; i<GetVtblNum(); i++ ){
			const UserProc *pUserProc = (UserProc *)pVtbl[i];
			if(!pUserProc) continue;

			if( pUserProc->GetBeginOpAddress() == 0
				&& pUserProc->GetEndOpAddress() == 0 )
			{
				Jenga::Throw( "̉z֐݂" );
			}

			pVtbl[i] = pUserProc->GetBeginOpAddress() + ImageBase + MemPos_CodeSection;
		}
	}

	// C^[tFCXvtbl
	BOOST_FOREACH( const ::Interface *pInterface, interfaces )
	{
		LONG_PTR *pVtbl = (LONG_PTR *)((char *)compiler.GetObjectModule().dataTable.GetPtr() + pInterface->GetVtblOffset());

		for( int i=0; i<pInterface->GetClass().GetVtblNum(); i++ ){
			const UserProc *pUserProc = (UserProc *)pVtbl[i];
			if(!pUserProc) continue;

			if( pUserProc->GetBeginOpAddress() == 0
				&& pUserProc->GetEndOpAddress() == 0 )
			{
				Jenga::Throw( "̉z֐݂" );
			}

			pVtbl[i] = pUserProc->GetBeginOpAddress() + ImageBase + MemPos_CodeSection;
		}
	}

	// vtbl}X^[Xg
	LONG_PTR *pVtblMasterList = (LONG_PTR *)((char *)compiler.GetObjectModule().dataTable.GetPtr() + vtblMasterListOffset );
	for( int i=0; i<static_cast<int>(vtblMasterList.size()); i++ )
	{
		pVtblMasterList[i] = vtblMasterList[i] + ImageBase + MemPos_DataSection;
	}
}
bool CClass::IsAbstract() const
{
	// (abstract)̉z֐ꍇtrueԂ

	BOOST_FOREACH( const CMethod *pMethod, GetDynamicMethods() ){
		if(pMethod->IsVirtual()){
			if(pMethod->IsAbstract()){
				return true;
			}
		}
	}

	// C^[tFCXvtbl
	BOOST_FOREACH( const ::Interface *pInterface, interfaces )
	{
		BOOST_FOREACH( const CMethod *pMethod, pInterface->GetDynamicMethods() ){
			if(pMethod->IsVirtual()){
				if(pMethod->IsAbstract()){
					return true;
				}
			}
		}
	}

	return false;
}

CClass *Classes::Create( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const char *name){
	return new CClass(namespaceScopes, importedNamespaces, name);
}
bool Classes::Insert( CClass *pClass, int nowLine )
{
	/////////////////////////////////
	// nbVf[^ɒǉ
	/////////////////////////////////

	if( !Put( pClass ) )
	{
		SetError(15,pClass->GetName(), nowLine);
		return false;
	}
	return true;
}
CClass *Classes::Add( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const char *name,int nowLine){
	//////////////////////////////////////////////////////////////////////////
	// NXǉ
	// Ô݂o^B̑̏SetClass\bhŁI
	//////////////////////////////////////////////////////////////////////////

	CClass *pClass = Create(namespaceScopes, importedNamespaces, name);

	if( !Insert( pClass, nowLine ) )
	{
		return NULL;
	}

	return pClass;	
}

void Classes::GenerateVTables()
{
	Iterator_Reset();
	while( Iterator_HasNext() )
	{
		CClass *pClass = Iterator_GetNext();
		pClass->GenerateFullVTables();
	}
}

void Classes::ActionVtblSchedule( LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection, LONG_PTR MemPos_DataSection ){
	Iterator_Reset();
	while( Iterator_HasNext() )
	{
		CClass *pClass = Iterator_GetNext();
		pClass->ActionVtblSchedule( ImageBase, MemPos_CodeSection, MemPos_DataSection);
	}
}


void Classes::InitStaticMember(){
	//ÓIoO[öɍ쐬

	//Ce[^Zbg

	extern int cp;
	int back_cp=cp;

	this->Iterator_Reset();
	while(this->Iterator_HasNext()){
		CClass &objClass = *this->Iterator_GetNext();
		if( objClass.isTargetObjectModule == false )
		{
			// ÓINCȕꍇ͔΂iɃCX^X`ς݂ł邽߁j
			continue;
		}

		// OԂZbg
		compiler.GetNamespaceSupporter().GetLivingNamespaceScopes() = objClass.GetNamespaceScopes();

		DWORD dwFlags = 0;
		if( objClass.GetName() == "_System_TypeBase" )
		{
			// _System_TypeBaseNX̓O[oAX^eBbN̈邽߂̃NXȂ̂łł̏͏O
			dwFlags |= DIMFLAG_NONCALL_CONSTRACTOR;
		}

		int i=0;
		BOOST_FOREACH( CMember *member, objClass.GetStaticMembers() ){
			char temporary[VN_SIZE];
			sprintf(temporary,"%s.%s",objClass.GetName().c_str(),member->GetName().c_str());
			dim(
				temporary,
				member->GetSubscripts(),
				member->GetType(),
				member->GetInitializeExpression().c_str(),
				member->GetConstructParameter().c_str(),
				dwFlags);

			i++;
		}
	}

	compiler.GetNamespaceSupporter().GetLivingNamespaceScopes().clear();

	cp=back_cp;
}

void Classes::Compile_System_InitializeUserTypes(){
	char temporary[VN_SIZE];

	////////////////////////////////////////////////////////////////////
	// NXo^
	////////////////////////////////////////////////////////////////////

	// Ce[^Zbg
	Iterator_Reset();

	while( Iterator_HasNext() ){
		const CClass &objClass = *Iterator_GetNext();

		if( !objClass.IsUsing() ){
			// gp̃NX͖
			continue;
		}	

		char referenceOffsetsBuffer[1024] = "";
		int numOfReference = 0;
		BOOST_FOREACH( CMember *pMember, objClass.GetDynamicMembers() ){
			if( pMember->GetType().IsObject() || pMember->GetType().IsPointer() ){
				if( referenceOffsetsBuffer[0] ){
					lstrcat( referenceOffsetsBuffer, "," );
				}

				sprintf( referenceOffsetsBuffer + lstrlen( referenceOffsetsBuffer ),
					"%d",
					objClass.GetMemberOffset( pMember->GetName().c_str() ) );

				numOfReference++;
			}
		}

		sprintf( temporary
			, "Add(%c%c_System_TypeForClass[strNamespace=\"%s\",name=\"%s\",fullName=\"%s\",referenceOffsets=[%s],numOfReference=%d])"
			, 1
			, ESC_SYSTEM_STATIC_NEW
			, objClass.GetNamespaceScopes().ToString().c_str()		// O
			, objClass.GetName().c_str()							// NX
			, objClass.GetFullName().c_str()						// tl[
			, referenceOffsetsBuffer								// QƃoItZbgz
			, numOfReference										// Qƃǒ
			);

		// RpC
		ChangeOpcode( temporary );

		objClass.SetTypeInfoDataTableOffset(
			compiler.GetObjectModule().dataTable.GetLastMadeConstObjectDataTableOffset()
		);
	}
}
void Classes::Compile_System_InitializeUserTypesForBaseType()
{
	extern int cp;
	cp = -1;
	////////////////////////////////////////////////////////////////////
	// NXo^
	////////////////////////////////////////////////////////////////////

	char temporary[VN_SIZE];
	sprintf(temporary, "%c%ctempType=Nothing%c%cTypeBaseImpl"
		, HIBYTE( COM_DIM )
		, LOBYTE( COM_DIM )
		, 1
		, ESC_AS
		);
	ChangeOpcode( temporary );

	// Ce[^Zbg
	Iterator_Reset();

	while( Iterator_HasNext() ){
		const CClass &objClass = *Iterator_GetNext();

		if( !objClass.IsUsing() ){
			// gp̃NX͖
			continue;
		}

		if( objClass.HasSuperClass() ){
			sprintf( temporary
				, "tempType=Search(\"%s\")"
				, objClass.GetFullName().c_str()
				);

			// RpC
			ChangeOpcode( temporary );

			sprintf( temporary
				, "tempType.SetBaseType(Search(\"%s\"))"
				, objClass.GetSuperClass().GetFullName().c_str()
				);

			// RpC
			ChangeOpcode( temporary );
		}
	}



	////////////////////////////////////////////////////////////////////
	// p֌Wo^
	////////////////////////////////////////////////////////////////////
	// TODO: 
	/*

	// Ce[^Zbg
	Iterator_Reset();

	while( Iterator_HasNext() ){
		CClass *pClass = Iterator_GetNext();

		sprintf( genBuffer + length
			, "obj.Search( \"%s\" ).SetBaseType( Search( \"%s\" ) ):"
			, ""				// NX
			, pClass->name		// NX
			);
		length += lstrlen( genBuffer + length );

		while( length + 8192 > max ){
			max += 8192;
			genBuffer = (char *)realloc( genBuffer, max );
		}
	}*/
}

const CClass *Classes::Find( const NamespaceScopes &namespaceScopes, const string &name ) const
{
	if( namespaceScopes.size() == 0 && name == "Object" ){
		return GetObjectClassPtr();
	}
	else if( namespaceScopes.size() == 0 && name == "String" ){
		return GetStringClassPtr();
	}

	const CClass *pClass = GetHashArrayElement( name.c_str() );
	while( pClass )
	{
		if( pClass->IsEqualSymbol( namespaceScopes, name ) ){
			//OԂƃNXv
			return pClass;
		}
		pClass = pClass->GetChainNext();
	}

	// TypeDef
	int index = compiler.GetObjectModule().meta.GetTypeDefs().GetIndex( namespaceScopes, name );
	if( index != -1 ){
		Type type = compiler.GetObjectModule().meta.GetTypeDefs()[index].GetBaseType();
		if( type.IsObject() ){
			return &type.GetClass();
		}
	}

	return NULL;
}
const CClass *Classes::Find( const string &fullName ) const
{
	char AreaName[VN_SIZE] = "";		//IuWFNgϐ
	char NestName[VN_SIZE] = "";		//qo
	bool isNest = SplitMemberName( fullName.c_str(), AreaName, NestName );

	return Find( NamespaceScopes( AreaName ), NestName );
}
void Classes::StartCompile( const UserProc *pUserProc ){
	const CClass *pParentClass = pUserProc->GetParentClassPtr();
	if( pParentClass ){
		pParentClass->Using();

		// z֐ɂȂ郁\bhɎgp`FbN
		BOOST_FOREACH( const CMethod *pMethod, pParentClass->GetDynamicMethods() )
		{
			if( pMethod->IsVirtual() )
			{
				pMethod->GetUserProc().Using();
			}
		}

		pCompilingMethod = pParentClass->GetDynamicMethodOrInterfaceMethod( pUserProc );
		if( !pCompilingMethod ){
			pCompilingMethod = pParentClass->GetStaticMethods().GetMethodPtr( pUserProc );
			if( !pCompilingMethod ){
				SmoothieException::Throw(300);
			}
		}
	}
	else{
		pCompilingMethod = NULL;
	}
}

const CClass *Classes::GetStringClassPtr() const
{
	if( !pStringClass ){
		// LbVĂ
		pStringClass = this->Find( NamespaceScopes( "System" ), "String" );

		if( !pStringClass )
		{
			SetError(400, "System.String", cp);
			static CClass dummy;
			return &dummy;
		}
		return pStringClass;
	}
	return pStringClass;
}
const CClass *Classes::GetObjectClassPtr() const
{
	if( !pObjectClass ){
		// LbVĂ
		pObjectClass = this->Find( NamespaceScopes( "System" ), "Object" );

		if( !pObjectClass )
		{
			SetError(400, "System.Object", cp);
			static CClass dummy;
			return &dummy;
		}
		return pObjectClass;
	}
	return pObjectClass;
}
const CClass *Classes::GetInterfaceInfoClassPtr() const
{
	if( !pInterfaceInfo ){
		// LbVĂ
		pInterfaceInfo = this->Find( "ActiveBasic.Core.InterfaceInfo" );

		if( !pInterfaceInfo )
		{
			SetError(400, "ActiveBasic.Core.InterfaceInfo", cp);
			static CClass dummy;
			return &dummy;
		}
		return pInterfaceInfo;
	}
	return pInterfaceInfo;
}
