#include "stdafx.h"

#include <jenga/include/smoothie/Smoothie.h>
#include <jenga/include/smoothie/SmoothieException.h>
#include <jenga/include/smoothie/LexicalAnalysis.h>

#include <Source.h>
#include <Class.h>
#include <Compiler.h>
#include <NamespaceSupporter.h>

#include "../common.h"
#ifdef _AMD64_
#include "../../BasicCompiler64/opcode.h"
#else
#include "../../BasicCompiler32/opcode.h"
#endif


class CLoopRefCheck{
	char **names;
	int num;
	void init(){
		int i;
		for(i=0;i<num;i++){
			free(names[i]);
		}
		free(names);
	}
public:
	CLoopRefCheck()
	{
		names=(char **)malloc(1);
		num=0;
	}
	~CLoopRefCheck()
	{
		init();
	}
	void add(const char *lpszInheritsClass)
	{
		names=(char **)realloc(names,(num+1)*sizeof(char *));
		names[num]=(char *)malloc(lstrlen(lpszInheritsClass)+1);
		lstrcpy(names[num],lpszInheritsClass);
		num++;
	}
	void del(const char *lpszInheritsClass)
	{
		int i;
		for(i=0;i<num;i++){
			if(lstrcmp(names[i],lpszInheritsClass)==0){
				free(names[i]);
				break;
			}
		}
		if(i!=num){
			num--;
			for(;i<num;i++){
				names[i]=names[i+1];
			}
		}
	}
	BOOL check(const CClass &inheritsClass) const
	{
		//[vp`FbN
		int i;
		for(i=0;i<num;i++){
			if( inheritsClass.GetName() == names[i] ){
				return 1;
			}
		}
		return 0;
	}
};
CLoopRefCheck *pobj_LoopRefCheck;


Interface::Interface( const CClass *pInterfaceClass )
	: DynamicMethodsPrototype()
	, pInterfaceClass( pInterfaceClass )
	, vtblOffset( -1 )
{
	//\bhRs[
	BOOST_FOREACH( const CMethod *pBaseMethod, pInterfaceClass->GetDynamicMethods() )
	{
		CMethod *pMethod = new DynamicMethod( *pBaseMethod );

		// ANZVreB
		if(pBaseMethod->GetAccessibility() == Prototype::Private){
			pMethod->SetAccessibility( Prototype::None );
		}
		else{
			pMethod->SetAccessibility( pBaseMethod->GetAccessibility() );
		}

		//pobj_Inherits
		// pClassIndexZbgiqplj
		if(pBaseMethod->GetInheritsClassPtr()==0){
			pMethod->SetInheritsClassPtr( pInterfaceClass );
		}
		else{
			pMethod->SetInheritsClassPtr( pBaseMethod->GetInheritsClassPtr() );
		}

		AddDynamicMethods( pMethod );
	}
}


bool CClass::IsClass() const
{
	return classType == CClass::Class;
}
bool CClass::IsInterface() const
{
	return classType == CClass::Interface;
}
bool CClass::IsComInterface() const
{
	return classType == CClass::ComInterface;
}
bool CClass::IsEnum() const
{
	return classType == CClass::Enum;
}
bool CClass::IsDelegate() const
{
	return classType == CClass::Delegate;
}
bool CClass::IsStructure() const
{
	return classType == CClass::Structure;
}


// RXgN^̃RpCJn
void CClass::NotifyStartConstructorCompile() const
{
	isCompilingConstructor = true;
}

//RXgN^̃RpCI
void CClass::NotifyFinishConstructorCompile() const
{
	isCompilingConstructor = false;
}

//RXgN^RpCǂ𔻕
bool CClass::IsCompilingConstructor() const
{
	return isCompilingConstructor;
}

//fXgN^̃RpCJn
void CClass::NotifyStartDestructorCompile() const{
	isCompilingDestructor = true;
}

//fXgN^̃RpCI
void CClass::NotifyFinishDestructorCompile() const{
	isCompilingDestructor = false;
}

//fXgN^RpCǂ𔻕
bool CClass::IsCompilingDestructor() const
{
	return isCompilingDestructor;
}

//g̔hNXǂmF
bool CClass::IsSubClass( const CClass *pClass ) const
{
	if( !pClass->HasSuperClass() )
	{
		return false;
	}

	const CClass *pTempClass = &pClass->GetSuperClass();
	while( pTempClass ){
		if( this == pTempClass ) return true;
		pTempClass = &pTempClass->GetSuperClass();
	}
	return false;
}

//gƓ܂͔hNXǂmF
bool CClass::IsEqualsOrSubClass( const CClass *pClass ) const
{
	if( IsEquals( pClass ) ) return true;
	return IsSubClass( pClass );
}

// gƓ܂͔hNXANXǂmF
bool CClass::IsEqualsOrSubClassOrSuperClass( const CClass &objClass ) const
{
	if( IsEquals( &objClass ) ) return true;
	if( IsSubClass( &objClass ) ) return true;
	if( objClass.IsSubClass( this ) ) return true;
	return false;
}

bool CClass::IsInheritsInterface( const CClass *pInterfaceClass ) const
{
	BOOST_FOREACH( const ::Interface *pInterface, interfaces ){
		if( pInterfaceClass == &pInterface->GetClass() ){
			return true;
		}
	}
	return false;
}

bool CClass::Inherits( const char *inheritNames, int nowLine ){
	int i = 0;
	bool isInheritsClass = false;
	while( true ){

		char temporary[VN_SIZE];
		for( int i2=0;; i++, i2++ ){
			if( inheritNames[i] == '\0' || inheritNames[i] == ',' ){
				temporary[i2] = 0;
				break;
			}
			temporary[i2] = inheritNames[i];
		}

		// WFlNX\𕪉
		char className[VN_SIZE];
		Jenga::Common::Strings typeParameterStrings;
		SplitGenericClassInstance( temporary, className, typeParameterStrings );

		// ^p[^񂩂^f[^擾
		std::vector<Type> actualTypeParameters;
		BOOST_FOREACH( const std::string &typeParameterStr, typeParameterStrings )
		{
			Type type;
			compiler.StringToType( typeParameterStr, type );
			actualTypeParameters.push_back( type );
		}

		//pNX擾
		const CClass *pInheritsClass = compiler.GetObjectModule().meta.GetClasses().Find(className);
		if( !pInheritsClass ){
			SmoothieException::Throw(106,className,nowLine);
			return false;
		}

		if( pInheritsClass->IsClass() ){
			// NXp
			isInheritsClass = true;

			if( !InheritsClass( *pInheritsClass, actualTypeParameters, nowLine ) ){
				return false;
			}
		}
		else{
			SetError(135,pInheritsClass->GetFullName().c_str(),nowLine);
			return false;
		}

		if( inheritNames[i] == '\0' ){
			break;
		}
		i++;
	}

	if( !isInheritsClass ){
		// NXpĂȂƂ
		if( !InheritsClass( *compiler.GetObjectModule().meta.GetClasses().GetObjectClassPtr(), Types(), nowLine ) ){
			return false;
		}
	}

	return true;
}
bool CClass::InheritsClass( const CClass &inheritsClass, const Types &actualTypeParameters, int nowLine ){

	//[vpłȂ`FbN
	if(pobj_LoopRefCheck->check(inheritsClass)){
		SmoothieException::Throw(123,inheritsClass.GetName(),nowLine);
		return false;
	}

	if( !inheritsClass.IsReady() ){
		//p悪ǂݎĂȂƂ
		pobj_LoopRefCheck->add(this->GetName().c_str());
		compiler.GetObjectModule().meta.GetClasses().GetClass_recur(inheritsClass.GetName().c_str());
		pobj_LoopRefCheck->del(this->GetName().c_str());
	}

	//oRs[
	BOOST_FOREACH( CMember *inheritsClassDynamicMember, inheritsClass.GetDynamicMembers() ){
		CMember *pMember = new CMember( *inheritsClassDynamicMember );

		// ANZVreB
		if( inheritsClassDynamicMember->IsPrivate() ){
			pMember->SetAccessibility( Prototype::None );
		}
		else{
			pMember->SetAccessibility( inheritsClassDynamicMember->GetAccessibility() );
		}

		// ô݁A^p[^i\bĥق͌Ăяoɉj
		if( pMember->GetType().IsTypeParameter() )
		{
			pMember->ResetType( actualTypeParameters[pMember->GetType().GetFormalTypeIndex()] );
		}

		dynamicMembers.push_back( pMember );
	}

	//\bhRs[
	BOOST_FOREACH( const CMethod *pBaseMethod, inheritsClass.GetDynamicMethods() ){
		CMethod *pMethod = new DynamicMethod( *pBaseMethod );

		// ANZVreB
		if(pBaseMethod->GetAccessibility() == Prototype::Private){
			pMethod->SetAccessibility( Prototype::None );
		}
		else{
			pMethod->SetAccessibility( pBaseMethod->GetAccessibility() );
		}

		//pobj_Inherits
		// pClassIndexZbgiqplj
		if(pBaseMethod->GetInheritsClassPtr()==0){
			pMethod->SetInheritsClassPtr( &inheritsClass );
		}
		else{
			pMethod->SetInheritsClassPtr( pBaseMethod->GetInheritsClassPtr() );
		}

		GetDynamicMethods().push_back( pMethod );
	}

	//z֐̐
	AddVtblNum( inheritsClass.GetVtblNum() );

	//p̃NXoƂĕێ
	SetSuperClass( &inheritsClass );
	SetSuperClassActualTypeParameters( actualTypeParameters );

	// C^[tFCXp
	BOOST_FOREACH( ::Interface *pInterface, inheritsClass.GetInterfaces() )
	{
		interfaces.push_back( new ::Interface( *pInterface ) );
	}

	if( this->IsInterface() && inheritsClass.IsComInterface() )
	{
		// COMC^[tFCXpꍇCOMC^[tFCXɂ
		this->SetClassType( CClass::ComInterface );
	}

	return true;
}

bool CClass::Implements( const CClass &interfaceClass, int nowLine )
{
	if( !interfaceClass.IsInterface() && !interfaceClass.IsComInterface() )
	{
		// C^[tFCXł͂ȂƂ
		SetError(138,interfaceClass.GetName().c_str(),nowLine );
		return false;
	}

	if( !interfaceClass.IsReady() ){
		// C^[tFCX͂̂Ƃ
		pobj_LoopRefCheck->add(this->GetName().c_str());
		compiler.GetObjectModule().meta.GetClasses().GetClass_recur(interfaceClass.GetName().c_str());
		pobj_LoopRefCheck->del(this->GetName().c_str());
	}

	::Interface *pDestInterface = new ::Interface( &interfaceClass );

	interfaces.push_back( pDestInterface );


	/////////////////////////////////////////////////////////////////
	// NX̃\bhC^[tFCX\bhĎ
	/////////////////////////////////////////////////////////////////
	BOOST_FOREACH( CMethod *pMethod, GetDynamicMethods() )
	{
		CMethod *pMethodForOverride = pDestInterface->GetDynamicMethods().FindForOverride( &pMethod->GetUserProc() );
		if( pMethodForOverride )
		{
			pMethodForOverride->Override( &pMethod->GetUserProc(), pMethod->GetAccessibility(), false );

			// ɂȂ郁\bh͌ĂяosɂĂiI[o[[h̉珜Oj
			pMethod->SetNotUseMark( true );
		}
	}


	/////////////////////////////////////////////////////////////////
	// LXg\bhǉiR[h͎邱Ɓj
	/////////////////////////////////////////////////////////////////
	if( interfaceClass.IsInterface() )
	{
		// Function Operator() As ITest

		char temporary[1024];
		sprintf(temporary,"%c%c%c%c()%c%c%s",
			1, ESC_FUNCTION,
			1, ESC_OPERATOR,
			1, ESC_AS,
			interfaceClass.GetName().c_str()
		);

		this->AddMethod(this,
			Prototype::Public,
			0,
			false,			// isConst
			false,			// isAbstract
			false,			// isVirtual
			false,			// isOverride
			true,			// isAutoGeneration
			temporary,
			-1
		);
	}


	return true;
}
bool CClass::Implements( const char *interfaceNames, int nowLine )
{
	Jenga::Common::Strings paramStrs;
	SplitParameter( interfaceNames, paramStrs );
	
	BOOST_FOREACH( const std::string &paramStr, paramStrs )
	{
		//pNX擾
		const CClass *pInterfaceClass = compiler.GetObjectModule().meta.GetClasses().Find( paramStr.c_str() );
		if( !pInterfaceClass ){
			SetError(106,paramStr.c_str(),nowLine);
			continue;
		}

		// C^[tFCXp
		Implements( *pInterfaceClass, nowLine );
	}

	return true;
}

CMember *CClass::CreateMember( Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine )
{
	extern int cp;

	//\
	char VarName[VN_SIZE];
	char initBuffer[VN_SIZE];
	char lpszConstructParameter[VN_SIZE];
	Subscripts subscripts;
	Type type;
	GetDimentionFormat(buffer,VarName,subscripts,type,initBuffer,lpszConstructParameter);

	//d`FbN
	if(this->DupliCheckAll(VarName)){
		SetError(15,VarName,cp);
	}

	CMember *pMember = new CMember( accessibility, VarName, type, isConst, subscripts, initBuffer, lpszConstructParameter );
	pMember->source_code_address = nowLine;
	return pMember;
}
void CClass::AddMember( Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine ){
	dynamicMembers.push_back(
		CreateMember( accessibility, isConst, isRef, buffer, nowLine )
	);
}
void CClass::AddStaticMember( Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine ){
	staticMembers.push_back(
		CreateMember( accessibility, isConst, isRef, buffer, nowLine )
	);
}

void CClass::AddMethod(CClass *pobj_c, Prototype::Accessibility accessibility, BOOL bStatic, bool isConst, bool isAbstract,
						 bool isVirtual, bool isOverride, bool isAutoGeneration, char *buffer, int nowLine){
	int i,i2;
	char temporary[VN_SIZE];

	i=2;
	for(i2=0;;i++,i2++){
		if(buffer[i]=='('||buffer[i]=='\0'){
			temporary[i2]=0;
			break;
		}
		temporary[i2]=buffer[i];
	}


	//֐nbV֓o^
	char interfaceName[VN_SIZE] = "";
	UserProc *pUserProc = compiler.GetObjectModule().meta.GetUserProcs().AddUserProc( NamespaceScopes(), NamespaceScopesCollection(), buffer,nowLine,isVirtual,pobj_c, (bStatic!=0), interfaceName );
	if(!pUserProc) return;

	if( isAutoGeneration )
	{
		// R[h
		pUserProc->ThisIsAutoGenerationProc();
	}


	////////////////////////////////////////////////////////////
	// RXgN^AfXgN^̏ꍇ̏
	////////////////////////////////////////////////////////////
	BOOL fConstructor=0,bDestructor=0;

	if(lstrcmp(temporary,pobj_c->GetName().c_str())==0){
		//RXgN^̏ꍇ

		//WRXgN^iȂj
		if(pUserProc->Params().size()==0) fConstructor=1;

		//IConstCq
		isConst = true;
	}
	else if(temporary[0]=='~'){
		//fXgN^̏ꍇ̖͂O`FbNs
		if(lstrcmp(temporary+1,pobj_c->GetName().c_str())!=0)
			SetError(117,NULL,nowLine);
		else
			bDestructor=1;
	}
	if(fConstructor||bDestructor){
		// RXgN^AfXgN^̃ANZVreB`FbN

		//IConstCq
		isConst = true;
	}

	if( fConstructor == 1 )
		pobj_c->SetConstructorMemberSubIndex( (int)pobj_c->GetDynamicMethods().size() );
	else if( bDestructor )
		pobj_c->SetDestructorMemberSubIndex( (int)pobj_c->GetDynamicMethods().size() );



	//////////////////
	// d`FbN
	//////////////////

	if(pobj_c->DupliCheckMember(temporary)){
		SetError(15,temporary,nowLine);
		return;
	}

	//\bh
	BOOST_FOREACH( const CMethod *pMethod, pobj_c->GetDynamicMethods() )
	{
		//NXƏdꍇ̓I[o[Chs
		if( pMethod->GetInheritsClassPtr() ) continue;

		if( pMethod->GetUserProc().IsEqualForOverride( pUserProc ) )
		{
			//֐Ap[^A߂lvƂ
			SetError(15,pUserProc->GetName().c_str(),nowLine);
			return;
		}
	}

	//z֐̏ꍇ
	if( isAbstract ) pUserProc->CompleteCompile();

	// \bh̃I[o[Ch
	CMethod *pMethodForOverride = pobj_c->GetDynamicMethods().FindForOverride( pUserProc );
	if( pMethodForOverride )
	{
		pMethodForOverride->Override( pUserProc, accessibility, isOverride );
		pUserProc->SetMethod( pMethodForOverride );
		return;
	}
	else
	{
		// C^[tFCX \bh̃I[o[Ch
		BOOST_FOREACH( ::Interface *pInterface, pobj_c->GetInterfaces() )
		{
			if( interfaceName[0] )
			{
				if( pInterface->GetClass().GetName() != interfaceName )
				{
					// w肳ꂽC^[tFCXƐȂƂ
					continue;
				}
			}

			CMethod *pMethodForOverride = pInterface->GetDynamicMethods().FindForOverride( pUserProc );
			if( pMethodForOverride )
			{
				pMethodForOverride->Override( pUserProc, accessibility, isOverride );
				pUserProc->SetMethod( pMethodForOverride );
				return;
			}
		}
	}

	if( interfaceName[0] )
	{
		SetError(139,interfaceName,nowLine);
	}

	if( isVirtual ){
		pobj_c->AddVtblNum( 1 );
	}

	if( isOverride ){
		SetError(12,"Override",nowLine);
	}

	if(bStatic){
		pobj_c->GetStaticMethods().AddStatic( pUserProc, accessibility );
	}
	else{
		pobj_c->GetDynamicMethods().Add(pUserProc, accessibility, isConst, isAbstract, isVirtual);
	}
}

bool CClass::DupliCheckAll(const char *name){
	//d`FbN

	//o
	if(DupliCheckMember(name)) return 1;

	//\bh
	BOOST_FOREACH( const CMethod *pMethod, GetDynamicMethods() ){
		if( lstrcmp( name, pMethod->GetUserProc().GetName().c_str() ) == 0 ){
			return 1;
		}
	}

	return 0;
}
bool CClass::DupliCheckMember(const char *name){
	//d`FbN

	// Io
	BOOST_FOREACH( CMember *pMember, dynamicMembers ){
		if( GetName() == pMember->GetName() ){
			return 1;
		}
	}

	// ÓIo
	BOOST_FOREACH( CMember *pMember, staticMembers ){
		if( GetName() == pMember->GetName() ){
			return 1;
		}
	}

	return 0;
}

void CClass::EnumDynamicMethodsOrInterfaceMethods( const char *methodName, std::vector<const UserProc *> &subs ) const
{
	// I\bh
	GetDynamicMethods().Enum( methodName, subs );

	// C^[tFCX \bh
	BOOST_FOREACH( ::Interface *pInterface, GetInterfaces() )
	{
		pInterface->GetDynamicMethods().Enum( methodName, subs );
	}
}
const CMethod *CClass::GetDynamicMethodOrInterfaceMethod( const UserProc *pUserProc ) const
{
	// I\bh
	const CMethod *result = GetDynamicMethods().GetMethodPtr( pUserProc );

	if( !result )
	{
		// C^[tFCX \bh
		BOOST_FOREACH( ::Interface *pInterface, GetInterfaces() )
		{
			result = pInterface->GetDynamicMethods().GetMethodPtr( pUserProc );
			if( result )
			{
				return result;
			}
		}
	}

	return result;
}

const ::Delegate &CClass::GetDelegate() const
{
	const ::Delegate *dg = compiler.GetObjectModule().meta.GetDelegates().GetHashArrayElement( GetName().c_str() );
	while( dg )
	{
		if( dg->IsEqualSymbol( GetNamespaceScopes(), GetName() ) ){
			//OԂƃNXv
			return *dg;
		}
		dg = dg->GetChainNext();
	}

	Jenga::Throw( "CClass::GetDelegate\bhɎs" );
	static ::Delegate dummy;
	return dummy;
}

//TCY擾
int CClass::GetSize() const
{
	return GetMemberOffset( NULL, NULL );
}

//õItZbg擾
int CClass::GetMemberOffset( const char *memberName, int *pMemberNum ) const
{
	int i2;

	//z֐݂ꍇvtblyvtblMasterListւ̃|C^̃TCYǉ
	int offset = IsExistVirtualFunctions() ? PTR_SIZE*2 : 0;

	int alignment = 1;
	if( GetFixedAlignment() )
	{
		alignment = GetFixedAlignment();
	}

	int iMaxAlign=0;
	int i = -1;
	BOOST_FOREACH( CMember *pMember, dynamicMembers ){
		i++;

		i2 = pMember->GetType().GetSize();

		//ACgZo
		int member_size;
		if( pMember->GetType().IsStruct() ){
			//oNX̃ACg擾
			member_size=pMember->GetType().GetClass().GetAlignment();
		}
		else{
			//oTCY擾
			member_size=i2;
		}
		if(iMaxAlign<member_size) iMaxAlign=member_size;

		//ACgl
		if(GetFixedAlignment()&&GetFixedAlignment()<member_size){
			if(offset%alignment) offset+=alignment-(offset%alignment);
		}
		else{
			if(alignment<member_size) alignment=member_size;

			if(member_size==0){
				//oȂNX
				//ȂiItZbǧvZȂj
			}
			else{
				if(offset%member_size) offset+=member_size-(offset%member_size);
			}
		}

		if(memberName){
			//ow肪ꍇ́AItZbgԂ
			if( pMember->GetName() == memberName ){
				if(pMemberNum) *pMemberNum=i;
				return offset;
			}
		}

		//zloTCY擾
		member_size = i2 * Variable::GetSubScriptCounts( pMember->GetSubscripts() );

		//oTCYZ
		offset+= member_size;
	}

	if(iMaxAlign<alignment) alignment=iMaxAlign;

	//ACgl
	if(alignment){
		if(offset%alignment) offset+=alignment-(offset%alignment);
	}

	if(pMemberNum) *pMemberNum=i;
	return offset;
}
int CClass::GetAlignment() const
{
	//z֐݂ꍇ͊֐Xgւ̃|C^̃TCYǉ
	int alignment = IsExistVirtualFunctions() ? PTR_SIZE : 0;

	BOOST_FOREACH( CMember *pMember, dynamicMembers ){
		int member_size;
		if(pMember->GetType().IsStruct()){
			//oNX̃ACg擾
			member_size=pMember->GetType().GetClass().GetAlignment();
		}
		else{
			//oTCY擾
			member_size = pMember->GetType().GetSize();
		}

		//ACgZbg
		if(alignment<member_size) alignment=member_size;
	}

	if(alignment==0) return 0;

	if(GetFixedAlignment()) alignment=GetFixedAlignment();

	return alignment;
}

void CClass::GetVtblMasterListIndexAndVtblIndex( const UserProc *pUserProc, int &vtblMasterListIndex, int &vtblIndex ) const
{
	vtblMasterListIndex = 0;

	vtblIndex = 0;
	BOOST_FOREACH( const CMethod *pMethod, GetDynamicMethods() ){
		if( &pMethod->GetUserProc() == pUserProc )
		{
			return;
		}

		if( pMethod->IsVirtual() )
		{
			vtblIndex++;
		}
	}

	BOOST_FOREACH( const ::Interface *pInterface, interfaces )
	{
		vtblMasterListIndex++;

		vtblIndex = 0;
		BOOST_FOREACH( const CMethod *pMethod, pInterface->GetDynamicMethods() ){
			if( &pMethod->GetUserProc() == pUserProc )
			{
				return;
			}

			if( pMethod->IsVirtual() )
			{
				vtblIndex++;
			}
		}
	}

	SetError();
	return;
}
int CClass::GetVtblMasterListIndex( const CClass *pClass ) const
{
	int result = 0;

	BOOST_FOREACH( const ::Interface *pInterface, interfaces )
	{
		result++;
		
		if( &pInterface->GetClass() == pClass )
		{
			return result;
		}
	}

	SetError();
	return 0;
}
long CClass::GetComVtblOffset() const
{
	return comVtblOffset;
}
long CClass::GetVtblMasterListOffset() const
{
	//ɑ݂ꍇ͂Ԃ
	if( vtblMasterListOffset == -1 )
	{
		SetError();
	}

	return vtblMasterListOffset;
}
void CClass::GenerateVTableMasterList( const std::vector<long> &vtableMasterList, long &offset )
{
	offset = compiler.GetObjectModule().dataTable.AddBinary(
		(void *)&vtableMasterList[0],
		static_cast<int>(vtableMasterList.size()*sizeof(LONG_PTR))
	);
}
void CClass::GenerateFullVTables()
{
	if( IsAbstract() )
	{
		// ۃNX͖
		return;
	}
	if( !IsUsing() )
	{
		// gĂȂNX͖
		return;
	}

	// vtbl}X^[Xǧf[^ɕsvȃf[^܂܂ĂG[
	if( vtblMasterList.size() )
	{
		SetError();
	}

	// g̃NXvtbl𐶐
	GetDynamicMethods().GenerateVTablePart( this->vtbl_offset );
	vtblMasterList.push_back( this->vtbl_offset );

	// C^[tFCXvtbl𐶐
	BOOST_FOREACH( const ::Interface *pInterface, interfaces )
	{
		long tempVtblOffset;
		pInterface->GetDynamicMethods().GenerateVTablePart( tempVtblOffset );
		vtblMasterList.push_back( tempVtblOffset );

		pInterface->SetVtblOffset( tempVtblOffset );

		if( pInterface->GetClass().IsComInterface() )
		{
			if( this->comVtblOffset )
			{
				SetError();
			}
			this->comVtblOffset = tempVtblOffset;
		}
	}

	// vtbl}X^[Xg𐶐
	GenerateVTableMasterList( vtblMasterList, this->vtblMasterListOffset );
}
void CClass::ActionVtblSchedule( LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection, LONG_PTR MemPos_DataSection )
{
	if( IsAbstract() )
	{
		// ۃNX͖
		return;
	}
	if( !IsUsing() )
	{
		// gĂȂNX͖
		return;
	}
	if(vtbl_offset==-1) return;

	// g̃NXvtbl
	{
		LONG_PTR *pVtbl = (LONG_PTR *)((char *)compiler.GetObjectModule().dataTable.GetPtr() + vtbl_offset);

		for( int i=0; i<GetVtblNum(); i++ ){
			const UserProc *pUserProc = (UserProc *)pVtbl[i];
			if(!pUserProc) continue;

			if( pUserProc->GetBeginOpAddress() == 0
				&& pUserProc->GetEndOpAddress() == 0 )
			{
				Jenga::Throw( "̉z֐݂" );
			}

			pVtbl[i] = pUserProc->GetBeginOpAddress() + ImageBase + MemPos_CodeSection;
		}
	}

	// C^[tFCXvtbl
	BOOST_FOREACH( const ::Interface *pInterface, interfaces )
	{
		LONG_PTR *pVtbl = (LONG_PTR *)((char *)compiler.GetObjectModule().dataTable.GetPtr() + pInterface->GetVtblOffset());

		for( int i=0; i<pInterface->GetClass().GetVtblNum(); i++ ){
			const UserProc *pUserProc = (UserProc *)pVtbl[i];
			if(!pUserProc) continue;

			if( pUserProc->GetBeginOpAddress() == 0
				&& pUserProc->GetEndOpAddress() == 0 )
			{
				Jenga::Throw( "̉z֐݂" );
			}

			pVtbl[i] = pUserProc->GetBeginOpAddress() + ImageBase + MemPos_CodeSection;
		}
	}

	// vtbl}X^[Xg
	LONG_PTR *pVtblMasterList = (LONG_PTR *)((char *)compiler.GetObjectModule().dataTable.GetPtr() + vtblMasterListOffset );
	for( int i=0; i<static_cast<int>(vtblMasterList.size()); i++ )
	{
		pVtblMasterList[i] = vtblMasterList[i] + ImageBase + MemPos_DataSection;
	}
}
bool CClass::IsAbstract() const
{
	// (abstract)̉z֐ꍇtrueԂ

	BOOST_FOREACH( const CMethod *pMethod, GetDynamicMethods() ){
		if(pMethod->IsVirtual()){
			if(pMethod->IsAbstract()){
				return true;
			}
		}
	}

	// C^[tFCXvtbl
	BOOST_FOREACH( const ::Interface *pInterface, interfaces )
	{
		BOOST_FOREACH( const CMethod *pMethod, pInterface->GetDynamicMethods() ){
			if(pMethod->IsVirtual()){
				if(pMethod->IsAbstract()){
					return true;
				}
			}
		}
	}

	return false;
}

CClass *Classes::Create( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const char *name){
	return new CClass(namespaceScopes, importedNamespaces, name);
}
bool Classes::Insert( CClass *pClass, int nowLine )
{
	/////////////////////////////////
	// nbVf[^ɒǉ
	/////////////////////////////////

	if( !Put( pClass ) )
	{
		SetError(15,pClass->GetName(), nowLine);
		return false;
	}
	return true;
}
CClass *Classes::Add( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const char *name,int nowLine){
	//////////////////////////////////////////////////////////////////////////
	// NXǉ
	// Ô݂o^B̑̏SetClass\bhŁI
	//////////////////////////////////////////////////////////////////////////

	CClass *pClass = Create(namespaceScopes, importedNamespaces, name);

	if( !Insert( pClass, nowLine ) )
	{
		return NULL;
	}

	return pClass;	
}

void Classes::CollectClassesForNameOnly( const BasicSource &source )
{
	int i, i2;
	char temporary[VN_SIZE];

	// OԊǗ
	NamespaceScopes &namespaceScopes = compiler.GetNamespaceSupporter().GetLivingNamespaceScopes();
	namespaceScopes.clear();

	// ImportsꂽOԂ̊Ǘ
	NamespaceScopesCollection &importedNamespaces = compiler.GetNamespaceSupporter().GetImportedNamespaces();
	importedNamespaces.clear();

	for(i=0;;i++){
		if(source[i]=='\0') break;

		if( source[i] == 1 && source[i+1] == ESC_NAMESPACE ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			namespaceScopes.push_back( temporary );

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				SmoothieException::Throw(12, "End Namespace", i );
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_IMPORTS ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			if( !compiler.GetNamespaceSupporter().ImportsNamespace( temporary ) )
			{
				SmoothieException::Throw(64,temporary,i );
			}

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_CLEARNAMESPACEIMPORTED ){
			importedNamespaces.clear();
			continue;
		}

		if(source[i]==1&&(
			source[i+1]==ESC_CLASS||
			source[i+1]==ESC_TYPE||
			source[i+1]==ESC_INTERFACE
			))
		{
			int nowLine = i;
			i += 2;

			Type blittableType;
			if(memicmp(source.GetBuffer()+i,"Align(",6)==0){
				//ACgCq
				i+=6;
				i=JumpStringInPare(source.GetBuffer(),i)+1;
			}
			else if( memicmp( source.GetBuffer() + i, "Blittable(", 10 ) == 0 ){
				// BlittableCq
				i+=10;
				i+=GetStringInPare_RemovePare(temporary,source.GetBuffer()+i)+1;
				compiler.StringToType( temporary, blittableType );
			}

			bool isEnum = false;
			bool isDelegate = false;
			if( source[i] == 1 && source[i+1] == ESC_ENUM ){
				// 񋓌^̏ꍇ
				isEnum = true;

				i += 2;
			}
			else if( source[i] == 1 && source[i+1] == ESC_DELEGATE )
			{
				// fQ[g̏ꍇ
				isDelegate = true;

				i += 2;
			}

			for(i2=0;;i++,i2++){
				if(!IsVariableChar(source[i])){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}

			//NXǉ
			CClass *pClass = this->Add(namespaceScopes, importedNamespaces, temporary,nowLine);
			if( pClass ){
				if( source[nowLine+1] == ESC_CLASS ){
					if( isEnum )
					{
						pClass->SetClassType( CClass::Enum );
					}
					else if( isDelegate )
					{
						pClass->SetClassType( CClass::Delegate );
					}
					else{
						pClass->SetClassType( CClass::Class );
					}
				}
				else if( source[nowLine+1] == ESC_INTERFACE ){
					pClass->SetClassType( CClass::Interface );
				}
				else{
					pClass->SetClassType( CClass::Structure );
				}
			}

			// Blittable^̏ꍇ
			if( !blittableType.IsNull() ){
				pClass->SetBlittableType( blittableType );

				// Blittable^Ƃēo^
				compiler.GetObjectModule().meta.GetBlittableTypes().push_back( BlittableType( blittableType, pClass ) );
			}
		}
	}
}

void Classes::GenerateVTables()
{
	Iterator_Reset();
	while( Iterator_HasNext() )
	{
		CClass *pClass = Iterator_GetNext();
		pClass->GenerateFullVTables();
	}
}

void Classes::ActionVtblSchedule( LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection, LONG_PTR MemPos_DataSection ){
	Iterator_Reset();
	while( Iterator_HasNext() )
	{
		CClass *pClass = Iterator_GetNext();
		pClass->ActionVtblSchedule( ImageBase, MemPos_CodeSection, MemPos_DataSection);
	}
}


void Classes::InitStaticMember(){
	//ÓIoO[öɍ쐬

	//Ce[^Zbg

	extern int cp;
	int back_cp=cp;

	this->Iterator_Reset();
	while(this->Iterator_HasNext()){
		CClass &objClass = *this->Iterator_GetNext();
		if( objClass.isTargetObjectModule == false )
		{
			// ÓINCȕꍇ͔΂iɃCX^X`ς݂ł邽߁j
			continue;
		}

		// OԂZbg
		compiler.GetNamespaceSupporter().GetLivingNamespaceScopes() = objClass.GetNamespaceScopes();

		DWORD dwFlags = 0;
		if( objClass.GetName() == "_System_TypeBase" )
		{
			// _System_TypeBaseNX̓O[oAX^eBbN̈邽߂̃NXȂ̂łł̏͏O
			dwFlags |= DIMFLAG_NONCALL_CONSTRACTOR;
		}

		int i=0;
		BOOST_FOREACH( CMember *member, objClass.GetStaticMembers() ){
			char temporary[VN_SIZE];
			sprintf(temporary,"%s.%s",objClass.GetName().c_str(),member->GetName().c_str());
			dim(
				temporary,
				member->GetSubscripts(),
				member->GetType(),
				member->GetInitializeExpression().c_str(),
				member->GetConstructParameter().c_str(),
				dwFlags);

			i++;
		}
	}

	compiler.GetNamespaceSupporter().GetLivingNamespaceScopes().clear();

	cp=back_cp;
}
bool Classes::MemberVar_LoopRefCheck(const CClass &objClass){
	bool result = true;
	BOOST_FOREACH( CMember *pMember, objClass.GetDynamicMembers() ){
		if(pMember->GetType().IsStruct()){
			//zQƂłȂ`FbN
			if(pobj_LoopRefCheck->check(pMember->GetType().GetClass())){
				extern int cp;
				SetError(124,pMember->GetType().GetClass().GetName(),cp);
				return false;
			}

			pobj_LoopRefCheck->add(objClass.GetName().c_str());

			bool tempResult = MemberVar_LoopRefCheck(pMember->GetType().GetClass());
			if( result )
			{
				result = tempResult;
			}

			pobj_LoopRefCheck->del(objClass.GetName().c_str());
		}
	}

	return result;
}
void Classes::GetClass_recur(const char *lpszInheritsClass){
	extern char *basbuf;
	int i,i2,i3,sub_address,top_pos;
	char temporary[8192];

	// OԊǗ
	NamespaceScopes backupNamespaceScopes = compiler.GetNamespaceSupporter().GetLivingNamespaceScopes();
	NamespaceScopes &namespaceScopes = compiler.GetNamespaceSupporter().GetLivingNamespaceScopes();
	namespaceScopes.clear();

	// ImportsꂽOԂ̊Ǘ
	NamespaceScopesCollection backupImportedNamespaces = compiler.GetNamespaceSupporter().GetImportedNamespaces();
	compiler.GetNamespaceSupporter().GetImportedNamespaces().clear();

	// ĂяoŃRpC̃NX|C^obNAbv
	const CClass *pBackCompilingClass = compiler.pCompilingClass;

	for(i=0;;i++){
		if(basbuf[i]=='\0') break;


		// O
		if( basbuf[i] == 1 && basbuf[i+1] == ESC_NAMESPACE ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( basbuf[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=basbuf[i];
			}
			namespaceScopes.push_back( temporary );

			continue;
		}
		else if( basbuf[i] == 1 && basbuf[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				SetError(12, "End Namespace", i );
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}

		else if( basbuf[i] == 1 && basbuf[i+1] == ESC_IMPORTS ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( basbuf[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=basbuf[i];
			}
			if( !compiler.GetNamespaceSupporter().ImportsNamespace( temporary ) )
			{
				SmoothieException::Throw(64,temporary,i );
			}

			continue;
		}
		else if( basbuf[i] == 1 && basbuf[i+1] == ESC_CLEARNAMESPACEIMPORTED ){
			compiler.GetNamespaceSupporter().GetImportedNamespaces().clear();
			continue;
		}



		if(basbuf[i]==1&&basbuf[i+1]==ESC_INTERFACE){
			//////////////////////////
			// C^[tFCX
			//////////////////////////

			top_pos=i;

			i+=2;

			//C^[tFCX擾
			GetIdentifierToken( temporary, basbuf, i );

			CClass *pobj_c = const_cast<CClass *>( this->Find(namespaceScopes, temporary) );
			if(!pobj_c) continue;

			if(lpszInheritsClass){
				if(lstrcmp(lpszInheritsClass,pobj_c->GetName().c_str())!=0){
					//pǂݗp
					continue;
				}
			}

			if(pobj_c->IsReady()){
				//ɐǂ݂ĂƂ
				continue;
			}

			pobj_c->Readed();

			pobj_c->SetConstructorMemberSubIndex( -1 );
			pobj_c->SetDestructorMemberSubIndex( -1 );

			if( memcmp( basbuf+i+1, "__COM", 5 ) == 0 && IsCommandDelimitation( basbuf[i+1+5] ) )
			{
				// COMC^[tFCX
				pobj_c->SetClassType( CClass::ComInterface );

				i += 6;
			}

			if(basbuf[i+1]==1&&basbuf[i+2]==ESC_INHERITS){
				//psꍇ
				for(i+=3,i2=0;;i++,i2++){
					if(IsCommandDelimitation(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
				}

				if(lstrcmpi(temporary,pobj_c->GetName().c_str())==0){
					SetError(105,temporary,i);
					goto Interface_InheritsError;
				}

				//pNX擾
				const Classes &classes = *this;
				const CClass *pInheritsClass = classes.Find(temporary);
				if( !pInheritsClass ){
					SetError(106,temporary,i);
					goto Interface_InheritsError;
				}

				//p
				if( !pobj_c->InheritsClass( *pInheritsClass, Types(), i ) ){
					goto Interface_InheritsError;
				}
			}
			else{
				//p
				if( &pobj_c->GetSuperClass() || pobj_c->GetVtblNum() )
				{
					// TODO: ɗȂƂ؂ł炱̕͏
					Jenga::Throw( "GetClass_recur̗O" );
				}
			}
Interface_InheritsError:

			//oϐA֐擾
			while(1){
				i++;

				//G[
				if(basbuf[i]==1&&(basbuf[i+1]==ESC_CLASS||basbuf[i+1]==ESC_TYPE||basbuf[i+1]==ESC_INTERFACE)){
					SetError(22,"Interface",i);
					i--;
					break;
				}

				if(basbuf[i]==1&&basbuf[i+1]==ESC_INHERITS){
					SetError(111,NULL,i);
					break;
				}
				else if( basbuf[i] == 1 && basbuf[i+1] == ESC_IMPLEMENTS )
				{
					SetError(137, NULL, i );
					break;
				}

				sub_address=i;

				for(i2=0;;i++,i2++){
					if(IsCommandDelimitation(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
				}
				if(temporary[0]=='\0'){
					if(basbuf[i]=='\0'){
						i--;
						SetError(22,"Interface",top_pos);
						break;
					}
					continue;
				}

				//End InterfaceLq̏ꍇ
				if(temporary[0]==1&&temporary[1]==ESC_ENDINTERFACE) break;

				if(!(temporary[0]==1&&(
					temporary[1]==ESC_SUB||temporary[1]==ESC_FUNCTION
					))){
					SetError(1,NULL,i);
					break;
				}

				//o֐ǉ
				pobj_c->AddMethod(pobj_c,
					Prototype::Public,	//PublicANZX
					0,					// bStatic
					false,				// isConst
					true,				// isAbstract
					true,				// isVirtual
					false,				// isOverride
					false,				// isAutoGeneration
					temporary,
					sub_address
					);
			}
		}

		if(basbuf[i]==1&&(basbuf[i+1]==ESC_CLASS||basbuf[i+1]==ESC_TYPE)){
			//////////////////////////
			// NX
			//////////////////////////

			top_pos=i;

			const DWORD dwClassType=basbuf[i+1];

			i+=2;

			int iAlign=0;
			if(memicmp(basbuf+i,"Align(",6)==0){
				//ACgCq
				i+=6;
				i+=GetStringInPare_RemovePare(temporary,basbuf+i)+1;
				iAlign=atoi(temporary);

				if(!(iAlign==1||iAlign==2||iAlign==4||iAlign==8||iAlign==16))
					SetError(51,NULL,i);
			}
			else if( memicmp( basbuf + i, "Blittable(", 10 ) == 0 ){
				// BlittableCq
				i+=10;
				i=JumpStringInPare(basbuf,i)+1;
			}

			if( basbuf[i] == 1 && basbuf[i+1] == ESC_ENUM )
			{
				// 񋓌^̏ꍇ
				i += 2;
			}
			else if( basbuf[i] == 1 && basbuf[i+1] == ESC_DELEGATE )
			{
				// fQ[g̏ꍇ
				i += 2;
			}

			//NX擾
			GetCommandToken( temporary, basbuf, i );

			char className[VN_SIZE];
			Jenga::Common::Strings typeParameters;
			SplitGenericClassInstance( temporary, className, typeParameters );

			CClass *pobj_c =  const_cast<CClass *>( this->Find(namespaceScopes, className) );
			if(!pobj_c) continue;

			compiler.pCompilingClass = pobj_c;

			if(lpszInheritsClass){
				if( pobj_c->GetName() != lpszInheritsClass ){
					//pǂݗp
					continue;
				}
			}

			if(pobj_c->IsReady()){
				//ɐǂ݂ĂƂ
				continue;
			}


			/////////////////////////////////////////////////////////
			//  WFlNXT|[g 
			BOOST_FOREACH( const std::string &typeParameter, typeParameters )
			{
				pobj_c->AddFormalGenericType( GenericType( typeParameter, Type(DEF_OBJECT,*GetObjectClassPtr()) ) );
			}
			/////////////////////////////////////////////////////////


			pobj_c->SetFixedAlignment( iAlign );

			pobj_c->Readed();

			pobj_c->SetConstructorMemberSubIndex( -1 );
			pobj_c->SetDestructorMemberSubIndex( -1 );

			//ANZX̏lZbg
			Prototype::Accessibility accessibility;
			if(dwClassType==ESC_CLASS){
				accessibility = Prototype::Private;
			}
			else{
				accessibility = Prototype::Public;
			}

			if( pobj_c->GetName() == "Object"
				|| dwClassType == ESC_TYPE )
			{
				// pȂ

				if( &pobj_c->GetSuperClass() || pobj_c->GetVtblNum() )
				{
					// TODO: ɗȂƂ؂ł炱̕͏
					Jenga::Throw( "GetClass_recur̗O" );
				}
			}
			else{
				if(basbuf[i+1]==1&&basbuf[i+2]==ESC_INHERITS)
				{
					// NXp悪w肳ĂƂ
					i += 3;
					GetCommandToken( temporary, basbuf, i );

					if(lstrcmpi(temporary,pobj_c->GetName().c_str())==0){
						SetError(105,temporary,i);
						goto InheritsError;
					}
				}
				else
				{
					// ̎wȂƂObjectNXp
					lstrcpy( temporary, "Object" );
				}
				pobj_c->Inherits( temporary, i );

				if( basbuf[i+1] == 1 && basbuf[i+2] == ESC_IMPLEMENTS )
				{
					// C^[tFCXsꍇ
					i += 3;
					GetCommandToken( temporary, basbuf, i );

					pobj_c->Implements( temporary, i );
				}
			}
InheritsError:

			//oƃ\bh擾
			while(1){
				i++;

				//G[
				if(basbuf[i]==1&&(basbuf[i+1]==ESC_CLASS||basbuf[i+1]==ESC_TYPE)){
					SetError(22,"Class",i);
					i--;
					break;
				}

				if(basbuf[i]==1&&basbuf[i+1]==ESC_INHERITS){
					SetError(111,NULL,i);
					break;
				}
				else if( basbuf[i] == 1 && basbuf[i+1] == ESC_IMPLEMENTS )
				{
					SetError(137, NULL, i );
					break;
				}

				//StaticCq
				BOOL bStatic;
				if(basbuf[i]==1&&basbuf[i+1]==ESC_STATIC){
					bStatic=1;
					i+=2;
				}
				else bStatic=0;

				//ConstCq
				bool isConst = false;
				if( basbuf[i] == 1 && basbuf[i + 1] == ESC_CONST ){
					isConst = true;
					i += 2;
				}

				if(basbuf[i]==1&&(
					basbuf[i+1]==ESC_ABSTRACT||basbuf[i+1]==ESC_VIRTUAL||basbuf[i+1]==ESC_OVERRIDE||
					basbuf[i+1]==ESC_SUB||basbuf[i+1]==ESC_FUNCTION
					)){
					i3=basbuf[i+1];
					sub_address=i;
				}
				else i3=0;

				bool isVirtual = false, isAbstract = false, isOverride = false;
				if(i3==ESC_ABSTRACT){
					isAbstract=1;
					isVirtual=1;
					i+=2;

					i3=basbuf[i+1];
				}
				else if(i3==ESC_VIRTUAL){
					isAbstract=0;
					isVirtual=1;
					i+=2;

					i3=basbuf[i+1];
				}
				else if(i3==ESC_OVERRIDE){
					isOverride=1;
					isVirtual=1;

					i+=2;

					i3=basbuf[i+1];
				}

				for(i2=0;;i++,i2++){
					if(IsCommandDelimitation(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
				}
				if(temporary[0]=='\0'){
					if(basbuf[i]=='\0'){

						if(dwClassType==ESC_CLASS)
							SetError(22,"Class",top_pos);
						else
							SetError(22,"Type",top_pos);

						i--;
						break;
					}
					continue;
				}

				//End ClassLq̏ꍇ
				if(temporary[0]==1&&temporary[1]==ESC_ENDCLASS&&dwClassType==ESC_CLASS) break;
				if(temporary[0]==1&&temporary[1]==ESC_ENDTYPE&&dwClassType==ESC_TYPE) break;

				//ANZXύX
				if(lstrcmpi(temporary,"Private")==0){
					accessibility = Prototype::Private;
					continue;
				}
				if(lstrcmpi(temporary,"Public")==0){
					accessibility = Prototype::Public;
					continue;
				}
				if(lstrcmpi(temporary,"Protected")==0){
					accessibility = Prototype::Protected;
					continue;
				}

				extern int cp;
				if(i3==0){
					if(bStatic){
						//ÓIoǉ
						cp=i;	//G[p
						pobj_c->AddStaticMember( accessibility, isConst, false, temporary, i);
					}
					else{
						//oǉ
						cp=i;	//G[p
						pobj_c->AddMember( accessibility, isConst, false, temporary, i );


						if(pobj_c->GetDynamicMembers()[pobj_c->GetDynamicMembers().size()-1]->GetType().IsStruct()){
							if( !pobj_c->GetDynamicMembers()[pobj_c->GetDynamicMembers().size()-1]->GetType().GetClass().IsReady() ){
								//QƐ悪ǂݎĂȂƂ
								GetClass_recur(pobj_c->GetDynamicMembers()[pobj_c->GetDynamicMembers().size()-1]->GetType().GetClass().GetName().c_str());
							}
						}


						if(pobj_c->GetDynamicMembers()[pobj_c->GetDynamicMembers().size()-1]->GetType().IsStruct()){
							//zQƂ̃`FbN
							pobj_LoopRefCheck->add(pobj_c->GetName().c_str());
							if(!MemberVar_LoopRefCheck(pobj_c->GetDynamicMembers()[pobj_c->GetDynamicMembers().size()-1]->GetType().GetClass())){
								//G[
								Type &type = const_cast<Type &>(pobj_c->GetDynamicMembers().back()->GetType());
								type.SetBasicType( DEF_PTR_VOID );
							}
							pobj_LoopRefCheck->del(pobj_c->GetName().c_str());
						}
					}
				}
				else{
					//\bhǉ
					cp=i;	//G[p
					pobj_c->AddMethod(pobj_c,
						accessibility,
						bStatic,
						isConst,
						isAbstract,
						isVirtual,
						isOverride,
						false,
						temporary,
						sub_address);

					if( isAbstract ) continue;

					for(;;i++){
						if(basbuf[i]=='\0'){
							i--;
							break;
						}
						if(basbuf[i-1]!='*'&&
							basbuf[i]==1&&(
							basbuf[i+1]==ESC_SUB||
							basbuf[i+1]==ESC_FUNCTION||
							basbuf[i+1]==ESC_MACRO||
							basbuf[i+1]==ESC_TYPE||
							basbuf[i+1]==ESC_CLASS||
							basbuf[i+1]==ESC_INTERFACE||
							basbuf[i+1]==ESC_ENUM)){
							GetDefaultNameFromES(i3,temporary);
							SetError(22,temporary,i);
						}
						if(basbuf[i]==1&&basbuf[i+1]==GetEndXXXCommand((char)i3)){
							i+=2;
							break;
						}
					}
				}
			}
		}
	}

	// ĂяoŃRpC̃NX|C^ɖ߂
	compiler.pCompilingClass = pBackCompilingClass;

	// OԂɖ߂
	compiler.GetNamespaceSupporter().GetLivingNamespaceScopes() = backupNamespaceScopes;

	// C|[gꂽOԂɖ߂
	compiler.GetNamespaceSupporter().GetImportedNamespaces() = backupImportedNamespaces;
}
void Classes::GetAllClassInfo(void){
	//[vp`FbNp̃NX
	pobj_LoopRefCheck=new CLoopRefCheck();

	//NX擾
	GetClass_recur(0);

	delete pobj_LoopRefCheck;
	pobj_LoopRefCheck=0;

	// Ce[^̏
	this->Iterator_Init();
}
void Classes::Compile_System_InitializeUserTypes(){
	char temporary[VN_SIZE];

	////////////////////////////////////////////////////////////////////
	// NXo^
	////////////////////////////////////////////////////////////////////

	// Ce[^Zbg
	Iterator_Reset();

	while( Iterator_HasNext() ){
		const CClass &objClass = *Iterator_GetNext();

		if( !objClass.IsUsing() ){
			// gp̃NX͖
			continue;
		}	

		char referenceOffsetsBuffer[1024] = "";
		int numOfReference = 0;
		BOOST_FOREACH( CMember *pMember, objClass.GetDynamicMembers() ){
			if( pMember->GetType().IsObject() || pMember->GetType().IsPointer() ){
				if( referenceOffsetsBuffer[0] ){
					lstrcat( referenceOffsetsBuffer, "," );
				}

				sprintf( referenceOffsetsBuffer + lstrlen( referenceOffsetsBuffer ),
					"%d",
					objClass.GetMemberOffset( pMember->GetName().c_str() ) );

				numOfReference++;
			}
		}

		sprintf( temporary
			, "Add(%c%c_System_TypeForClass[strNamespace=\"%s\",name=\"%s\",fullName=\"%s\",referenceOffsets=[%s],numOfReference=%d])"
			, 1
			, ESC_SYSTEM_STATIC_NEW
			, objClass.GetNamespaceScopes().ToString().c_str()		// O
			, objClass.GetName().c_str()							// NX
			, objClass.GetFullName().c_str()						// tl[
			, referenceOffsetsBuffer								// QƃoItZbgz
			, numOfReference										// Qƃǒ
			);

		// RpC
		ChangeOpcode( temporary );

		objClass.SetTypeInfoDataTableOffset(
			compiler.GetObjectModule().dataTable.GetLastMadeConstObjectDataTableOffset()
		);
	}
}
void Classes::Compile_System_InitializeUserTypesForBaseType()
{
	extern int cp;
	cp = -1;
	////////////////////////////////////////////////////////////////////
	// NXo^
	////////////////////////////////////////////////////////////////////

	char temporary[VN_SIZE];
	sprintf(temporary, "%c%ctempType=Nothing%c%cTypeBaseImpl"
		, HIBYTE( COM_DIM )
		, LOBYTE( COM_DIM )
		, 1
		, ESC_AS
		);
	ChangeOpcode( temporary );

	// Ce[^Zbg
	Iterator_Reset();

	while( Iterator_HasNext() ){
		const CClass &objClass = *Iterator_GetNext();

		if( !objClass.IsUsing() ){
			// gp̃NX͖
			continue;
		}

		if( objClass.HasSuperClass() ){
			sprintf( temporary
				, "tempType=Search(\"%s\")"
				, objClass.GetFullName().c_str()
				);

			// RpC
			ChangeOpcode( temporary );

			sprintf( temporary
				, "tempType.SetBaseType(Search(\"%s\"))"
				, objClass.GetSuperClass().GetFullName().c_str()
				);

			// RpC
			ChangeOpcode( temporary );
		}
	}



	////////////////////////////////////////////////////////////////////
	// p֌Wo^
	////////////////////////////////////////////////////////////////////
	// TODO: 
	/*

	// Ce[^Zbg
	Iterator_Reset();

	while( Iterator_HasNext() ){
		CClass *pClass = Iterator_GetNext();

		sprintf( genBuffer + length
			, "obj.Search( \"%s\" ).SetBaseType( Search( \"%s\" ) ):"
			, ""				// NX
			, pClass->name		// NX
			);
		length += lstrlen( genBuffer + length );

		while( length + 8192 > max ){
			max += 8192;
			genBuffer = (char *)realloc( genBuffer, max );
		}
	}*/
}

const CClass *Classes::Find( const NamespaceScopes &namespaceScopes, const string &name ) const
{
	if( namespaceScopes.size() == 0 && name == "Object" ){
		return GetObjectClassPtr();
	}
	else if( namespaceScopes.size() == 0 && name == "String" ){
		return GetStringClassPtr();
	}

	const CClass *pClass = GetHashArrayElement( name.c_str() );
	while( pClass )
	{
		if( pClass->IsEqualSymbol( namespaceScopes, name ) ){
			//OԂƃNXv
			return pClass;
		}
		pClass = pClass->GetChainNext();
	}

	// TypeDef
	int index = compiler.GetObjectModule().meta.GetTypeDefs().GetIndex( namespaceScopes, name );
	if( index != -1 ){
		Type type = compiler.GetObjectModule().meta.GetTypeDefs()[index].GetBaseType();
		if( type.IsObject() ){
			return &type.GetClass();
		}
	}

	return NULL;
}
const CClass *Classes::Find( const string &fullName ) const
{
	char AreaName[VN_SIZE] = "";		//IuWFNgϐ
	char NestName[VN_SIZE] = "";		//qo
	bool isNest = SplitMemberName( fullName.c_str(), AreaName, NestName );

	return Find( NamespaceScopes( AreaName ), NestName );
}
void Classes::StartCompile( const UserProc *pUserProc ){
	const CClass *pParentClass = pUserProc->GetParentClassPtr();
	if( pParentClass ){
		pParentClass->Using();

		// z֐ɂȂ郁\bhɎgp`FbN
		BOOST_FOREACH( const CMethod *pMethod, pParentClass->GetDynamicMethods() )
		{
			if( pMethod->IsVirtual() )
			{
				pMethod->GetUserProc().Using();
			}
		}

		pCompilingMethod = pParentClass->GetDynamicMethodOrInterfaceMethod( pUserProc );
		if( !pCompilingMethod ){
			pCompilingMethod = pParentClass->GetStaticMethods().GetMethodPtr( pUserProc );
			if( !pCompilingMethod ){
				SmoothieException::Throw(300);
			}
		}
	}
	else{
		pCompilingMethod = NULL;
	}
}

const CClass *Classes::GetStringClassPtr() const
{
	if( !pStringClass ){
		// LbVĂ
		pStringClass = this->Find( NamespaceScopes( "System" ), "String" );

		if( !pStringClass )
		{
			SetError(400, "System.String", cp);
			static CClass dummy;
			return &dummy;
		}
		return pStringClass;
	}
	return pStringClass;
}
const CClass *Classes::GetObjectClassPtr() const
{
	if( !pObjectClass ){
		// LbVĂ
		pObjectClass = this->Find( NamespaceScopes( "System" ), "Object" );

		if( !pObjectClass )
		{
			SetError(400, "System.Object", cp);
			static CClass dummy;
			return &dummy;
		}
		return pObjectClass;
	}
	return pObjectClass;
}
const CClass *Classes::GetInterfaceInfoClassPtr() const
{
	if( !pInterfaceInfo ){
		// LbVĂ
		pInterfaceInfo = this->Find( "ActiveBasic.Core.InterfaceInfo" );

		if( !pInterfaceInfo )
		{
			SetError(400, "ActiveBasic.Core.InterfaceInfo", cp);
			static CClass dummy;
			return &dummy;
		}
		return pInterfaceInfo;
	}
	return pInterfaceInfo;
}
