#include "common.h"
#include "HtmlAnalysis.h"


void TextEditEvent_StartAnalysis_Basic(HWND hwnd,int WndNum,int nVirtualKey);
void TextEditEvent_StartAnalysis_Html(HWND hwnd,int WndNum,int nVirtualKey);


void TextEditEvent_KeyUp(HWND hwnd,int nVirtualKey){
	if(nVirtualKey==VK_CONTROL&&pobj_nv->bCtrlKeyHyperLink){
		int WndNum;
		WndNum=GetWndNum(GetParent(hwnd));

		if(MdiInfo[WndNum].pMdiTextEdit->iUnderStart!=-1){
			//nCp[N̕\
			MdiInfo[WndNum].pMdiTextEdit->iUnderStart=-1;
			MdiInfo[WndNum].pMdiTextEdit->iUnderEnd=-1;

			//ĕ`
			InvalidateRect(hwnd,NULL,0);
			UpdateWindow(hwnd);
		}

		obj_WebStrings.clear();
	}
}


int IsIndentAdditionCommand_FromBuffer(char *buffer){
	int i;
	char temporary[255];

	for(i=0;;i++){
		if(!IsVariableChar(buffer[i])){
			temporary[i]=0;
			break;
		}
		temporary[i]=buffer[i];
	}

	if(lstrcmpi(temporary,"If")==0){
		//If̏ꍇ̓ubN`̗L𔻒

		for(;;i++){
			if(buffer[i]=='\''||
				IsCommandDelimitation(buffer,i)){
				i--;
				break;
			}
		}

		while(buffer[i]==' '||buffer[i]=='\t') i--;

		if(memicmp(buffer+i-3,"Then",4)==0){
			//ubN`If
			return 1;
		}
		else{
			//ŝ݂If
			return 0;
		}
	}

	if(
		lstrcmpi(temporary,"Case")==0||
		lstrcmpi(temporary,"Class")==0||
		lstrcmpi(temporary,"Do")==0||
		lstrcmpi(temporary,"Else")==0||
		lstrcmpi(temporary,"ElseIf")==0||
		lstrcmpi(temporary,"Enum")==0||
		lstrcmpi(temporary,"For")==0||
		lstrcmpi(temporary,"Function")==0||
		lstrcmpi(temporary,"Namespace")==0||
		lstrcmpi(temporary,"Override")==0||
		lstrcmpi(temporary,"Sub")==0||
		lstrcmpi(temporary,"Type")==0||
		lstrcmpi(temporary,"Virtual")==0||
		lstrcmpi(temporary,"Static")==0||
		lstrcmpi(temporary,"While")==0||
		lstrcmpi(temporary,"With")==0||

		lstrcmpi(temporary,"Private")==0||
		lstrcmpi(temporary,"Protected")==0||
		lstrcmpi(temporary,"Public")==0||

		lstrcmpi(temporary,"Try")==0||
		lstrcmpi(temporary,"Catch")==0||
		lstrcmpi(temporary,"Finally")==0
		) return 1;
	else if(lstrcmpi(temporary,"Select")==0) return 2;
	else if(lstrcmpi(temporary,"Interface")==0) return 3;

	return 0;
}
int IsIndentDecreaseCommand_FromBuffer(char *buffer){
	int i;
	char temporary[255];

	for(i=0;;i++){
		if(!IsVariableChar(buffer[i])){
			temporary[i]=0;
			break;
		}
		temporary[i]=buffer[i];
	}

	if(lstrcmpi(temporary,"End")==0&&(buffer[i]==' '||buffer[i]=='\t')){
		//End `̏ꍇ

		int i2=i;

		while(buffer[i]==' '||buffer[i]=='\t') i++;

		for(;;i++,i2++){
			if(!IsVariableChar(buffer[i])){
				temporary[i2]=0;
				break;
			}
			temporary[i2]=buffer[i];
		}
	}

	if(
		lstrcmpi(temporary,"Case")==0||
		lstrcmpi(temporary,"EndClass")==0||
		lstrcmpi(temporary,"Loop")==0||
		lstrcmpi(temporary,"Else")==0||
		lstrcmpi(temporary,"ElseIf")==0||
		lstrcmpi(temporary,"EndIf")==0||
		lstrcmpi(temporary,"EndEnum")==0||
		lstrcmpi(temporary,"Next")==0||
		lstrcmpi(temporary,"EndFunction")==0||
		lstrcmpi(temporary,"EndNamespace")==0||
		lstrcmpi(temporary,"EndSub")==0||
		lstrcmpi(temporary,"EndType")==0||
		lstrcmpi(temporary,"EndTry")==0||
		lstrcmpi(temporary,"Wend")==0||
		lstrcmpi(temporary,"EndWith")==0||

		lstrcmpi(temporary,"Private")==0||
		lstrcmpi(temporary,"Protected")==0||
		lstrcmpi(temporary,"Public")==0||

		lstrcmpi(temporary,"Catch")==0||
		lstrcmpi(temporary,"Finally")==0
		) return 1;
	else if(lstrcmpi(temporary,"EndSelect")==0) return 2;
	else if(lstrcmpi(temporary,"EndInterface")==0) return 3;


	return 0;
}

int TextEdit_GetLineIndex(int WndNum,int iPos){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i;
	char *pBuf;

	pBuf=MdiInfo[WndNum].pMdiTextEdit->buffer;
	for(i=iPos;i>0;i--){
		if(pBuf[i-1]=='\r'&&pBuf[i]=='\n') return i+1;
	}
	return i;
}
void TextEditEvent_Char(HWND hwnd,int nVirtualKey){
	extern COMPLEMENT_WINDOW_INFO ComplementWndInfo;
	int i,i2,i3;
	char temporary[1024];
	char *pBuf,*pTemp;
	CHARRANGE CharRange;


	//BackSpaceWM_KEYDOWNŏ
	if(nVirtualKey==VK_BACK) return;

	if(nVirtualKey==VK_ESCAPE){
		if(ComplementWndInfo.hWnd){
			//R[h⊮Xgj
			DestroyWindow(ComplementWndInfo.hWnd);
			ComplementWndInfo.hWnd=0;
		}

		extern METHODCHECKINFO MethodCheckInfo;
		if(MethodCheckInfo.hWnd){
			//p[^qgj
			DestroyWindow(MethodCheckInfo.hWnd);
			MethodCheckInfo.hWnd=0;
		}

		return;
	}

	//Ή̕R[ȟ͂j~
	if(GetKeyState(VK_CONTROL)&0x8000) return;

	int WndNum;
	WndNum=GetWndNum(GetParent(hwnd));

	if(ComplementWndInfo.hWnd){
		if((!(IsVariableChar(nVirtualKey)||nVirtualKey==VK_RETURN))||nVirtualKey=='.'){
			//R[h⊮Xgj

			//yAXe[gg⊮̏ꍇ́A󔒕eF
			if(!(nVirtualKey==' '&&ComplementWndInfo.pMemberInfo[0].dwAccess==ACCESS_PAIRCOMMAND)){
				DestroyWindow(ComplementWndInfo.hWnd);
				ComplementWndInfo.hWnd=0;
			}
		}
	}

	if(nVirtualKey==VK_RETURN){
		if(ComplementWndInfo.hWnd){
			//R[h⊮Xg\ĂƂ
			for(i=0;i<ComplementWndInfo.MemberNum;i++){
				if(ListView_GetItemState(ComplementWndInfo.hList,i,LVIS_SELECTED)) break;
			}
			if(i!=ComplementWndInfo.MemberNum){
				SendMessage(ComplementWndInfo.hList,WM_KEYDOWN,VK_RETURN,0);
				return;
			}
			else{
				//R[h⊮Xgj
				DestroyWindow(ComplementWndInfo.hWnd);
				ComplementWndInfo.hWnd=0;
			}
		}

		temporary[0]='\r';
		temporary[1]='\n';
		temporary[2]=0;

		if(nVirtualKey==VK_RETURN&&pobj_nv->bAutoIndent){
			//////////////////
			// Cfg
			//////////////////

			//Cfg͂h~̂߁ALbgꎞ\ɂ
			extern int hide_caret_switch;
			HideCaret(hwnd);
			hide_caret_switch=1;

			if(MdiInfo[WndNum].IndentStr){
				//ȑO̎Cfg
				CancelBeforeAutoIndent(WndNum);
			}

			pBuf=MdiInfo[WndNum].pMdiTextEdit->buffer;

			int StartX;

			//vCXÕJ[\obt@ʒu擾
			i=GetBufferIndexFromCaretPos(pBuf,
				MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x,
				MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y);
			StartX=MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x;

			//vCX
			TextEdit_ReplaceUpdateUndoData(WndNum,temporary,0,1);
			pBuf=MdiInfo[WndNum].pMdiTextEdit->buffer;

			//vCX̃J[\s̃Cfgi3Ɏ擾
			for(i3=0;;i3++){
				if(pBuf[i+i3]!='\t') break;
			}

			//O̍s̃CfgRs[ii2Ƀ^ui[j
			for(;i>0;i--){
				if(
					pBuf[i-1]=='\r'&&pBuf[i]=='\n'&&
					(!(pBuf[i+1]=='\r'&&pBuf[i+2]=='\n'))
					){
					i++;
					break;
				}
			}

			for(i2=0;;i2++){
				if(pBuf[i+i2]!='\t') break;
			}

			if(MdiInfo[WndNum].DocType==WNDTYPE_BASIC){
				//Cfgǉ̃R}hǂ𔻒f
				if(IsIndentAdditionCommand_FromBuffer(pBuf+i+i2)) i2++;
			}

			i2-=i3;
			if(i2<0) i2=0;

			//CfgƂ
			if(i2==0){
				hide_caret_switch=0;
				ResetCaretPos(WndNum);
				ShowCaret(hwnd);
				return;
			}

			/*ihcJ[\j
			iu\t\tTv̂悤ȏꍇjA
			iu\t\tTtext...v̂悤ȏꍇj𔻒f
			*/
			i=GetBufferIndexFromCaretPos(pBuf,
				MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x,
				MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y);
			if(pBuf[i]=='\r'&&
				pBuf[i+1]=='\n'){
				//CfgJniu\t\tTv̂悤ȏꍇj
				MdiInfo[WndNum].IndentStr=(char *)HeapAlloc(hHeap,0,i2+1);
				memset(MdiInfo[WndNum].IndentStr,'\t',i2);
				MdiInfo[WndNum].IndentStr[i2]=0;
				TextEdit_Replace(WndNum,MdiInfo[WndNum].IndentStr,1);
			}
			else{
				//CfgLɂiu\t\tTtext...v̂悤ȏꍇj

				//vCXÕJ[\s̐擪ʒuɂꍇ͔o
				if(StartX==0){
					hide_caret_switch=0;
					ResetCaretPos(WndNum);
					ShowCaret(hwnd);
					return;
				}

				memset(temporary,'\t',i2);
				temporary[i2]=0;
				TextEdit_ReplaceUpdateUndoData(WndNum,temporary,0,1);
			}

			hide_caret_switch=0;
			ShowCaret(hwnd);
			return;
		}
	}
	else if(nVirtualKey==VK_TAB){
		pBuf=MdiInfo[WndNum].pMdiTextEdit->buffer;

		TextEdit_GetSel(WndNum,&CharRange);
		for(i=CharRange.cpMin;i>0;i--){
			if(pBuf[i-1]=='\r'&&pBuf[i]=='\n'){
				i++;
				break;
			}
		}
		CharRange.cpMin=i;

		for(i2=0;i<CharRange.cpMax;i++){
			if(pBuf[i]=='\0') break;
			if(pBuf[i]=='\r'&&pBuf[i+1]=='\n') i2++;
		}
		if(i2){
			if(GetKeyState(VK_SHIFT)&0x8000){
				//////////////////////////////////
				// sɂ킽ă^u폜
				//////////////////////////////////

				if(pBuf[CharRange.cpMax-2]=='\r'&&pBuf[CharRange.cpMax-1]=='\n'){
					CharRange.cpMax-=2;
				}

				TextEdit_SetSel(WndNum,CharRange.cpMin,CharRange.cpMax);

				pTemp=(char *)HeapAlloc(hHeap,0,CharRange.cpMax-CharRange.cpMin+1);

				i=CharRange.cpMin;
				for(i3=0;i<CharRange.cpMax;i++,i3++){
					if(i==CharRange.cpMin&&pBuf[i]=='\t'){
						i3--;
						continue;
					}
					if(pBuf[i]=='\r'&&pBuf[i+1]=='\n'&&pBuf[i+2]=='\t'){
						pTemp[i3]='\r';
						pTemp[i3+1]='\n';
						i3++;

						i+=2;
						continue;
					}
					pTemp[i3]=pBuf[i];
				}
				pTemp[i3]=0;
			}
			else{
				//////////////////////////
				// sɃ^uǉ
				//////////////////////////

				if(pBuf[CharRange.cpMax-2]=='\r'&&pBuf[CharRange.cpMax-1]=='\n'){
					CharRange.cpMax-=2;
				}

				i2++;	//擪s̃^uǉ̑Ώ
				TextEdit_SetSel(WndNum,CharRange.cpMin,CharRange.cpMax);

				pTemp=(char *)HeapAlloc(hHeap,0,CharRange.cpMax-CharRange.cpMin+1 +i2);

				i=CharRange.cpMin;
				if(pBuf[i]=='\r'&&pBuf[i+1]=='\n'){
					i3=0;
				}
				else{
					pTemp[0]='\t';
					i3=1;
				}
				for(;i<CharRange.cpMax;i++,i3++){
					if(pBuf[i]=='\r'&&pBuf[i+1]=='\n'&&
						(!(pBuf[i+2]=='\r'&&pBuf[i+3]=='\n'))){
						pTemp[i3]='\r';
						pTemp[i3+1]='\n';
						pTemp[i3+2]='\t';
						i3+=2;

						i++;
						continue;
					}
					pTemp[i3]=pBuf[i];
				}
				pTemp[i3]=0;
			}

			//vCX
			TextEdit_ReplaceUpdateUndoData(WndNum,pTemp,0,0);
			pBuf=MdiInfo[WndNum].pMdiTextEdit->buffer;

			HeapDefaultFree(pTemp);

			//Lbgʒu̐ݒ
			for(i=CharRange.cpMin+i3;;i++){
				if(pBuf[i]=='\0') break;
				if(pBuf[i]=='\r'&&pBuf[i+1]=='\n'){
					i+=2;
					break;
				}
			}
			TextEdit_SetSel(WndNum,
				CharRange.cpMin,
				i);

			//ĕ`
			if(!TextEdit_ScrollCaret(WndNum,0))
				InvalidateRect(hwnd,NULL,0);
			ResetCaretPos(WndNum);

			return;
		}
		else{
			temporary[0]='\t';
			temporary[1]=0;
		}
	}
	else{
		temporary[0]=nVirtualKey;
		temporary[1]=0;
	}


	if(ComplementWndInfo.hWnd){
		//R[h⊮Xg\̂Ƃ
		ComplementWndInfo.iLength++;
	}



	///////////////////////
	// L[͂̎󂯓
	///////////////////////

	TextEdit_ReplaceUpdateUndoData(WndNum,temporary,0,1);



	////////////////////////////////////////////
	// R[h⊮@\Ap[^qgȂ
	////////////////////////////////////////////

	if(MdiInfo[WndNum].DocType==WNDTYPE_BASIC)
		TextEditEvent_StartAnalysis_Basic(hwnd,WndNum,nVirtualKey);
	else if(MdiInfo[WndNum].DocType==WNDTYPE_HTML){
		TextEditEvent_StartAnalysis_Html(hwnd,WndNum,nVirtualKey);
	}
}
void TextEditEvent_KeyDown(HWND hwnd,int nVirtualKey,int lKeyData){
	extern COMPLEMENT_WINDOW_INFO ComplementWndInfo;
	int i,i2;
	CHARRANGE CharRange;
	char *pBuf;

	int WndNum;
	WndNum=GetWndNum(GetParent(hwnd));

	if(nVirtualKey==VK_LEFT||nVirtualKey==VK_UP||nVirtualKey==VK_RIGHT||nVirtualKey==VK_DOWN||nVirtualKey==VK_PRIOR||nVirtualKey==VK_NEXT){
		if(MdiInfo[WndNum].IndentStr){
			//Cfg̃Cfg𖳌ɂ
			CancelBeforeAutoIndent(WndNum);
			if(nVirtualKey==VK_LEFT) return;
		}

		if(ComplementWndInfo.hWnd){
			//R[h⊮Xg\̂Ƃ
			if(!(nVirtualKey==VK_LEFT||nVirtualKey==VK_RIGHT)){
				//R[h⊮XgɃtH[JX^
				PostMessage(ComplementWndInfo.hList,WM_KEYDOWN,nVirtualKey,lKeyData);
				return;
			}
		}

		switch(nVirtualKey){
			case VK_LEFT:
				//㉺Lbgړ̍Eʒuێ@\
				MdiInfo[WndNum].pMdiTextEdit->Temp_UpDown_CaretXPos=-1;

				if((MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x==MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.x&&
					MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y==MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.y)||
					GetKeyState(VK_SHIFT)&0x8000){
					//I𒆂łȂƂA܂̓VtgL[ĂƂ
					GetNaturalCaretPos_Left(WndNum);
				}
				else{
					//I𒆂̂Ƃ
					if(MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y<MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.y)
						MdiInfo[WndNum].pMdiTextEdit->EndCaretPos=MdiInfo[WndNum].pMdiTextEdit->StartCaretPos;
					else if(MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y>MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.y)
						MdiInfo[WndNum].pMdiTextEdit->StartCaretPos=MdiInfo[WndNum].pMdiTextEdit->EndCaretPos;
					else{
						if(MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x<MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.x)
							MdiInfo[WndNum].pMdiTextEdit->EndCaretPos=MdiInfo[WndNum].pMdiTextEdit->StartCaretPos;
						else
							MdiInfo[WndNum].pMdiTextEdit->StartCaretPos=MdiInfo[WndNum].pMdiTextEdit->EndCaretPos;
					}
				}
				break;
			case VK_RIGHT:
				//㉺Lbgړ̍Eʒuێ@\
				MdiInfo[WndNum].pMdiTextEdit->Temp_UpDown_CaretXPos=-1;

				if((MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x==MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.x&&
					MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y==MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.y)||
					GetKeyState(VK_SHIFT)&0x8000){
					//I𒆂łȂƂA܂̓VtgL[ĂƂ
					GetNaturalCaretPos_Right(WndNum,
						&MdiInfo[WndNum].pMdiTextEdit->StartCaretPos);
				}
				else{
					//I𒆂̂Ƃ
					if(MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y<MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.y)
						MdiInfo[WndNum].pMdiTextEdit->StartCaretPos=MdiInfo[WndNum].pMdiTextEdit->EndCaretPos;
					else if(MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y>MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.y)
						MdiInfo[WndNum].pMdiTextEdit->EndCaretPos=MdiInfo[WndNum].pMdiTextEdit->StartCaretPos;
					else{
						if(MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x<MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.x)
							MdiInfo[WndNum].pMdiTextEdit->StartCaretPos=MdiInfo[WndNum].pMdiTextEdit->EndCaretPos;
						else
							MdiInfo[WndNum].pMdiTextEdit->EndCaretPos=MdiInfo[WndNum].pMdiTextEdit->StartCaretPos;
					}
				}
				break;
			case VK_UP:
				if((GetKeyState(VK_CONTROL)&0x8000)&&
					MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x!=0){
					//s̐擪փLbgړ
					MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x=0;

					//㉺Lbgړ̍Eʒuێ@\
					MdiInfo[WndNum].pMdiTextEdit->Temp_UpDown_CaretXPos=-1;
				}
				else{
					if((MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x==MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.x&&
						MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y==MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.y)||
						GetKeyState(VK_SHIFT)&0x8000){
						//I𒆂łȂƂA܂̓VtgL[ĂƂ
						GetNaturalCaretPos_Up(WndNum,
							&MdiInfo[WndNum].pMdiTextEdit->StartCaretPos);
					}
					else{
						//I𒆂̂Ƃ
						if(MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y<MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.y)
							MdiInfo[WndNum].pMdiTextEdit->EndCaretPos=MdiInfo[WndNum].pMdiTextEdit->StartCaretPos;
						else if(MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y>MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.y)
							MdiInfo[WndNum].pMdiTextEdit->StartCaretPos=MdiInfo[WndNum].pMdiTextEdit->EndCaretPos;
						else{
							if(MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x<MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.x)
								MdiInfo[WndNum].pMdiTextEdit->EndCaretPos=MdiInfo[WndNum].pMdiTextEdit->StartCaretPos;
							else
								MdiInfo[WndNum].pMdiTextEdit->StartCaretPos=MdiInfo[WndNum].pMdiTextEdit->EndCaretPos;
						}

						GetNaturalCaretPos_Up(WndNum,
							&MdiInfo[WndNum].pMdiTextEdit->StartCaretPos);
					}
				}
				break;
			case VK_DOWN:
				i2=MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y;
				if((MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x==MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.x&&
					MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y==MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.y)||
					GetKeyState(VK_SHIFT)&0x8000){
					//I𒆂łȂƂA܂̓VtgL[ĂƂ
					GetNaturalCaretPos_Down(WndNum,
						&MdiInfo[WndNum].pMdiTextEdit->StartCaretPos);
				}
				else{
					//I𒆂̂Ƃ
					if(MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y<MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.y)
						MdiInfo[WndNum].pMdiTextEdit->StartCaretPos=MdiInfo[WndNum].pMdiTextEdit->EndCaretPos;
					else if(MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y>MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.y)
						MdiInfo[WndNum].pMdiTextEdit->EndCaretPos=MdiInfo[WndNum].pMdiTextEdit->StartCaretPos;
					else{
						if(MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x<MdiInfo[WndNum].pMdiTextEdit->EndCaretPos.x)
							MdiInfo[WndNum].pMdiTextEdit->StartCaretPos=MdiInfo[WndNum].pMdiTextEdit->EndCaretPos;
						else
							MdiInfo[WndNum].pMdiTextEdit->EndCaretPos=MdiInfo[WndNum].pMdiTextEdit->StartCaretPos;
					}

					GetNaturalCaretPos_Down(WndNum,
						&MdiInfo[WndNum].pMdiTextEdit->StartCaretPos);
				}

				if(GetKeyState(VK_CONTROL)&0x8000){
					if(i2!=MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y){
						//s̐擪փLbgړ
						MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x=0;
					}
					else{
						//s̖[փLbgړiI[s̏ꍇj
						CaretPos_LooseToNatural(WndNum,
							INT_MAX,
							MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y,
							&MdiInfo[WndNum].pMdiTextEdit->StartCaretPos);
					}

					//㉺Lbgړ̍Eʒuێ@\
					MdiInfo[WndNum].pMdiTextEdit->Temp_UpDown_CaretXPos=-1;
				}
				break;
			case VK_PRIOR:
				GetNaturalCaretPos_PageUp(WndNum,
					&MdiInfo[WndNum].pMdiTextEdit->StartCaretPos);
				break;
			case VK_NEXT:
				GetNaturalCaretPos_PageDown(WndNum,
					&MdiInfo[WndNum].pMdiTextEdit->StartCaretPos);
				break;
		}

		if(!(GetKeyState(VK_SHIFT)&0x8000)){
			//VtgL[ĂȂAʏ펞
			MdiInfo[WndNum].pMdiTextEdit->EndCaretPos=MdiInfo[WndNum].pMdiTextEdit->StartCaretPos;
		}

		if(nVirtualKey==VK_PRIOR){
			//y[WAbvXN[
			SendMessage(hwnd,WM_VSCROLL,SB_PAGEUP,0);
		}
		else if(nVirtualKey==VK_NEXT){
			//y[W_EXN[
			SendMessage(hwnd,WM_VSCROLL,SB_PAGEDOWN,0);
		}
		else{
			//̑AXN[Kvȏꍇl
			TextEdit_ScrollCaret(WndNum,0);
			ResetCaretPos(WndNum);
		}

		//ҏWj[Zbg
		ResetState_EditMenu();

		//ĕ`iI̔]\ꂽƂlj
		UpdateWindow(hwnd);	//h~
		InvalidateRect(hwnd,NULL,0);
	}
	else if(nVirtualKey==VK_HOME||nVirtualKey==VK_END){

		//㉺Lbgړ̍Eʒuێ@\
		MdiInfo[WndNum].pMdiTextEdit->Temp_UpDown_CaretXPos=-1;

		if(GetKeyState(VK_CONTROL)&0x8000){
			//t@C̐擪܂͖[փLbgړ
			if(nVirtualKey==VK_HOME){
				MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x=0;
				MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y=0;
			}
			else if(nVirtualKey==VK_END){
				//݂Lbgʒuɕϊ
				CaretPos_LooseToNatural(WndNum,
					INT_MAX,
					INT_MAX,
					&MdiInfo[WndNum].pMdiTextEdit->StartCaretPos);
			}
		}
		else{
			//s̐擪܂͖[փLbgړ
			if(nVirtualKey==VK_HOME) MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x=0;
			else if(nVirtualKey==VK_END){
				//݂Lbgʒuɕϊ
				CaretPos_LooseToNatural(WndNum,
					INT_MAX,
					MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y,
					&MdiInfo[WndNum].pMdiTextEdit->StartCaretPos);
			}
		}

		if(!(GetKeyState(VK_SHIFT)&0x8000)){
			//VtgL[ĂȂAʏ펞
			MdiInfo[WndNum].pMdiTextEdit->EndCaretPos=MdiInfo[WndNum].pMdiTextEdit->StartCaretPos;
		}

		if(!TextEdit_ScrollCaret(WndNum,0)){
			//ĕ`iI̔]\ꂽƂlj
			InvalidateRect(hwnd,NULL,0);
		}
		ResetCaretPos(WndNum);

		//ҏWj[Zbg
		ResetState_EditMenu();
	}
	else if(nVirtualKey==VK_DELETE){
		////////////
		// 폜L[
		////////////

		TextEdit_GetSel(WndNum,&CharRange);

		pBuf=MdiInfo[WndNum].pMdiTextEdit->buffer;

		//Lbgt@C̏I[ɂƂ
		if(CharRange.cpMin==lstrlen(pBuf)) return;

		if(CharRange.cpMin==CharRange.cpMax){
			if(MdiInfo[WndNum].IndentStr){
				//CfgLɂ
				char temporary[1024];
				lstrcpy(temporary,MdiInfo[WndNum].IndentStr);

				CancelBeforeAutoIndent(WndNum);
				TextEdit_ReplaceUpdateUndoData(WndNum,temporary,0,1);
			}

			if(pBuf[CharRange.cpMin]=='\r'&&pBuf[CharRange.cpMin+1]=='\n'||
				IsDBCSLeadByte(pBuf[CharRange.cpMin])){
				CharRange.cpMax+=2;
			}
			else CharRange.cpMax++;

			GetCaretPosFromBufferIndex(
				MdiInfo[WndNum].pMdiTextEdit->buffer,
				CharRange.cpMax,
				&MdiInfo[WndNum].pMdiTextEdit->EndCaretPos);
		}

		TextEdit_ReplaceUpdateUndoData(WndNum,"",0,1);
	}
	else if(nVirtualKey==VK_BACK){
		/////////////////
		// BackSpaceL[
		/////////////////

		if(MdiInfo[WndNum].IndentStr){
			//Cfg̃Cfg̏ꍇACfg1폜
			if(lstrlen(MdiInfo[WndNum].IndentStr)==1){
				//1cĂȂꍇ͎Cfĝ̂
				CancelBeforeAutoIndent(WndNum);
			}
			else{
				MdiInfo[WndNum].IndentStr[lstrlen(MdiInfo[WndNum].IndentStr)-1]=0;

				i=GetBufferIndexFromCaretPos(
					MdiInfo[WndNum].pMdiTextEdit->buffer,
					MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x,
					MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y);
				GetCaretPosFromBufferIndex(
					MdiInfo[WndNum].pMdiTextEdit->buffer,
					i-1,
					&MdiInfo[WndNum].pMdiTextEdit->StartCaretPos);
				TextEdit_Replace(WndNum,"",1);
			}
			return;
		}

		TextEdit_GetSel(WndNum,&CharRange);

		if(CharRange.cpMax==0) return;
		if(CharRange.cpMin==CharRange.cpMax){
			if(ComplementWndInfo.hWnd){
				//R[h⊮Xg\̂Ƃ
				ComplementWndInfo.iLength--;
			}

			SendMessage(hwnd,WM_KEYDOWN,VK_LEFT,0);
		}
		SendMessage(hwnd,WM_KEYDOWN,VK_DELETE,0);
	}
}



void TextEditEvent_StartAnalysis_Basic(HWND hwnd,int WndNum,int nVirtualKey){
	extern COMPLEMENT_WINDOW_INFO ComplementWndInfo;
	int i,i2,i3;
	CHARRANGE CharRange;
	char temporary[1024];

	char *pBuf;
	pBuf=MdiInfo[WndNum].pMdiTextEdit->buffer;


	////////////////////
	// p[^qg
	////////////////////

	extern METHODCHECKINFO MethodCheckInfo;
	if(pobj_nv->dwParameterHint&&
		(!ComplementWndInfo.hWnd)&&
		(MethodCheckInfo.hWnd||nVirtualKey==' '||nVirtualKey=='\"'||nVirtualKey=='(')){
			//Oɓ͂ꂽ\
			UpdateWindow(hwnd);

			//p[^qg\
			ShowParameterHint(WndNum);
	}


	///////////////////////////////
	// yAXe[gg⊮
	///////////////////////////////

	if(
		pobj_nv->BackNum_PairStatementComplement&&
		(nVirtualKey=='c'||nVirtualKey=='C'||		//CaseACatch
		nVirtualKey=='e'||nVirtualKey=='E'||		//End `
		nVirtualKey=='f'||nVirtualKey=='F'||		//Finally
		nVirtualKey=='l'||nVirtualKey=='L'||		//Loop
		nVirtualKey=='n'||nVirtualKey=='N'||		//Next
		nVirtualKey=='p'||nVirtualKey=='P'||		//PrivateAProtectedAPublic
		nVirtualKey=='w'||nVirtualKey=='W')		//Wend
		){

		i=GetBufferIndexFromCaretPos(pBuf,
			MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x,
			MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y);

		i2=i-2;
		while(pBuf[i2]==' '||pBuf[i2]=='\t') i2--;
		if(IsCommandBackDelimitation(pBuf,i2)){
			if(GetEndPairCommandInfo(pBuf,i-1)){

				//͂ꂽƈv邩ǂ
				for(i3=0;i3<ComplementWndInfo.MemberNum;i3++){
					if((char)CharUpper((LPSTR)(char)nVirtualKey)==
						(char)CharUpper((LPSTR)ComplementWndInfo.pMemberInfo[i3].pName[0])) break;
				}
				if(i3==ComplementWndInfo.MemberNum){
					DeleteComplementInfo();
					return;
				}

				ComplementWndInfo.iLength=1;
				CodeComplement(WndNum,i-1);

				//͎ɕ⊮Xg̑I邽
				ResetCaretPos(WndNum);
			}
		}
	}


	//////////////////
	// R[h⊮@\
	//////////////////

	if(nVirtualKey=='.'&&pobj_nv->bShowComplementWnd){
		TextEdit_GetSel(WndNum,&CharRange);

Complement:
		i2=CharRange.cpMin-1;

		i3=TextEdit_GetLineIndex(WndNum,i2);
		int IsStr;
		for(IsStr=0;i3<i2;i3++){
			if(IsDBCSLeadByte(pBuf[i3])){
				i3++;
				continue;
			}
			if(pBuf[i3]=='\r'&&pBuf[i3+1]=='\n') break;
			if(pBuf[i3]=='\''){
				//ߕ̂Ƃ
				return;
			}
			if(pBuf[i3]=='\"') IsStr^=1;
		}
		if(IsStr){
			//̂Ƃ
			return;
		}

		for(i=i2;i>0;i--){
			if(pBuf[i-1]=='-'&&pBuf[i]=='>')i-=2;
			if(pBuf[i]==']'){
				for(i3=1,i--;i>0;i--){
					if(pBuf[i]==']') i3++;
					if(pBuf[i]=='['){
						i3--;
						if(i3==0) break;
					}
				}
				if(pBuf[i]=='[') continue;
				break;
			}
			if(pBuf[i]==')'){
				for(i3=1,i--;i>0;i--){
					if(pBuf[i]==')') i3++;
					if(pBuf[i]=='('){
						i3--;
						if(i3==0) break;
					}
				}
				if(pBuf[i]=='(') continue;
				break;
			}
			if(!(IsVariableChar(pBuf[i])||pBuf[i]=='.')){
				i++;
				break;
			}
		}

		if((nVirtualKey=='.'&&i2-i==0)||
			nVirtualKey=='>'&&i2-i==1){
			//IuWFNgʎqȂƂAWith
			GetWithObjectVariable(pBuf,i2,temporary);

			if(nVirtualKey=='.') lstrcat(temporary,".");
			else lstrcat(temporary,"->");
		}
		else{
			//IuWFNgʎqtemporaryɃRs[

			//ANZXᔽh߁AVN_SIZEȏ̎Qƃf[^ւ̕⊮͍sȂ
			if(i2-i>VN_SIZE) return;

			if(pBuf[i]=='.'){
				GetWithObjectVariable(pBuf,i2,temporary);
			}
			else if(pBuf[i]=='-'&&pBuf[i+1]=='>'){
				GetWithObjectVariable(pBuf,i2,temporary);
			}
			else temporary[0]=0;

			i3=lstrlen(temporary);
			memcpy(temporary+i3,pBuf+i,i2-i+1);
			temporary[i3+i2-i+1]=0;
		}

		if(temporary[0]){
			//IuWFNgʎqoꍇ
			if(GetComplementInfo(temporary,pBuf,i2)){
				ComplementWndInfo.iLength=0;
				CodeComplement(WndNum,i2+1);
			}
		}
	}
	else if(nVirtualKey=='>'&&pobj_nv->bShowComplementWnd){
		TextEdit_GetSel(WndNum,&CharRange);
		if(pBuf[CharRange.cpMin-2]=='-'){
			goto Complement;
		}
	}
}
void TextEditEvent_StartAnalysis_Html(HWND hwnd,int WndNum,int nVirtualKey){
	//////////////////////////
	// HTML̃R[h⊮
	//////////////////////////

	extern COMPLEMENT_WINDOW_INFO ComplementWndInfo;
	int i;

	char *pBuf;
	pBuf=MdiInfo[WndNum].pMdiTextEdit->buffer;



	///////////////////////////////
	// R[h⊮
	///////////////////////////////

	if(nVirtualKey==' '){
 
		i=GetBufferIndexFromCaretPos(pBuf,
			MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x,
			MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y);

		if(GetNowTagInfo(pBuf,i-1)){
			ComplementWndInfo.iLength=0;
			CodeComplement(WndNum,i);

			//͎ɕ⊮Xg̑I邽
			ResetCaretPos(WndNum);
		}
	}
}
